/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.elements;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.utils.ExceptionLauncher;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import java.util.function.BooleanSupplier;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.selectors.Selectors;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementFacadeImpl
extends WebElementFacadeImpl
implements ElementFacade {
    public static final Logger LOGGER = LoggerFactory.getLogger(ElementFacadeImpl.class);
    private final WebDriver driver;
    protected WebElement webElement;
    protected final String xPathOrCSSSelector;

    public static ElementFacadeImpl wrapWebElementFacade(WebDriver driver, WebElementFacade element, ElementLocator locator, String xPathOrCSSSelector, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        return new ElementFacadeImpl(driver, locator, xPathOrCSSSelector, (WebElement)element, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public ElementFacadeImpl(WebDriver driver, ElementLocator locator, String xPathOrCSSSelector, WebElement element, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(driver, locator, element, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
        this.driver = driver;
        this.webElement = element;
        this.xPathOrCSSSelector = xPathOrCSSSelector;
    }

    public ElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement element, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this(driver, locator, null, element, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    @Override
    public void click() {
        int retries = 0;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                this.checkVisible();
                WebElement resolvedWebElement = this.getResolvedWebElement((WebElement)this);
                if (resolvedWebElement == null) {
                    throw new NoSuchElementException("Element not found " + this.xPathOrCSSSelector);
                }
                resolvedWebElement.click();
                return;
            }
            catch (ElementClickInterceptedException e) {
                return;
            }
            catch (WebDriverException e) {
                if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"unexpected command response")) {
                    return;
                }
                if (++retries <= Utils.MAX_WAIT_RETRIES) continue;
                throw new ElementClickInterceptedException(String.format("The element [%s] cannot be clicked after %s retries and %s ms of waiting. Current URL = %s", this, retries - 1, System.currentTimeMillis() - start, this.getDriver().getCurrentUrl()), (Throwable)e);
                if (retries <= Utils.MAX_WAIT_RETRIES) continue;
                return;
            }
            break;
        }
    }

    public ElementFacadeImpl findByXPath(String xpath) {
        this.checkXpathFormat(xpath);
        WebElementFacade nestedElement = this.findSubElementFacadeByXPathOrCSS(xpath);
        return ElementFacadeImpl.wrapWebElementFacade(this.getDriver(), nestedElement, null, xpath, Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, Utils.DEFAULT_WAIT_FOR_TIMEOUT);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public WebElement getElement() {
        if (this.webElement == null) {
            this.webElement = this.getWebElementFacadeByXPathOrCSS(this.xPathOrCSSSelector);
        }
        return this.webElement;
    }

    @Override
    public void hover() {
        Actions action = new Actions(this.getDriver());
        action.moveToElement((WebElement)this).perform();
    }

    public boolean isClickable() {
        return this.isElementClickable(Utils.SHORT_WAIT_DURATION_MILLIS);
    }

    public boolean isCurrentlyEnabled() {
        return this.isElementCurrentlyEnabled();
    }

    @Override
    public boolean isCurrentlyVisible() {
        return this.isElementCurrentlyDisplayed();
    }

    public boolean isDisabled() {
        return this.isElementDisabled(Utils.SHORT_WAIT_DURATION_MILLIS);
    }

    public boolean isDisplayed() {
        return this.isVisible();
    }

    public boolean isElementNotVisible(long implicitWaitInMillis) {
        return this.hasElementProperty(implicitWaitInMillis, this::isElementCurrentlyNotDisplayed);
    }

    public boolean isElementVisible(long implicitWaitInMillis) {
        return this.hasElementProperty(implicitWaitInMillis, this::isElementCurrentlyDisplayed);
    }

    public boolean isEnabled() {
        return this.isElementEnabled(Utils.SHORT_WAIT_DURATION_MILLIS);
    }

    @Override
    public boolean isNotVisible() {
        return this.isElementNotVisible(Utils.SHORT_WAIT_DURATION_MILLIS);
    }

    public boolean isPresent() {
        return this.isElementCurrentlyDisplayed();
    }

    public boolean isVisible() {
        return this.isElementVisible(Utils.SHORT_WAIT_DURATION_MILLIS);
    }

    @Override
    public void scrollDown() {
        JavascriptExecutorFacade javascriptExecutorFacade = new JavascriptExecutorFacade(this.getDriver());
        javascriptExecutorFacade.executeScript("arguments[0].scrollBy(0, 200);", new Object[]{this});
    }

    @Override
    public void scrollToTheRight() {
        JavascriptExecutorFacade javascriptExecutorFacade = new JavascriptExecutorFacade(this.getDriver());
        javascriptExecutorFacade.executeScript("arguments[0].scrollBy(300, 0);", new Object[]{this});
    }

    @Override
    public void scrollToWebElement() {
        JavascriptExecutorFacade javascriptExecutorFacade = new JavascriptExecutorFacade(this.getDriver());
        javascriptExecutorFacade.executeScript("arguments[0].scrollIntoView();", new Object[]{this});
    }

    public WebElementFacade waitUntilClickable() {
        this.checkClickable();
        return this;
    }

    public WebElementFacade waitUntilNotVisible() {
        this.checkNotVisible();
        return this;
    }

    public WebElementFacade waitUntilVisible() {
        this.checkVisible();
        return this;
    }

    protected void checkXpathFormat(String xpath) {
        if (!Selectors.isXPath((String)xpath)) {
            ExceptionLauncher.throwSerenityExeption(new Exception(), String.format("The format for the xpath [%s] is not correct.", xpath));
        }
    }

    protected WebElementFacade findSubElementFacadeByXPathOrCSS(String xpathOrCss) {
        if (StringUtils.contains((CharSequence)xpathOrCss, (CharSequence)"//")) {
            return this.find(By.xpath((String)xpathOrCss));
        }
        return this.find(By.cssSelector((String)xpathOrCss));
    }

    protected WebElementFacade getWebElementFacadeByXPathOrCSS(String xpathOrCss) {
        if (StringUtils.contains((CharSequence)xpathOrCss, (CharSequence)"//")) {
            return WebElementFacadeImpl.wrapWebElement((WebDriver)this.driver, (By)By.xpath((String)xpathOrCss), (long)Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, (long)Utils.DEFAULT_WAIT_FOR_TIMEOUT, (String)xpathOrCss);
        }
        return WebElementFacadeImpl.wrapWebElement((WebDriver)this.driver, (By)By.cssSelector((String)xpathOrCss), (long)Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, (long)Utils.DEFAULT_WAIT_FOR_TIMEOUT, (String)xpathOrCss);
    }

    private boolean isElementClickable(long implicitWaitInMillis) {
        return this.hasElementProperty(implicitWaitInMillis, this::isElementCurrentlyClickable);
    }

    private boolean isElementCurrentlyClickable() {
        return this.isElementCurrentlyEnabled() && this.isElementCurrentlyDisplayed();
    }

    private boolean isElementCurrentlyNotDisplayed() {
        return !this.isElementCurrentlyDisplayed();
    }

    private boolean isElementDisabled(long implicitWaitInMillis) {
        return this.hasElementProperty(implicitWaitInMillis, this::isElementCurrentlyDisabled);
    }

    private boolean isElementEnabled(long implicitWaitInMillis) {
        return this.hasElementProperty(implicitWaitInMillis, this::isElementCurrentlyEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isElementCurrentlyDisabled() {
        Duration defaultTimeout = this.getImplicitTimeout();
        this.setImplicitTimeout(Duration.ofMillis(0L));
        try {
            WebElement resolvedWebElement = this.getResolvedWebElement();
            boolean bl = resolvedWebElement != null && !resolvedWebElement.isEnabled();
            return bl;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            this.webElement = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.setImplicitTimeout(defaultTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isElementCurrentlyDisplayed() {
        Duration defaultTimeout = this.getImplicitTimeout();
        this.setImplicitTimeout(Duration.ofMillis(0L));
        try {
            WebElement resolvedWebElement = this.getResolvedWebElement();
            boolean bl = resolvedWebElement != null && resolvedWebElement.isDisplayed();
            return bl;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            this.webElement = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.setImplicitTimeout(defaultTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isElementCurrentlyEnabled() {
        Duration defaultTimeout = this.getImplicitTimeout();
        this.setImplicitTimeout(Duration.ofMillis(0L));
        try {
            WebElement resolvedWebElement = this.getResolvedWebElement();
            boolean bl = resolvedWebElement != null && resolvedWebElement.isEnabled();
            return bl;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            this.webElement = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.setImplicitTimeout(defaultTimeout);
        }
    }

    private WebElement getResolvedWebElement() {
        try {
            return this.getResolvedWebElement((WebElement)this);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private WebElement getResolvedWebElement(WebElement element) {
        if (element instanceof WebElementFacadeImpl) {
            WebElementFacadeImpl webElementFacadeImpl = (WebElementFacadeImpl)element;
            try {
                return this.getResolvedWebElement(webElementFacadeImpl.getElement());
            }
            catch (JavascriptException e) {
                LOGGER.warn(e.getRawMessage(), (Object)this);
                return null;
            }
        }
        return element;
    }

    private boolean hasElementProperty(long implicitWaitInMillis, BooleanSupplier checkPropertyMethod) {
        int retry = 0;
        do {
            long start = System.currentTimeMillis();
            if (checkPropertyMethod.getAsBoolean()) {
                return true;
            }
            this.resetAndWaitForRemainingTime(implicitWaitInMillis, start);
        } while (retry++ < Utils.MAX_WAIT_RETRIES);
        this.waitForAppLoading();
        return checkPropertyMethod.getAsBoolean();
    }

    private void resetAndWaitForRemainingTime(long implicitWaitInMillis, long start) {
        Utils.waitRemainingTime(implicitWaitInMillis, start);
        this.webElement = null;
    }

    private void waitForAppLoading() {
        try {
            Utils.waitForLoading();
        }
        catch (Exception e) {
            LOGGER.info("The page seems not to be completely loaded, thus the element {} could be not built yet.", (Object)this);
        }
    }
}

