/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class AchievementsPage
extends GenericPage {
    private static final int MAX_REFRESH_RETRIES = 5;

    public AchievementsPage(WebDriver driver) {
        super(driver);
    }

    public void filterAchievementByProgram(String programTitle) {
        this.achievementsFilterButton().click();
        this.waitForDrawerToOpen();
        this.mentionInField(this.achievementsFilterProgramSuggester(), programTitle, 3);
        this.getDrawerButton("Confirm").click();
        Utils.waitForLoading();
    }

    public void filterAchievementByUser(String userFullName) {
        this.achievementsFilterButton().click();
        this.waitForDrawerToOpen();
        while (this.achievementsFilterUserSuggesterDeleteButton().isCurrentlyVisible()) {
            this.achievementsFilterUserSuggesterDeleteButton().click();
            this.waitFor(200).milliseconds();
        }
        this.mentionInField(this.achievementsFilterUserSuggester(), userFullName, 3);
        this.getDrawerButton("Confirm").click();
        Utils.waitForLoading();
    }

    public void checkThatAchievementIsAccepted(String actionTitle) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> this.acceptedAchievementElement(actionTitle).checkVisible(), () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
    }

    public void checkThatAchievementIsPending(String actionTitle) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> this.pendingAchievementElement(actionTitle).checkVisible(), () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
    }

    public void acceptAchievement(String actionTitle) {
        Utils.waitForPageLoading();
        this.acceptedAchievementElement(actionTitle).click();
    }

    public void checkThatAchievementIsRejected(String actionTitle) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> {
            ElementFacade rejectedAchievementElement = this.rejectedAchievementElement(actionTitle);
            rejectedAchievementElement.checkVisible();
            rejectedAchievementElement.hover();
            ElementFacade tooltipRejectedElement = this.tooltipRejectedElement();
            tooltipRejectedElement.checkVisible();
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
    }

    public void checkThatAchievementIsCanceled(String actionTitle) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> {
            ElementFacade canceledAchievementElement = this.canceledOrDeletedAchievementElement(actionTitle);
            canceledAchievementElement.checkVisible();
            canceledAchievementElement.hover();
            ElementFacade tooltipCanceledElement = this.tooltipCanceledElement();
            tooltipCanceledElement.checkVisible();
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
    }

    public void checkThatAchievementIsDeleted(String actionTitle) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> {
            ElementFacade rejectedAchievementElement = this.canceledOrDeletedAchievementElement(actionTitle);
            rejectedAchievementElement.checkVisible();
            rejectedAchievementElement.hover();
            ElementFacade tooltipDeletedActivity = this.tooltipDeletedActivity();
            tooltipDeletedActivity.checkVisible();
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
    }

    public void checkThatAchievementIsDisplayed(String actionTitle, long times) {
        String errorMessage = Utils.retryGetOnCondition(() -> {
            long found = this.achievementsCount(actionTitle);
            return this.checkAchievementsCount(actionTitle, times, found);
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            Assertions.fail((String)errorMessage);
        }
    }

    public void checkThatAchievementIsDisplayedWithProgramOwnerView(String actionTitle, long times, String programName) {
        String errorMessage = Utils.retryGetOnCondition(() -> {
            this.enableProgramOwnerView();
            this.filterAchievementByProgram(programName);
            Utils.waitForLoading();
            long found = this.achievementsCount(actionTitle);
            return this.checkAchievementsCount(actionTitle, times, found);
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            Assertions.fail((String)errorMessage);
        }
    }

    public void checkThatAchievementIsDisplayed(String actionTitle, long times, String programName) {
        String errorMessage = Utils.retryGetOnCondition(() -> {
            this.filterAchievementByProgram(programName);
            long found = this.achievementsCount(actionTitle);
            return this.checkAchievementsCount(actionTitle, times, found);
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 5L);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            Assertions.fail((String)errorMessage);
        }
    }

    public void checkThatAchievementIsDisplayedInPosition(String ruleTitle, String userName, int index) {
        this.achievementRowElement(ruleTitle, userName, index).assertVisible();
    }

    public void checkThatAchievementInDrawerIsDisplayedInPosition(String fullName, int index) {
        this.achievementDrawerElement(fullName, index).assertVisible();
    }

    public void checkThatAchievementIsDisplayedInPosition(String ruleTitle, int index) {
        this.achievementRowElement(ruleTitle, index).assertVisible();
    }

    public void openAchievementsDrawerFromProgramDetail(String ruleTitle) {
        this.achievementAvatarsElement(ruleTitle).click();
    }

    private ElementFacade achievementAvatarsElement(String ruleTitle) {
        return this.findByXPathOrCSS(String.format("(//tbody//*[contains(text(), '%s')]//ancestor::tr//*[contains(@class, 'profile-popover')])[last()]", ruleTitle));
    }

    private ElementFacade achievementRowElement(String ruleTitle, String userName, int index) {
        return this.findByXPathOrCSS(String.format("(//tbody//tr)[%s]//*[contains(text(), '%s')]//ancestor::tr//a[contains(@href, '/profile/%s')]", index, ruleTitle, userName));
    }

    private ElementFacade achievementRowElement(String ruleTitle, int index) {
        return this.findByXPathOrCSS(String.format("(//tbody//tr)[%s]//*[contains(text(), '%s')]", index, ruleTitle));
    }

    private ElementFacade achievementDrawerElement(String userName, int index) {
        return this.findByXPathOrCSS(String.format("(//*[@id = 'AchievementsDrawer']//*[contains(@class, 'profile-popover')])[%s]//*[contains(text(), '%s')]", index, userName));
    }

    private void enableProgramOwnerView() {
        this.getButton("Review").click();
        this.waitFor(200).milliseconds();
        Utils.waitForLoading();
    }

    private ElementFacade rejectedAchievementElement(String actionTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'GamificationRealizationItem')]//*[contains(@class, 'fas fa-times')]", actionTitle));
    }

    private ElementFacade canceledOrDeletedAchievementElement(String actionTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'GamificationRealizationItem')]//*[contains(text(), '-')]/../..//span[@class='not-clickable']", actionTitle));
    }

    private ElementFacade achievementsFilterButton() {
        return this.findByXPathOrCSS("//*[@id = 'applicationToolbar']//*[contains(text(), 'Filter')]//ancestor-or-self::button");
    }

    private TextBoxElementFacade achievementsFilterProgramSuggester() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Campaign')]/parent::*//*[contains(@class, 'identitySuggesterInputStyle')]//input[@type = 'text']");
    }

    private TextBoxElementFacade achievementsFilterUserSuggester() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Contributor')]/parent::*//*[contains(@class, 'identitySuggesterInputStyle')]//input[@type = 'text']");
    }

    private TextBoxElementFacade achievementsFilterUserSuggesterDeleteButton() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'user-suggester')]//*[contains(@class, 'fa-times') or contains(@class, 'mdi-close')]");
    }

    private ElementFacade acceptedAchievementElement(String actionTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'GamificationRealizationItem')]//*[contains(@class, 'fas fa-check')]", actionTitle));
    }

    private ElementFacade pendingAchievementElement(String actionTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'GamificationRealizationItem')]//*[contains(@class, 'fas fa-question')]", actionTitle));
    }

    private ElementFacade tooltipRejectedElement() {
        return this.findByXPathOrCSS("//span[contains(text(), 'Rejected')]//ancestor::*[contains(@class, 'v-tooltip__content')]");
    }

    private ElementFacade tooltipCanceledElement() {
        return this.findByXPathOrCSS("//span[contains(text(), 'Canceled')]//ancestor::*[contains(@class, 'v-tooltip__content')]");
    }

    private ElementFacade tooltipDeletedActivity() {
        return this.findByXPathOrCSS("//span[contains(text(), 'Rejected due to activity')]//ancestor::*[contains(@class, 'v-tooltip__content')]");
    }

    private int achievementsCount(String actionTitle) {
        return this.findAll(By.xpath((String)String.format("//*[contains(@id, 'GamificationRealizationItem')]//td[1]//*[contains(text(), '%s')]", actionTitle))).size();
    }

    private String checkAchievementsCount(String actionTitle, long times, long found) {
        if (found < times) {
            throw new IllegalStateException(String.format("Expected to find '%s' achievement %s times, but was %s times", actionTitle, times, found));
        }
        if (found > times) {
            return String.format("Expected to find '%s' achievement %s times which was more than expected %s times", actionTitle, found, times);
        }
        return null;
    }
}

