/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ActionsPage
extends GenericPage {
    public ActionsPage(WebDriver driver) {
        super(driver);
    }

    public void openEditChallengeDrawer(String challengeName) {
        this.searchAction(challengeName);
        this.actionCard(challengeName).hover();
        ElementFacade menuThreeDots = this.editChallengeThreeDots(challengeName);
        menuThreeDots.assertVisible();
        menuThreeDots.click();
        this.editChallengeButton(challengeName).click();
        this.waitForDrawerToOpen();
        Utils.waitForLoading();
    }

    public void searchAction(String actionName) {
        TextBoxElementFacade searchField = this.searchChallengeElement();
        searchField.setTextValue("");
        this.waitFor(300).milliseconds();
        Utils.waitForLoading();
        searchField.setTextValue(actionName);
        this.waitFor(300).milliseconds();
        Utils.waitForLoading();
        boolean visible = this.actionCard(actionName).isVisible();
        int retry = 0;
        while (!visible && retry++ < Utils.MAX_WAIT_RETRIES) {
            searchField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            this.waitFor(300).milliseconds();
            Utils.waitForLoading();
            visible = this.actionCard(actionName).isVisible();
        }
    }

    public void isOverviewChallengeDisplayed(String challengeTitle, String participantsCount) {
        this.getOverviewChallengeItemElement(challengeTitle, participantsCount).isVisible();
    }

    public void isOverviewChallengeNotDisplayed(String challengeTitle, String participantsCount) {
        this.getOverviewChallengeItemElement(challengeTitle, participantsCount).isNotVisible();
    }

    public void checkChallengePoints(String challengeName, String points) {
        this.challengeByNameAndPoints(challengeName, points).assertVisible();
    }

    public void enableActionPublication() {
        ElementFacade publicationSwitchButton = this.publicationSwitchButton();
        publicationSwitchButton.assertVisible();
        publicationSwitchButton.click();
        this.waitFor(200).milliseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionPublicationMessage(String message) {
        this.waitCKEditorLoading("//*[@id='engagementCenterRulePublishMessage']");
        ElementFacade ckEditorFrame = this.ckEditorFramePublicationElement();
        ckEditorFrame.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrame);
        try {
            TextBoxElementFacade ckEditorTextBoxElement = this.ckEditorTextBoxElement();
            ckEditorTextBoxElement.waitUntilVisible();
            ckEditorTextBoxElement.setTextValue(message);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void openActionActivity() {
        this.waitForDrawerToOpen();
        ElementFacade actionDrawerThreeDots = this.actionDrawerThreeDots();
        actionDrawerThreeDots.assertVisible();
        actionDrawerThreeDots.click();
        this.waitFor(200).milliseconds();
        this.clickLink("Open activity");
        Utils.waitForLoading();
    }

    public void openActionFromActivity() {
        this.waitForDrawerToOpen();
        ElementFacade actionDrawerThreeDots = this.actionDrawerThreeDots();
        actionDrawerThreeDots.assertVisible();
        actionDrawerThreeDots.click();
        this.waitFor(200).milliseconds();
        this.clickLink("Open quest");
        Utils.waitForLoading();
    }

    public void checkParticipantsCount(int count) {
        Assertions.assertThat((int)this.findAll("//*[contains(@class, 'rule-realizations')]//button//*[contains(@class, 'v-avatar')]", new Object[0]).size()).isEqualTo(count).as("Number of participants doesn't match", new Object[0]);
    }

    private TextBoxElementFacade searchChallengeElement() {
        return this.findTextBoxByXPathOrCSS("//input[@id='applicationToolbarFilterInput']");
    }

    private ElementFacade challengeByNameAndPoints(String challengeName, String points) {
        return this.findByXPathOrCSS(String.format("//*[@id='rulesList']//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'rule-card-info')]//*[contains(text(), '+ %s')]", challengeName, points));
    }

    private ElementFacade editChallengeThreeDots(String challengeName) {
        return this.findByXPathOrCSS(String.format("//*[@id='rulesList']//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'rule-card-info')]//*[contains(@class, 'fa-ellipsis')]", challengeName));
    }

    private ElementFacade actionCard(String challengeName) {
        return this.findByXPathOrCSS(String.format("//*[@id='rulesList']//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'rule-card-info')]", challengeName));
    }

    private ElementFacade editChallengeButton(String challengeName) {
        return this.findByXPathOrCSS(String.format("//*[@id='rulesList']//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'rule-card-info')]//*[contains(@class, 'v-menu')]//*[contains(text(), 'Edit')]", challengeName));
    }

    private ElementFacade getOverviewChallengeItemElement(String challengeTitle, String participantsCount) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]/following::*[contains(text(), '%s')]", challengeTitle, participantsCount + " Participants"));
    }

    private ElementFacade publicationSwitchButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[@id='engagementCenterRulePublishSwitch' and @aria-checked='false']//ancestor::*[contains(@class, 'v-input--switch')]");
    }

    private ElementFacade actionDrawerThreeDots() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerHeader')]//*[contains(@class, 'fa-ellipsis-v')]");
    }

    private ElementFacade ckEditorFramePublicationElement() {
        return this.findByXPathOrCSS("//*[@id='engagementCenterRulePublishMessage']//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private TextBoxElementFacade ckEditorTextBoxElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }
}

