/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ButtonElementFacadeImpl;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.ElementFacadeImpl;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacadeImpl;
import io.meeds.qa.ui.elements.TextElementFacade;
import io.meeds.qa.ui.elements.TextElementFacadeImpl;
import io.meeds.qa.ui.pages.BasePage;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.annotations.WhenPageOpens;
import net.thucydides.core.pages.PageObject;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePageImpl
extends PageObject
implements BasePage {
    private static final String CAN_T_WAIT_FOR_PROGRESS_BAR_TO_FINISH_LOADING = "Can't wait for progress bar to finish loading";
    protected static final Logger LOGGER = LoggerFactory.getLogger(BasePageImpl.class);
    public static final String OPENED_DRAWER_XPATH = "//*[contains(@class, 'v-navigation-drawer--open')]";
    public static final String OPENED_DRAWER_CSS_SELECTOR = ".v-navigation-drawer--open";
    public static final String UPLOAD_DIRECTORY_PATH = GenericPage.class.getResource("/DataFiles/").getFile();
    public static final String USER_AVATAR_PNG = "cap02.png";
    public static final String GIF_IMAGE = "cap04.gif";
    public static final String PUBLIC_SITE_URL = "/portal/public";
    protected String url;

    public BasePageImpl() {
        this(null);
    }

    public BasePageImpl(WebDriver driver) {
        super(driver);
    }

    public void clickOnElement(ElementFacade element) {
        element.click();
    }

    public void closeAlertIfOpened() {
        try {
            this.getDriver().switchTo().alert().accept();
        }
        catch (NoAlertPresentException noAlertPresentException) {
            // empty catch block
        }
    }

    public void clickToConfirmDialog() {
        ElementFacade okButton = this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[contains(@class, 'primary')]");
        if (okButton.isVisible()) {
            okButton.click();
            okButton.waitUntilNotVisible();
        }
    }

    public void closeConfirmDialogIfDisplayed() {
        ElementFacade okButton = this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[contains(@class, 'primary')]");
        if (okButton.isCurrentlyVisible()) {
            okButton.click();
            okButton.waitUntilNotVisible();
        }
    }

    public void clickToCancelDialog() {
        ElementFacade cancelButton = this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[not(contains(@class, 'primary'))]");
        cancelButton.click();
        cancelButton.waitUntilNotVisible();
    }

    public void closeToastNotification(boolean waitElement) {
        ElementFacade closeAlertButton = this.findByXPathOrCSS(".v-snack--active .v-alert .fa-times");
        if (waitElement ? closeAlertButton.isVisible() : closeAlertButton.isCurrentlyVisible()) {
            try {
                closeAlertButton.click();
                closeAlertButton.waitUntilNotVisible();
            }
            catch (Exception exception) {}
        } else {
            closeAlertButton = this.findByXPathOrCSS(".v-alert .fa-times");
            if (waitElement ? closeAlertButton.isVisible() : closeAlertButton.isCurrentlyVisible()) {
                try {
                    closeAlertButton.click();
                    closeAlertButton.waitUntilNotVisible();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void closeAllDialogs() {
        int i = Utils.MAX_WAIT_RETRIES * 2;
        while (this.openedDialogElement().isCurrentlyVisible() && i-- > 0) {
            if (this.dialogCloseIcon().isCurrentlyVisible()) {
                this.dialogCloseIcon().click();
            } else {
                this.pressEscape();
            }
            try {
                this.waitOverlayToClose();
            }
            catch (Exception e) {
                LOGGER.debug("Dialog seems not displayed", (Throwable)e);
            }
        }
        if (i == 0) {
            this.openedDialogElement().checkNotVisible();
        }
    }

    public void closeMenu() {
        this.pressEscape();
        this.waitFor(300).milliseconds();
    }

    public boolean isMenuDisplayed() {
        return this.activeMenuElement().isCurrentlyVisible();
    }

    public void waitMenuToDisplay() {
        this.activeMenuElement().waitUntilVisible();
    }

    public void closeAllDrawers() {
        int i = Utils.MAX_WAIT_RETRIES * 2;
        while (this.openedDrawerElement().isCurrentlyVisible() && i-- > 0) {
            if (i > Utils.MAX_WAIT_RETRIES) {
                this.pressEscape();
            } else {
                ElementFacade drawerCloseIcon = this.drawerCloseIcon();
                if (drawerCloseIcon.isCurrentlyVisible()) {
                    drawerCloseIcon.click();
                } else {
                    return;
                }
            }
            this.closeAlertIfOpened();
            this.closeConfirmDialogIfDisplayed();
            this.waitFor(200).milliseconds();
        }
        this.waitForDrawerToClose();
        if (i == 0) {
            this.openedDrawerElement().checkNotVisible();
        }
    }

    private ElementFacade drawerCloseIcon() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerIcons')]//*[contains(@class, 'close') or contains(@class, 'times')])[last()]");
    }

    private ElementFacade dialogCloseIcon() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-dialog--active')]//*[contains(@class, 'close') or contains(@class, 'times')])[last()]");
    }

    public boolean closeDrawerIfDisplayed() {
        if (this.openedDrawerElement().isCurrentlyVisible()) {
            this.closeDrawer();
            this.closeAlertIfOpened();
            this.waitForDrawerToClose();
            return true;
        }
        return false;
    }

    public void expandDrawer() {
        this.expandDrawerButton().checkVisible();
        this.expandDrawerButton().click();
    }

    public void clickOnGoBack() {
        this.goBackButton().click();
    }

    public void clickOnGoBackInDrawer() {
        this.goBackButtonInDrawer().click();
    }

    public void clickButton(String buttonText, int index) {
        ElementFacade button = this.getButton(buttonText, index);
        button.checkVisible();
        button.checkEnabled();
        button.click();
        Utils.waitForLoading();
    }

    public void clickButton(String buttonText) {
        ElementFacade button = this.getButton(buttonText);
        button.checkEnabled();
        button.click();
        Utils.waitForLoading();
    }

    public void clickMenuItem(String menuItemText) {
        ElementFacade menuItem = this.getMenuItem(menuItemText);
        menuItem.checkVisible();
        menuItem.click();
        Utils.waitForLoading();
    }

    public void clickLink(String linkText) {
        ElementFacade button = this.getLink(linkText);
        button.checkEnabled();
        button.click();
        Utils.waitForLoading();
    }

    public void clickOnText(String text) {
        ElementFacade textElement = this.getText(text);
        textElement.checkEnabled();
        textElement.click();
        Utils.waitForLoading();
    }

    public void clickDrawerButton(String buttonText) {
        ElementFacade button = this.getDrawerButton(buttonText);
        button.checkVisible();
        button.checkEnabled();
        button.click();
        Utils.waitForLoading();
    }

    public void clickSelecdLevelDrawerButton(String buttonText) {
        AtomicInteger index = new AtomicInteger();
        Utils.retryOnCondition(() -> {
            ElementFacade button = this.getSelecdLevelDrawerButton(buttonText, index.getAndIncrement());
            button.checkEnabled();
            button.click();
        });
        Utils.waitForLoading();
    }

    public void buttonIsDisabled(String buttonText) {
        this.getButton(buttonText).assertDisabled();
    }

    public void buttonIsEnabled(String buttonText) {
        this.getButton(buttonText).assertEnabled();
    }

    public void buttonInDrawerIsDisabled(String buttonText) {
        this.getDrawerButton(buttonText).assertDisabled();
    }

    public void buttonInDrawerIsEnabled(String buttonText) {
        this.getDrawerButton(buttonText).assertEnabled();
    }

    public void buttonInDrawerIsNotDisplayed(String buttonText) {
        this.getDrawerButton(buttonText).assertNotVisible();
    }

    public void buttonInDrawerIsDisplayed(String buttonText) {
        this.getDrawerButton(buttonText).assertVisible();
    }

    public ButtonElementFacade findButtonByXPathOrCSS(String xpath) {
        WebElementFacade nestedElement = this.getWebElementFacadeByXPathOrCSS(xpath);
        return ButtonElementFacadeImpl.wrapWebElementFacadeInButtonElement(this.getDriver(), nestedElement, null, xpath, Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, Utils.DEFAULT_WAIT_FOR_TIMEOUT);
    }

    public ElementFacade findByXPathOrCSS(String xpathOrCSSSelector) {
        WebElementFacade nestedElement = this.getWebElementFacadeByXPathOrCSS(xpathOrCSSSelector);
        return ElementFacadeImpl.wrapWebElementFacade(this.getDriver(), nestedElement, null, xpathOrCSSSelector, Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, Utils.DEFAULT_WAIT_FOR_TIMEOUT);
    }

    public TextBoxElementFacade findTextBoxByXPathOrCSS(String xpathOrCSSSelector) {
        WebElementFacade nestedElement = this.getWebElementFacadeByXPathOrCSS(xpathOrCSSSelector);
        return TextBoxElementFacadeImpl.wrapWebElementFacadeInTextBoxElement(this.getDriver(), nestedElement, null, xpathOrCSSSelector, Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, Utils.DEFAULT_WAIT_FOR_TIMEOUT);
    }

    public TextElementFacade findTextByXPathOrCSS(String xpath) {
        WebElementFacade nestedElement = this.getWebElementFacadeByXPathOrCSS(xpath);
        return TextElementFacadeImpl.wrapWebElementFacadeInTextElement(this.getDriver(), nestedElement, null, xpath, Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT, Utils.DEFAULT_WAIT_FOR_TIMEOUT);
    }

    public String getCurrentUrl() {
        return this.getDriver().getCurrentUrl();
    }

    public boolean mentionInField(TextBoxElementFacade inputField, String user, int maxRetries) {
        inputField.waitUntilVisible();
        if (!inputField.getTagName().equals("input")) {
            inputField = (TextBoxElementFacade)inputField.findBy("input");
            inputField.checkVisible();
        }
        inputField.setTextValue(user + "x");
        boolean visible = false;
        int retry = 0;
        Duration retryWaitTime = Duration.ofSeconds(1L);
        do {
            inputField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            this.waitFor(300).milliseconds();
            ElementFacade suggesterElement = this.findByXPathOrCSS(String.format("//div[contains(@class,'identitySuggestionMenuItemText') and contains(text(),'%s')]", user.substring(0, user.length() - retry - 1)));
            suggesterElement.setImplicitTimeout(retryWaitTime);
            visible = suggesterElement.isVisible();
            if (!visible) continue;
            suggesterElement.click();
            return true;
        } while (!visible && retry++ < maxRetries);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mentionUserInCKEditor(ElementFacade ckEditorFrame, TextBoxElementFacade ckEditorBody, String content, String user, boolean shouldExists) {
        this.waitCKEditorLoading();
        Utils.retryOnCondition(() -> {
            ckEditorFrame.waitUntilVisible();
            this.getDriver().switchTo().frame((WebElement)ckEditorFrame);
        }, () -> ((WebDriver.TargetLocator)this.getDriver().switchTo()).defaultContent());
        try {
            ckEditorBody.waitUntilVisible();
            ckEditorBody.setTextValue(content + " @" + user + "x");
            ckEditorBody.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            boolean visible = false;
            int retry = 0;
            int maxRetries = shouldExists ? 5 : 3;
            Duration retryWaitTime = shouldExists ? Duration.ofSeconds(1L) : Duration.ofMillis(300L);
            do {
                ckEditorBody.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                if (shouldExists) {
                    this.waitFor(1).seconds();
                }
                this.getDriver().switchTo().defaultContent();
                try {
                    ElementFacade suggesterElement = this.findByXPathOrCSS(String.format("//*[contains(@class, 'atwho-view')]//*[contains(text(), '%s')]", user.substring(0, user.length() - retry - 1)));
                    suggesterElement.setImplicitTimeout(retryWaitTime);
                    visible = suggesterElement.isVisible();
                }
                finally {
                    this.getDriver().switchTo().frame((WebElement)ckEditorFrame);
                }
            } while (!visible && retry++ < maxRetries);
            if (visible) {
                ckEditorBody.sendKeys(new CharSequence[]{Keys.ENTER});
            }
            boolean bl = visible;
            return bl;
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public ElementFacade openedDialogElement() {
        return this.findByXPathOrCSS(".v-dialog--active");
    }

    public ElementFacade openedDrawerElement() {
        return this.findByXPathOrCSS(OPENED_DRAWER_CSS_SELECTOR);
    }

    public ElementFacade expandDrawerButton() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open .mdi-arrow-expand");
    }

    public ElementFacade notificationContentElement(String message) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@id, 'notifItem-')]//*[contains(text(),'%s')]/parent::*", message));
    }

    public ElementFacade notificationContentElement(String message, String content) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@id, 'notifItem-')]//*[contains(text(),'%s')]//ancestor::*[contains(@id, 'notifItem-')]//*[contains(text(),'%s')]/parent::*", message, content));
    }

    @WhenPageOpens
    public void verifyPageLoaded() {
        Utils.waitForLoading(Utils.DEFAULT_WAIT_PAGE_LOADING, false);
    }

    public void waitCKEditorLoading() {
        this.waitCKEditorLoading("");
    }

    public void waitDrawerCKEditorLoading() {
        this.waitCKEditorLoading(OPENED_DRAWER_XPATH);
    }

    public void waitCKEditorLoading(String parentXPath) {
        try {
            this.getDriver().switchTo().defaultContent();
            ElementFacade iframeElement = this.findByXPathOrCSS(parentXPath + "//iframe[contains(@class,'cke_wysiwyg_frame')]");
            if (!iframeElement.isCurrentlyVisible()) {
                Utils.retryOnCondition(() -> {
                    ElementFacade richTextLoadingElement = this.findByXPathOrCSS(parentXPath + "//*[contains(@class, 'loadingRing')]");
                    if (richTextLoadingElement.isCurrentlyVisible()) {
                        richTextLoadingElement.waitUntilNotVisible();
                    }
                    iframeElement.setImplicitTimeout(this.getImplicitWaitTimeout().multipliedBy(3L));
                    iframeElement.waitUntilVisible();
                }, () -> this.getDriver().switchTo().defaultContent());
            }
        }
        catch (Exception e) {
            LOGGER.warn(CAN_T_WAIT_FOR_PROGRESS_BAR_TO_FINISH_LOADING, (Throwable)e);
        }
    }

    public void waitForDrawerToClose() {
        this.waitForDrawerToClose(null, true);
    }

    public void waitForDrawerToClose(String drawerId, boolean withOverlay) {
        this.closeAlertIfOpened();
        String drawerSelector = StringUtils.isBlank((CharSequence)drawerId) ? OPENED_DRAWER_CSS_SELECTOR : drawerId;
        ElementFacade drawerElement = this.findByXPathOrCSS(drawerSelector);
        if (drawerElement.isCurrentlyVisible()) {
            try {
                drawerElement.waitUntilNotVisible();
                if (withOverlay) {
                    this.waitOverlayToClose();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Overlay seems not displayed", (Throwable)e);
            }
        }
    }

    public void waitForDrawerToLoad() {
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(30L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeScript("return document.readyState === 'complete'  && (!document.getElementById('TopbarLoadingContainer') || !!document.querySelector('.TopbarLoadingContainer.hidden')) && !!document.querySelector('.v-navigation-drawer--open') && !document.querySelector('.v-navigation-drawer--open .v-progress-linear')", new Object[0]).toString().equals("true"));
    }

    public void waitForDrawerToOpen() {
        this.waitForDrawerToOpen(null, true, false);
    }

    public void waitForDrawerToOpen(boolean throwException) {
        this.waitForDrawerToOpen(null, true, throwException);
    }

    public void waitForDrawerToOpen(String drawerId, boolean withOverlay) {
        this.waitForDrawerToOpen(null, true, false);
    }

    public void waitForDrawerToOpen(boolean withOverlay, boolean throwException) {
        this.waitForDrawerToOpen(null, withOverlay, throwException);
    }

    public void waitForDrawerToOpen(String drawerId, boolean withOverlay, boolean throwException) {
        String drawerSelector = StringUtils.isBlank((CharSequence)drawerId) ? OPENED_DRAWER_CSS_SELECTOR : drawerId;
        try {
            this.findByXPathOrCSS(drawerSelector).waitUntilVisible();
            if (withOverlay) {
                this.findByXPathOrCSS(".v-overlay").waitUntilVisible();
            }
        }
        catch (RuntimeException e) {
            if (throwException) {
                throw e;
            }
            LOGGER.debug("Overlay seems not displayed", (Throwable)e);
        }
    }

    public void waitForProgressBar() {
        this.waitForProgressBar(false);
    }

    public void waitForProgressBar(boolean waitForProgress) {
        if (waitForProgress) {
            try {
                this.pageProgressBar().waitUntilVisible();
            }
            catch (Exception e) {
                LOGGER.warn("Can't wait for progress bar to appear", (Throwable)e);
            }
        }
        try {
            ElementFacade progressBar = this.pageProgressBar();
            if (progressBar.isCurrentlyVisible()) {
                progressBar.waitUntilNotVisible();
            }
        }
        catch (Exception e) {
            LOGGER.warn(CAN_T_WAIT_FOR_PROGRESS_BAR_TO_FINISH_LOADING, (Throwable)e);
        }
    }

    public ElementFacade pageProgressBar() {
        return this.findByXPathOrCSS(".UISiteBody .v-progress-linear");
    }

    public void waitForMenuToOpen(String contentClass) {
        try {
            ElementFacade menu = this.findByXPathOrCSS(String.format("//*[contains(@class, 'menuable__content__active') and contains(@class, '%s')]", contentClass));
            menu.waitUntilVisible();
        }
        catch (Exception e) {
            LOGGER.warn(CAN_T_WAIT_FOR_PROGRESS_BAR_TO_FINISH_LOADING, (Throwable)e);
        }
    }

    public void waitForMenuToClose(String contentClass) {
        try {
            ElementFacade menu = this.findByXPathOrCSS(String.format("//*[contains(@class, 'menuable__content__active') and contains(@class, '%s')]", contentClass));
            menu.waitUntilNotVisible();
        }
        catch (Exception e) {
            LOGGER.warn(CAN_T_WAIT_FOR_PROGRESS_BAR_TO_FINISH_LOADING, (Throwable)e);
        }
    }

    public ElementFacade getButton(String buttonText) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::button", buttonText));
    }

    public ElementFacade getButton(String buttonText, int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor-or-self::button)[%s]", buttonText, index + 1));
    }

    public ElementFacade getMenuItem(String menuItemText) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@role, 'menuitem')]", menuItemText));
    }

    public ElementFacade getLink(String linkText) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::a", linkText));
    }

    public ElementFacade getText(String text) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]", text));
    }

    public ElementFacade getDrawerButton(String buttonName) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor-or-self::button)[last()]", buttonName));
    }

    public ElementFacade getSelecdLevelDrawerButton(String buttonName, int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor-or-self::button)[%s]", buttonName, index));
    }

    public void attachImageToOpenedDrawer() {
        this.attachImageToFileInput(".v-navigation-drawer--open input[type=file]", USER_AVATAR_PNG);
        this.waitFor(200).milliseconds();
        AtomicInteger index = new AtomicInteger();
        Utils.retryOnCondition(() -> this.clickButton("Apply", index.getAndIncrement()), () -> this.waitFor(200).milliseconds());
    }

    public void attachGifImageToCKeditor() {
        this.attachImageToCKeditor(GIF_IMAGE);
    }

    public void attachImageToCKeditor() {
        this.attachImageToCKeditor(USER_AVATAR_PNG);
    }

    public void attachImageToCKeditor(String fileName) {
        AtomicInteger atomicInteger;
        int i = -1;
        while (++i < 5 && !this.ckEditorAttachImageButton(i).isCurrentlyVisible()) {
        }
        if (i < 5 && i > 0) {
            AtomicInteger atomicInteger2 = new AtomicInteger(--i);
            atomicInteger = atomicInteger2;
        } else {
            atomicInteger = new AtomicInteger();
        }
        AtomicInteger index = atomicInteger;
        Utils.retryOnCondition(() -> this.ckEditorAttachImageButton(index.incrementAndGet()).checkCurrentlyVisible());
        int initialImagesCount = this.ckEditorAttachImageCount(index.get());
        Utils.retryOnCondition(() -> {
            if (this.ckEditorAttachImageCount(index.get()) == initialImagesCount) {
                ElementFacade fileInput = this.ckEditorAttachImageInput(index.get());
                fileInput.checkEnabled();
                this.waitFor(1).seconds();
                this.attachImageToFileInput(fileInput, fileName);
                this.ckEditorImageAttachmentProgressElement(index.get()).checkVisible();
                Utils.retryOnCondition(() -> this.ckEditorImageAttachmentProgressElement(index.get()).waitUntilNotVisible());
                Utils.retryOnCondition(() -> this.ckEditorImageAttachmentEditButton(index.get()).waitUntilVisible());
                this.ckEditorImageAttachmentCarousel(index.get()).checkVisible();
                this.ckEditorImageAttachmentPlusIcon(index.get()).checkVisible();
                this.ckEditorAttachImageInputParent(index.get()).checkVisible();
            }
        });
    }

    public ElementFacade attachFileInput(boolean secondLevel) {
        String fileInputXPath = (secondLevel ? OPENED_DRAWER_XPATH : "") + "//*[contains(@class, 'v-navigation-drawer--open')]//*[@type='file']";
        return this.findByXPathOrCSS(fileInputXPath);
    }

    public void attachImageToFileInput(String xPathOrCss, String fileName) {
        Utils.retryOnCondition(() -> {
            ElementFacade fileInput = this.findByXPathOrCSS(xPathOrCss);
            fileInput.waitUntilEnabled();
            this.upload(UPLOAD_DIRECTORY_PATH + fileName).fromLocalMachine().to(fileInput.getElement());
        }, () -> this.waitFor(500).milliseconds());
        this.waitForProgressBar();
    }

    public void attachImageToFileInput(ElementFacade fileInput, String fileName) {
        Utils.retryOnCondition(() -> this.upload(UPLOAD_DIRECTORY_PATH + fileName).fromLocalMachine().to(fileInput.getElement()), () -> this.waitFor(500).milliseconds());
        this.waitForProgressBar();
    }

    public void pressEscape() {
        this.findByXPathOrCSS("//body").sendKeys(new CharSequence[]{Keys.ESCAPE});
    }

    private void closeDrawer() {
        this.closeDrawer(Utils.MAX_WAIT_RETRIES);
    }

    private void closeDrawer(int i) {
        if (i == 0) {
            throw new IllegalStateException("Drawer can't be closed");
        }
        if (this.drawerCloseIcon().isClickable()) {
            try {
                this.drawerCloseIcon().click();
            }
            catch (Throwable e) {
                this.pressEscape();
            }
        } else {
            this.pressEscape();
        }
    }

    private WebElementFacade getWebElementFacadeByXPathOrCSS(String xpathOrCss) {
        if (StringUtils.contains((CharSequence)xpathOrCss, (CharSequence)"//")) {
            return this.find(By.xpath((String)xpathOrCss));
        }
        return this.find(By.cssSelector((String)xpathOrCss));
    }

    private ElementFacade goBackButton() {
        return this.findByXPathOrCSS("#UIPage .fa-arrow-left");
    }

    private ElementFacade goBackButtonInDrawer() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open .fa-arrow-left");
    }

    private void waitOverlayToClose() {
        this.findByXPathOrCSS(".v-overlay").waitUntilNotVisible();
    }

    private ElementFacade activeMenuElement() {
        return this.findByXPathOrCSS(".menuable__content__active");
    }

    private ElementFacade ckEditorAttachImageInput(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//input[@type='file']", index));
    }

    private ElementFacade ckEditorAttachImageInputParent(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//input[@type='file']/ancestor::*[contains(@class, 'v-input')]/parent::*", index));
    }

    private int ckEditorAttachImageCount(int index) {
        return this.findAll(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//input[@type='file']/ancestor::*[contains(@class, 'v-input')]/parent::*//*[contains(@class, 'v-image')]/parent::*[contains(@class,'v-card')]", index), new Object[0]).size();
    }

    private ElementFacade ckEditorAttachImageButton(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]//a[contains(@class, 'cke_button__attachimage')]", index));
    }

    private ElementFacade ckEditorImageAttachmentCarousel(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//*[contains(@class, 'carousel-top-parent')]", index));
    }

    private ElementFacade ckEditorImageAttachmentPlusIcon(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//*[contains(@class, 'carousel-top-parent')]//*[contains(@class, 'fa-plus')]", index));
    }

    private ElementFacade ckEditorImageAttachmentProgressElement(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//*[contains(@class, 'v-progress-circular')]", index));
    }

    private ElementFacade ckEditorImageAttachmentEditButton(int index) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'richEditor')])[%s]/parent::*//*[contains(@class, 'fa-edit')]", index));
    }
}

