/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.BasePageImpl;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class GenericPage
extends BasePageImpl {
    public GenericPage() {
        this(null);
    }

    public GenericPage(WebDriver driver) {
        super(driver);
        this.url = "genericPage";
    }

    public void switchPageLanguage(String lang) {
        String currentUrl = this.getDriver().getCurrentUrl();
        Utils.retryOnCondition(() -> {
            this.getDriver().navigate().to(currentUrl.replaceAll("/portal/(.*)$", "/portal"));
            Utils.waitForLoading();
            this.getDriver().navigate().to(this.getDriver().getCurrentUrl().replace("/portal", "/portal/" + lang));
            Utils.waitForLoading();
            this.getDriver().navigate().to(currentUrl);
            Utils.waitForLoading();
            this.pageLangBodyElement(lang).assertVisible();
        });
    }

    public void checkConfirmMessageIsDisplayed(String message) {
        ElementFacade confirmMessageElement = this.getDisplayedConfirmMessage();
        confirmMessageElement.assertVisible();
        Assertions.assertThat((String)confirmMessageElement.getText()).contains(new CharSequence[]{message});
    }

    public void checkMessageIsDisplayed(String message) {
        this.messageElement(message).assertVisible();
    }

    public void checkMessageIsNotDisplayed(String message) {
        this.messageElement(message).assertNotVisible();
    }

    public void checkMessageIsDisplayedInPage(String message) {
        this.messageElementInPage(message).assertVisible();
    }

    public void checkMessageIsNotDisplayedInPage(String message) {
        this.messageElementInPage(message).assertNotVisible();
    }

    public void checkDrawerDisplayed(String title) {
        this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class, 'drawerTitle')]", title)).assertVisible();
    }

    public void clickConfirm() {
        this.clickToConfirmDialog();
        this.waitFor(200).milliseconds();
    }

    public ButtonElementFacade getWidgetSeeAllButton(String widgetId) {
        return this.findButtonByXPathOrCSS(String.format("//*[@id = '%s']//*[contains(@class, 'widget-text-header')]//*[contains(@class, 'primary')]//ancestor::button", widgetId));
    }

    public ButtonElementFacade getDrawerExpandButton(String drawerId) {
        return this.findButtonByXPathOrCSS(String.format("//*[@id = '%s' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerHeader')]//*[contains(@class, 'expand')]//ancestor::button", drawerId));
    }

    public void closeBrowserTab(int index) {
        Utils.switchToTabByIndex(this.getDriver(), index);
        this.getDriver().close();
        if (index > 0) {
            Utils.switchToTabByIndex(this.getDriver(), index - 1);
        }
    }

    public boolean containsContent(String content) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]", content)).isVisible();
    }

    public boolean isButtonDisplayed(String buttonName) {
        return this.getButton(buttonName).isVisible();
    }

    public void isPageOpened(String uriPart) {
        Assert.assertTrue((boolean)this.getDriver().getCurrentUrl().contains(uriPart));
    }

    public void checkSuccessMessageDisplayed() {
        this.findByXPathOrCSS("//*[contains(@class, 'v-alert')]//*[contains(@class, 'success')]").assertVisible();
    }

    public void checkInformationMessageDisplayed() {
        this.findByXPathOrCSS("//*[contains(@class, 'v-alert')]//*[contains(@class, 'info')]").assertVisible();
    }

    public void checkSwitchButtonNotDisplayed(String buttonName) {
        this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-input--switch')]/parent::*//*[contains(text(), '%s')]", buttonName)).assertNotVisible();
    }

    public void checkSwitchButtonDisplayed(String buttonName) {
        this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-input--switch')]/parent::*//*[contains(text(), '%s')]", buttonName)).assertVisible();
    }

    public void enableSwitchButtonDisplayed(String buttonName) {
        this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]/parent::*//*[contains(@class, 'v-input--switch')]", buttonName)).click();
        this.waitFor(200).milliseconds();
    }

    public void checkTranslationButtonIsPrimary(int index) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.translationButton(index).hasClass("primary--text")).as("Translation button should be primary", new Object[0])).isTrue();
    }

    public void checkTranslationButtonIsNotPrimary(int index) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.translationButton(index).hasClass("primary--text")).as("Translation button should not be primary", new Object[0])).isFalse();
    }

    public void openTranslationsDrawer(int index) {
        this.translationButton(index).assertVisible();
        this.translationButton(index).click();
    }

    public void addTranslationValues(String fieldType, Map<String, String> valuesByLanguage) {
        valuesByLanguage.forEach((lang, label) -> {
            this.addTranslationButton().click();
            this.lastTranslationLanguageSelect().selectByValue((String)lang);
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"text") || StringUtils.equals((CharSequence)fieldType, (CharSequence)"field") || StringUtils.equals((CharSequence)fieldType, (CharSequence)"input")) {
                this.lastTranslationLanguageInput().setTextValue((String)label);
            } else if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"rich editor")) {
                this.lastTranslationDropdownButton().click();
                this.waitCKEditorLoading("//*[@id = 'translationDrawer']");
                this.translationCKEditor();
                Utils.retryOnCondition(() -> {
                    ElementFacade ckEditorFrameKudos = this.translationCKEditor();
                    ckEditorFrameKudos.waitUntilVisible();
                    this.getDriver().switchTo().frame((WebElement)ckEditorFrameKudos);
                }, () -> {
                    this.getDriver().switchTo().defaultContent();
                    this.waitFor(500).milliseconds();
                });
                try {
                    TextBoxElementFacade kudosFieldElement = this.translationCKEditorElement();
                    kudosFieldElement.waitUntilVisible();
                    kudosFieldElement.setTextValue((String)label);
                }
                finally {
                    this.getDriver().switchTo().defaultContent();
                }
                this.getDriver().switchTo().defaultContent();
            } else {
                throw new IllegalStateException("Translation Field Type " + fieldType + " is not recognized");
            }
        });
    }

    public void sortTableByField(String fieldText) {
        this.tableHeaderElement(fieldText).click();
    }

    public void clickOnApplicationFilterButton() {
        if (this.applicationToolbarConeButton().isVisible()) {
            this.applicationToolbarConeButton().click();
        }
    }

    public void goToPage(String link) {
        this.getDriver().navigate().to(this.getDriver().getCurrentUrl().split("/portal/")[0] + link);
        this.verifyPageLoaded();
    }

    private ElementFacade applicationToolbarConeButton() {
        return this.findByXPathOrCSS("//*[@id='applicationToolbarConeButton']");
    }

    private ElementFacade getDisplayedConfirmMessage() {
        return this.findByXPathOrCSS(".v-snack--active .v-alert__content");
    }

    private ElementFacade messageElement(String message) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]", message));
    }

    private ElementFacade messageElementInPage(String message) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'UIPage' or contains(@class, 'layout-page-parent')]//*[contains(text(), '%s') and not (@role)]", message));
    }

    private ElementFacade translationButton(int index) {
        return this.findByXPathOrCSS(String.format("(//button//*[contains(@class, 'fa-language')])[%s]", index));
    }

    private ElementFacade addTranslationButton() {
        return this.findByXPathOrCSS("//*[@id = 'translationDrawer']//button//*[contains(@class, 'fa-plus')]");
    }

    private ElementFacade lastTranslationLanguageSelect() {
        return this.findByXPathOrCSS("(//*[@id = 'translationDrawer']//select)[last()]");
    }

    private TextBoxElementFacade lastTranslationLanguageInput() {
        return this.findTextBoxByXPathOrCSS("(//*[@id = 'translationDrawer']//input)[last()]");
    }

    private ElementFacade lastTranslationDropdownButton() {
        return this.findByXPathOrCSS("(//*[@id = 'translationDrawer']//*[contains(@class, 'fa-chevron-down')])[last()]");
    }

    private ElementFacade translationCKEditor() {
        return this.findByXPathOrCSS("//*[@id = 'translationDrawer']//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private TextBoxElementFacade translationCKEditorElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable')]");
    }

    private ElementFacade tableHeaderElement(String fieldText) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor-or-self::th", fieldText));
    }

    private ElementFacade pageLangBodyElement(String lang) {
        return this.findByXPathOrCSS(String.format("//html[@lang='%s']//body", lang));
    }
}

