/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeVisibleException;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class HomePage
extends GenericPage {
    private static final String PORTAL_ROOT_CONTEXT_NO_SLASH = "/portal";
    private static final String PORTAL_ROOT_CONTEXT = "/portal/";
    private static final Map<String, String> ADMIN_URLS = new HashMap<String, String>();
    private String metaSiteName;

    public HomePage(WebDriver driver) {
        super(driver);
    }

    public void acceptConnectionInvitation(String userName) {
        this.getAcceptIconConnectionFromDrawer(userName).click();
    }

    public void acceptSpaceInvitation(String spaceName) {
        this.getAcceptIconSpaceFromDrawer(spaceName).click();
    }

    public void accessToAdministrationMenu() {
        if (!this.getCurrentUrl().contains("/portal/administration")) {
            this.closeAllDrawers();
            this.closeAllDialogs();
            this.administrationMenuElement().waitUntilVisible();
            this.getDriver().navigate().to(this.administrationMenuElement().getAttribute("href"));
            this.verifyPageLoaded();
        }
    }

    public void accessToRecentSpaces() {
        Utils.retryOnCondition(() -> {
            ElementFacade recentSpacesBtnElement;
            this.clickOnHamburgerMenu(true);
            ElementFacade recentSpacesIconElement = this.recentSpacesIconElement();
            if (recentSpacesIconElement.isPresent()) {
                recentSpacesIconElement.scrollToWebElement();
                recentSpacesIconElement.hover();
                Actions action = new Actions(this.getDriver());
                action.moveToElement((WebElement)recentSpacesIconElement).build().perform();
                recentSpacesBtnElement = this.recentSpacesBtnElement();
                if (!recentSpacesBtnElement.isVisible()) {
                    throw new ElementShouldBeVisibleException(String.format("Recent spaces arrow should be visible %s", recentSpacesBtnElement), null);
                }
            } else {
                throw new ElementShouldBeVisibleException(String.format("Recent spaces icon should be visible %s", recentSpacesIconElement), null);
            }
            recentSpacesBtnElement.click();
        }, Utils::refreshPage);
    }

    public void bookmarkActivity(String activity) {
        this.clickOnElement(this.getFavoriteIconActivity(activity));
    }

    public void checkExistingSpaceInvitation(String spaceName) {
        this.checkSpaceFromDrawer(spaceName).assertVisible();
    }

    public void checkFavIcon(String activity) {
        this.getFavoriteIconActivity(activity).assertVisible();
    }

    public void checkNoActivityDisplayed() {
        this.contextBoxWelcomeActivityElement().assertVisible();
    }

    public void checkNotExistingSpaceInvitation(String spaceName) {
        this.checkSpaceFromDrawer(spaceName).assertNotVisible();
    }

    public void checkPageIsDisplayed(String pageUri) {
        Assertions.assertThat((String)this.getDriver().getCurrentUrl()).contains(new CharSequence[]{pageUri});
    }

    public void clickOnArrowIcon() {
        this.spaceArrowIconElement().click();
    }

    public void clickOnCommentActivityNotification(String message, String activity, String comment) {
        this.commentActivityNotificationIsDisplayed(message, activity, comment);
        this.notificationContentElement(message, comment).click();
    }

    public void clickOnConnectionsBagde() {
        this.connectionsBadgeElement().click();
        this.waitForDrawerToOpen();
        Utils.waitForLoading();
    }

    public void clickOnHomeIcon(String pageName) {
        this.homeHoverButton(pageName).click();
    }

    public void clickOnHomeLink() {
        this.clickOnElement(this.homePageLinkElement());
    }

    public void checkHomeButtonPosition(String pageName) {
        if (this.getStickiedHamburgerMenuParent().isVisible()) {
            this.clickOnHamburgerMenu(true);
        }
        if (this.homeButtonElement(pageName).isNotVisible()) {
            this.hoverOnPageHomeIcon(pageName);
            this.clickOnHomeIcon(pageName);
            this.confirmationForChangeSiteHomeLink();
            this.homeButtonElement(pageName).assertVisible();
        }
    }

    public void clickOnSpaceInvitationWidget() {
        this.clickOnElement(this.spaceInvitationWidgetElement());
    }

    public void clickOnSpacesBagde() {
        this.clickOnElement(this.spacesBadgeElement());
    }

    public void clickSeeAll() {
        this.clickOnElement(this.seeAllLinkElement());
    }

    public void commentActivityNotificationIsDisplayed(String message, String activity, String comment) {
        Utils.retryOnCondition(() -> this.notificationContentElement(message).checkVisible(), () -> this.waitFor(2).seconds(), 10L);
        this.notificationContentElement(message).assertVisible();
        this.notificationContentElement(message, activity).assertVisible();
        this.notificationContentElement(message, comment).assertVisible();
    }

    public void confirmationForChangeSiteHomeLink() {
        this.clickToConfirmDialog();
        this.waitFor(200).milliseconds();
    }

    public void deactivateSwitcher() {
        ElementFacade switcherButtonElement = this.switcherButtonElement();
        Assert.assertTrue((boolean)switcherButtonElement.isVisible());
        this.clickOnElement(switcherButtonElement);
    }

    public void favoriteActivity(String activity) {
        this.clickOnElement(this.getFavoriteIconActivity(activity));
    }

    public void goToSite(String siteName) {
        this.goToSite(siteName, false);
    }

    public void goToSite(String siteName, boolean forceRefresh) {
        if (forceRefresh || !StringUtils.contains((CharSequence)this.getDriver().getCurrentUrl(), (CharSequence)(PORTAL_ROOT_CONTEXT + siteName))) {
            if (!this.getStickiedHamburgerMenuParent().isCurrentlyVisible()) {
                this.clickOnHamburgerMenu(true);
            }
            ElementFacade hamburgerMenuItemLink = this.hamburgerMenuItemLink(siteName);
            Assert.assertNotNull((String)String.format("Can't find Site %s from Sidebar", siteName), (Object)hamburgerMenuItemLink);
            hamburgerMenuItemLink.assertVisible();
            hamburgerMenuItemLink.click();
            Utils.waitForPageLoading();
            Assertions.assertThat((String)this.getDriver().getCurrentUrl()).contains(new CharSequence[]{PORTAL_ROOT_CONTEXT + siteName});
        } else {
            this.closeAllDrawers();
            this.closeAllDialogs();
        }
    }

    public void goToSiteNavigation(String siteName, String uriPart) {
        Utils.retryOnCondition(() -> this.goToSiteNavigation(siteName, uriPart, false), () -> this.closeAllDrawers());
        Assertions.assertThat((String)this.getDriver().getCurrentUrl()).contains(new CharSequence[]{PORTAL_ROOT_CONTEXT + siteName});
        Assertions.assertThat((String)this.getDriver().getCurrentUrl()).contains(new CharSequence[]{uriPart});
    }

    public void goToSiteNavigation(String siteName, String uriPart, boolean forceRefresh) {
        if (forceRefresh || !StringUtils.contains((CharSequence)this.getDriver().getCurrentUrl(), (CharSequence)(PORTAL_ROOT_CONTEXT + siteName)) || !StringUtils.endsWith((CharSequence)this.getDriver().getCurrentUrl(), (CharSequence)uriPart)) {
            if (!this.getStickiedHamburgerMenuParent().isCurrentlyVisible()) {
                this.clickOnHamburgerMenu(true);
            }
            ElementFacade hamburgerMenuItemLink = this.hamburgerMenuItemLink(siteName);
            Assert.assertNotNull((String)String.format("Can't find Site navigation %s from Sidebar", siteName), (Object)hamburgerMenuItemLink);
            hamburgerMenuItemLink.checkVisible();
            hamburgerMenuItemLink.hover();
            Actions action = new Actions(this.getDriver());
            action.moveToElement((WebElement)hamburgerMenuItemLink).build().perform();
            ElementFacade hamburgerMenuSiteArrowIcon = this.hamburgerMenuSiteArrowIcon();
            hamburgerMenuSiteArrowIcon.checkVisible();
            if (hamburgerMenuSiteArrowIcon.hasClass("fa-arrow-right")) {
                hamburgerMenuSiteArrowIcon.click();
            }
            this.hamburgerMenuSecondLevelItemLink(uriPart).click();
            Utils.waitForPageLoading();
        } else {
            this.closeAllDrawers();
            this.closeAllDialogs();
        }
    }

    public void goToAddGroups() {
        this.goToAdministrationPage("Organization/Groups");
    }

    public void goToAddUser() {
        this.goToAdministrationPage("Organization/Users");
    }

    public void goToMainSettings() {
        this.goToAdministrationPage("General/Appearance", true);
    }

    public void goToAccessCustomization() {
        this.goToAdministrationPage("General/Access", true);
    }

    public void goToNotificationAdminPage() {
        this.goToAdministrationPage("General/Notifications");
    }

    public void goToAppCenterAdminSetupPage() {
        this.goToAdministrationPage("Applications/Applications center");
    }

    public void goToHomePage() {
        this.closeAlertIfOpened();
        this.getDriver().get(this.getDriver().getCurrentUrl().split(PORTAL_ROOT_CONTEXT)[0]);
        Utils.waitForPageLoading();
    }

    public void goToMyProfile() {
        this.goToPageWithLink("/mycraft/profile", true);
    }

    public void goToPeoplePage() {
        this.goToPageWithLink("/mycraft/people", true);
    }

    public void goToSettingsPage() {
        this.goToPageWithLink("/mycraft/settings", true);
    }

    public void goToSpacesPage(boolean stickMenu) {
        this.goToPageWithLink("/mycraft/spaces", stickMenu);
    }

    public void goToStreamPage() {
        this.goToPageWithLink("/mycraft/dashboard", true);
    }

    public void goToPrograms() {
        this.goToContributePage();
        this.getWidgetSeeAllButton("programsOverview").click();
        this.getDrawerExpandButton("programsOverviewListDrawer").click();
    }

    public void goMyAchievements() {
        this.goToPageWithLink("/" + this.getMetaSiteName() + "/contributions/achievements#yours", true);
    }

    public void goToContributePage() {
        this.goToPageWithLink("/contribute", true);
    }

    public void hoverOnPageHomeIcon(String pageName) {
        this.waitFor(300).milliseconds();
        this.hamburgerMenuItemByName(pageName).assertVisible();
        this.hamburgerMenuItemByName(pageName).hover();
    }

    public void hoverSearchedSpaceInSideBarFilter(String space) {
        this.searchedSpaceInSideBarFilterHover(space).hover();
    }

    public void isArrowDisplayedAfterHoveringOnSpaceName() {
        this.spaceArrowIconElement().assertVisible();
    }

    public boolean isConnectionsBadgeWithNumberVisible(String number) {
        Utils.retryOnCondition(() -> this.getConnectionsBadge().checkVisible(), () -> this.waitFor(1).seconds());
        return this.getConnectionsBadgeWithNumber(number).isVisible();
    }

    public boolean isPortalDisplayed() {
        return this.getSiteBody().isCurrentlyVisible();
    }

    public void checkNoConnectionsBadge() {
        Assert.assertTrue((boolean)this.getConnectionsBadge().isNotVisible());
    }

    public void checkNoSpacesBadge() {
        Assert.assertTrue((boolean)this.spacesBadgeElement().isNotVisible());
    }

    public boolean isHamburgerMenuPresent() {
        return this.getHamburgerNavigationMenu().isCurrentlyVisible();
    }

    public boolean isLoggedIn() {
        return ((JavascriptExecutor)this.getDriver()).executeScript("return !!window?.eXo?.env?.portal?.userName?.length", new Object[0]).toString().equals("true");
    }

    public boolean isNoConnectionsBadge() {
        return this.getConnectionsBadge().isNotVisible();
    }

    public void checkNumberOfConnectionsInDrawer(int expectedNumber) {
        Utils.waitForLoading();
        Assertions.assertThat((int)this.getListConnectionInDrawer().size()).isEqualTo(expectedNumber);
    }

    public boolean isNumberOfSpacesInDrawer(int expectedNumber) {
        int listOfSpaces = this.getListSpaceInDrawer().size();
        return listOfSpaces == expectedNumber;
    }

    public boolean isSpacesBadgeWithNumberVisible(String number) {
        Utils.retryOnCondition(() -> this.getSpacesBadge().checkVisible(), () -> this.waitFor(1).seconds());
        return this.getSpacesBadgeWithNumber(number).isVisible();
    }

    public void checkThirdLevelNavigationDisplayed() {
        this.thirdLevelNavigationElement().assertVisible();
    }

    public boolean isWidgetWithNumberVisible(String widget, String number) {
        this.closeAllDrawers();
        return this.getProfileWidgetContent(widget, number).isVisible();
    }

    public void openConnectionRequestDrawer() {
        ElementFacade badgeButton = this.findByXPathOrCSS("#profile-stats-connectionsCount .v-badge button");
        this.clickOnElement(badgeButton);
    }

    public void openNotifications() {
        this.clickOnElement(this.notificationIconElement());
    }

    public void rejectConnexionInvitation(String userName) {
        this.clickOnElement(this.getRejectIconConnectionFromDrawer(userName));
    }

    public void rejectSpaceInvitation(String spaceName) {
        this.clickOnElement(this.getRejectIconSpaceFromDrawer(spaceName));
    }

    public void searchApplicationCenter(String app) {
        ElementFacade adminUiElement = this.findByXPathOrCSS("//*[contains(@class, 'listApplications')]//tr");
        boolean isAdminUI = adminUiElement.isCurrentlyVisible();
        this.searchApplicationCenterInputElement().setTextValue(app);
        this.waitUntilAppCenterSearchFinishes(isAdminUI);
    }

    public void searchedSpaceIsDisplayedInSideBarFilter(String space) {
        this.recentSpaceElement(space).assertVisible();
    }

    public void searchedSpaceIsNotDisplayedInSideBarFilter(String space) {
        this.recentSpaceElement(space).assertNotVisible();
    }

    public void searchSpaceInSideBarFilter(String space) {
        this.sideBarFilterSpacesButton().click();
        TextBoxElementFacade sideBarFilterSpacesInputElement = this.sideBarFilterSpacesInputElement();
        sideBarFilterSpacesInputElement.waitUntilVisible();
        sideBarFilterSpacesInputElement.setTextValue(space);
    }

    public void selectAllOrMySpaces(String filter) {
        this.selectSpacesFilterElement().selectByVisibleText(filter);
    }

    public void unbookmarkActivity(String activity) {
        this.clickOnElement(this.getFavoriteIconActivity(activity));
    }

    public void openHamburgerMenuDrawer() {
        this.clickOnHamburgerMenu(false);
        this.myProfileButtonElement().hover();
    }

    public void clickOnHamburgerMenu(boolean stickMenu) {
        if (this.getCurrentUrl().contains("/portal/administration")) {
            this.getDriver().navigate().to(this.getCurrentUrl().split(PORTAL_ROOT_CONTEXT_NO_SLASH)[0]);
            this.verifyPageLoaded();
        }
        Utils.retryOnCondition(() -> {
            this.closeToastNotification(false);
            this.closeAllDialogs();
            this.closeAllDrawers();
            int i = Utils.MAX_WAIT_RETRIES;
            if (this.myProfileButtonElement().isNotVisible() && --i > 0) {
                this.getHamburgerNavigationMenu().click();
                this.waitForDrawerToOpen();
                if (stickMenu) {
                    this.stickHamburgerMenu();
                }
            }
            this.myProfileButtonElement().checkVisible();
        }, () -> LOGGER.warn("Hamburger Menu isn't visible, retry by waiting until application is built"));
    }

    public void checkHamburgerMenuSpacePosition(String spaceName, int spaceMenuPosition) {
        if (!this.getStickiedHamburgerMenuParent().isCurrentlyVisible()) {
            this.clickOnHamburgerMenu(true);
        }
        this.recentSpaceFirstLevelMenuItem(spaceName, spaceMenuPosition).assertVisible();
    }

    public void checkHamburgerMenuRecentSpaceMenuApplication(String spaceName, String appName, int appPosition) {
        this.openHamburgerMenuRecentSpaceDetails(spaceName);
        this.recentSpaceSecondLevelMenuApplication(appName, appPosition).assertVisible();
    }

    public void checkHamburgerMenuSpaceDescriptionAndName(String randomSpaceName) {
        this.recentSpaceSecondLevelSpaceName(randomSpaceName).assertVisible();
        this.recentSpaceSecondLevelSpaceDescription(randomSpaceName).assertVisible();
    }

    public void openHamburgerMenuRecentSpaceDetails(String spaceName) {
        if (!this.getStickiedHamburgerMenuParent().isCurrentlyVisible()) {
            this.clickOnHamburgerMenu(true);
        }
        ElementFacade menuItem = this.recentSpaceFirstLevelMenuItem(spaceName);
        menuItem.assertVisible();
        menuItem.hover();
        this.waitFor(200).milliseconds();
        ElementFacade arrowIcon = this.recentSpaceFirstLevelMenuArrowIcon(spaceName);
        arrowIcon.assertVisible();
        arrowIcon.click();
        this.waitFor(200).milliseconds();
        this.recentSpaceSecondLevelSpaceName(spaceName).waitUntilVisible();
    }

    public void checkHamburgerMenuUnsticked() {
        this.stickySideBarMenuElement().checkNotVisible();
    }

    public void checkHamburgerMenuSticked() {
        this.stickySideBarMenuElement().checkVisible();
    }

    public void stickHamburgerMenu() {
        this.stickHamburgerMenuElement().click();
    }

    public void unstickHamburgerMenu() {
        this.getHamburgerNavigationMenu().hover();
        this.unstickHamburgerMenuElement().assertVisible();
        this.unstickHamburgerMenuElement().click();
    }

    public void checkRedDotInHamburgerMenu() {
        this.getHamburgerNavigationMenu().assertVisible();
        Utils.retryOnCondition(() -> this.findByXPathOrCSS(".hamburger-unread-badge ").checkVisible());
    }

    public void checkRedDotNotInHamburgerMenu() {
        this.getHamburgerNavigationMenu().assertVisible();
        Utils.retryOnCondition(() -> this.findByXPathOrCSS(".hamburger-unread-badge ").checkNotVisible());
    }

    public void clickOnHamburgerMenu() {
        this.getHamburgerNavigationMenu().click();
    }

    public void clickOutsideHamburgerMenu() {
        ElementFacade drawerOverlay = this.getDrawerOverlay();
        if (drawerOverlay.isCurrentlyVisible()) {
            drawerOverlay.click();
        } else {
            drawerOverlay = this.getHamburgerMenuDrawerOverlay();
            if (drawerOverlay.isCurrentlyVisible()) {
                drawerOverlay.click();
            } else {
                this.pressEscape();
            }
        }
    }

    public void closeHamburgerMenu() {
        this.getHamburgerNavigationMenuDrawer().checkNotVisible();
    }

    public void waitPortalDisplayed(int retries) {
        while (!this.isPortalDisplayed() && retries-- > 0) {
            this.waitFor(1).seconds();
        }
    }

    private String getMetaSiteName() {
        if (this.metaSiteName == null) {
            String getMetaPortalNameScript = "const callback = arguments[arguments.length - 1];\ncallback(eXo.env.portal.metaPortalName);\n";
            this.metaSiteName = ((JavascriptExecutor)this.getDriver()).executeAsyncScript(getMetaPortalNameScript, new Object[0]).toString();
        }
        return this.metaSiteName;
    }

    private void goToAdministrationPage(String uri) {
        ADMIN_URLS.computeIfPresent(uri, (k, v) -> {
            if (!this.getDriver().getCurrentUrl().equals(v)) {
                this.getDriver().navigate().to(v);
            }
            return v;
        });
        ADMIN_URLS.computeIfAbsent(uri, k -> this.goToAdministrationPage((String)k, false));
    }

    private String goToAdministrationPage(String menuItem, boolean forceRefresh) {
        if (forceRefresh || !StringUtils.contains((CharSequence)this.getDriver().getCurrentUrl(), (CharSequence)menuItem)) {
            this.accessToAdministrationMenu();
            String[] menuParts = menuItem.split("/");
            Utils.retryOnCondition(() -> {
                this.administrationMenuItem(menuParts[0]).waitUntilVisible();
                if (!this.administrationMenuItem(menuParts[1]).isCurrentlyVisible()) {
                    this.administrationMenuItem(menuParts[0]).click();
                    this.administrationMenuItem(menuParts[1]).checkVisible();
                }
                this.administrationMenuItem(menuParts[1]).click();
            });
            Utils.waitForPageLoading();
        }
        return this.getCurrentUrl();
    }

    private void goToPageWithLink(String linkSuffix, boolean stickMenu) {
        String siteName;
        this.closeAllDrawers();
        String currentUrl = this.getDriver().getCurrentUrl();
        if (currentUrl.endsWith(linkSuffix) && !currentUrl.endsWith("g:")) {
            return;
        }
        if (!this.getStickiedHamburgerMenuParent().isCurrentlyVisible()) {
            this.clickOnHamburgerMenu(stickMenu);
        }
        if (StringUtils.isNotBlank((CharSequence)(siteName = this.getSiteName(linkSuffix)))) {
            Utils.retryOnCondition(() -> {
                ElementFacade menuItem = this.siteFirstLevelMenuItem(siteName);
                menuItem.assertVisible();
                menuItem.hover();
                ElementFacade arrowIcon = this.siteFirstLevelMenuItemArrowIcon(siteName);
                arrowIcon.assertVisible();
                arrowIcon.hover();
            });
            this.siteSecondLevelMenuItem(linkSuffix).checkVisible();
            this.siteSecondLevelMenuItem(linkSuffix).click();
        } else {
            Utils.retryOnCondition(() -> {
                ElementFacade hamburgerMenuItemLink = this.hamburgerMenuItemLink(linkSuffix);
                if (hamburgerMenuItemLink != null && hamburgerMenuItemLink.isCurrentlyVisible()) {
                    hamburgerMenuItemLink.checkVisible();
                    hamburgerMenuItemLink.click();
                } else {
                    this.getDriver().navigate().to(this.getCurrentUrl().split(PORTAL_ROOT_CONTEXT_NO_SLASH)[0] + PORTAL_ROOT_CONTEXT_NO_SLASH + linkSuffix);
                }
                Utils.waitForPageLoading();
            });
        }
        Assertions.assertThat((String)this.getDriver().getCurrentUrl()).endsWith((CharSequence)linkSuffix);
    }

    private ElementFacade stickySideBarMenuElement() {
        return this.findByXPathOrCSS("#ParentSiteLeftContainer #ParentSiteStickyMenu .HamburgerNavigationMenu");
    }

    private ElementFacade administrationMenuItem(String name) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'siteNavigationTree']//*[contains(text(), '%s')]", name));
    }

    private ElementFacade stickHamburgerMenuElement() {
        return this.findByXPathOrCSS(".HamburgerNavigationMenu .fa-angle-double-right");
    }

    private ElementFacade unstickHamburgerMenuElement() {
        return this.findByXPathOrCSS(".HamburgerNavigationMenu .fa-angle-double-left");
    }

    private ElementFacade siteFirstLevelMenuItem(String siteName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class, 'v-list-item-group')]//a[contains(@href, '/portal/%s')]", siteName));
    }

    private ElementFacade siteFirstLevelMenuItemArrowIcon(String siteName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class, 'v-list-item-group')]//a[contains(@href, '%s')]//*[contains(@class, 'fa-arrow-right')]", siteName));
    }

    private ElementFacade siteSecondLevelMenuItem(String link) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'siteDetails')]//a[contains(@href, '%s')]", link));
    }

    private ElementFacade recentSpaceFirstLevelMenuItem(String spaceName, int spaceMenuPosition) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'spacesNavigationContent')]//a[contains(@class, 'spaceItem')]/parent::*/a[%s]//*[contains(text(), '%s')]", spaceMenuPosition, spaceName));
    }

    private ElementFacade recentSpaceFirstLevelMenuItem(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'spacesNavigationContent')]//*[contains(text(), '%s')]//ancestor::a[contains(@class, 'spaceItem')]//*[contains(@class, 'v-image')]", spaceName));
    }

    private ElementFacade recentSpaceFirstLevelMenuArrowIcon(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'spacesNavigationContent')]//*[contains(text(), '%s')]//ancestor::a[contains(@class, 'spaceItem')]//*[contains(@class, 'fa-arrow')]", spaceName));
    }

    private ElementFacade recentSpaceSecondLevelMenuApplication(String appName, int appPosition) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerMenuSecondLevelParent')]//*[contains(text(), '%s')]//ancestor::a/parent::*/a[%s]", appName, appPosition));
    }

    private ElementFacade recentSpaceSecondLevelSpaceName(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerMenuSecondLevelParent')]//a/parent::*/*[contains(text(), '%s')]", spaceName));
    }

    private ElementFacade recentSpaceSecondLevelSpaceDescription(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerMenuSecondLevelParent')]//p[contains(text(), '%s')]", spaceName));
    }

    private ElementFacade administrationMenuElement() {
        return this.findByXPathOrCSS("//*[@id='platformSettings']//a");
    }

    private ElementFacade checkSpaceFromDrawer(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'spaceDrawer')]//descendant::div[contains(text(),'%s')]//ancestor::*[@role = 'listitem']//*[contains(@class,'check')]", spaceName));
    }

    private ElementFacade connectionsBadgeElement() {
        return this.findByXPathOrCSS("(//div[contains(@class,'profileCard')]//*[@aria-label='Badge'])[2]");
    }

    private ElementFacade contextBoxWelcomeActivityElement() {
        return this.findByXPathOrCSS("//*[@id='ActivityContextBoxWelcomeActivity']");
    }

    private ElementFacade getAcceptIconConnectionFromDrawer(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'connectionsDrawer')]//descendant::div[contains(text(),'%s')]//ancestor::*[@role = 'listitem']//*[contains(@class,'check')]", spaceName));
    }

    private ElementFacade getAcceptIconSpaceFromDrawer(String spaceName) {
        return this.findByXPathOrCSS(String.format("//aside[contains(@class,'spaceDrawer ')]//descendant::div[contains(text(),'%s')]//following::i[contains(@class,'mdi-checkbox-marked')]", spaceName));
    }

    private ElementFacade getConnectionsBadge() {
        return this.findByXPathOrCSS("//div[contains(@class,'profileCard')]//*[contains(text(),'Connections')]/preceding::*[@class='v-btn__content'][1]");
    }

    private ElementFacade getConnectionsBadgeWithNumber(String number) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'profileCard')]//*[contains(text(),'Connections')]/preceding::*[@class='v-btn__content' and contains(text(),'%s')][1]", number));
    }

    private ElementFacade getFavoriteIconActivity(String activity) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'contentBox')]//*[contains(text(),'%s')]//preceding::i[contains(@class,'fa-star')][01]", activity));
    }

    private ElementFacade getHamburgerNavigationMenu() {
        return this.findByXPathOrCSS(".HamburgerNavigationMenu");
    }

    private ElementFacade getStickiedHamburgerMenuParent() {
        return this.findByXPathOrCSS("#ParentSiteStickyMenu .HamburgerNavigationMenu");
    }

    private ElementFacade getDrawerOverlay() {
        return this.findByXPathOrCSS("#drawers-overlay .v-overlay--active");
    }

    private ElementFacade getHamburgerMenuDrawerOverlay() {
        return this.findByXPathOrCSS("#HamburgerNavigationMenu .v-overlay--active");
    }

    private ElementFacade getSiteBody() {
        return this.findByXPathOrCSS("#UISiteBody");
    }

    private ElementFacade getHamburgerNavigationMenuDrawer() {
        return this.findByXPathOrCSS(".HamburgerNavigationMenuLink .v-navigation-drawer");
    }

    private List<WebElementFacade> getListConnectionInDrawer() {
        return this.findAll("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class,'connectionsRequests')]//*[contains(@class,'request-user-name')]", new Object[0]);
    }

    private List<WebElementFacade> getListSpaceInDrawer() {
        return this.findAll("//aside[contains(@class,'spaceDrawer ')]//div[@role='list']//descendant::div[@role='listitem']", new Object[0]);
    }

    private ElementFacade getProfileWidgetContent(String widget, String number) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'profileCard')]//div[contains(@class,'mx-0')]//span[text()='%s']/../..//span[text()='%s']", widget, number));
    }

    private ElementFacade getRejectIconConnectionFromDrawer(String spaceName) {
        return this.findByXPathOrCSS(String.format("//aside[contains(@class,'connectionsDrawer')]//descendant::div[contains(text(),'%s')]//following::i[contains(@class,'mdi-close-circle')]", spaceName));
    }

    private ElementFacade getRejectIconSpaceFromDrawer(String spaceName) {
        return this.findByXPathOrCSS(String.format("//aside[contains(@class,'spaceDrawer ')]//descendant::div[contains(text(),'%s')]//following::i[contains(@class,'mdi-close-circle')]", spaceName));
    }

    private ElementFacade getSpacesBadge() {
        return this.findByXPathOrCSS("//div[contains(@class,'profileCard')]//*[contains(text(),'Spaces')]");
    }

    private ElementFacade getSpacesBadgeWithNumber(String number) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'profileCard')]//*[contains(text(),'Spaces')]/preceding::*[@class='v-btn__content' and contains(text(),'%s')][1]", number));
    }

    private ElementFacade homeHoverButton(String pageName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(text(), '%s')]/ancestor::a//*[contains(@class, 'fa-house-user')]", pageName));
    }

    private ElementFacade homeButtonElement(String pageName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(text(), '%s')]/ancestor::a//*[contains(@class, 'fa-house-user') and contains(@class, 'primary')]", pageName));
    }

    private ElementFacade homePageLinkElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class, 'fa-house-user') and contains(@class, 'primary')]/ancestor::a");
    }

    private ElementFacade contributePageBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerNavigationMenu')]//*[contains(@class,'fa-rocket')]");
    }

    private ElementFacade myProfileButtonElement() {
        return this.findByXPathOrCSS(".HamburgerNavigationMenu a .userAvatar");
    }

    private ElementFacade notificationIconElement() {
        return this.findByXPathOrCSS("#NotificationPopoverPortlet");
    }

    private ElementFacade recentSpaceElement(String space) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'recentSpacesWrapper')]//*[contains(text(), '%s')]", space));
    }

    private ElementFacade recentSpacesBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerNavigationMenu')]//*[contains(@class,'fa fa-arrow')]");
    }

    private ElementFacade recentSpacesIconElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerNavigationMenu')]//*[contains(@class,'fa-layer-group')]");
    }

    private TextBoxElementFacade searchApplicationCenterInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='v-text-field__slot']//input");
    }

    private ElementFacade searchedSpaceInSideBarFilterHover(String space) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'recentSpacesWrapper')]//*[@class='v-list-item__content']//*[contains(text(), '%s')]", space));
    }

    private ElementFacade seeAllLinkElement() {
        return this.findByXPathOrCSS("//aside[contains(@class,'v-navigation-drawer')]//span[contains(text(),'See all')]");
    }

    private ElementFacade selectSpacesFilterElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'selectSpacesFilter')]");
    }

    private TextBoxElementFacade sideBarFilterSpacesButton() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'HamburgerMenuSecondLevelParent')]//*[contains(@class,'fa-filter')]");
    }

    private TextBoxElementFacade sideBarFilterSpacesInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'HamburgerMenuSecondLevelParent')]//*[contains(@class,'recentSpacesFilter')]//input");
    }

    private ElementFacade spaceArrowIconElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'recentSpacesWrapper')]//*[contains(@class,'fa-arrow')]");
    }

    private ElementFacade spaceInvitationWidgetElement() {
        return this.findByXPathOrCSS("//*[@id='profile-stats-spacesCount']//*[contains(@class, 'v-badge')]");
    }

    private ElementFacade spacesBadgeElement() {
        return this.findByXPathOrCSS("(//div[contains(@class,'profileCard')]//*[@aria-label='Badge'])[1]");
    }

    private ElementFacade hamburgerMenuItemLink(String pageUri) {
        return Stream.of(this.hamburgerMenuItemLinkText(pageUri), this.hamburgerMenuItemLinkParent(pageUri)).filter(ElementFacade::isCurrentlyVisible).findFirst().orElse(null);
    }

    private ElementFacade hamburgerMenuItemLinkText(String pageUri) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class, 'v-list-item-group')]//a[contains(@href, '%s')]//*[contains(@class, 'menu-text-color')]", pageUri));
    }

    private ElementFacade hamburgerMenuItemLinkParent(String pageUri) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class, 'v-list-item-group')]//a[contains(@href, '%s')]", pageUri));
    }

    private ElementFacade hamburgerMenuSecondLevelItemLink(String pageUri) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerMenuSecondLevelParent')]//a[contains(@href, '%s')]//*[contains(@class, 'menu-text-color')]", pageUri));
    }

    private ElementFacade hamburgerMenuItemByName(String pageName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(text(), '%s')]", pageName));
    }

    private ElementFacade switcherButtonElement() {
        return this.findByXPathOrCSS("(//*[@class='providersTableRow']//*[@class='center actionContainer']/div)[1]");
    }

    private ElementFacade thirdLevelNavigationElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerMenuThirdLevelParent')]");
    }

    private ElementFacade hamburgerMenuSiteArrowIcon() {
        return this.findByXPathOrCSS("//*[contains(@class, 'HamburgerNavigationMenu')]//*[contains(@class,'fa fa-arrow')]");
    }

    private void waitUntilAppCenterSearchFinishes(boolean isAdminUI) {
        if (isAdminUI) {
            this.findByXPathOrCSS("(//*[contains(@class, 'listApplications')]//tr)[3]").waitUntilNotVisible();
        } else {
            this.findByXPathOrCSS("(//*[contains(@class, 'userAuthorizedApplications')]//*[contains(@class, 'authorizedApplication')])[2]").waitUntilNotVisible();
        }
    }

    private String getSiteName(String linkSuffix) {
        if (linkSuffix.equals("/dashboard") || linkSuffix.equals("/tasks") || linkSuffix.equals("/contents") || linkSuffix.equals("/myteam")) {
            return "mycraft";
        }
        return null;
    }
}

