/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.pages.HomePage;
import io.meeds.qa.ui.utils.Utils;
import java.util.List;
import net.serenitybdd.markers.IsHidden;
import net.thucydides.core.annotations.DefaultUrl;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

@DefaultUrl(value="https://baseUrl/")
public class LoginPage
extends GenericPage
implements IsHidden {
    private static final String PORTAL_LOGIN_URI = "/portal/login";
    private static final String LAST_LOGGED_IN_USER_COOKIE_NAME = "lastLoggedInUser";
    private String lastLoggedInUser = null;
    private HomePage homePage;

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public void deleteCookies() {
        this.lastLoggedInUser = null;
        this.closeAlertIfOpened();
        this.getDriver().manage().deleteAllCookies();
    }

    public String getLastLoggedInUser() {
        if (this.lastLoggedInUser != null) {
            return this.lastLoggedInUser;
        }
        Cookie cookie = this.getDriver().manage().getCookieNamed(LAST_LOGGED_IN_USER_COOKIE_NAME);
        return cookie == null ? null : cookie.getValue();
    }

    public void login(String login, String password) {
        Utils.retryOnCondition(() -> this.login(login, password, true), this::logout);
    }

    public boolean login(String login, String password, boolean throwException) {
        try {
            if (StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)password)) {
                return this.returnError("Username " + login + " and Password " + password + " are mandatory", throwException);
            }
            if (StringUtils.equals((CharSequence)this.getLastLoggedInUser(), (CharSequence)login)) {
                this.closeAllDrawers();
            } else {
                this.logout();
                this.usernameInputElement().setTextValue(login);
                this.passwordInputElement().setTextValue(password);
                if (!this.loginButtonElement().isEnabled()) {
                    return this.returnError("Login button is disabled", throwException);
                }
                this.loginButtonElement().click();
                this.verifyPageLoaded();
                boolean notLoggedIn = Utils.retryGetOnCondition(() -> !this.homePage.isLoggedIn() && this.returnError("User not logged in", throwException));
                if (notLoggedIn) {
                    return notLoggedIn;
                }
                this.getDriver().manage().addCookie(new Cookie(LAST_LOGGED_IN_USER_COOKIE_NAME, login, "/"));
                this.lastLoggedInUser = login;
            }
            return true;
        }
        catch (RuntimeException e) {
            if (throwException) {
                throw e;
            }
            LOGGER.warn("An error occurred while login with user {}", (Object)login, (Object)e);
            return false;
        }
    }

    public void openLoginPage() {
        this.verifyPageLoaded();
        int maxRetries = 3;
        int i = 0;
        do {
            this.deleteCookies();
            this.openLoginPageIfNotDisplayed();
            this.verifyPageLoaded();
        } while (!this.isLoginPageDisplayed() && i++ < maxRetries);
        if (i >= maxRetries) {
            throw new IllegalStateException("Can't display login page after 3 retries");
        }
    }

    public void waitForUsernameInputDisplay(int retries) {
        while (this.usernameInputElement().isNotVisible() && retries-- > 0) {
            this.waitFor(1).seconds();
        }
    }

    public boolean isLoginPageDisplayed() {
        return StringUtils.contains((CharSequence)this.getDriver().getCurrentUrl(), (CharSequence)PORTAL_LOGIN_URI);
    }

    public void logout() {
        try {
            this.deleteCookies();
            this.openLoginPage();
        }
        finally {
            this.deleteLastLoginCookie();
        }
        this.usernameInputElement().checkVisible();
    }

    public void registerLinkIsDisplayed() {
        this.registerLink().isVisible();
    }

    public void registerLinkIsNotDisplayed() {
        this.registerLink().isNotVisible();
    }

    private void openLoginPageIfNotDisplayed() {
        String currentUrl = this.getCurrentUrl();
        if (StringUtils.isBlank((CharSequence)currentUrl)) {
            this.getDriver().navigate().to(System.getProperty("webdriver.base.url"));
            this.verifyPageLoaded();
            currentUrl = this.getCurrentUrl();
        }
        if (!StringUtils.contains((CharSequence)currentUrl, (CharSequence)PORTAL_LOGIN_URI)) {
            this.getDriver().get(currentUrl.split("/portal")[0] + PORTAL_LOGIN_URI);
        }
    }

    public void checkLoginPageDisplay() {
        List windowDimensions = (List)((JavascriptExecutor)this.getDriver()).executeScript("return [window.innerWidth, window.innerHeight];", new Object[0]);
        int windowWidth = ((Long)windowDimensions.get(0)).intValue();
        int windowHeight = ((Long)windowDimensions.get(1)).intValue();
        ElementFacade loginElement = this.findByXPathOrCSS("#loginApplication");
        loginElement.assertVisible();
        int loginElementTop = loginElement.getLocation().getY();
        int loginElementLeft = loginElement.getLocation().getX();
        Assert.assertEquals((long)0L, (long)loginElementTop);
        Assert.assertEquals((long)0L, (long)loginElementLeft);
        int loginElementWidth = loginElement.getRect().getWidth();
        int loginElementHeight = loginElement.getRect().getHeight();
        Assert.assertEquals((long)windowWidth, (long)loginElementWidth);
        Assert.assertEquals((long)windowHeight, (long)loginElementHeight);
        ElementFacade brandingLogoElement = this.findByXPathOrCSS(".brandingLogo");
        brandingLogoElement.assertVisible();
        int brandingLogoElementTop = brandingLogoElement.getLocation().getY();
        int brandingLogoElementLeft = brandingLogoElement.getLocation().getX();
        int brandingLogoElementWidth = brandingLogoElement.getRect().getWidth();
        int brandingLogoElementHeight = brandingLogoElement.getRect().getHeight();
        long diffY = Math.abs((long)((double)(windowHeight - brandingLogoElementHeight) - (double)windowHeight * 0.03) - (long)brandingLogoElementTop);
        long diffX = Math.abs((long)((double)(windowWidth - brandingLogoElementWidth) - (double)windowWidth * 0.03) - (long)brandingLogoElementLeft);
        Assert.assertTrue((diffY <= 2L ? 1 : 0) != 0);
        Assert.assertTrue((diffX <= 2L ? 1 : 0) != 0);
    }

    private boolean returnError(String message, boolean throwException) {
        if (throwException) {
            throw new IllegalStateException(message);
        }
        return false;
    }

    private void deleteLastLoginCookie() {
        this.lastLoggedInUser = null;
        this.closeAlertIfOpened();
        this.getDriver().manage().deleteCookieNamed(LAST_LOGGED_IN_USER_COOKIE_NAME);
    }

    private ElementFacade loginButtonElement() {
        return this.findButtonByXPathOrCSS("//*[contains(@class, 'loginButton')]//button");
    }

    private ElementFacade registerLink() {
        return this.findButtonByXPathOrCSS("//a[@href = '/portal/register']");
    }

    private TextBoxElementFacade passwordInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='password']");
    }

    private TextBoxElementFacade usernameInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='username']");
    }
}

