/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import org.openqa.selenium.WebDriver;

public class MainSettingsPage
extends GenericPage {
    public MainSettingsPage(WebDriver driver) {
        super(driver);
    }

    public void goToLoginCustomization() {
        this.loginCustomizationEditButton().click();
    }

    public void goToBrandingCustomization() {
        this.brandingCustomizationEditButton().click();
    }

    public void goBackToMainSettings() {
        this.backToMainButton().click();
    }

    public void checkLoginCustomization() {
        this.loginBackgroundButton().assertVisible();
        this.loginTitleInput().assertVisible();
        this.loginSubTitleInput().assertVisible();
        this.cancelButton().assertVisible();
        this.cancelButton().assertEnabled();
        this.applyButton().assertVisible();
        this.applyButton().assertDisabled();
        this.backToMainButton().assertVisible();
    }

    public void checkBrandingCustomization() {
        this.brandingCompanyNameInput().assertVisible();
        this.brandingLogoInput().assertVisible();
        this.brandingFaviconInput().assertVisible();
        this.brandingTopbarColorsInput().assertVisible();
        this.brandingSidebarColorsInput().assertVisible();
        this.brandingPageColorsInput().assertVisible();
        this.brandingDrawerColorsInput().assertVisible();
        this.cancelButton().assertVisible();
        this.cancelButton().assertEnabled();
        this.applyButton().assertVisible();
        this.applyButton().assertDisabled();
        this.backToMainButton().assertVisible();
    }

    public void checkAccessCustomization() {
        this.accessTypeOpenInput().assertVisible();
        this.accessTypeRestrictedInput().assertVisible();
        this.accessEditDefaultSpaceButton().assertVisible();
        this.accessExternalUserOpenSwitchButton().assertVisible();
        this.accessExternalUserRestrictedSwitchButton().assertVisible();
        this.cancelButton().assertVisible();
        this.cancelButton().assertEnabled();
        this.applyButton().assertVisible();
    }

    public void selectOpenAccessCustomization() {
        this.accessTypeOpenInput().click();
    }

    public void selectRestrictedAccessCustomization() {
        this.accessTypeRestrictedInput().click();
    }

    public void switchRestrictedExternalUsers() {
        this.accessExternalUserRestrictedSwitchButton().click();
    }

    public void checkApplyButtonIsEnabled() {
        this.applyButton().assertEnabled();
    }

    public void checkApplyButtonIsDisabled() {
        this.applyButton().assertDisabled();
    }

    public void cancelCustomization() {
        this.cancelButton().click();
    }

    public void applyCustomization() {
        if (this.applyButton().isEnabled()) {
            this.applyButton().click();
        }
    }

    public void setLoginTitle(String title) {
        if (this.clearLoginTitleButton().isVisible()) {
            this.clearLoginTitleButton().click();
        }
        this.loginTitleInput().setTextValue(title);
    }

    public void setLoginSubTitle(String subtitle) {
        if (this.clearSubTitleTitleButton().isVisible()) {
            this.clearSubTitleTitleButton().click();
        }
        this.loginSubTitleInput().setTextValue(subtitle);
    }

    public void selectAccessDefaultSpace(String randomSpaceName) {
        this.accessEditDefaultSpaceButton().click();
        this.waitForDrawerToOpen();
        while (this.accessDefaultSpaceDeleteIcon().isVisible()) {
            this.accessDefaultSpaceDeleteIcon().click();
        }
        this.mentionInField(this.accessDefaultSpaceInput(), randomSpaceName, 3);
        this.clickDrawerButton("Apply");
        this.waitForDrawerToClose();
    }

    public void checkRestrictedExternalUserSwitchButtonIsDisabled() {
        this.accessExternalUserOpenSwitchButtonInput().assertEnabled();
        this.accessExternalUserRestrictedSwitchButtonInput().assertDisabled();
    }

    public void checkOpenExternalUserSwitchButtonIsDisabled() {
        this.accessExternalUserOpenSwitchButtonInput().assertDisabled();
        this.accessExternalUserRestrictedSwitchButtonInput().assertEnabled();
    }

    public void checkAccessDefaultSpacesCount(int count) {
        this.findByXPathOrCSS(String.format("//*[@id='PlatformAccess']//*[contains(@class, 'v-list-item')]//*[contains(text(), '%s ') and contains(text(), 'space')]", count)).assertVisible();
    }

    private ElementFacade brandingCustomizationEditButton() {
        return this.findByXPathOrCSS("(//*[@id='generalSettings']//*[contains(@class, 'fa-caret')])[1]");
    }

    private ElementFacade loginCustomizationEditButton() {
        return this.findByXPathOrCSS("(//*[@id='generalSettings']//*[contains(@class, 'fa-caret')])[3]");
    }

    private TextBoxElementFacade brandingCompanyNameInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//*[@name='companyName']");
    }

    private TextBoxElementFacade brandingLogoInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//*[@id='logoFileInput']//ancestor::*[contains(@class, 'file-selector')]//ancestor::*[contains(@class, 'v-image')]");
    }

    private TextBoxElementFacade brandingFaviconInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//*[@id='faviconFileInput']//ancestor::*[contains(@class, 'file-selector')]//ancestor::*[contains(@class, 'v-image')]");
    }

    private ElementFacade brandingTopbarColorsInput() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//*[contains(text(), 'Topbar')]/ancestor::*[contains(@class, 'option-item')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade brandingSidebarColorsInput() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//*[contains(text(), 'Sidebar')]/ancestor::*[contains(@class, 'option-item')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade brandingPageColorsInput() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//*[contains(text(), 'Page')]/ancestor::*[contains(@class, 'option-item')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade brandingDrawerColorsInput() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//*[contains(text(), 'Drawer')]/ancestor::*[contains(@class, 'option-item')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade cancelButton() {
        return this.findByXPathOrCSS("//button//*[contains(text(), 'Cancel')]//ancestor::button");
    }

    private ElementFacade applyButton() {
        return this.findByXPathOrCSS("//button//*[contains(text(), 'Apply')]//ancestor::button");
    }

    private ElementFacade backToMainButton() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//*[contains(@class, 'fa-arrow-left')]");
    }

    private TextBoxElementFacade loginTitleInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//input[@name='loginTitle']");
    }

    private TextBoxElementFacade clearLoginTitleButton() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//*[@name = 'loginTitle']//ancestor::*[contains(@class, 'v-input')]//*[contains(@class, 'fa-times')]");
    }

    private TextBoxElementFacade loginSubTitleInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//input[@name='loginSubtitle']");
    }

    private TextBoxElementFacade clearSubTitleTitleButton() {
        return this.findTextBoxByXPathOrCSS("//*[@id='generalSettings']//*[@name = 'loginSubtitle']//ancestor::*[contains(@class, 'v-input')]//*[contains(@class, 'fa-times')]");
    }

    private ElementFacade loginBackgroundButton() {
        return this.findByXPathOrCSS("//*[@id='generalSettings']//button//*[contains(text(), 'Add background') or contains(text(), 'Change background')]");
    }

    private ElementFacade accessTypeOpenInput() {
        return this.findByXPathOrCSS("//*[@id='PlatformAccess']//input[@value = 'OPEN' and @type = 'radio']//ancestor::*[contains(@class, 'v-radio')]");
    }

    private ElementFacade accessTypeRestrictedInput() {
        return this.findByXPathOrCSS("//*[@id='PlatformAccess']//input[@value = 'RESTRICTED' and @type = 'radio']//ancestor::*[contains(@class, 'v-radio')]");
    }

    private ElementFacade accessExternalUserOpenSwitchButtonInput() {
        return this.findByXPathOrCSS("(//*[@id='PlatformAccess']//input[@role = 'switch' and @type = 'checkbox'])[1]");
    }

    private ElementFacade accessExternalUserRestrictedSwitchButtonInput() {
        return this.findByXPathOrCSS("(//*[@id='PlatformAccess']//input[@role = 'switch' and @type = 'checkbox'])[2]");
    }

    private ElementFacade accessExternalUserOpenSwitchButton() {
        return this.findByXPathOrCSS("(//*[@id='PlatformAccess']//input[@role = 'switch' and @type = 'checkbox'])[1]//ancestor::*[contains(@class, 'v-input--switch')]");
    }

    private ElementFacade accessExternalUserRestrictedSwitchButton() {
        return this.findByXPathOrCSS("(//*[@id='PlatformAccess']//input[@role = 'switch' and @type = 'checkbox'])[2]//ancestor::*[contains(@class, 'v-input--switch')]");
    }

    private ElementFacade accessEditDefaultSpaceButton() {
        return this.findByXPathOrCSS("//*[@id='PlatformAccess']//*[contains(@class, 'v-list-item')]//*[contains(@class, 'fa-edit')]");
    }

    private TextBoxElementFacade accessDefaultSpaceInput() {
        return this.findTextBoxByXPathOrCSS("//*[@id='defaultSpacesInput']//input");
    }

    private TextBoxElementFacade accessDefaultSpaceDeleteIcon() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'identitySuggesterItem')]//button[contains(@class, 'close')]");
    }
}

