/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.util.List;
import java.util.Set;
import net.serenitybdd.core.Serenity;
import org.junit.Assert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class NotePage
extends GenericPage {
    public NotePage(WebDriver driver) {
        super(driver);
    }

    public void editNote() {
        Utils.retryOnCondition(() -> {
            this.editNoteButton().checkVisible();
            this.editNoteButton().click();
        }, Utils::refreshPage);
        String windowHandle = this.getDriver().getWindowHandle();
        Serenity.setSessionVariable((Object)"windowHandle").to((Object)windowHandle);
        Set windowHandles = this.getDriver().getWindowHandles();
        Assert.assertTrue((String)String.format("Can't find Notes editor Browser Tab: tabs length: %s", windowHandles.size()), (boolean)windowHandles.stream().anyMatch(id -> {
            this.getDriver().switchTo().window(id);
            return this.editNoteButton().isNotVisible();
        }));
        Utils.waitForLoading();
    }

    public void checkNotesEditorDisplayedInFullPageWindow() {
        ElementFacade notesEditorElement = this.notesEditorElement();
        notesEditorElement.assertVisible();
        Assert.assertEquals((long)0L, (long)notesEditorElement.getLocation().getX());
        Assert.assertEquals((long)0L, (long)notesEditorElement.getLocation().getY());
        JavascriptExecutor driver = (JavascriptExecutor)this.getDriver();
        List windowDimensions = (List)driver.executeScript("return [window.innerWidth, window.innerHeight];", new Object[0]);
        Assert.assertEquals((long)((Long)windowDimensions.get(0)).intValue(), (long)notesEditorElement.getRect().getWidth());
        Assert.assertEquals((long)((Long)windowDimensions.get(1)).intValue(), (long)notesEditorElement.getRect().getHeight());
    }

    public ElementFacade editNoteButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'notes-application-header')]//i[contains(@class, 'edit-note')]//ancestor::button");
    }

    public ElementFacade notesEditorElement() {
        return this.findByXPathOrCSS("#notesEditor");
    }
}

