/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import net.serenitybdd.core.Serenity;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;

public class PeoplePage
extends GenericPage {
    public PeoplePage(WebDriver driver) {
        super(driver);
    }

    public ElementFacade addContactFullnameElement(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='v-card__text peopleCardBody align-center pt-2 pb-1']//a[contains(text(),'%s')]", user));
    }

    public void areCurrentUserPositionAndPointsOnLeaderboardDisplayed() {
        this.currentUserLeaderboardPositionElement().assertVisible();
    }

    public void areTwoFirstPlacesOnLeaderboardDisplayed() {
        this.firstUserLeaderboardPositionElement().assertVisible();
        this.secondUserLeaderboardPositionElement().assertVisible();
    }

    public void areTwoFirstUsersPointsOnLeaderboardDisplayed() {
        this.firstUserLeaderboardPointsElement().assertVisible();
        this.secondUserLeaderboardPointsElement().assertVisible();
    }

    public void checkConnectToUser(String user) {
        Assertions.assertThat((boolean)this.searchUser(user)).isTrue().as("User " + user + " wasn't found", new Object[0]);
        ElementFacade userButton = this.getUserButton(user);
        userButton.checkClickable();
        if (!userButton.hasClass("connectUserButton")) {
            if (userButton.hasClass("acceptToConnectButton")) {
                ElementFacade invitationsRequestUserButton = this.getInvitationsRequestUserButton(user);
                this.clickOnElement(invitationsRequestUserButton);
                ElementFacade refuseInvitationUserButton = this.getRefuseInvitationUserButton(user);
                this.clickOnElement(refuseInvitationUserButton);
            } else if (userButton.hasClass("disconnectUserButton")) {
                this.clickOnElement(userButton);
                ElementFacade okButton = this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[contains(text(),'OK')]");
                okButton.waitUntilClickable();
                okButton.click();
            } else {
                this.clickOnElement(userButton);
            }
            userButton = this.getConnectUserButton(user);
            userButton.waitUntilVisible();
        }
        this.clickOnElement(userButton);
        this.getCancelRequestUserButton(user).waitUntilVisible();
    }

    public void checkThatAddContactButtonIsDisplayed() {
        ElementFacade addContactTitleElement = this.addContactTitleElement();
        addContactTitleElement.assertVisible();
        Assert.assertEquals((Object)addContactTitleElement.getText(), (Object)"Connect");
    }

    public void checkThatAddedUserSuggestionIsDisplayed() {
        String fourthUserFirstName = (String)Serenity.sessionVariableCalled((Object)"fourthUserFirstName");
        String fourthUserLastName = (String)Serenity.sessionVariableCalled((Object)"fourthUserLastName");
        String isFirstUserSuggestion = fourthUserFirstName + " " + fourthUserLastName;
        this.sentRequestsUsersElement(isFirstUserSuggestion).waitUntilVisible();
    }

    public void checkThatCircularAvatarIsDisplayed() {
        ElementFacade contactAvatarElement = this.contactAvatarElement();
        contactAvatarElement.assertVisible();
    }

    public void checkThatDeletedUserSuggestionIsNotDisplayed() {
        String thirdUserFirstName = (String)Serenity.sessionVariableCalled((Object)"thirdUserFirstName");
        String thirdUserLastName = (String)Serenity.sessionVariableCalled((Object)"thirdUserLastName");
        String isSecondUserSuggestion = thirdUserFirstName + " " + thirdUserLastName;
        this.sentRequestsUsersElement(isSecondUserSuggestion).waitUntilNotVisible();
    }

    public void checkThatFirstUserSuggestionIsNotDisplayed() {
        String thirdUserFirstName = (String)Serenity.sessionVariableCalled((Object)"thirdUserFirstName");
        String thirdUserLastName = (String)Serenity.sessionVariableCalled((Object)"thirdUserLastName");
        String isSecondUserSuggestion = thirdUserFirstName + " " + thirdUserLastName;
        ElementFacade firstSuggestionElement = this.firstSuggestionElement();
        Assert.assertEquals((Object)firstSuggestionElement.getText(), (Object)isSecondUserSuggestion);
    }

    public void checkThatFullNameIsDisplayed() {
        this.addContactFullnameElement().assertVisible();
    }

    public void checkThatJobIsDisplayed() {
        this.addContactJobElement().assertVisible();
    }

    public void checkThatMyConnectionsPulldownFiltersIsDisplayed(String user) {
        this.peoplePulldownFilterElement().selectByValue("connections");
        this.addContactFullnameElement(user).waitUntilVisible();
    }

    public void checkThatPeopleShowingResultsIsDisplayed() {
        this.peopleShowingResultsElement().assertVisible();
    }

    public void checkThatPulldownFiltersIsDisplayed() {
        this.peoplePulldownFilterElement().assertVisible();
    }

    public void checkThatSuggestionWidgetDisplayedTwoUsersWithAddAndDeleteButtons() {
        this.firstSuggestionElement().assertVisible();
        this.secondSuggestionElement().assertVisible();
        this.addFirstUserSuggestionElement().assertVisible();
        this.addSecondUserSuggestionElement().assertVisible();
        this.deleteFirstSuggestionElement().assertVisible();
        this.deleteSecondSuggestionElement().assertVisible();
    }

    public void checkThatTheCoverIsDisplayed() {
        this.addContactCoverWidthElement().assertVisible();
    }

    public void checkThatUserSuggestionIsDisplayed(String firstName, String lastName) {
        String fullName = firstName + " " + lastName;
        Assert.assertEquals((Object)this.firstSuggestionElement().getText(), (Object)fullName);
    }

    public void checkThatUserSuggestionIsNotDisplayed(String firstName, String lastName) {
        String fullName = firstName + " " + lastName;
        Assert.assertNotEquals((Object)this.firstSuggestionElement().getText(), (Object)fullName);
    }

    public void closeSentRequestsButton() {
        this.closesendRequestButtonElement().click();
    }

    public void connectToUser(String user) {
        Utils.retryOnCondition(() -> this.checkConnectToUser(user));
    }

    public void connectUserProfile() {
        Utils.refreshPage();
        this.connectUserProfileButtonElement().click();
    }

    public ElementFacade currentUserLeaderboardPoints(String id) {
        return this.findByXPathOrCSS(String.format("(//*[@class='v-list-item__title']//a/following::*[@class='v-list-item__action me-4'])['%s']", id));
    }

    public void deleteSentRequest(String firstName, String lastName) {
        String userSuggestion = firstName + " " + lastName;
        this.deleteSentRequestsUsersElement(userSuggestion).click();
    }

    public ElementFacade deleteSentRequestsUsersElement(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='layout column']//*[@class='v-list-item__title']//a[contains(text(),'%s')]/following::button[1]", user));
    }

    public void deleteUserSuggestion() {
        this.deleteFirstSuggestionElement().click();
    }

    public void goToSentRequests() {
        ElementFacade sentRequestsButtonElement = this.sentRequestsButtonElement();
        sentRequestsButtonElement.waitUntilClickable();
        sentRequestsButtonElement.click();
    }

    public void goToUserProfile(String user) {
        Utils.retryOnCondition(() -> {
            this.searchUser(user);
            Utils.waitForLoading();
            this.getUserProfileButton(user).click();
        }, () -> this.waitFor(2).seconds());
    }

    public void isLeaderBoardWidgetDisplayed(String title) {
        TextBoxElementFacade leaderboardTitleElement = this.leaderboardTitleElement();
        leaderboardTitleElement.waitUntilVisible();
        Assert.assertEquals((Object)leaderboardTitleElement.getText(), (Object)title);
    }

    public ElementFacade sentRequestsUsersElement(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='layout column']//*[@class='v-list-item__title']//a[contains(text(),'%s')]", user));
    }

    private ElementFacade addContactCoverWidthElement() {
        return this.findByXPathOrCSS("//*[@class='peopleCardFront']/div/div/div[@class='v-image__image v-image__image--cover']");
    }

    private ElementFacade addContactFullnameElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text peopleCardBody align-center pt-2 pb-1']//a");
    }

    private ElementFacade addContactJobElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__subtitle userPositionLabel text-truncate py-0']");
    }

    private ElementFacade addContactTitleElement() {
        return this.findByXPathOrCSS("//*[@class='d-inline peopleRelationshipButtonText']");
    }

    private ElementFacade addFirstUserSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='uiIconInviteUser'])[1]");
    }

    private ElementFacade addSecondUserSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='uiIconInviteUser'])[2]");
    }

    private ElementFacade closesendRequestButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-icon notranslate v-icon--link mdi mdi-close theme--light']");
    }

    private ElementFacade connectUserProfileButtonElement() {
        return this.findByXPathOrCSS("//i[contains(@class,'fas') and contains(@class,'fa-user-plus')]");
    }

    private ElementFacade contactAvatarElement() {
        return this.findByXPathOrCSS("//*[@class='peopleAvatar']//*[@class='v-image__image v-image__image--cover']");
    }

    private TextBoxElementFacade currentUserLeaderboardPositionElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='v-avatar tertiary']");
    }

    private ElementFacade deleteFirstSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='uiIconCloseCircled'])[1]");
    }

    private ElementFacade deleteSecondSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='uiIconCloseCircled'])[2]");
    }

    private ElementFacade firstSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='v-list-item__content pb-3']//a)[1]");
    }

    private TextBoxElementFacade firstUserLeaderboardPointsElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-list-item__title']//a/following::*[@class='v-list-item__action me-4'])[1]");
    }

    private TextBoxElementFacade firstUserLeaderboardPositionElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-list-item__title']//a)[1]");
    }

    private ElementFacade getCancelRequestUserButton(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]//ancestor::*[contains(@class, 'peopleCardItem')]//button[contains(@class, 'cancelRequestButton')]", user));
    }

    private ElementFacade getConnectUserButton(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]//ancestor::*[contains(@class, 'peopleCardItem')]//button[contains(@class, 'connectUserButton')]", user));
    }

    private ElementFacade getInvitationsRequestUserButton(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]//ancestor::*[contains(@class, 'peopleCardItem')]//button[contains(@class, 'peopleButtonMenu')]", user));
    }

    private ElementFacade getRefuseInvitationUserButton(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]//ancestor::*[contains(@class, 'peopleCardItem')]//button[contains(@class, 'refuseToConnectButton')]", user));
    }

    private ElementFacade getUserButton(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]//ancestor::*[contains(@class, 'peopleCardItem')]//button[contains(@class, 'peopleRelationshipButton')]", user));
    }

    private ElementFacade getUserProfileButton(String user) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id, 'peopleCardItem')]//*[contains(text(), '%s')]", user));
    }

    private TextBoxElementFacade leaderboardTitleElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='usersLeaderboard']//*[@class='d-inline-block']");
    }

    private TextBoxElementFacade peoplePulldownFilterElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-input__prepend-inner']/following::*[@class='v-text-field__slot']/input/following::select)[1]");
    }

    private TextBoxElementFacade peopleShowingResultsElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='showingPeopleText text-sub-title ms-3 d-none d-sm-flex']");
    }

    private TextBoxElementFacade searchPeopleInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'fa-filter')]//ancestor::*[contains(@class, 'v-input')]//input");
    }

    private ElementFacade secondSuggestionElement() {
        return this.findByXPathOrCSS("(//*[@class='v-list-item__content pb-3']//a)[2]");
    }

    private TextBoxElementFacade secondUserLeaderboardPointsElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-list-item__title']//a/following::*[@class='v-list-item__action me-4'])[2]");
    }

    private TextBoxElementFacade secondUserLeaderboardPositionElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-list-item__title']//a)[2]");
    }

    private ElementFacade sentRequestsButtonElement() {
        return this.findByXPathOrCSS("//*[@class='peopleOverviewCard d-flex flex-column clickable']");
    }

    private ElementFacade getUserProfileFullName(String user) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s') and contains(@class,'userFullname')]", user));
    }

    public boolean searchUser(String user) {
        TextBoxElementFacade inputField = this.insertSearchTerm(user);
        boolean visible = false;
        int retry = 0;
        Duration retryWaitTime = Duration.ofSeconds(1L);
        do {
            inputField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            this.waitFor(300).milliseconds();
            Utils.waitForLoading();
            ElementFacade userCard = this.getUserProfileButton(user);
            userCard.setImplicitTimeout(retryWaitTime);
            visible = userCard.isVisible();
            if (!visible) continue;
            return true;
        } while (!visible && retry++ < Utils.MAX_WAIT_RETRIES);
        return false;
    }

    public void searchUserProfile(String user) {
        this.searchPeopleInputElement().setTextValue(user);
    }

    public void checkThatTheSearchedUserProfileIsDisplayed(String user) {
        this.getUserProfileFullName(user).waitUntilVisible();
    }

    public TextBoxElementFacade insertSearchTerm(String term) {
        this.clickOnApplicationFilterButton();
        TextBoxElementFacade inputField = this.searchPeopleInputElement();
        inputField.checkVisible();
        inputField.setTextValue(term + "x");
        return inputField;
    }
}

