/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class RulePage
extends GenericPage {
    private static final String MEEDS_APPLICATION = "meeds";
    private static final String MANUAL_SUBMISSION_APPLICATION = "manual";
    private static final String OPENED_RULE_PUBLICATION_DRAWER_SELECTOR = "//*[@id='engagementCenterRulePublication']";
    private static final String OPENED_RULE_DRAWER_SELECTOR = "//*[@id = 'ruleDetailDrawer' and contains(@class, 'v-navigation-drawer--open')]";

    public RulePage(WebDriver driver) {
        super(driver);
    }

    public void clickAddActionButton() {
        this.addActionButton().click();
    }

    public void saveAction(String title, String description, String points, boolean manual, boolean changeDates, boolean newRule) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.setActionTitle(title);
        }
        if (newRule) {
            if (manual) {
                this.applicationElement(MANUAL_SUBMISSION_APPLICATION).click();
            } else {
                this.applicationElement(MEEDS_APPLICATION).click();
            }
        }
        this.clickOnStartButton();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            this.setActionDescription(description);
        }
        this.clickOnNextButton();
        if (changeDates) {
            this.selectDurationChoice();
            this.setActionEndDate();
        }
        this.clickOnNextButton();
        if (StringUtils.isNotBlank((CharSequence)points)) {
            this.setActionPoints(points);
        }
        this.clickOnNextButton();
        this.clickOnSaveButton(newRule);
        this.waitForDrawerToClose();
    }

    public void selectDurationChoice() {
        ElementFacade durationChip = this.durationDeselectedChip();
        durationChip.waitUntilVisible();
        durationChip.click();
        this.durationSelectedChip().assertVisible();
    }

    public void setActionTitle(String title) {
        this.ruleTitleFieldElement().setTextValue(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionDescription(String description) {
        ElementFacade ckEditorFrameRuleElement = this.ckEditorFrameRuleElement();
        ckEditorFrameRuleElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameRuleElement);
        try {
            TextBoxElementFacade ruleDescriptionFieldElement = this.ruleDescriptionFieldElement();
            ruleDescriptionFieldElement.waitUntilVisible();
            ruleDescriptionFieldElement.setTextValue(description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void setActionPoints(String challengePoints) {
        this.actionPointsTextbox().setTextValue(challengePoints);
    }

    public void selectActionApplication(String applicationLabel) {
        this.applicationElement(applicationLabel).click();
    }

    public void setActionEvent(String triggerName) {
        ElementFacade triggerSelectAutoComplete = this.triggerSelectAutoComplete();
        triggerSelectAutoComplete.click();
        triggerSelectAutoComplete.type(new CharSequence[]{triggerName});
        triggerSelectAutoComplete.type(new CharSequence[]{Keys.ARROW_DOWN});
        triggerSelectAutoComplete.type(new CharSequence[]{Keys.ENTER});
        this.triggerSelectedAutoComplete(triggerName).assertVisible();
    }

    public void selectDefaultContributionStatus(String status) {
        switch (status) {
            case "Accepted": {
                this.acceptedRadioBtnElement().click();
                this.acceptedRadioBtnActiveElement().waitUntilVisible();
                break;
            }
            case "Pending": {
                this.pendingRadioBtnElement().click();
                this.pendingRadioBtnActiveElement().waitUntilVisible();
                break;
            }
        }
    }

    public void deleteActionDuration() {
        this.durationSelectedChip().click();
    }

    public void setActionEndDate() {
        this.selectActionDateChoice("BEFORE");
        this.actionEndDateElement().click();
        this.waitForMenuToOpen("DatePickerMenu");
        if (!this.randomDateCalenderElement().isVisible()) {
            this.nextMonthDateCalenderButton().click();
        }
        this.randomDateCalenderElement().click();
        this.waitForMenuToClose("DatePickerMenu");
    }

    public void clickOnStartButton() {
        this.startButton().click();
    }

    public void clickOnNextButton() {
        this.nextStepButton().click();
    }

    public void clickOnSaveButton(boolean newRule) {
        if (newRule) {
            this.addButton().click();
        } else {
            this.updateButton().click();
        }
    }

    public boolean isEventDisplayed(String eventName) {
        return this.ruleEventsMenuItem(eventName).isVisible();
    }

    public void searchRuleInProgramRuleFilter(String ruleTitle) {
        this.searchRuleByTitle(ruleTitle, 1);
    }

    public void searchRuleByTitle(String ruleTitle, int tentatives) {
        int retry = 0;
        do {
            TextBoxElementFacade searchRulesFieldElement = this.searchRulesFieldElement();
            searchRulesFieldElement.setTextValue(ruleTitle);
            this.waitForProgressBar();
        } while (++retry < tentatives && !this.actionInProgramDetailElement(ruleTitle).isCurrentlyVisible());
    }

    public void ruleNotfoundTryAgain() {
        this.ruleNotfoundTryAgainElement().assertVisible();
    }

    public void clearRulesSearchFilter() {
        this.clearSearchBtnElement().click();
    }

    public void attachImageToAnnouncement() {
        this.waitCKEditorLoading(OPENED_RULE_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
    }

    public void attachImageToProgramAction() {
        this.waitCKEditorLoading(OPENED_RULE_PUBLICATION_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
    }

    public void isActionDisplayedInProgramDetail(String actionTitle) {
        this.actionInProgramDetailElement(actionTitle).assertVisible();
    }

    public void isActionNotDisplayedInProgramDetail(String actionTitle) {
        this.actionInProgramDetailElement(actionTitle).assertNotVisible();
    }

    public void openActionDrawer(String actionTitle) {
        this.actionInProgramDetailElement(actionTitle).click();
        this.waitForDrawerToOpen();
    }

    private void selectActionDateChoice(String value) {
        ElementFacade selectActionDateElement = this.selectActionDateElement(value);
        selectActionDateElement.waitUntilVisible();
        selectActionDateElement.waitUntilClickable();
        selectActionDateElement.selectByValue(value);
        this.waitFor(50).milliseconds();
    }

    private ElementFacade selectActionDateElement(String value) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//option[@value='%s']//parent::select", value));
    }

    private ElementFacade durationDeselectedChip() {
        return this.findByXPathOrCSS("//*[contains(text(),'Duration')]//ancestor-or-self::*[contains(@class, 'v-chip--clickable') and not(contains(@class, 'primary'))]");
    }

    private ElementFacade durationSelectedChip() {
        return this.findByXPathOrCSS("//*[contains(text(),'Duration')]//ancestor-or-self::*[contains(@class, 'v-chip--clickable') and contains(@class, 'primary')]");
    }

    private ElementFacade startButton() {
        return this.findByXPathOrCSS("//*[contains(text(),'Start')]//ancestor-or-self::button");
    }

    private ElementFacade nextStepButton() {
        return this.findByXPathOrCSS("//*[contains(text(),'Next')]//ancestor-or-self::button");
    }

    private ElementFacade addButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//button[normalize-space(.) = 'Add']");
    }

    private ElementFacade updateButton() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'Update')]//ancestor-or-self::button");
    }

    private ElementFacade addActionButton() {
        return this.findByXPathOrCSS("//*[@id = 'engagementCenterProgramDetail']//*[contains(text(), 'Add Quest') or contains(text(), 'Add quest')]//ancestor::button");
    }

    private ButtonElementFacade ruleEventsMenuItem(String eventName) {
        return this.findButtonByXPathOrCSS(String.format("//*[contains(@class, 'menuable__content__active')]//*[contains(text(), '%s')]/parent::*", eventName));
    }

    private ElementFacade triggerSelectAutoComplete() {
        return this.findByXPathOrCSS("#triggerAutoComplete");
    }

    private ElementFacade triggerSelectedAutoComplete(String eventName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'v-chip')]//*[contains(text(), '%s')]", eventName));
    }

    private TextBoxElementFacade actionPointsTextbox() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'points') or contains(text(),'Points')]/ancestor::*//input[@type = 'number']");
    }

    private ElementFacade ckEditorFrameRuleElement() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open iframe.cke_wysiwyg_frame");
    }

    private TextBoxElementFacade actionEndDateElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class,'ruleDates')]//*[contains(@class, 'datePickerText')]");
    }

    private TextBoxElementFacade randomDateCalenderElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'menuable__content__active')]//*[contains(@class,'v-date-picker-table')]//button[not(@disabled)]");
    }

    private TextBoxElementFacade nextMonthDateCalenderButton() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'menuable__content__active')]//*[contains(@class,'v-date-picker-header')]//button[not(@disabled)]//i[contains(@class, 'right')]");
    }

    private TextBoxElementFacade ruleDescriptionFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private TextBoxElementFacade ruleTitleFieldElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='ruleTitle']");
    }

    private TextBoxElementFacade searchRulesFieldElement() {
        return this.findTextBoxByXPathOrCSS("//input[@placeholder='Filter by quest']");
    }

    public ElementFacade actionInProgramDetailElement(String ruleTitle) {
        return this.findByXPathOrCSS(String.format("//*[@class='v-data-table__wrapper']//*[@class='text-truncate' and contains(@title,'%s')][1]", ruleTitle));
    }

    public ElementFacade ruleNotfoundTryAgainElement() {
        return this.findByXPathOrCSS("//a[contains(text(), 'try again')]");
    }

    public ElementFacade clearSearchBtnElement() {
        return this.findByXPathOrCSS("#engagementCenterProgramDetail .v-input button.fa-times");
    }

    private ElementFacade applicationElement(String applicationLabel) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[@id = '%sApplicationSubmissionOption']", applicationLabel));
    }

    private ElementFacade acceptedRadioBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//input[@value='ACCEPTED']//ancestor::*[contains(@class,'v-radio')]");
    }

    private ElementFacade acceptedRadioBtnActiveElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//input[@value='ACCEPTED']//ancestor::*[contains(@class,'v-radio') and contains(@class,'v-item--active')]");
    }

    private ElementFacade pendingRadioBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//input[@value='PENDING']//ancestor::*[contains(@class,'v-radio')]");
    }

    private ElementFacade pendingRadioBtnActiveElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//input[@value='PENDING']//ancestor::*[contains(@class,'v-radio') and contains(@class,'v-item--active')]");
    }
}

