/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;

public class SettingsPage
extends GenericPage {
    private static final String NOTIFICATION_SWITCH_BUTTON_XPATH = "(//*[@id='UserSettingNotifications']//*[contains(@class, 'v-input--switch')]//input)[%s]";
    private static final String NOTIFICATION_SWITCH_BUTTON_BY_STATE_XPATH = "(//*[@id='UserSettingNotifications']//*[contains(@class, 'v-input--switch')]//input)[%s]//self::*[@aria-checked='%s']//ancestor::*[contains(@class, 'v-input')]";

    public SettingsPage(WebDriver driver) {
        super(driver);
    }

    public void acceptEditLanguage() {
        ElementFacade applyChangeLanguageButtonElement = this.applyChangeLanguageButtonElement();
        applyChangeLanguageButtonElement.waitUntilClickable();
        applyChangeLanguageButtonElement.click();
        this.waitForDrawerToClose();
    }

    public void acceptEditPassword() {
        ElementFacade confirmEditPasswordElement = this.confirmEditPasswordElement();
        confirmEditPasswordElement.waitUntilClickable();
        confirmEditPasswordElement.click();
    }

    public void applyEditGeneralNotifications() {
        ElementFacade applyEditGeneralNotificationsButtonElement = this.applyEditGeneralNotificationsButtonElement();
        applyEditGeneralNotificationsButtonElement.waitUntilClickable();
        applyEditGeneralNotificationsButtonElement.click();
        Utils.refreshPage();
    }

    public void cancelEditLanguage() {
        this.clickCancelInDrawerButton();
    }

    public void cancelEditPassword() {
        this.clickCancelInDrawerButton();
    }

    public void checkThatActivityStreamSectionIsDisplayed() {
        this.manageNoticiationActivityStreamSectionElement().assertVisible();
    }

    public void checkThatConnectionsSectionIsDisplayed() {
        this.manageNotificationConnectionsSectionElement().assertVisible();
    }

    public void checkThatGeneralSectionIsDisplayed() {
        this.manageNotificationGeneralSectionElement().assertVisible();
    }

    public void checkThatKudosSectionIsDisplayed() {
        this.manageNotificationKudosSectionElement().assertVisible();
    }

    public void checkThatLanguageIsDisplayed(String language) {
        this.languageTextElement(language).assertVisible();
    }

    public void checkThatManageNotificationPageIsOpened() {
        this.manageNotificationPageElement().assertVisible();
    }

    public void checkThatNotesSectionIsDisplayed() {
        this.manageNotificationNotesSectionElement().assertVisible();
    }

    public void checkThatNotificationOnMobileIsDisabled() {
        this.checkNotificationSwitchButtonState(2, false);
    }

    public void checkThatNotificationOnMobileIsEnabled() {
        this.checkNotificationSwitchButtonState(2, true);
    }

    public void checkThatNotificationOnSiteIsDisabled() {
        this.checkNotificationSwitchButtonState(3, false);
    }

    public void checkThatNotificationOnSiteIsEnabled() {
        this.checkNotificationSwitchButtonState(3, true);
    }

    public void checkThatNotificationViaMailIsDisabled() {
        this.checkNotificationSwitchButtonState(1, false);
    }

    public void checkThatNotificationViaMailIsEnabled() {
        this.checkNotificationSwitchButtonState(1, true);
    }

    public void checkThatPerkStoreSectionIsDisplayed() {
        this.manageNotificationPerkStoreSectionElement().assertVisible();
    }

    public void checkThatSettingsPageIsOpened() {
        this.findByXPathOrCSS("#UserSettingLanguage").assertVisible();
    }

    public void checkThatSpacesSectionIsDisplayed() {
        this.manageNotificationSpacesSectionElement().assertVisible();
    }

    public void checkThatTasksSectionIsDisplayed() {
        this.manageNotificationTasksSectionElement().assertVisible();
    }

    public void checkThatWalletSectionIsDisplayed() {
        this.manageNotificationWalletSectionElement().assertVisible();
    }

    public void dailyEmailIsDisplayedInGeneralNotificationsSection() {
        Assert.assertTrue((boolean)this.generalNotificationsSectionElement().getText().contains("Daily digest email notification"));
    }

    public void editLanguage(String language) {
        this.findByXPathOrCSS("#UserSettingLanguage button").click();
        ElementFacade changeLanguageElement = this.changeLanguageElement(language);
        changeLanguageElement.waitUntilClickable();
        changeLanguageElement.click();
    }

    public void editPassword(String oldPassword, String password) {
        this.editPasswordElement().click();
        this.oldPasswordElement().setTextValue(oldPassword);
        this.newPasswordElement().setTextValue(password);
        this.newPasswordConfirmElement().setTextValue(password);
    }

    public void enableDisableNotificationOnMobile() {
        this.clickOnNotificationSwitchButton(2);
    }

    public void enableDisableNotificationOnSite() {
        this.clickOnNotificationSwitchButton(3);
    }

    public void enableDisableNotificationViaMail() {
        this.clickOnNotificationSwitchButton(1);
    }

    public void generalNotificationsSendingMailTypeIsDaily() {
        Assert.assertTrue((boolean)this.generalNotificationsSelectMailSendingTypeElement().getText().contains("Daily"));
    }

    public void generalNotificationsSendingMailTypeIsNever() {
        Assert.assertTrue((boolean)this.generalNotificationsSelectMailSendingTypeElement().getText().contains("Never"));
    }

    public void generalNotificationsSendingMailTypeIsWeekly() {
        Assert.assertTrue((boolean)this.generalNotificationsSelectMailSendingTypeElement().getText().contains("Weekly"));
    }

    public void goToManageNotifications() {
        this.clickOnElement(this.manageNotificationsElement());
    }

    public void noEmailIsDisplayedInGeneralNotificationsSection() {
        ElementFacade generalNotificationsSectionElement = this.generalNotificationsSectionElement();
        Assert.assertFalse((boolean)generalNotificationsSectionElement.getText().contains("Daily digest email notification"));
        Assert.assertFalse((boolean)generalNotificationsSectionElement.getText().contains("Weekly digest email notification"));
    }

    public void notifyMeByEmailIsDisplayedInGeneralNotificationsSection() {
        Assert.assertTrue((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me by email"));
    }

    public void notifyMeByEmailIsNotDisplayedInGeneralNotificationsSection() {
        Assert.assertFalse((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me by email"));
    }

    public void notifyMeOnMobileIsDisplayedInGeneralNotificationsSection() {
        Assert.assertTrue((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me on mobile"));
    }

    public void notifyMeOnMobileIsNotDisplayedInGeneralNotificationsSection() {
        Assert.assertFalse((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me on mobile"));
    }

    public void notifyMeOnSiteIsDisplayedInGeneralNotificationsSection() {
        Assert.assertTrue((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me on-site"));
    }

    public void notifyMeOnSiteIsNotDisplayedInGeneralNotificationsSection() {
        Assert.assertFalse((boolean)this.generalNotificationsSectionElement().getText().contains("Notify me on-site"));
    }

    public void selectSendMeASummaryEmail(String mailSendingType2) {
        switch (mailSendingType2) {
            case "Daily": {
                this.generalNotificationsSelectMailSendingTypeElement().selectByValue("Daily");
                break;
            }
            case "Weekly": {
                this.generalNotificationsSelectMailSendingTypeElement().selectByValue("Weekly");
                break;
            }
            case "Never": {
                this.generalNotificationsSelectMailSendingTypeElement().selectByValue("Never");
                break;
            }
        }
    }

    public void weeklyEmailIsDisplayedInGeneralNotificationsSection() {
        Assert.assertTrue((boolean)this.generalNotificationsSectionElement().getText().contains("Weekly digest email notification"));
    }

    private ElementFacade applyChangeLanguageButtonElement() {
        return this.findByXPathOrCSS("(//button[@class='btn btn-primary v-btn v-btn--contained theme--light v-size--default']//*[@class='v-btn__content'])[1]");
    }

    private ElementFacade applyEditGeneralNotificationsButtonElement() {
        return this.findByXPathOrCSS("(//button[@class='btn btn-primary v-btn v-btn--contained theme--light v-size--default']//*[@class='v-btn__content'])[1]");
    }

    private ElementFacade cancelEditPasswordElement() {
        return this.findByXPathOrCSS("(//input[@type='password'])[3]/following::*[@class='v-btn__content'][1]");
    }

    private ElementFacade changeLanguageElement(String language) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]", language));
    }

    private void checkNotificationSwitchButtonState(int switchButtonIndex, boolean expectedState) {
        this.findByXPathOrCSS(String.format(NOTIFICATION_SWITCH_BUTTON_BY_STATE_XPATH, String.valueOf(switchButtonIndex), String.valueOf(expectedState))).assertVisible();
    }

    private void clickOnNotificationSwitchButton(int switchButtonIndex) {
        ElementFacade element = this.findByXPathOrCSS(String.format(NOTIFICATION_SWITCH_BUTTON_XPATH, String.valueOf(switchButtonIndex)));
        boolean beforeClickState = Boolean.parseBoolean(element.getAttribute("aria-checked"));
        element.findByXPath("//ancestor::*[contains(@class, 'v-input')]").click();
        boolean expectedNewState = !beforeClickState;
        element = this.findByXPathOrCSS(String.format(NOTIFICATION_SWITCH_BUTTON_BY_STATE_XPATH, String.valueOf(switchButtonIndex), String.valueOf(expectedNewState)));
        element.waitUntilVisible();
    }

    private ElementFacade confirmEditPasswordElement() {
        return this.findByXPathOrCSS("(//input[@type='password'])[3]/following::*[@class='v-btn__content'][2]");
    }

    private ElementFacade editPasswordElement() {
        return this.findByXPathOrCSS("//*[@class='v-list-item__action']//*[@data-original-title='Edit password']//button");
    }

    private ElementFacade generalNotificationsSectionElement() {
        return this.findByXPathOrCSS("//*[contains(text(), 'Manage notifications')]//ancestor::*[contains(@class, 'application-body')]");
    }

    private ElementFacade generalNotificationsSelectMailSendingTypeElement() {
        return this.findByXPathOrCSS("//select[@name='EMAIL_DIGEST']");
    }

    private ElementFacade languageTextElement(String language) {
        return this.findByXPathOrCSS(String.format("//*[@id='UserSettingLanguage']//*[contains(text(), '%s')]", language));
    }

    private ElementFacade manageNoticiationActivityStreamSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Activity Stream')]");
    }

    private ElementFacade manageNotificationConnectionsSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Connections')]");
    }

    private ElementFacade manageNotificationGeneralSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Connections')]");
    }

    private ElementFacade manageNotificationKudosSectionElement() {
        return this.findByXPathOrCSS("(///div[@class='v-list-item__content']//*[contains(text(),'Kudos')]");
    }

    private ElementFacade manageNotificationNotesSectionElement() {
        return this.findByXPathOrCSS("(//div[@class='v-list-item__content']//*[contains(text(),'Notes')]");
    }

    private ElementFacade manageNotificationPageElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Manage notifications')]");
    }

    private ElementFacade manageNotificationPerkStoreSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Perk store')]");
    }

    private ElementFacade manageNotificationsElement() {
        return this.findByXPathOrCSS("(//*[@class='v-list-item__action'])[7]//button");
    }

    private ElementFacade manageNotificationSpacesSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'Spaces')]");
    }

    private ElementFacade manageNotificationTasksSectionElement() {
        return this.findByXPathOrCSS("(//*[contains(text(),'My Tasks')]");
    }

    private ElementFacade manageNotificationWalletSectionElement() {
        return this.findByXPathOrCSS("(//div[@class='v-list-item__content']//*[contains(text(),'Wallet')]");
    }

    private TextBoxElementFacade newPasswordConfirmElement() {
        return this.findTextBoxByXPathOrCSS("(//input[@type='password'])[3]");
    }

    private TextBoxElementFacade newPasswordElement() {
        return this.findTextBoxByXPathOrCSS("(//input[@type='password'])[2]");
    }

    private TextBoxElementFacade oldPasswordElement() {
        return this.findTextBoxByXPathOrCSS("(//input[@type='password'])[1]");
    }

    private void clickCancelInDrawerButton() {
        this.clickDrawerButton("Cancel");
        this.waitForDrawerToClose();
    }

    public static enum mailSendingType {
        DAILY,
        NEVER,
        WEEKLY;

    }
}

