/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.pages.PeoplePage;
import io.meeds.qa.ui.utils.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.serenitybdd.core.Serenity;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class SpacePage
extends GenericPage {
    private static final String COMMENT_SESSION_VARIABLE = "comment";
    private static final String CKE_EDITOR_BODY = "//body[contains(@class,'cke_editable_themed')]";
    private static final String CKE_WYSIWYG_FRAME_SUFFIX = "//iframe[contains(@class,'cke_wysiwyg_frame')]";
    private static final String COMMENT_LINK = "CommentLink";
    private static final String CREATE_POLL_DRAWER_ID = "#createPollDrawer";
    private static final String OPENED_ACTIVITY_COMMENTS_DRAWER_SELECTOR = "//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]";
    private static final String OPENED_ACTIVITY_REPLIES_DRAWER_SELECTOR = "//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activity-comment')]";
    private static final String OPENED_ACTIVITY_COMPOSER_DRAWER_SELECTOR = "//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]";
    private static final String OPENED_KUDOS_DRAWER_SELECTOR = "//*[@id = 'activityKudosDrawer' and contains(@class, 'v-navigation-drawer--open')]";
    private static final String CONFIRMATION_BUTTON_TO_DELETE_ACTIVITY_SELECTOR = "//*[contains(text(),'Yes')]";
    private PeoplePage peoplePage;

    public SpacePage(WebDriver driver) {
        super(driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityTextInOpenedEditor(String activity) {
        this.waitForDrawerToOpen();
        this.waitCKEditorLoading(OPENED_ACTIVITY_COMPOSER_DRAWER_SELECTOR);
        this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameElement());
        try {
            TextBoxElementFacade activityContentTextBoxElement = this.activityContentTextBoxElement();
            if (activity.contains("https")) {
                activityContentTextBoxElement.sendKeys(new CharSequence[]{activity});
                activityContentTextBoxElement.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "a"});
                activityContentTextBoxElement.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "x"});
                this.getDriver().switchTo().defaultContent();
                this.closeDrawerIfDisplayed();
                this.clickPostIcon();
                this.waitForDrawerToOpen();
                this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameElement());
                activityContentTextBoxElement = this.activityContentTextBoxElement();
                activityContentTextBoxElement.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "v"});
                int i = Utils.MAX_WAIT_RETRIES;
                while (!this.activityLinkPreviewElement().isVisible() && i-- > 0) {
                    this.waitFor(2).seconds();
                }
            } else if (activity.contains("lien")) {
                activityContentTextBoxElement.click();
                activityContentTextBoxElement.sendKeys(new CharSequence[]{Keys.PAGE_UP});
                activityContentTextBoxElement.sendKeys(new CharSequence[]{activity});
            } else {
                activityContentTextBoxElement.setTextValue(activity);
                Serenity.setSessionVariable((Object)"activity").to((Object)activity);
            }
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void addActivityComment(String activity, String comment) {
        this.getActivityCommentButton(activity).click();
        this.waitForDrawerToOpen();
        this.waitForDrawerToLoad();
        this.addActivityCommentEditorContent(comment, false, true);
        this.closeDrawerIfDisplayed();
        this.waitForDrawerToClose();
    }

    public void addActivityComments(String activity, List<String> comments) {
        this.getActivityCommentButton(activity).click();
        this.waitForDrawerToOpen();
        this.waitForDrawerToLoad();
        Iterator<String> commentsIterator = comments.iterator();
        while (commentsIterator.hasNext()) {
            String comment = commentsIterator.next();
            this.addActivityCommentEditorContent(comment, false, true);
            if (!commentsIterator.hasNext()) continue;
            this.waitFor(100).milliseconds();
            ElementFacade addCommentInDrawerButton = this.findByXPathOrCSS(".v-navigation-drawer--open .drawerIcons > button:first-of-type");
            addCommentInDrawerButton.click();
        }
        this.closeDrawerIfDisplayed();
    }

    public void addActivityCommentEditorContent(String comment, boolean edit, boolean save) {
        Utils.retryOnCondition(() -> {
            if (!edit && !this.ckEditorFrameCommentElement().isCurrentlyVisible()) {
                this.addCommentButtonInDrawerElement().click();
                this.waitFor(200).milliseconds();
            }
            this.waitOnCommentRichText();
            this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameCommentElement());
            try {
                TextBoxElementFacade ckEditorBodyCommentElement = this.ckEditorBodyCommentElement();
                ckEditorBodyCommentElement.waitUntilVisible();
                ckEditorBodyCommentElement.setTextValue(comment);
            }
            finally {
                this.getDriver().switchTo().defaultContent();
            }
            if (save) {
                this.clickOnSaveComment();
            }
        });
        if (save) {
            this.waitForDrawerToLoad();
            this.ckEditorFrameCommentElement().waitUntilNotVisible();
        }
    }

    public void clickOnSaveComment() {
        ElementFacade saveCommentButtonInDrawerElement = this.saveCommentButtonInDrawerElement();
        saveCommentButtonInDrawerElement.click();
    }

    public void addCommentReplies(List<String> replies, String comment, String activity) {
        this.clickOnReplyToComment(comment, activity);
        Iterator<String> repliesIterator = replies.iterator();
        while (repliesIterator.hasNext()) {
            String reply = repliesIterator.next();
            this.waitOnReplyRichText();
            this.addReplyEditorContent(reply);
            this.waitForDrawerToLoad();
            if (!repliesIterator.hasNext()) continue;
            this.ckEditorFrameCommentElement().checkNotVisible();
            this.clickOnReplyToComment(comment, activity);
        }
        this.closeDrawerIfDisplayed();
    }

    public void addCommentReply(String reply, String comment, String activity) {
        this.clickOnReplyToComment(comment, activity);
        this.waitForDrawerToOpen();
        this.waitForDrawerToLoad();
        this.waitOnReplyRichText();
        this.addReplyEditorContent(reply);
        this.closeDrawerIfDisplayed();
    }

    public void addDescriptionLess1000CharsInThePoll(String choiceThree) {
        TextBoxElementFacade choiceThreePollElement = this.choiceThreePollElement();
        choiceThreePollElement.waitUntilVisible();
        choiceThreePollElement.setTextValue(choiceThree);
    }

    public void addOptionThreeInThePoll(String choiceThree) {
        TextBoxElementFacade choiceThreePollElement = this.choiceThreePollElement();
        choiceThreePollElement.click();
        choiceThreePollElement.setTextValue(choiceThree);
    }

    public void addOptionTwoInThePoll(String choiceTow) {
        TextBoxElementFacade choiceTwoPollElement = this.choiceTwoPollElement();
        choiceTwoPollElement.click();
        choiceTwoPollElement.setTextValue(choiceTow);
    }

    public void cancelDeleteComment() {
        this.cancelDeleteCommentBtnElement().click();
    }

    public void cancelUpdateActivityComment(String comment) {
        this.waitOnCommentRichText();
        this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameCommentElement());
        try {
            TextBoxElementFacade commentFieldElement = this.commentFieldElement();
            commentFieldElement.waitUntilVisible();
            commentFieldElement.clear();
            commentFieldElement.setTextValue(comment);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.cancelBtnElement().click();
        this.closeCommentsDrawerElement().click();
    }

    public void checkActivityCommentInDrawer(String comment) {
        this.commentsDrawerElement().assertVisible();
        this.getCommentElementInDrawer(comment).assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkActivityCommentDisplayed(String activity, String comment) {
        this.checkCommentDrawerOpened(activity);
        this.getCommentElementInDrawer(comment).assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkActivityCommentNotDisplayed(String activity, String comment) {
        this.checkCommentDrawerOpened(activity);
        this.getCommentElementInDrawer(comment).assertNotVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkActivityNotVisible(String activity) {
        this.getActivityText(activity).assertNotVisible();
    }

    public void checkActivityPinned(String activity) {
        this.getPinnedActivity(activity).assertVisible();
    }

    public void checkActivityTitle(String activity) {
        Assert.assertEquals((Object)this.activityTitleElement().getText(), (Object)activity);
    }

    public void checkActivityVisible(String activity) {
        this.getActivityText(activity).assertVisible();
    }

    public void checkCommentVisible(String comment) {
        this.getCommentElement(comment).assertVisible();
    }

    public void checkCommentReplyDisplayed(String activity, String comment, String reply) {
        this.checkCommentDrawerOpened(activity);
        this.getReplyBox(comment, reply).assertVisible();
    }

    public void checkCommentReplyNotDisplayed(String activity, String comment, String reply) {
        this.checkCommentDrawerOpened(activity);
        this.getReplyBox(comment, reply).assertNotVisible();
    }

    public void checkConfirmationPopupNotVisible() {
        this.findByXPathOrCSS(CONFIRMATION_BUTTON_TO_DELETE_ACTIVITY_SELECTOR).assertNotVisible();
    }

    public void checkConfirmationPopupVisible() {
        this.findByXPathOrCSS(CONFIRMATION_BUTTON_TO_DELETE_ACTIVITY_SELECTOR).assertVisible();
    }

    public void checkCreatePollButtonIsDisabled() {
        this.buttonCreatePollElement().assertDisabled();
    }

    public void checkCreatePollButtonIsEnabled() {
        this.buttonCreatePollElement().assertEnabled();
    }

    public void checkFirstActivityComment(String comment) {
        Assert.assertEquals((Object)this.firstASDisplayedCommentElement().getText(), (Object)comment);
    }

    public void checkFirstCommentInDrawer(String comment) {
        Assert.assertEquals((Object)this.firstCommentInDrawerElement().getText(), (Object)comment);
        this.closeDrawerIfDisplayed();
    }

    public void checkFourCommentIsDisplayedInDrawer() {
        this.firstCommentInDrawerElement().assertVisible();
        this.secondCommentInDrawerElement().assertVisible();
        this.thirdCommentInDrawerElement().assertVisible();
        this.fourthCommentInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkFourthCommentInDrawer() {
        this.fourthCommentInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkLinkPreviewVisible() {
        this.findByXPathOrCSS("//*[contains(@class, 'activity-thumbnail-box')]//*[contains(@class, 'v-avatar')]").assertVisible();
    }

    public void checkSearchedUserWellMatched(String fullName) {
        this.insertNameContact(fullName);
        Utils.retryOnCondition(() -> this.getUserProfileButton(fullName).checkVisible(), () -> this.peoplePage.searchUser(fullName));
    }

    public void checkSecondActivityComment() {
        this.secondASDisplayedCommentElement().assertVisible();
    }

    public void checkSecondCommentInDrawer() {
        this.secondCommentInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkSixthPositionInDrawer() {
        this.sixthPositionInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkTenCommentIsDisplayedInDrawer() {
        this.firstCommentInDrawerElement().assertVisible();
        this.secondCommentInDrawerElement().assertVisible();
        this.thirdCommentInDrawerElement().assertVisible();
        this.fourthCommentInDrawerElement().assertVisible();
        this.fifthCommentInDrawerElement().assertVisible();
        this.sixthPositionInDrawerElement().assertVisible();
        this.seventhCommentInDrawerElement().assertVisible();
        this.eighthCommentInDrawerElement().assertVisible();
        this.ninthCommentInDrawerElement().assertVisible();
        this.tenthCommentInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkThirdCommentInDrawer() {
        this.thirdCommentInDrawerElement().assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkUserDisplayedInReactionsDrawer(String userLastName) {
        this.getUserElementFromReactionsDrawer(userLastName).assertVisible();
    }

    public void checkVideoActivityVisible(String videoLink) {
        this.getSharedVideoPreview(videoLink).assertVisible();
    }

    public void clickApplyDownload() {
        this.applyDownloadButtonElement().click();
    }

    public void clickCreatePoll() {
        this.createPollLinkElement().click();
    }

    public void clickSendKudos() {
        this.sendKudosLinkElement().click();
    }

    public void clickKudosBtnBelowPostField() {
        ElementFacade sendKudos = this.findByXPathOrCSS("//*[contains(@class,'activityComposer')]//*[contains(@id,'kudosBtnToolbar')]");
        sendKudos.click();
    }

    public void clickPollBtnBelowPostField() {
        ElementFacade createPoll = this.findByXPathOrCSS("//*[contains(@class,'activityComposer')]//*[contains(@id,'pollBtnToolbar')]");
        createPoll.click();
    }

    public void clickCreatePollButton() {
        this.buttonCreatePollElement().click();
    }

    public void clickDeleteActivityButton(String activity) {
        this.getDeleteActivityIcon(activity).click();
    }

    public void clickCommentButton(String buttonName, String comment) {
        this.getCommentMenuButton(buttonName, comment).click();
    }

    public void clickOnActivityComment(String comment) {
        this.getCommentTitleActivityStream(comment).click();
    }

    public void clickOnCommentActivityButton(String activity) {
        this.getActivityCommentButton(activity).click();
    }

    public void clickOnCommentsDrawerFirstPage() {
        this.commentsDrawerFirstPageBtnElement().click();
    }

    public void clickOnCommentsDrawerSecondPage() {
        this.commentsDrawerSecondPageBtnElement().click();
    }

    public void clickOnCommentThreeDotsButtonFromCommentsDrawer(String comment, boolean reply) {
        this.getDropDownCommentMenuFromCommentsDrawer(comment, reply).click();
    }

    public void clickOnConfirmButton() {
        this.getConfirmButton("Confirm").click();
    }

    public void clickOnkudosButtonFromCommentsDrawerToCommentActivity() {
        this.kudosButtonFromCommentsDrawerToCommentActivityElement().click();
        this.waitForDrawerToOpen("#activityKudosDrawer", false);
    }

    public void clickOnKudosButtonNumberFromCommentsDrawerToCommentActivity() {
        this.kudosButtonNumberFromCommentsDrawerToCommentActivityElement().assertVisible();
        this.kudosButtonNumberFromCommentsDrawerToCommentActivityElement().click();
        this.waitForDrawerToOpen(".v-navigation-drawer--open .kudos-list", false);
    }

    public void clickOnKudosButtonNumberToCommentActivity() {
        this.kudosButtonNumberToCommentActivityElement().click();
    }

    public void clickOnkudosButtonToActivityStream() {
        ElementFacade firstActivityKudosButton = this.findByXPathOrCSS("(//*[contains(@class, 'activity-detail')])[1]//*[contains(@class, 'activity-footer-actions')]//*[contains(@id, 'KudosActivity')]");
        firstActivityKudosButton.click();
    }

    public void getCommentKudosButton(String comment) {
        this.getCommentKudosFooterButton(comment, "ActivityCommment_comment", "KudosActivity").click();
    }

    public void clickOnLoadMoreActivities() {
        this.loadMoreActivitiesBtnElement().click();
    }

    public void clickOnReplyKudos(String reply) {
        this.getBlackKudosCommentIcon(reply).click();
    }

    public void clickOnTheUserPopover(String user) {
        this.getUserPopover(user).click();
    }

    public void clickOnViewallXcomments() {
        this.viewallXcommentsElement().click();
    }

    public void clickPinActivityButton(String activity) {
        this.getPinActivityIcon(activity).click();
    }

    public void clickPostIcon() {
        this.goToSpecificTab("Home");
        Utils.waitForLoading();
        ElementFacade activityPostLink = this.findByXPathOrCSS(".activityComposer .openLink");
        activityPostLink.click();
    }

    public void composerDrawerIsDisplayed() {
        this.findByXPathOrCSS("#activityComposerDrawer").assertVisible();
    }

    public void kudosDrawerIsDisplayed() {
        this.findByXPathOrCSS("#activityKudosDrawer").assertVisible();
    }

    public void pollDrawerIsDisplayed() {
        this.findByXPathOrCSS(CREATE_POLL_DRAWER_ID).assertVisible();
    }

    public void clickUserAvatar() {
        ElementFacade userAvatarLink = this.findByXPathOrCSS("//*[contains(@class,'activityComposer')]//descendant::*[starts-with(@id,'userAvatar')]");
        userAvatarLink.click();
    }

    public void showUserPopover(String user) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(user + "UserName"));
        ElementFacade userAvatar = this.findByXPathOrCSS("a[href*='" + userName + "'] > div.v-avatar");
        userAvatar.hover();
    }

    public void clickCloseKudosDrawer() {
        ElementFacade closeKudosDrawerIcon = this.findByXPathOrCSS("//*[contains(@id,'activityKudosDrawer')]//*[contains(@class,'drawerIcons')]//button[@title='Close']");
        closeKudosDrawerIcon.click();
    }

    public void clickUnpinActivityButton(String activity) {
        this.getUnpinActivityIcon(activity).checkVisible();
        this.waitFor(200).milliseconds();
        this.getUnpinActivityIcon(activity).click();
    }

    public void clickYesbutton() {
        this.findByXPathOrCSS(CONFIRMATION_BUTTON_TO_DELETE_ACTIVITY_SELECTOR).click();
        this.waitFor(200).milliseconds();
        Utils.waitForLoading();
    }

    public void commentIsDisplayedInDrawer(String commentsNumber, String comment) {
        this.getDrawerCommentsNumberAndNames(commentsNumber, comment).assertVisible();
    }

    public void commentIsNotDisplayedInDrawer(String commentsNumber, String comment) {
        this.getDrawerCommentsNumberAndNames(commentsNumber, comment).assertNotVisible();
    }

    public void commentNameIsNotDisplayedInDrawer(String comment) {
        this.getDrawerCommentName(comment).assertNotVisible();
    }

    public void commentsDrawerDisplayedLikesOnComment(String comment, String number) {
        Assert.assertTrue((boolean)this.getCommentLikesNumberCommentsDrawer(comment).getTextContent().contains(number));
    }

    public void commentsDrawerlikeActivityComment(String activityComment) {
        this.getCommentsDrawerLikeCommentIcon(activityComment).click();
    }

    public void copyLinkActivityButtonIsDisplayed(String activity) {
        this.getCopyLinkActivityIcon(activity).assertVisible();
    }

    public void createPoll(String pollTitle, String choiceOne, String choiceTow) {
        this.waitForDrawerToOpen(CREATE_POLL_DRAWER_ID, false);
        this.titlePollElement().setTextValue(pollTitle);
        this.choiceOnePollElement().setTextValue(choiceOne);
        this.choiceTwoPollElement().setTextValue(choiceTow);
        this.buttonCreatePollElement().click();
        this.waitForDrawerToClose(CREATE_POLL_DRAWER_ID, false);
    }

    public void createPollDrawerClosed() {
        this.titlePollElement().assertNotVisible();
    }

    public void createPollWithOneChoice(String pollTitle, String choiceOne) {
        TextBoxElementFacade titlePollElement = this.titlePollElement();
        titlePollElement.click();
        titlePollElement.setTextValue(pollTitle);
        TextBoxElementFacade choiceOnePollElement = this.choiceOnePollElement();
        choiceOnePollElement.click();
        choiceOnePollElement.setTextValue(choiceOne);
    }

    public void deleteActivityButtonIsDisplayed(String activity) {
        this.getDeleteActivityIcon(activity).assertVisible();
    }

    public void deleteComment(String comment) {
        this.getDeleteCommentLabel(comment).click();
    }

    public void deleteReply(String reply) {
        this.getDeleteReplyLabel(reply).click();
    }

    public void displayedLikesOnComment(String comment, String number) {
        Assert.assertTrue((boolean)this.getCommentLikesNumber(comment).getTextContent().contains(number));
    }

    public void downloadActivityButtonIsDisplayed(String activity) {
        this.getDownloadActivityIcon(activity).assertVisible();
    }

    public void clickOnUpdateActivity() {
        this.updateActivityButtonElement().click();
        Utils.waitForLoading();
        this.waitFor(200).milliseconds();
    }

    public void editActivityButtonIsDisplayed(String activity) {
        this.getEditActivityIcon(activity).assertVisible();
    }

    public void editComment() {
        this.dotsMenuElement().click();
        this.editButtonElement().click();
    }

    public void editComment(String comment) {
        this.getEditCommentLabel(comment).click();
    }

    public void editCommentFromCommentsDrawer(String comment) {
        this.getEditCommentLabelFromCommentsDrawer(comment).click();
    }

    public void editPoll(String pollTitle, String choiceOne, String choiceTow) {
        TextBoxElementFacade titlePollElement = this.titlePollElement();
        titlePollElement.click();
        titlePollElement.setTextValue(pollTitle);
        TextBoxElementFacade choiceOnePollElement = this.choiceOnePollElement();
        choiceOnePollElement.click();
        choiceOnePollElement.setTextValue(choiceOne);
        TextBoxElementFacade choiceTwoPollElement = this.choiceTwoPollElement();
        choiceTwoPollElement.click();
        choiceTwoPollElement.setTextValue(choiceTow);
        this.buttonCreatePollElement().click();
    }

    public void enterActivityCommentWithUser(String comment, String user) {
        this.mentionUserInCKEditor(this.ckEditorFrameCommentElement(), this.ckEditorBodyCommentElement(), comment, user, true);
    }

    public void enterActivityCommentWithUserNoMention(String comment, String user) {
        this.mentionUserInCKEditor(this.ckEditorFrameCommentElement(), this.ckEditorBodyCommentElement(), comment, user, false);
    }

    public void enterActivityText(String activity) {
        this.ckEditorFrameElement().waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameElement());
        try {
            TextBoxElementFacade activityContentTextBoxElement = this.activityContentTextBoxElement();
            activityContentTextBoxElement.waitUntilVisible();
            activityContentTextBoxElement.sendKeys(new CharSequence[]{activity});
            activityContentTextBoxElement.sendKeys(new CharSequence[]{Keys.SPACE});
            activityContentTextBoxElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            this.waitFor(100).milliseconds();
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        Serenity.setSessionVariable((Object)"activity").to((Object)activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterCommentLink(String activity, String comment) {
        this.getActivityCommentButton(activity).click();
        this.waitOnCommentRichText();
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameCommentElement();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            TextBoxElementFacade ckEditorBodyCommentElement = this.ckEditorBodyCommentElement();
            if (comment.contains("https")) {
                ckEditorBodyCommentElement.sendKeys(new CharSequence[]{comment});
                ckEditorBodyCommentElement.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "ax"});
                Utils.refreshPage();
                this.getActivityCommentButton(activity).click();
                ckEditorFrameCommentElement.waitUntilVisible();
                this.waitOnCommentRichText();
                this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
                ckEditorBodyCommentElement.waitUntilVisible();
                ckEditorBodyCommentElement.click();
                ckEditorBodyCommentElement.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "v"});
            } else if (comment.contains("lien")) {
                ckEditorBodyCommentElement.click();
                ckEditorBodyCommentElement.sendKeys(new CharSequence[]{Keys.PAGE_UP});
                ckEditorBodyCommentElement.sendKeys(new CharSequence[]{comment});
            } else {
                ckEditorBodyCommentElement.setTextValue(comment);
                Serenity.setSessionVariable((Object)COMMENT_SESSION_VARIABLE).to((Object)comment);
            }
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void enterCommentText(String comment) {
        this.ckEditorFrameCommentElement().waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameCommentElement());
        try {
            TextBoxElementFacade ckEditorBodyCommentElement = this.ckEditorBodyCommentElement();
            ckEditorBodyCommentElement.waitUntilVisible();
            ckEditorBodyCommentElement.sendKeys(new CharSequence[]{comment});
            ckEditorBodyCommentElement.sendKeys(new CharSequence[]{Keys.SPACE});
            ckEditorBodyCommentElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            this.waitFor(100).milliseconds();
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        Serenity.setSessionVariable((Object)COMMENT_SESSION_VARIABLE).to((Object)comment);
    }

    public void filterByMyConnections() {
        this.clickOnApplicationFilterButton();
        ElementFacade filterByMyConnectionsElement = this.filterByMyConnectionsElement();
        filterByMyConnectionsElement.waitUntilVisible();
        filterByMyConnectionsElement.click();
        filterByMyConnectionsElement.selectByValue("connections");
    }

    public void getReceivedKudosSectionIsDisplayed(String kudosNumber) {
        this.getReceivedKudosNumberInDrawer(kudosNumber).assertVisible();
    }

    public void goToPeopleMenu() {
        this.menuBtnElement().click();
        this.peopleBtnElement().click();
    }

    public void goToSpecificTab(String tabName) {
        if (tabName.contains("/")) {
            String[] navigationParts = tabName.split("/");
            this.searchNavigationTabElement(navigationParts[0]).assertVisible();
            this.tabElement(navigationParts[0]).hover();
            this.tabSubNavigationElement(navigationParts[1]).click();
            this.verifyPageLoaded();
        } else {
            ElementFacade tabElement = this.searchSpaceTabElement(tabName);
            tabElement.assertVisible();
            if (!this.selectedTabElement(tabName).isCurrentlyVisible()) {
                tabElement.click();
            }
            this.verifyPageLoaded();
            this.selectedTabElement(tabName).assertVisible();
        }
    }

    public void goToUserProfileFromLikersDrawer(String userLastName) {
        this.getUserElementFromReactionsDrawer(userLastName).click();
    }

    public void hoverOnLikeIcon(String comment) {
        this.getLikeCommentIcon(comment).hover();
    }

    public void hoverOnLikeIconCommentsDrawer(String comment) {
        this.getCommentsDrawerLikeCommentIcon(comment).hover();
    }

    public void hoverOnMentionedUserInPost(String activity, String user) {
        this.getUserMentionedInPost(activity, user).hover();
    }

    public void insertNameContact(String contact) {
        this.peoplePage.searchUser(contact);
    }

    public void isActivityNameUserSpaceDisplayed(String activity, String user, String space) {
        this.getActivityNameUserSpace(activity, user, space).assertVisible();
    }

    public void isMentionedUserDisplayedInPost(String activity, String user) {
        this.getUserMentionedInPost(activity, user).assertVisible();
    }

    public void isUserPopoverDisplayed(String user) {
        this.getUserPopover(user).assertVisible();
    }

    public void kudosLabelIsBlack(String comment) {
        this.getBlackKudosCommentIcon(comment).assertVisible();
        this.getBlueKudosCommentIcon(comment).assertNotVisible();
    }

    public void kudosLabelIsBlue(String comment) {
        this.getBlackKudosCommentIcon(comment).assertNotVisible();
        this.getBlueKudosCommentIcon(comment).assertVisible();
    }

    public void likeActivity(String activity) {
        this.getActivityLikeButton(activity).click();
    }

    public void likeActivityComment(String activityComment) {
        this.getLikeCommentIcon(activityComment).click();
    }

    public void likeLabelInCommentsDrawerIsBlack(String comment) {
        this.getCommentsDrawerBlueLikeCommentIcon(comment).assertNotVisible();
    }

    public void likeLabelInCommentsDrawerIsBlue(String comment) {
        this.getCommentsDrawerBlueLikeCommentIcon(comment).assertVisible();
    }

    public void likeLabelIsBlack(String comment) {
        this.getBlueLikeCommentIcon(comment).assertNotVisible();
    }

    public void likeLabelIsBlue(String comment) {
        this.getBlueLikeCommentIcon(comment).assertVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkIsOpenedNewTab(String link) {
        this.waitFor(1).seconds();
        Set windowHandles = this.getDriver().getWindowHandles();
        try {
            boolean tabFound = windowHandles.size() > 1 && windowHandles.stream().anyMatch(windowId -> {
                this.getDriver().switchTo().window(windowId);
                this.waitFor(50).milliseconds();
                String currentUrl = this.getDriver().getCurrentUrl();
                boolean found = currentUrl.contains(link);
                if (!currentUrl.contains("/portal")) {
                    this.getDriver().close();
                }
                return found;
            });
            Assert.assertTrue((boolean)tabFound);
        }
        finally {
            this.getDriver().switchTo().window((String)windowHandles.iterator().next());
        }
    }

    public void noCommentDisplayedInDrawer() {
        this.findByXPathOrCSS("//*[@class='text-capitalize-first-letter' and contains(text(),'No comment yet')]").assertVisible();
    }

    public void openActivityReactionsDrawer(String activity) {
        this.getReactionActivityLink(activity).click();
        this.waitForDrawerToOpen();
    }

    public void checkActivityReactionsNumberDisplayed(String activity) {
        this.getReactionActivityLink(activity).assertVisible();
    }

    public void checkActivityReactionsNumberNotDisplayed(String activity) {
        this.getReactionActivityLink(activity).assertNotVisible();
    }

    public void openCommentsDrawer(String activity) {
        this.getActivityCommentButton(activity).click();
        this.waitForDrawerToLoad();
    }

    public void openDeleteActivityMenu(String activity) {
        this.getDropDownActivityMenu(activity).click();
        this.getDeleteActivityIcon(activity).click();
    }

    public void openEditActivityMenu(String activity) {
        this.openThreeDotsActivityMenu(activity);
        this.getEditActivityIcon(activity).click();
    }

    public void openLinkInNewTab(String link) {
        Actions newTab = new Actions(this.getDriver());
        newTab.keyDown((CharSequence)Keys.CONTROL).click((WebElement)this.getCommentTitleActivityStream(link)).keyUp((CharSequence)Keys.CONTROL).build().perform();
    }

    public void openThreeDotsActivityMenu(String activity) {
        if (this.isMenuDisplayed()) {
            this.closeMenu();
        }
        Utils.retryOnCondition(() -> {
            this.getDropDownActivityMenu(activity).click();
            this.waitMenuToDisplay();
        });
    }

    public boolean isThreeDotsActivityMenuOpen(String activity) {
        return this.getDropDownActivityMenu(activity).isVisible();
    }

    public void openThreeDotsCommentMenu(String activity, String comment) {
        this.checkCommentDrawerOpened(activity);
        this.clickOnCommentThreeDotsButtonFromCommentsDrawer(comment, false);
    }

    public void pinActivityButtonIsDisplayed(String activity) {
        this.getPinActivityIcon(activity).assertVisible();
    }

    public void pinActivityButtonIsNotDisplayed(String activity) {
        this.getPinActivityIcon(activity).assertNotVisible();
    }

    public void pinnedActivityDisappears(String activity) {
        this.getPinnedActivity(activity).assertNotVisible();
    }

    public void promoteSpaceMemberAsManager(String name) {
        this.searchMember(name);
        this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'peopleCardItem')]", name)).hover();
        ElementFacade threeDots = this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'peopleCardItem')]//*[contains(@class, 'fa-ellipsis-v')]//ancestor::button", name));
        threeDots.click();
        ElementFacade promoteAsAdminButton = this.findByXPathOrCSS("//*[contains(@class, 'fa-user-cog')]//ancestor::*[contains(@role, 'menuitem')]");
        promoteAsAdminButton.click();
    }

    public void publishActivity(boolean refreshStream) {
        this.publishActivityButtonElement().click();
        try {
            this.waitForDrawerToClose();
            if (refreshStream) {
                this.refreshStream();
            }
            Utils.waitForLoading();
        }
        catch (Exception e) {
            Utils.refreshPage();
        }
    }

    public void attachImagesToActivity() {
        this.waitCKEditorLoading(OPENED_ACTIVITY_COMPOSER_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
    }

    public void attachGifImageToActivity() {
        this.waitCKEditorLoading(OPENED_ACTIVITY_COMPOSER_DRAWER_SELECTOR);
        this.attachGifImageToCKeditor();
    }

    public void attachImagesToActivityComment() {
        this.waitCKEditorLoading(OPENED_ACTIVITY_COMMENTS_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
    }

    public void attachImagesToKudos() {
        this.waitCKEditorLoading(OPENED_KUDOS_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
    }

    public void clickPreviewAttachedImage(String activity) {
        this.getAttachedImagesActivity(activity).click();
    }

    public void clickClosePreviewAttachedImage() {
        this.previewAttachedImageCloseBtn().click();
    }

    public void checkPreviewAttachedImageIsClosed() {
        this.getPreviewAttachedImage().assertNotVisible();
    }

    public void previewAttachedImage() {
        this.getPreviewAttachedImage().assertVisible();
    }

    public void checkPreviewAttachedImageArrows() {
        this.getPreviewAttachedImageNextArrow().assertNotVisible();
        this.getPreviewAttachedImagePrevArrow().assertNotVisible();
    }

    public void clickDeleteAttachment() {
        this.deleteAttachmentBtn().click();
    }

    public void clickEditAttachment() {
        this.editAttachmentBtn().click();
    }

    public void clickUpdateAttachment() {
        this.getAttachedImageCropDrawerUpdateBtn().click();
    }

    public void zoomAttachedImage() {
        this.getAttachedImageCropDrawerZoomBtn().click();
    }

    public void checkAttachedImageCropDrawerCancelOption() {
        this.getAttachedImageCropDrawerCancekBtn().assertVisible();
    }

    public void checkAttachedImageCropDrawer() {
        this.getAttachedImageCropDrawer().assertVisible();
    }

    public void checkCropDrawerBlurredZone() {
        this.getAttachedImageCropDrawerBlurredZone().assertVisible();
    }

    public void checkActivityAttachImageDeleted() {
        this.getActivityAttachedImage().assertNotVisible();
    }

    public void publishActivityInArabicLanguage() {
        this.newActivityButtonInArabicLanguageElement().click();
    }

    public void publishComment() {
        this.saveCommentButtonInDrawerElement().click();
        this.closeDrawerIfDisplayed();
    }

    public void refreshStream() {
        ElementFacade newActivityButtonElement = this.newActivityButtonElement();
        if (newActivityButtonElement.isVisible()) {
            newActivityButtonElement.click();
        } else {
            Utils.refreshPage();
        }
    }

    public void removeMember(String name) {
        this.searchMember(name);
        ElementFacade threeDots = this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'peopleCardItem')]//*[contains(@class, 'mdi-dots-vertical')]//ancestor::button", name));
        threeDots.click();
        ElementFacade removeMemberButton = this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'peopleCardItem')]//*[contains(@class, 'uiIconTrash')]//ancestor::*[contains(@class, 'v-list-item')]", name));
        removeMemberButton.click();
    }

    public void replyInDrawerIsNotDisplayed(String reply) {
        ElementFacade element = this.getDrawerReplyName(reply);
        element.assertNotVisible();
    }

    public void replyIsDisplayedInCommentsDrawer(String comment, String reply) {
        this.getReplyBox(comment, reply).assertVisible();
    }

    public void replyIsNotDisplayedInCommentsDrawer(String comment, String reply) {
        this.getReplyBox(comment, reply).assertNotVisible();
    }

    public void searchMember(String name) {
        this.peoplePage.searchUser(name);
    }

    public void selectActivityFilter(String filter) {
        ElementFacade activityFilterRadioButton = this.findByXPathOrCSS(String.format("//*[contains(@id,'filterStreamDrawer')]//*[contains(text(),'%s')]", filter));
        activityFilterRadioButton.click();
    }

    public void clickFilterIconFromComposer() {
        ElementFacade filterLink = this.findByXPathOrCSS("//*[contains(@class,'activityComposer')]//*[contains(@id,'toolbarFilterButton')]");
        filterLink.click();
        this.waitForDrawerToOpen();
    }

    public void filterIsSelected() {
        Assert.assertTrue((boolean)this.filterIcon().getAttribute("class").contains("primary--text"));
    }

    public void filterIsntSelected() {
        Assert.assertFalse((boolean)this.filterIcon().getAttribute("class").contains("primary--text"));
    }

    public void tooltipCommentsDrawerIsDisplayed(String comment) {
        Assert.assertTrue((boolean)this.getCommentsDrawerLikeCommentIcon(comment).getAttribute("aria-expanded").contains("true"));
    }

    public void unPinActivityButtonIsDisplayed(String activity) {
        this.getUnpinActivityIcon(activity).assertVisible();
    }

    public void checkActivityAttachedImages(String activity) {
        this.getAttachedImagesActivity(activity).assertVisible();
    }

    public void checkActivitySecondAttachedImage(String activity) {
        this.getSecondAttachedImageActivity(activity).assertVisible();
    }

    public void checkActivityCommentKudos(String comment) {
        Assert.assertEquals((Object)this.commentKudosTitleElement().getText(), (Object)comment);
    }

    public void checkKudosCommentAttachedImages(String comment) {
        this.getAttachedImagesKudosComment(comment).assertVisible();
    }

    public void checkActivityAttachedImagesIsNotDisplayed(String activity) {
        this.getAttachedImagesActivity(activity).assertNotVisible();
    }

    public void checkActivityDrawerAttachedImagesDeleteIcon(String activity) {
        this.getActivityAttachedImageWithDeleteIcon(activity).assertVisible();
    }

    public void checkActivityDrawerAttachedImagesEditIcon(String activity) {
        this.getActivityAttachedImageWithEditIcon(activity).assertVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivityComment(String comment) {
        this.waitOnCommentRichText();
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameCommentElement();
        ckEditorFrameCommentElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            TextBoxElementFacade commentFieldElement = this.commentFieldElement();
            commentFieldElement.waitUntilVisible();
            commentFieldElement.clear();
            commentFieldElement.setTextValue(comment);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.updateButonElement().click();
        this.closeCommentsDrawerElement().click();
    }

    public void updateComment() {
        this.updateButtonInDrawerElement().click();
        this.closeDrawerIfDisplayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommentText(String comment) {
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameCommentElement();
        ckEditorFrameCommentElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            TextBoxElementFacade ckEditorBodyCommentElement = this.ckEditorBodyCommentElement();
            ckEditorBodyCommentElement.clear();
            ckEditorBodyCommentElement.sendKeys(new CharSequence[]{comment});
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        Serenity.setSessionVariable((Object)COMMENT_SESSION_VARIABLE).to((Object)comment);
    }

    public void userIsMentionedInCommentEntered(String user) {
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameCommentElement();
        ckEditorFrameCommentElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            this.getMentionedUserInCommentEntered(user).assertVisible();
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void userIsNotMentionedInCommentEntered(String user) {
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameCommentElement();
        ckEditorFrameCommentElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            this.getMentionedUserInCommentEntered(user).assertNotVisible();
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void viewAllRepliesInActivityStream(String comment) {
        this.getActivityStreamViewAllReplies(comment).click();
    }

    public void viewAllRepliesInCommentsDrawer(String comment) {
        this.getCommentsDrawerViewAllReplies(comment).click();
    }

    public void openSpaceSettingsSection(String sectionId) {
        this.getSpaceSettingSectionButton(sectionId).click();
    }

    public void enableRedactionalSpaceSettings() {
        ElementFacade switchButton = this.getRedactionalSpaceSwitchButton();
        this.getRedactionalSpaceSwitchButtonParent().checkVisible();
        int i = Utils.MAX_WAIT_RETRIES;
        while (--i > 0 && StringUtils.equals((CharSequence)"true", (CharSequence)switchButton.getAttribute("aria-checked"))) {
            this.getRedactionalSpaceSwitchButtonParent().click();
            this.waitFor(50).seconds();
        }
        if (i <= 0) {
            throw new ElementClickInterceptedException(String.format("Restrict content creation switch button wasn't enabled after %s retries", Utils.MAX_WAIT_RETRIES));
        }
        this.getRedactionalSpaceSwitchButtonParent().click();
        this.waitForDrawerToOpen();
        this.getSpaceSettingsRedactorsDrawer().checkVisible();
    }

    public void promoteUserAsSpaceRedactor(String userFirstName) {
        this.mentionInField(this.getUserMemberSuggester(), userFirstName, 3);
        this.getRedactorItemInList(userFirstName).assertVisible();
    }

    public void addUserWithRoleInSpace(String userFirstName) {
        this.mentionInField(this.getUserMemberSuggester(), userFirstName, 3);
        this.getAddedUserToRoleItemInList(userFirstName).assertVisible();
    }

    public void openSpaceSettingsRoleDrawer(String role) {
        this.getSpaceSettingRoleButtonToOpenDrawer(role).assertVisible();
        this.getSpaceSettingRoleButtonToOpenDrawer(role).click();
        this.waitForDrawerToOpen();
        Utils.retryOnCondition(() -> {
            if (this.getSpaceSettingRoleAddButton(role).isCurrentlyVisible()) {
                this.getSpaceSettingRoleAddButton(role).click();
                this.waitForDrawerToOpen();
            }
            this.findButtonByXPathOrCSS("#SpaceSettingsUsersSelectionDrawer #userMemberSuggester").checkVisible();
        });
    }

    private ElementFacade getSpaceSettingRoleAddButton(String role) {
        return this.findByXPathOrCSS(String.format("#SpaceSettingsUsersDrawer #%sAddUser", role));
    }

    private ElementFacade getSpaceSettingRoleButtonToOpenDrawer(String role) {
        return this.findByXPathOrCSS(String.format("//*[@id='%sSpaceSettingRoleRow']//button", role));
    }

    private TextBoxElementFacade getUserMemberSuggester() {
        return this.findTextBoxByXPathOrCSS("#userMemberSuggester input");
    }

    private ElementFacade getRedactorItemInList(String userFirstName) {
        return this.findByXPathOrCSS(String.format("//*[@id='SpaceSettingsRedactorsList']//*[contains(text(), '%s')]", userFirstName));
    }

    private ElementFacade getAddedUserToRoleItemInList(String userFirstName) {
        return this.findByXPathOrCSS(String.format("//*[@id='SpaceSettingsUsersSelectionDrawer']//*[contains(text(), '%s')]", userFirstName));
    }

    private ElementFacade getRedactionalSpaceSwitchButton() {
        return this.findByXPathOrCSS("#SpaceSettingRestrictContent");
    }

    private ElementFacade getRedactionalSpaceSwitchButtonParent() {
        return this.findByXPathOrCSS("//*[@id='SpaceSettingRestrictContent']//ancestor::*[contains(@class, 'v-input--switch')]");
    }

    private ElementFacade getSpaceSettingsRedactorsDrawer() {
        return this.findByXPathOrCSS("#SpaceSettingsRedactorsDrawer");
    }

    private ButtonElementFacade getSpaceSettingSectionButton(String sectionId) {
        return this.findButtonByXPathOrCSS(String.format("#SpaceSettings%s button", sectionId));
    }

    private ElementFacade searchSpaceTabElement(String tabName) {
        try {
            this.selectedTabElement().waitUntilVisible();
        }
        catch (Exception e) {
            LOGGER.debug("Selected Tab element not present, attempt continue to search for space tabs", (Throwable)e);
        }
        return Utils.retryGetOnCondition(() -> {
            Utils.waitForLoading();
            while (!this.tabLinkElement(tabName).findBy("span").isCurrentlyVisible() && this.goToSpaceLeftTabsElement().isVisible()) {
                this.goToSpaceLeftTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            while (!this.tabLinkElement(tabName).findBy("span").isCurrentlyVisible() && this.goToSpaceRightTabsElement().isVisible()) {
                this.goToSpaceRightTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            while (!this.tabLinkElement(tabName).findBy("span").isCurrentlyVisible() && this.goToSpaceLeftTabsElement().isVisible()) {
                this.goToSpaceLeftTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            ElementFacade tabElement = this.tabLinkElement(tabName);
            tabElement.checkVisible();
            return tabElement;
        });
    }

    private ElementFacade searchNavigationTabElement(String tabName) {
        return Utils.retryGetOnCondition(() -> {
            Utils.waitForLoading();
            while (!this.tabElement(tabName).isCurrentlyVisible() && this.goToSpaceLeftTabsElement().isVisible()) {
                this.goToSpaceLeftTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            while (!this.tabElement(tabName).isCurrentlyVisible() && this.goToSpaceRightTabsElement().isVisible()) {
                this.goToSpaceRightTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            while (!this.tabElement(tabName).isCurrentlyVisible() && this.goToSpaceLeftTabsElement().isVisible()) {
                this.goToSpaceLeftTabsElement().click();
                this.waitFor(200).milliseconds();
            }
            ElementFacade tabElement = this.tabElement(tabName);
            tabElement.checkVisible();
            return tabElement;
        });
    }

    private TextBoxElementFacade activityContentTextBoxElement() {
        return this.findTextBoxByXPathOrCSS(CKE_EDITOR_BODY);
    }

    private ElementFacade activityLinkPreviewElement() {
        return this.findByXPathOrCSS("[data-widget='embedSemantic']");
    }

    private ElementFacade activityTitleElement() {
        return this.findByXPathOrCSS("//div[contains(@class,'contentBox')]//*[contains(@class,'postContent ')]//div");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplyEditorContent(String reply) {
        ElementFacade ckEditorFrameCommentElement = this.ckEditorFrameReplyElement();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameCommentElement);
        try {
            TextBoxElementFacade ckEditorBodyCommentElement = this.ckEditorBodyCommentElement();
            ckEditorBodyCommentElement.waitUntilVisible();
            ckEditorBodyCommentElement.setTextValue(reply);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.replyButtonInDrawerElement().click();
    }

    private ElementFacade applyDownloadButtonElement() {
        return this.findByXPathOrCSS("//div[contains(@class,'attachmentsFooter')]//a");
    }

    private ElementFacade buttonCreatePollElement() {
        return this.findByXPathOrCSS("//*[@id='createPollDrawer']//*[contains(@class, 'drawerFooter')]//button[contains(@class, 'primary')]");
    }

    private ElementFacade cancelBtnElement() {
        return this.findByXPathOrCSS("//button[@class='btn ms-2 v-btn v-btn--contained theme--light v-size--default']");
    }

    private ElementFacade cancelDeleteCommentBtnElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__actions']//button[2]");
    }

    private TextBoxElementFacade choiceOnePollElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='createPollDrawer']//*[contains(@class, 'custom-poll-textarea')]//textarea)[2]");
    }

    private TextBoxElementFacade choiceThreePollElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='createPollDrawer']//*[contains(@class, 'custom-poll-textarea')]//textarea)[4]");
    }

    private TextBoxElementFacade choiceTwoPollElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='createPollDrawer']//*[contains(@class, 'custom-poll-textarea')]//textarea)[3]");
    }

    private TextBoxElementFacade ckEditorBodyCommentElement() {
        return this.findTextBoxByXPathOrCSS(CKE_EDITOR_BODY);
    }

    private ElementFacade ckEditorFrameCommentElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private ElementFacade ckEditorFrameReplyElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activity-comment')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private ElementFacade ckEditorFrameElement() {
        return this.findByXPathOrCSS("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private void clickOnReplyToComment(String comment, String activity) {
        this.checkCommentDrawerOpened(activity);
        this.getCommentReply(comment).click();
        this.waitForDrawerToOpen();
    }

    private ElementFacade addCommentButtonInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class,'drawerIcons')]//button)[1]");
    }

    private ElementFacade closeCommentsDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//button[contains(@class, 'close') or contains(@title, 'Close')]");
    }

    private ElementFacade saveCommentButtonInDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class,'drawerContent')]//button//*[contains(text(),'Comment') or contains(text(),'Update')]");
    }

    private TextBoxElementFacade commentFieldElement() {
        return this.findTextBoxByXPathOrCSS(CKE_EDITOR_BODY);
    }

    private ElementFacade commentsDrawerFirstPageBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-pagination__item')])[1]");
    }

    private ElementFacade commentsDrawerSecondPageBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-pagination__item')])[2]");
    }

    private ElementFacade commentKudosTitleElement() {
        return this.findByXPathOrCSS("//*[contains(@id,'activity-comment-detail')]//*[contains(@id,'Extactivity-content-extensions')]//*[contains(@class,'rich-editor-content')]//div");
    }

    private ElementFacade createPollLinkElement() {
        return this.findByXPathOrCSS("//*[contains(@id,'activityComposerDrawer')]//*[contains(@id,'createPollComposerButton')]");
    }

    private ElementFacade sendKudosLinkElement() {
        return this.findByXPathOrCSS("//*[contains(@id,'activityComposerDrawer')]//*[contains(@id,'sendKudosComposerButton')]");
    }

    private ElementFacade dotsMenuElement() {
        return this.findByXPathOrCSS("//i[@class='v-icon notranslate primary--text mdi mdi-dots-vertical theme--light']");
    }

    private ElementFacade editButtonElement() {
        return this.findByXPathOrCSS("(//*[@class='v-list-item v-list-item--dense v-list-item--link theme--light']//*[@class='v-list-item__title pl-3'])[1]");
    }

    private ElementFacade eighthCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[8]");
    }

    private ElementFacade fifthCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[5]");
    }

    private ElementFacade filterByMyConnectionsElement() {
        return this.findByXPathOrCSS("//*[@id = 'applicationToolbarFilterSelect']");
    }

    private ElementFacade firstASDisplayedCommentElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'activity-comment-detail')]//*[contains(@id,'Extactivity-content-extensions')]//p//div)[1]");
    }

    private ElementFacade firstCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[1]");
    }

    private ElementFacade fourthCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//div)[4]");
    }

    private ElementFacade getActivityCommentButton(String activity) {
        return this.getActivityFooterButton(activity, COMMENT_LINK);
    }

    private ElementFacade getActivityFooterButton(String activity, String buttonIdPart) {
        return this.findByXPathOrCSS(String.format("//div[contains(text(),'%s')]//ancestor::*[contains(@class, 'activity-detail')]//*[contains(@class, 'activity-footer-actions')]//button[contains(@id,'%s')]", activity, buttonIdPart));
    }

    private ElementFacade getCommentKudosFooterButton(String comment, String commentIdPart, String buttonIdPart) {
        return this.findByXPathOrCSS(String.format("//div[contains(text(),'%s')]//ancestor::*[contains(@id, '%s')]//button[contains(@id,'%s')]", comment, commentIdPart, buttonIdPart));
    }

    private ElementFacade getActivityLikeButton(String activity) {
        return this.getActivityFooterButton(activity, "LikeLink");
    }

    private ElementFacade getActivityNameUserSpace(String activity, String user, String space) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]/preceding::*[contains(@class,'accountTitleLabel')][1]//*[contains(@id,'userAvatar') and contains(@href,'%s')]/following::*[contains(@id,'spaceAvatar') and contains(text(),'%s')][1]/following::*[contains(@class,'caption text-light-color text-truncate d-flex activity-head-time')][1]", activity, user, space));
    }

    private ElementFacade getActivityStreamViewAllReplies(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id,'Extactivity-content-extensions')]//div[contains(text(),'%s')]/following::span[contains(text(),'replies')][1]", comment));
    }

    private ElementFacade getActivityText(String activity) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'activity-detail')]//descendant::*[contains(text(),'%s')]", activity));
    }

    private ElementFacade getBlackKudosCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor::*[contains(@id, 'ActivityCommment')])[1]/*[1]//button[contains(@id,'KudosActivity') and not(contains(@class,'primary--text'))]", activityComment));
    }

    private ElementFacade getBlueKudosCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor::*[contains(@id, 'ActivityCommment')])[1]/*[1]//button[contains(@id,'KudosActivity') and contains(@class,'primary--text')]", activityComment));
    }

    private ElementFacade getBlueLikeCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'activity-detail')]//div[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-list-item')]//button[contains(@id,'LikeLinkcomment') and contains(@class,'primary--text')]", activityComment));
    }

    private ElementFacade goToSpaceRightTabsElement() {
        return this.findByXPathOrCSS("//*[@id = 'topBarMenu']//*[contains(@class,'chevron-right')]");
    }

    private ElementFacade goToSpaceLeftTabsElement() {
        return this.findByXPathOrCSS("//*[@id = 'topBarMenu']//*[contains(@class,'chevron-left')]");
    }

    private ElementFacade getCommentDrawerButton(String comment, String buttonIdPart) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'v-list-item')]//*[contains(@id, 'Extactivity-comment-footer-action')]//button[contains(@id,'%s')]", comment, buttonIdPart));
    }

    private ElementFacade getCommentLikesNumber(String comment) {
        return this.findByXPathOrCSS(String.format("(//div[contains(text(),'%s')]//following::button[contains(@id,'LikersListLinkcomment')])[1]//span", comment));
    }

    private ElementFacade getCommentLikesNumberCommentsDrawer(String comment) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'drawerContent')]//div[contains(text(),'%s')]//following::button[contains(@id,'LikersListLinkcomment')])[1]//span", comment));
    }

    private ElementFacade getCommentReply(String comment) {
        return this.getCommentDrawerButton(comment, COMMENT_LINK);
    }

    private ElementFacade getCommentsDrawerBlueLikeCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'drawerContent')]//div[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-list-item')]//button[contains(@id,'LikeLinkcomment') and contains(@class,'primary--text')]", activityComment));
    }

    private ElementFacade getCommentsDrawerLikeCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'drawerContent')]//div[contains(text(),'%s')]//following::button[contains(@id,'LikeLinkcomment')])[1]", activityComment));
    }

    private ElementFacade getCommentsDrawerViewAllReplies(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'drawerHeader')]/following::*[contains(@id,'Extactivity-content-extensions')]//div[contains(text(),'%s')]/following::span[contains(text(),'View all')][1]", comment));
    }

    private ElementFacade getCommentElementInDrawer(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment')]", comment));
    }

    private ElementFacade getCommentTitleActivityStream(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id,'activity-comment-detail')]//*[contains(@id,'Extactivity-content-extensions')]//a[contains(text(),'%s')]", comment));
    }

    private ElementFacade getCommentElement(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment')]", comment));
    }

    private ElementFacade getConfirmButton(String buttonName) {
        return this.findByXPathOrCSS(String.format("//a[contains(text(),'%s')]", buttonName));
    }

    private ElementFacade getCopyLinkActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'contentBox')]//*[contains(text(),'%s')]//preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Copy link')]", activity));
    }

    private ElementFacade getDeleteActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'contentBox')]//*[contains(text(),'%s')]//preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Delete')]", activity));
    }

    private ElementFacade getDeleteCommentLabel(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]/preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Delete')]", comment));
    }

    private ElementFacade getCommentMenuButton(String buttonName, String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment')]//*[@role='menuitem']//*[contains(text(), '%s')]", comment, buttonName));
    }

    private ElementFacade getDeleteReplyLabel(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]/preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Delete')]", comment));
    }

    private ElementFacade getDownloadActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'contentBox')]//*[contains(text(),'%s')]//preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Download')]", activity));
    }

    private ElementFacade getDrawerCommentName(String comment) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'drawerHeader')]/following::*[contains(@id,'Extactivity-content-extensions')]/p/div[contains(text(),'%s')])[1]", comment));
    }

    private ElementFacade getDrawerCommentsNumberAndNames(String commentsNumber, String comment) {
        return this.findByXPathOrCSS(String.format("//*[@class='text-capitalize-first-letter' and contains(text(),'%s')]/following::*[contains(@class,'activity-comment-detail')]//*[contains(text(),'%s')]", commentsNumber, comment));
    }

    private ElementFacade getDrawerReplyName(String reply) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'drawerHeader')]/following::*[contains(@class,'rich-editor-content')]//following::*[contains(text(),'%s')])[1]", reply));
    }

    private ElementFacade getDropDownActivityMenu(String activity) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor::div[contains(@class,'contentBox')]//*[contains(@class, 'activity-head')]//*[contains(@class,'fa-ellipsis-v')])[1]", activity));
    }

    private ElementFacade getDropDownCommentMenuFromCommentsDrawer(String comment, boolean reply) {
        return this.findByXPathOrCSS(String.format("(//*[@id='activityCommentsDrawer']//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'activity-comment ')])[%s]//button//*[contains(@class, 'dots') or contains(@class, 'ellipsis')]", comment, reply ? "2" : "1"));
    }

    private ElementFacade getEditActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::div[contains(@class,'contentBox')]//*[contains(@class, 'activity-head')]//*[contains(@class, 'v-menu')]//*[contains(@class,'fa-edit')]", activity));
    }

    private ElementFacade getEditCommentLabel(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]/preceding::*[@class='v-list-item__title pl-3' and contains(text(),'Edit')]", comment));
    }

    private ElementFacade getEditCommentLabelFromCommentsDrawer(String comment) {
        return this.findByXPathOrCSS(String.format("//*[@id='activityCommentsDrawer']//*[contains(@class,'activity-comment')]//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment') and contains(@id, 'ActivityCommment_')][1]//i[contains(@class,'fa-edit')]/..", comment));
    }

    private ElementFacade getLikeCommentIcon(String activityComment) {
        return this.findByXPathOrCSS(String.format("//div[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-list-item')]//button[contains(@id,'LikeLinkcomment')]", activityComment));
    }

    private ElementFacade getMentionedUserInCommentEntered(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='atwho-inserted']//*[contains(text(),'%s')]", user));
    }

    private ElementFacade getPinActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class,'contentBox')]//*[contains(@class, 'v-menu')]//*[contains(@class,'fa-thumbtack')]", activity));
    }

    private ElementFacade getPinnedActivity(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'pinnedActivity')]", activity));
    }

    private ElementFacade getAttachedImagesActivity(String activity) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor::*[contains(@class,'activity-detail')])[1]//*[contains(@class, 'attachments-image-item')]", activity));
    }

    private ElementFacade getSecondAttachedImageActivity(String activity) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(),'%s')]//ancestor::*[contains(@class,'activity-detail')])[1]//*[contains(@class, 'attachments-image-item')][2]", activity));
    }

    private ElementFacade getAttachedImagesKudosComment(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class,'activity-comment') and contains(@id,'ActivityCommment_comment')][1]//*[contains(@id,'Extcomment-content-extensions')]//*[contains(@class, 'attachments-image-item')][1]", comment));
    }

    private ElementFacade getPreviewAttachedImage() {
        return this.findByXPathOrCSS("//*[@id='previewCarousel-activity' and contains(@class, 'AttachmentCarouselPreview')]");
    }

    private ElementFacade getPreviewAttachedImageNextArrow() {
        return this.findByXPathOrCSS("//*[@id='previewCarousel-activity' and contains(@class, 'AttachmentCarouselPreview')]//*[contains(@class, 'v-window__next')]");
    }

    private ElementFacade getPreviewAttachedImagePrevArrow() {
        return this.findByXPathOrCSS("//*[@id='previewCarousel-activity' and contains(@class, 'AttachmentCarouselPreview')]//*[contains(@class, 'v-window__prev')]");
    }

    private ElementFacade previewAttachedImageCloseBtn() {
        return this.findByXPathOrCSS("//*[contains(@class,'preview-attachment-action')]//button[@id='preview-attachment-close']");
    }

    private ElementFacade deleteAttachmentBtn() {
        return this.findByXPathOrCSS("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activityRichEditor')]//*[contains(@class, 'carousel-top-parent')]//*[contains(@class, 'v-card__actions')]//button[2]");
    }

    private ElementFacade editAttachmentBtn() {
        return this.findByXPathOrCSS("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activityRichEditor')]//*[contains(@class, 'carousel-top-parent')]//*[contains(@class, 'v-card__actions')]//button[1]");
    }

    private ElementFacade getAttachedImageCropDrawer() {
        return this.findByXPathOrCSS("//*[@id = 'cropperDrawer' and contains(@class, 'v-navigation-drawer--open')]");
    }

    private ElementFacade getAttachedImageCropDrawerBlurredZone() {
        return this.findByXPathOrCSS("//*[@id = 'cropperDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'filter-blur-3')]");
    }

    private ElementFacade getAttachedImageCropDrawerZoomBtn() {
        return this.findByXPathOrCSS("//*[@id = 'cropperDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[@id = 'zoomImageIn']");
    }

    private ElementFacade getAttachedImageCropDrawerCancekBtn() {
        return this.findByXPathOrCSS("//*[@id = 'cropperDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[@id = 'cancelChanges']");
    }

    private ElementFacade getAttachedImageCropDrawerUpdateBtn() {
        return this.findByXPathOrCSS("//*[@id = 'cropperDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[@id = 'imageCropDrawerApply']");
    }

    private ElementFacade getActivityAttachedImage() {
        return this.findByXPathOrCSS("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activityRichEditor')]//*[contains(@class, 'carousel-top-parent')]");
    }

    private ElementFacade getActivityAttachedImageWithDeleteIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activityRichEditor')]//*[contains(@class, 'carousel-top-parent')]//button[contains(@class, 'v-btn')]//*[contains(@class, 'fa-trash')]", activity));
    }

    private ElementFacade getActivityAttachedImageWithEditIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'activityComposerDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activityRichEditor')]//*[contains(@class, 'carousel-top-parent')]//button[contains(@class, 'v-btn')]//*[contains(@class, 'fa-edit')]", activity));
    }

    private ElementFacade getReactionActivityLink(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'activity-detail')]//*[contains(@class,'seeMoreLikers')]", activity));
    }

    private ElementFacade getReceivedKudosNumberInDrawer(String kudosNumber) {
        return this.findByXPathOrCSS(String.format("//div[@class='v-slide-group__wrapper']//a[@href='#kudos']//span[contains(.,'%s')]", kudosNumber));
    }

    private ElementFacade getReplyBox(String comment, String reply) {
        return this.findByXPathOrCSS(String.format("//*[@id='activityCommentsDrawer']//*[contains(@class,'activity-comment')]//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment') and contains(@id, 'ActivityCommment_')]//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class,'activity-comment') and contains(@id, 'ActivityCommment_')][1]", comment, reply));
    }

    private ElementFacade getSharedVideoPreview(String link) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id,'Extactivity-content-extensions')]//following::*[@src]//following::*[@href='%s']//*[contains(@class,'font-weight-bold')]", link));
    }

    private ElementFacade getUnpinActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class,'contentBox')]//*[contains(@class, 'v-menu')]//*[contains(@class,'fa-thumbtack')]", activity));
    }

    private ElementFacade getUserElementFromReactionsDrawer(String userLastName) {
        return this.findByXPathOrCSS(String.format("//*[@class='likers-list']//*[contains(text(),'%s')]", userLastName));
    }

    private ElementFacade getUserMentionedInPost(String activity, String user) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id,'Extactivity-content')]//*[contains(text(),'%s')]//*[contains(text(),'%s')]", activity, user));
    }

    private ElementFacade getUserPopover(String user) {
        return this.findByXPathOrCSS(String.format("//*[@id='profileName']//*[contains(text(),'%s')]", user));
    }

    private ElementFacade getUserProfileButton(String fullName) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]/ancestor::a[contains(@class,'socialUserCard')]", fullName));
    }

    private ElementFacade kudosButtonFromCommentsDrawerToCommentActivityElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer']//*[contains(@id,'KudosActivity') and not(@disabled='disabled')]");
    }

    private ElementFacade kudosButtonNumberFromCommentsDrawerToCommentActivityElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-footer-comment-action')]//div[@class='d-inline-flex']//button[contains(@class,'primary--text font-weight')][1]");
    }

    private ElementFacade kudosButtonNumberToCommentActivityElement() {
        return this.findByXPathOrCSS("(//button[contains(@id,'KudusCountLinkcomment') and @style=''])[1]");
    }

    private ElementFacade loadMoreActivitiesBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-btn--block v-btn--contained theme--light')]//span");
    }

    private ElementFacade menuBtnElement() {
        return this.findByXPathOrCSS("//a[@class='HamburgerNavigationMenuLink']");
    }

    private ElementFacade newActivityButtonElement() {
        return this.findByXPathOrCSS(".newActivitiesButton");
    }

    private ElementFacade newActivityButtonInArabicLanguageElement() {
        return this.findByXPathOrCSS("//button[contains(@class,'primary btn no-box-shadow ms-auto v-btn v-btn--contained')]");
    }

    private ElementFacade ninthCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[9]");
    }

    private ElementFacade peopleBtnElement() {
        return this.findByXPathOrCSS("//a[@class='v-list-item v-list-item--link theme--light UserPageLink']");
    }

    private ElementFacade publishActivityButtonElement() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open .drawerFooter button#activityComposerPostButton");
    }

    private ElementFacade replyButtonInDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activity-comment')]//button//span[contains(text(),'Comment')]");
    }

    private ElementFacade secondASDisplayedCommentElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'activity-comment-detail')]//*[contains(@id,'Extactivity-content-extensions')]//div)[2]");
    }

    private ElementFacade secondCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//div)[2]");
    }

    private ElementFacade seventhCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[7]");
    }

    private ElementFacade sixthPositionInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//div)[6]");
    }

    private ElementFacade tabLinkElement(String tabName) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'topBarMenu']//*[contains(text(),'%s')]//ancestor-or-self::a", tabName));
    }

    private ElementFacade tabElement(String tabName) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'topBarMenu']//*[contains(text(),'%s')]", tabName));
    }

    private ElementFacade tabSubNavigationElement(String name) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'menuable__content__active')]//*[contains(text(), '%s')]//ancestor::a", name));
    }

    private ElementFacade selectedTabElement() {
        return this.findByXPathOrCSS("//*[@id = 'topBarMenu']//a[contains(@class, 'v-tab--active')]");
    }

    private ElementFacade selectedTabElement(String tabName) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'topBarMenu']//*[contains(text(),'%s')]//ancestor-or-self::a[contains(@class, 'v-tab--active')]", tabName));
    }

    private ElementFacade tenthCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//p//div)[10]");
    }

    private ElementFacade thirdCommentInDrawerElement() {
        return this.findByXPathOrCSS("(//*[@id='activityCommentsDrawer']//*[contains(@id,'Extactivity-content-extensions')]//div)[3]");
    }

    private TextBoxElementFacade titlePollElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='createPollDrawer']//*[contains(@class, 'custom-poll-textarea')]//textarea)[1]");
    }

    private ElementFacade updateActivityButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//button[@aria-label='Update']");
    }

    private ElementFacade updateButonElement() {
        return this.findByXPathOrCSS("//button[@class='btn btn-primary ms-10 v-btn v-btn--contained theme--light v-size--default primary']");
    }

    private ElementFacade updateButtonInDrawerElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'Update')]");
    }

    private ElementFacade viewallXcommentsElement() {
        return this.findByXPathOrCSS("//button[contains(@class,'primary--text font-weight-bold mb-1')]");
    }

    private void waitOnCommentRichText() {
        this.waitCKEditorLoading("//*[@id = 'activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]");
    }

    private void waitOnReplyRichText() {
        this.waitCKEditorLoading("//*[@id = 'activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'activity-comment')]");
    }

    private ElementFacade filterIcon() {
        return this.findByXPathOrCSS(".activityComposer .v-btn--icon .fa-sliders-h");
    }

    private void checkCommentDrawerOpened(String activity) {
        Utils.retryOnCondition(() -> {
            if (!this.isCommentsDrawerOpened()) {
                this.closeAllDrawers();
                this.waitForDrawerToClose();
                this.openCommentsDrawer(activity);
            }
            this.commentsDrawerElement().checkVisible();
        });
    }

    private boolean isCommentsDrawerOpened() {
        return this.commentsDrawerElement().isCurrentlyVisible();
    }

    private ElementFacade commentsDrawerElement() {
        return this.findByXPathOrCSS("//*[@id = 'activityCommentsDrawer' and contains(@class, 'v-navigation-drawer--open')]");
    }
}

