/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class TasksPage
extends GenericPage {
    private static final String OPENED_TASK_COMMENTS_DRAWER_SELECTOR = "//*[@id = 'taskCommentDrawer' and contains(@class, 'v-navigation-drawer--open')]";
    private static final String OPENED_TASK__DRAWER_SELECTOR = "//*[@id = 'task-Drawer' and contains(@class, 'v-navigation-drawer--open')]";

    public TasksPage(WebDriver driver) {
        super(driver);
    }

    public void addFourLabelToProject(String label1, String label2, String label3, String label4) {
        this.labelTaskElement().sendKeys(new CharSequence[]{label1 + String.valueOf(Keys.ENTER) + label2 + String.valueOf(Keys.ENTER) + label3 + String.valueOf(Keys.ENTER) + label4 + String.valueOf(Keys.ENTER)});
    }

    public void addLabel(String label) {
        TextBoxElementFacade labelTaskElement = this.labelTaskElement();
        labelTaskElement.waitUntilVisible();
        labelTaskElement.setTextValue(label);
        labelTaskElement.sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public void addLabelToTask(String label) {
        Utils.retryOnCondition(() -> {
            this.labelTaskElement().click();
            this.getAddLabelToTask(label).click();
        });
    }

    public void clickToAddNewCommentInTask() {
        this.addNewCommentInTaskElement().click();
    }

    public void addNewCommentInTaskWithMentioningTheFirstUserInTask(String comment, String user) {
        this.mentionUserInCKEditor(this.ckEditorFrameTaskMentioningUserElement(), this.taskCommentContentTextBoxElement(), comment, user, true);
        this.commentTaskButtonElement().click();
        this.closeDrawerIfDisplayed();
    }

    public void addOtherCommentInTask() {
        this.addOtherCommentInTaskElement().click();
    }

    public void addProject(String projectName) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectManagerInput(String manager) {
        this.addManagerBtnElement().click();
        this.mentionInField(this.inviteProjectManagerInputElement(), manager, 5);
    }

    public void addProjectParticipantInput(String participant) {
        this.addParticipantBtnElement().click();
        this.mentionInField(this.inviteProjectParticipantInputElement(), participant, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectWithDescription(String projectName, String description) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade projectDescriptionFieldElement = this.projectDescriptionFieldElement();
            projectDescriptionFieldElement.waitUntilVisible();
            projectDescriptionFieldElement.setTextValue(description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectWithFirstCreatedUserAsManger(String projectName, String fullName) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.addProjectManagerInput(fullName);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectWithFirstUserAsParticipant(String projectName, String participant) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.addProjectParticipantInput(participant);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectWithManager(String projectName, String fullName) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.addManagerBtnElement().click();
        this.mentionInField(this.inviteProjectManagerInputElement(), fullName, 5);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectWithManagerAndParticipant(String projectName, String manager, String participant) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.addProjectManagerInput(manager);
        this.addProjectParticipantInput(participant);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addProjectWithParticipant(String projectName, String lastName) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.addProjectParticipantInput(lastName);
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void addSecondUserToProject(String lastName) {
        this.addProjectParticipantInput(lastName);
    }

    public void addSixLabelToProject(String label1, String label2, String label3, String label4, String label5, String label6) {
        this.labelTaskElement().sendKeys(new CharSequence[]{label1 + String.valueOf(Keys.ENTER) + label2 + String.valueOf(Keys.ENTER) + label3 + String.valueOf(Keys.ENTER) + label4 + String.valueOf(Keys.ENTER) + label5 + String.valueOf(Keys.ENTER) + label6 + String.valueOf(Keys.ENTER)});
    }

    public void assignTaskToMe() {
        this.taskAssignLinkElement().assertVisible();
        this.taskAssignLinkElement().click();
        this.taskAssignMeElement().click();
    }

    public void assignTaskToUser(String user) {
        this.taskAssignLinkElement().assertVisible();
        this.taskAssignLinkElement().click();
        this.mentionInField(this.taskAssignUserInputElement(), user, 5);
    }

    public void boardViewIsDisplayedByDefault() {
        this.projectActiveBoardViewElement().assertVisible();
    }

    public void cancelFilterButtonIsDisplayed() {
        this.cancelFilterButtonElement().assertVisible();
    }

    public void checkAttachmentDisplay(String attachmentName) {
        this.getAttachmentName(attachmentName).assertNotVisible();
    }

    public void checkClonedProject(String projectName) {
        this.getProjectCard(projectName).assertVisible();
        this.checkSuccessMessageDisplayed();
    }

    public void checkClonedTask(String taskName) {
        this.getTaskTitle(taskName).assertVisible();
    }

    public void checkDeletedProject(String projectName) {
        this.getProjectCard(projectName).assertNotVisible();
        this.checkSuccessMessageDisplayed();
    }

    public void checkDeletedStatus(String statusColumn) {
        this.getStatusColumn(statusColumn).assertNotVisible();
    }

    public void checkDeletedTaskIsNotDisplayed(String taskName) {
        this.getTaskName(taskName).assertNotVisible();
    }

    public void checkDescriptionDisplay(String description) {
        this.getDescriptionForTask(description).assertVisible();
    }

    public void checkDisplayOfFilterByProject() {
        this.filterByProjectElement().assertVisible();
    }

    public void checkDisplayOfFilterByTask() {
        this.filterByTaskElement().assertVisible();
    }

    public void checkFirstStatusColumn(String columnStatus) {
        Assertions.assertEquals((Object)this.firstStatusColumnElement().getText(), (Object)columnStatus);
    }

    public void checkGroupingSelected(String groupingValue) {
        Assert.assertTrue((boolean)this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//input[@aria-checked='true' and @value='%s']//ancestor::*[contains(@class, 'v-radio')]", groupingValue)).isVisible());
    }

    public void checkLastStatusColumn(String columnStatus) {
        Assert.assertEquals((Object)this.lastStatusColumnElement().getText(), (Object)columnStatus);
    }

    public void checkMessageEmptyProjectDisplay() {
        Assertions.assertEquals((Object)this.projectTitleElement().getText(), (Object)"");
    }

    public void checkMoveStatusAfterIconIsNotDisplayed() {
        this.moveStatusAfterIconElement().assertNotVisible();
    }

    public void checkMoveStatusBeforeIconIsNotDisplayed() {
        this.moveStatusBeforeIconElement().assertNotVisible();
    }

    public void checkProject(String projectName) {
        this.getProjectCard(projectName).assertVisible();
        this.checkSuccessMessageDisplayed();
    }

    public void checkProjectNameIsDisplayedInProjectCard(String projectName, String description) {
        this.getProjectCard(projectName).assertVisible();
        this.getProjectCardDescription(description).assertVisible();
    }

    public void checkProjectNotDisplayed(String projectName) {
        this.getProjectCard(projectName).assertNotVisible();
        this.checkSuccessMessageDisplayed();
    }

    public void checkSecondStatusColumn(String columnStatus) {
        Assertions.assertEquals((Object)this.secondStatusColumnElement().getText(), (Object)columnStatus);
    }

    public void checkTaskPriority(String taskPriority) {
        this.getTaskPriority(taskPriority).assertVisible();
    }

    public void checkTaskStatus(String taskStatus) {
        this.getTaskStatus(taskStatus).assertVisible();
    }

    public void checkThatSecondLevelDrawerChangesIsOpened() {
        this.checkChangesDrawerElement().assertVisible();
    }

    public void checkThatTasksAreGroupedByAssignee() {
        this.textAssigneeElement().assertVisible();
    }

    public void checkTheTimestampUpdate() {
        String timestampText = this.timesTampElement().getText();
        Assert.assertTrue((boolean)timestampText.contains("Last Update"));
    }

    public void checkThirdStatusColumn(String columnStatus) {
        Assert.assertEquals((Object)this.thirdStatusColumnElement().getText(), (Object)columnStatus);
    }

    public void checkTooltipIsDisplayed() {
        String toolText = this.toolTipElement().getAttribute("title");
        Assertions.assertEquals((Object)"Click to view all changes", (Object)toolText);
    }

    public void checkTypedProjectIsRemoved(String typedProject) {
        Assert.assertFalse((boolean)this.filterByProjectElement().getText().contains(typedProject));
    }

    public void checkTypedTaskIsRemoved(String typedTask) {
        Assert.assertFalse((boolean)this.filterByTaskElement().getText().contains(typedTask));
    }

    public void checkUpdatedDescription(String description) {
        this.clickOnTaskDescription();
        ElementFacade ckEditorFrameDescriptionElement = this.ckEditorFrameDescriptionElement();
        ckEditorFrameDescriptionElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameDescriptionElement);
        try {
            Assertions.assertEquals((Object)this.settaskDescriptionElement().getText(), (Object)description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void checkUpdatedProject(String projectName, String description) {
        this.getProjectCard(projectName).assertVisible();
        this.getProjectCardDescription(description).assertVisible();
        this.checkSuccessMessageDisplayed();
    }

    public void checkViewLinkAttachments() {
        this.viewAttachmentsLinkElement().assertVisible();
    }

    public void clearButtonInFilterByTaskIsNotVisible() {
        this.clearButtonInFilterByTaskElement().assertNotVisible();
    }

    public void clearButtonInFilterByTaskIsVisible() {
        this.clearButtonInFilterByTaskElement().assertVisible();
    }

    public void clearButtonIsNotVisible() {
        this.clearButtonInFilterByProjectElement().assertNotVisible();
    }

    public void clearButtonIsVisible() {
        this.clearButtonInFilterByProjectElement().assertVisible();
    }

    public void clickAddProjectButton() {
        this.addProjectOrTaskElement().click();
    }

    public void clickAddTaskButton() {
        this.addTaskInProjectButtonElement().click();
    }

    public void clickCancel() {
        this.clickToCancelDialog();
    }

    public void clickChangeLocation() {
        this.changeLocationLinkElement().click();
    }

    public void clickDelete() {
        this.deleteButtonElement().click();
    }

    public void clickDeleteProjectButton() {
        this.deleteProjectButtonElement().click();
    }

    public void clickDocButton() {
        this.documentButtonElement().click();
    }

    public void clickFilterButton() {
        this.filterButtonElement().click();
        this.waitForDrawerToOpen();
    }

    public void clickOnAddAttachmentLink() {
        this.addAttachmentLinkElement().click();
    }

    public void clickOnAddStatusAfterOptionOfTheFifthStatusColumn() {
        this.addStatusafteroptionElement().click();
    }

    public void clickOnAddStatusBeforeOption() {
        this.addStatusBeforeoptionElement().click();
    }

    public void clickOnAssigneeRadioButton() {
        this.assigneeRadioButtonElement().click();
    }

    public void clickOnClearButton() {
        this.clearButtonInFilterByProjectElement().click();
    }

    public void clickOnClearButtonInFilterByTask() {
        this.clearButtonInFilterByTaskElement().click();
    }

    public void clickOnCommentReply(String comment) {
        ElementFacade taskCommentReplyBtn = this.getTaskCommentReplyBtn(comment);
        taskCommentReplyBtn.assertVisible();
        taskCommentReplyBtn.click();
    }

    public void clickOnConfirmButton() {
        this.primaryButtonDrawerElement().click();
    }

    public void clickOnDeleteStatusIcon() {
        this.deleteStatusIconElement().click();
    }

    public void clickOnDeleteTaskOption() {
        this.deleteTaskOptionElement().click();
    }

    public void clickOnEditProjectButton() {
        this.editProjectButtonElement().click();
        this.waitForDrawerToOpen();
    }

    public void clickOnFifthColumnThreeDotsIcon() {
        this.fifthColumnThreeDotsIconElement().click();
    }

    public void clickOnLastColumnThreeDotsIcon() {
        this.lastColumnThreeDotsIconElement().click();
    }

    public void clickOnMoveStatusAfterIcon() {
        this.moveStatusAfterIconElement().click();
    }

    public void clickOnMoveStatusBeforeIcon() {
        this.moveStatusBeforeIconElement().click();
    }

    public void clickOnPlusButtonToAddTask() {
        this.plusButtonToAddTaskElement().click();
    }

    public void clickOnPlusButtonToAddTaskOfTheSixthStatusColumn() {
        this.plusButtonToAddTaskOfTheSixthStatusColumnElement().click();
    }

    public void clickOnProjectThreeDotsButton() {
        this.projectThreeDotsButtonElement().click();
        this.editProjectButtonElement().waitUntilVisible();
    }

    public void clickOnSaveButtonToAddTask() {
        this.saveButtonTaskElement().click();
    }

    public void clickOnApplyButtonToSaveDescription() {
        this.getApplyTaskDescriptionBtn().click();
    }

    public void attachImageToTaskDescription() {
        this.waitCKEditorLoading("//*[@id='task-Drawer']");
        this.attachImageToCKeditor();
    }

    public void addNewCommentWithAttachedImages(String comment) {
        this.waitCKEditorLoading(OPENED_TASK_COMMENTS_DRAWER_SELECTOR);
        this.attachImageToCKeditor();
        this.getDriver().switchTo().frame((WebElement)this.ckEditorFrameTaskElement());
        try {
            TextBoxElementFacade taskCommentContentTextBoxElement = this.taskCommentContentTextBoxElement();
            taskCommentContentTextBoxElement.waitUntilVisible();
            taskCommentContentTextBoxElement.setTextValue(comment);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        ElementFacade commentTaskButtonElement = this.commentTaskButtonElement();
        commentTaskButtonElement.waitUntilVisible();
        commentTaskButtonElement.click();
        commentTaskButtonElement.waitUntilNotVisible();
        this.waitForDrawerToLoad();
    }

    public void clickOutsideTaskDescription() {
        this.getTaskDrawerProject().click();
    }

    public void checkTaskDescriptionNewAttachImage() {
        this.getTaskDescriptionSecondeAttachImage().assertNotVisible();
    }

    public void checkAttachedImagesToTaskDescription() {
        this.getTaskDescriptionAttachedImage().assertVisible();
    }

    public void checkAttachedImagesToTaskComment() {
        this.getTaskCommentAttachedImage().assertVisible();
    }

    public void openTaskDescriptionEditor() {
        this.taskDescriptionTextFieldElement().click();
    }

    public void closeTaskCommentDrawer() {
        this.taskCommentDrawerCloseBtn().click();
    }

    public void clickOnSaveButtonToAddTaskSpaceProject() {
        this.saveButtonTaskSpaceProjectElement().click();
    }

    public void clickOnTaskThreeDotsOption() {
        this.taskThreeDotsOptionElement().click();
    }

    public void clickOnTheNotificationThatMentioneThirdUserInATaskInProject(String message, String projectName) {
        Utils.retryOnCondition(() -> this.notificationContentElement(projectName).checkVisible(), () -> this.waitFor(2).seconds(), 10L);
        this.notificationContentElement(message, projectName).assertVisible();
        this.notificationContentElement(message, projectName).click();
    }

    public void clickOnTheTimestamp() {
        this.timesTampElement().click();
    }

    public void clickOnThreeDotsIcon() {
        this.threeDotsIconElement().click();
    }

    public void clickOnUpDateButton() {
        this.updateButtonDescriptionElement().click();
    }

    public void clickOnValidateStatusName() {
        String currentStatusName = this.statusFieldElement().getValue();
        this.validateStatusNameElement().click();
        Utils.retryGetOnCondition(() -> this.getStatusColumn(currentStatusName).waitUntilVisible(), () -> this.waitFor(2).seconds());
    }

    public void clickPlusIcon() {
        this.plusIconElement().click();
    }

    public void clickPlusIconProject() {
        this.plusIconProjectElement().click();
    }

    public void clickQuickAddTaskButton() {
        this.quickAddTaskInProjectButtonElement().click();
    }

    public void clickSaveProjectButton() {
        this.primaryButtonDrawerElement().click();
        this.waitForDrawerToClose();
    }

    public void clickStatusName(String statusColumn) {
        this.getStatusColumn(statusColumn).click();
    }

    public void clickViewAttachmentLink() {
        this.viewAttachmentsLinkElement().assertVisible();
        this.viewAttachmentsLinkElement().click();
    }

    public void cloneProject(String projectName) {
        this.getProjectCard(projectName).assertVisible();
        this.projectThreeDotsButtonElement().click();
        this.cloneProjectButtonElement().click();
        this.clickToConfirmDialog();
    }

    public void cloneProjectButtonIsDisplayed() {
        this.cloneProjectButtonElement().assertVisible();
    }

    public void clonetaskinspaceproject() {
        this.taskThreeDotsOptionElement().click();
        this.cloneoptionElement().click();
    }

    public void colorPaletteIsDisplayed() {
        this.colorPaletteElement().assertVisible();
    }

    public void commentButtonIsDisabled() {
        this.commentTaskButtonElement().waitUntilDisabled();
    }

    public void commentsDrawerIsDisplayed() {
        this.commentsDrawerSectionElement().assertVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commentTask(String comment) {
        this.waitCKEditorLoading(OPENED_TASK_COMMENTS_DRAWER_SELECTOR);
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade taskCommentContentTextBoxElement = this.taskCommentContentTextBoxElement();
            taskCommentContentTextBoxElement.waitUntilVisible();
            taskCommentContentTextBoxElement.setTextValue(comment);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        ElementFacade commentTaskButtonElement = this.commentTaskButtonElement();
        commentTaskButtonElement.waitUntilVisible();
        commentTaskButtonElement.click();
        commentTaskButtonElement.waitUntilNotVisible();
        this.closeDrawerIfDisplayed();
    }

    public void commentTaskWithUser(String user, String comment) {
        this.getTaskCommentWithUser(user, comment);
    }

    public void completeTask() {
        this.markTaskCompletedElement().click();
    }

    public void confirmDeleteStatusColumn() {
        this.clickToConfirmDialog();
    }

    public void confirmDeleteTaskFromTasksBord() {
        this.clickToConfirmDialog();
    }

    public void confirmFilter() {
        this.primaryButtonDrawerElement().click();
    }

    public void confirmFilterButtonIsDisplayed() {
        this.primaryButtonDrawerElement().assertVisible();
    }

    public void deleteProject(String projectName) {
        this.getProjectCard(projectName).assertVisible();
        this.projectThreeDotsButtonElement().click();
        this.deleteProjectButtonElement().click();
        this.clickToConfirmDialog();
    }

    public void deleteProjectButtonIsDisplayed() {
        this.deleteProjectButtonElement().assertVisible();
    }

    public void deleteTaskOptionIsDisplayed() {
        this.deleteTaskOptionElement().assertVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editDescriptionForTask(String newDescription) {
        this.clickOnTaskDescription();
        this.waitCKEditorLoading(OPENED_TASK__DRAWER_SELECTOR);
        ElementFacade switchToFrameTaskUserElement = this.switchToFrameTaskUserElement();
        switchToFrameTaskUserElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)switchToFrameTaskUserElement);
        try {
            TextBoxElementFacade taskDescriptionBodyFieldElement = this.taskDescriptionBodyFieldElement();
            taskDescriptionBodyFieldElement.waitUntilVisible();
            taskDescriptionBodyFieldElement.setTextValue(newDescription);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.updateButtonDescriptionElement().click();
        Utils.waitForLoading();
    }

    public void editProjectButtonIsDisplayed() {
        this.editProjectButtonElement().assertVisible();
    }

    public void editProjectName(String projectName) {
        this.projectThreeDotsButtonElement().click();
        this.editProjectButtonElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.primaryButtonDrawerElement().click();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editProjectNameWithDescription(String projectName, String newProjectName, String newDescription) {
        this.getProjectCard(projectName).assertVisible();
        this.projectThreeDotsButtonElement().click();
        this.editProjectButtonElement().click();
        this.projectTitleElement().setTextValue(newProjectName);
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade projectDescriptionFieldElement = this.projectDescriptionFieldElement();
            projectDescriptionFieldElement.waitUntilVisible();
            projectDescriptionFieldElement.setTextValue(newDescription);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.primaryButtonDrawerElement().click();
    }

    public void editSpaceName(String spaceName) {
        this.spaceNameTitleElement().setTextValue(spaceName);
        this.updateNameSpaceButtonElement().click();
        Utils.waitForLoading();
        this.waitFor(200).milliseconds();
    }

    public void editTaskDrawerIsDisplayed() {
        this.editTaskDrawerSectionElement().assertVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterDescriptionForTask(String description) {
        this.clickOnTaskDescription();
        ElementFacade switchToFrameTaskElement = this.switchToFrameTaskElement();
        switchToFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)switchToFrameTaskElement);
        try {
            TextBoxElementFacade taskDescriptionBodyFieldElement = this.taskDescriptionBodyFieldElement();
            taskDescriptionBodyFieldElement.waitUntilVisible();
            taskDescriptionBodyFieldElement.setTextValue(description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterProjectDescriptionWithoutTheTitle(String description) {
        this.addProjectOrTaskElement().click();
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade projectDescriptionFieldElement = this.projectDescriptionFieldElement();
            projectDescriptionFieldElement.waitUntilVisible();
            projectDescriptionFieldElement.setTextValue(description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterProjectTitleAndDescription(String projectName, String description) {
        this.addProjectOrTaskElement().click();
        this.projectTitleElement().setTextValue(projectName);
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade projectDescriptionFieldElement = this.projectDescriptionFieldElement();
            projectDescriptionFieldElement.waitUntilVisible();
            projectDescriptionFieldElement.setTextValue(description);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void enterStatusText(String status) {
        this.statusFieldElement().sendKeys(new CharSequence[]{status});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterTaskComment(String comment) {
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            TextBoxElementFacade taskCommentContentTextBoxElement = this.taskCommentContentTextBoxElement();
            taskCommentContentTextBoxElement.waitUntilVisible();
            taskCommentContentTextBoxElement.setTextValue(comment);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void enterTitleForTask(String title) {
        ElementFacade titleForTaskFieldElement = this.titleForTaskFieldElement();
        titleForTaskFieldElement.waitUntilVisible();
        titleForTaskFieldElement.sendKeys(new CharSequence[]{title});
    }

    public void exitFromTheFirstProject() {
        this.backButtonProjectElement().click();
    }

    public void goBack() {
        this.goBackIconElement().click();
    }

    public void goToFilterTab() {
        this.filterTabElement().click();
    }

    public void goToGroupAndSortTab() {
        this.groupAndSortTabElement().click();
    }

    public void goToLabelsTab() {
        this.labelsTabElement().click();
    }

    public void goToPLanView() {
        this.planViewElement().click();
    }

    public void goToProjectDetailsList() {
        this.projectDetailsListButtonElement().click();
    }

    public void goToProjectsTab() {
        this.goToTab(1);
    }

    public void goToTasksTab() {
        this.goToTab(2);
    }

    public void greenInformationIconIsDisplayed() {
        ElementFacade informationIconElement = this.informationIconElement();
        informationIconElement.assertVisible();
        Assert.assertEquals((Object)informationIconElement.getCssValue("color"), (Object)"rgba(46, 181, 140, 1)");
    }

    public void hoverOnProjectManagerIcon() {
        this.projectCardUserPopover().hover();
    }

    public void hoverOnTaskName(String task) {
        this.taskNameInProjectDetails(task).hover();
    }

    public void hoverOnTheChangesTimestamp() {
        Actions actions = new Actions(this.getDriver());
        actions.moveToElement((WebElement)this.timesTampElement()).perform();
    }

    public void isFilterDrawerTabDisplayed(String tab) {
        Assert.assertEquals((Object)this.activeTabFilterDrawerElement().getText(), (Object)tab);
    }

    public void isLabelDisplayedInProjectDetails(String label, String times) {
        this.getDisplayedLabel(label, times).assertVisible();
    }

    public void isSearchedTaskDisplayed(String taskName) {
        Assert.assertEquals((Object)this.taskNameElement().getValue(), (Object)taskName);
    }

    public boolean isStatusEditModeDisplayed(String statusColumn) {
        return this.getStatusColumn(statusColumn).isNotVisible();
    }

    public void labelIsDisplayedInProjectDrawer(String label) {
        this.getLabelInEditProjectDrawer(label).assertVisible();
    }

    public void labelIsDisplayedInTaskDrawer(String label) {
        this.getLabelInEditTaskDrawer(label).assertVisible();
        this.getRemoveLabelTaskButton(label).assertNotVisible();
    }

    public void labelIsNotDisplayedInProjectDrawer(String label) {
        this.getLabelInEditProjectDrawer(label).assertNotVisible();
    }

    public void markTaskAsCompletedFromTaskCard() {
        this.markTaskCompletedOnTaskCardElement().click();
    }

    public void markTaskAsCompletedInProjectDetails(String taskName) {
        this.getTaskToMarkAsCompleted(taskName).click();
    }

    public void maxCharsCount1250InformationIsDisplayed() {
        this.maxCharsCountInfoElement().assertVisible();
    }

    public void maxCharsNumberMessageIsDisplayed() {
        this.commentsDrawerSectionElement().click();
        this.waitCKEditorLoading();
        ElementFacade ckEditorFrameTaskElement = this.ckEditorFrameTaskElement();
        ckEditorFrameTaskElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameTaskElement);
        try {
            this.commentTaskMaxCharsMsgElement().assertVisible();
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void more1250CharsInformationIsDisplayed() {
        this.more1250CharsCountInfoElement().assertVisible();
        Assert.assertEquals((Object)this.more1250CharsCountInfoElement().getCssValue("color"), (Object)"rgba(188, 67, 67, 1)");
    }

    public void openFilterDrawer() {
        Utils.refreshPage();
        this.filterDrawerButtonElement().click();
    }

    public void openProject(String project) {
        this.getProjectCard(project).click();
        this.filterButtonElement().assertVisible();
    }

    public void openTaskCard(String task) {
        this.closeDrawerIfDisplayed();
        this.openTask(task).click();
        this.waitForDrawerToOpen();
    }

    public void openTaskDrawer(String taskName) {
        Utils.retryOnCondition(() -> {
            if (this.closeDrawerIfDisplayed()) {
                this.waitFor(200).milliseconds();
            }
            this.getTaskName(taskName).click();
            this.waitForDrawerToOpen(true);
        });
    }

    public void openTaskInTasksTab(String taskName) {
        this.getTaskTitleInTasksTab(taskName).click();
    }

    public void projectDrawerNotClosing() {
        Assert.assertTrue((boolean)this.findByXPathOrCSS(".v-navigation-drawer--open").isVisible());
    }

    public void projectIsDisplayedInTasksAppCenter(String projectName) {
        this.getProjectCard(projectName).assertVisible();
    }

    public void projectNameIsDisplayedInProjectDetails(String projectName) {
        this.projectNameInProjectDetails(projectName).assertVisible();
    }

    public void redInformationIconIsDisplayed() {
        this.informationIconElement().assertVisible();
        Assert.assertEquals((Object)this.informationIconElement().getCssValue("color"), (Object)"rgba(188, 67, 67, 1)");
    }

    public void removeLabelToProject(String label) {
        Utils.retryGetOnCondition(() -> this.findByXPathOrCSS(".projectLabelsName .v-chip").waitUntilVisible());
        this.getRemoveLabelButton(label).click();
    }

    public void replyTaskCommentButtonIsDisabled() {
        this.replyTaskCommentButtonElement().waitUntilDisabled();
    }

    public void resetFilterButtonIsDisplayed() {
        this.resetFilterButtonElement().assertVisible();
    }

    public void returnToProjectsTab() {
        this.arrowBackButtonElement().click();
    }

    public void saveAddingProject() {
        this.primaryButtonDrawerElement().click();
    }

    public void saveAddTaskButton() {
        this.primaryButtonDrawerElement().click();
    }

    public void saveQuickTask() {
        this.taskQuickNameFieldElement().sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public void searchTask(String taskName) {
        this.searchTaskNameElement().sendKeys(new CharSequence[]{taskName});
    }

    public void selectFilterOption(String label) {
        this.getFilterOption(label).click();
    }

    public void setInSearchProjectField(String project) {
        this.searchProjectInputElement().setTextValue(project);
        this.waitFor(1).seconds();
        Utils.waitForLoading();
    }

    public void setProjectTitle(String projectTitle) {
        this.projectTitleInputElement().setTextValue(projectTitle);
    }

    public void setQuickTaskName(String taskName) {
        this.taskQuickNameFieldElement().setTextValue(taskName);
    }

    public void setTaskCompletedInDrawer() {
        this.markTaskCompletedInDrawerElement().click();
        this.closeDrawerIfDisplayed();
    }

    public void setTaskCompletedInDrawerWithoutClosingIt() {
        this.markTaskCompletedInDrawerElement().click();
    }

    public void setTaskDescription(String description) {
        this.clickOnTaskDescription();
        ElementFacade ckEditorFrameDescriptionElement = this.ckEditorFrameDescriptionElement();
        ckEditorFrameDescriptionElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameDescriptionElement);
        try {
            this.settaskDescriptionElement().sendKeys(new CharSequence[]{description});
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void setTaskDueDateNextWeek() {
        this.taskDueDateElement().click();
        this.taskDueDateNextWeekElement().click();
    }

    public void setTaskDueDateToday() {
        this.taskDueDateElement().click();
        this.taskDueDateTodayElement().click();
    }

    public void setTaskDueDateTomorrow() {
        this.taskDueDateElement().click();
        this.taskDueDateTomorrowElement().click();
    }

    public void setTaskName(String taskName) {
        this.taskNameFieldElement().setTextValue(taskName);
    }

    public void setTaskPriority(String taskPriority) {
        this.taskPrioritySelectorElement().assertVisible();
        this.taskPrioritySelectorElement().click();
        this.selectTaskPriority(taskPriority).click();
    }

    public void setTaskStartDateToday() {
        this.taskStartDateElement().click();
        this.taskStartDateTodayElement().click();
    }

    public void setTaskStartDateTomorrow() {
        this.taskStartDateElement().click();
        this.taskStartDateTomorrowElement().click();
    }

    public void setTaskStatus(String taskStatus) {
        this.selectStatusSelectorElement().click();
        this.selectTaskStatus(taskStatus).click();
    }

    public void switchToTASKSTab() {
        this.backDrawerElement().click();
    }

    public void taskIsMarkedAndDisplayedInCompletedSection(String taskName) {
        Assert.assertEquals((Object)this.getCompletedTask(taskName).getText(), (Object)taskName);
    }

    public void taskIsNotMarkedAndDisplayedInUncompletedSection(String taskName) {
        Assert.assertEquals((Object)this.getUncompletedTask(taskName).getText(), (Object)taskName);
    }

    public void taskMarkedAsCompletedIsDisplayedInDrawer() {
        this.taskMarkedAsCompletedInDrawerElement().assertVisible();
    }

    public void taskNameAndLabelIsDisplayedInProjectDetails(String label, String taskName) {
        Assert.assertTrue((boolean)this.taskNameAndLabelAndNumberInProjectDetails(taskName).getText().contains(label));
    }

    public void taskNameIsDisplayedInDesiredColumn(String status, String taskName) {
        Assert.assertTrue((boolean)this.getTaskStatusColumn(status).getText().contains(taskName));
    }

    public void taskNameIsDisplayedInProjectDetails(String taskName) {
        ElementFacade taskElement = this.taskNameInProjectDetails(taskName);
        taskElement.assertVisible();
        Assert.assertEquals((Object)taskElement.getText(), (Object)taskName);
    }

    public void taskNameIsNotDisplayedInProjectDetails(String taskName) {
        ElementFacade taskElement = this.taskNameInProjectDetails(taskName);
        taskElement.assertNotVisible();
    }

    public void taskNamePLanView(String taskName) {
        this.getTaskNamePlanView(taskName).shouldBeVisible();
    }

    public void taskOrderInProjectDetails(String task, String number) {
        Assert.assertTrue((boolean)this.getTaskOrder(number).getTextContent().contains(task));
    }

    public void tasksNumberToDo(String tasksNumber) {
        this.getTasksNumberToDo(tasksNumber).assertVisible();
    }

    public void taskTooltipIsDisplayed(String task) {
        Assert.assertEquals((Object)this.taskTooltipElement().getText(), (Object)task);
    }

    public void updateTaskDescription(String description) {
        this.clickOnTaskDescription();
        ElementFacade ckEditorFrameDescriptionElement = this.ckEditorFrameDescriptionElement();
        ckEditorFrameDescriptionElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameDescriptionElement);
        try {
            this.settaskDescriptionElement().sendKeys(new CharSequence[]{" " + description});
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void countUserAvatarsInProjectCard(int count) {
        Assertions.assertEquals((int)count, (int)this.countProjectCardUserAvatars());
    }

    public void userAvatarIsDisplayedInProjectCard(String userName) {
        this.getProjectCardUserAvatar(userName).assertVisible();
    }

    public void userAvatarIsNotDisplayedInProjectCard(String userName) {
        this.getProjectCardUserAvatar(userName).assertNotVisible();
    }

    public void userFullNameIsDisplayedInProjectCard(String name) {
        Assert.assertEquals((Object)this.projectCardUserFullNameElement().getText(), (Object)name);
    }

    public void userFullNameIsNotDisplayedInProjectCard(String name) {
        Assert.assertNotEquals((Object)this.projectCardUserFullNameElement().getText(), (Object)name);
    }

    public void verifyViewLinkAttachments() {
        this.viewAttachmentsLinkElement().assertNotVisible();
    }

    public void viewAllCommentsTaskButton() {
        ElementFacade viewAllCommentsTaskButtonElement = this.viewAllCommentsTaskButtonElement();
        viewAllCommentsTaskButtonElement.waitUntilVisible();
        viewAllCommentsTaskButtonElement.click();
    }

    private void clickOnTaskDescription() {
        this.taskDescriptionFieldElement().click();
        this.waitFor(200).milliseconds();
    }

    public void clickFilterTasksButton() {
        this.filterTasksButton().click();
    }

    public void goToFilterType(String filterType) {
        this.getFilterType(filterType).click();
    }

    public void selectProjectFilterOption(String option) {
        this.getFilterProjectSelectBox().selectByVisibleText(option);
    }

    private ElementFacade getFilterProjectSelectBox() {
        return this.findByXPathOrCSS("//select[@name='projectFilter']");
    }

    private ElementFacade filterTasksButton() {
        return this.findByXPathOrCSS("#projectListApplication .tasksToolbar button.filterTasksSetting");
    }

    private ElementFacade getFilterType(String type) {
        return this.findByXPathOrCSS(String.format("//aside[contains(@class,'filterTasksDrawer')]//div[contains(@class,'taskFilter')]//div[contains(text(),'%s')]", type));
    }

    private ElementFacade activeTabFilterDrawerElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterTasksDrawer ')]//*[contains(@class,'v-tab--active') and @aria-selected='true']");
    }

    private ElementFacade addAttachmentLinkElement() {
        return this.findByXPathOrCSS("//div[@id='attachmentIntegration']//button[contains(@class,'v-btn v-btn--flat')]");
    }

    private TextBoxElementFacade addManagerBtnElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='editManager']//*[@class='editManager']//i[contains(@class,'uiIconProject')]");
    }

    private ElementFacade addNewCommentInTaskElement() {
        return this.findByXPathOrCSS("//*[@class='ViewAllCommentText']");
    }

    private ElementFacade addOtherCommentInTaskElement() {
        return this.findByXPathOrCSS("//button[contains(@class,'addCommentBtn')]");
    }

    private TextBoxElementFacade addParticipantBtnElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='editParticipant']//i[@class='fas fa-plus']");
    }

    private ElementFacade addProjectOrTaskElement() {
        return Utils.retryGetOnCondition(() -> Stream.of("//*[@id = 'projectBoardToolbar']//*[contains(@class, 'tasksToolbar')]//button[contains(@class, 'btn-primary')]", "//*[contains(@class, 'noTasksProject')]//*[contains(@class, 'btn btn-primary')][1]").map(this::findByXPathOrCSS).filter(ElementFacade::isCurrentlyVisible).findFirst().orElseThrow());
    }

    private ElementFacade addStatusafteroptionElement() {
        return this.findByXPathOrCSS("(//*[contains(@class,'uiIcon uiIconRotateRight')])[2]");
    }

    private ElementFacade addStatusBeforeoptionElement() {
        return this.findByXPathOrCSS("(//*[contains(@class,'uiIconRotateLeft')])[1]");
    }

    private ElementFacade addTaskInProjectButtonElement() {
        return Utils.retryGetOnCondition(() -> Stream.of("//*[contains(@class,'tasksToolbar')]//button//*[contains(text(), 'Add')]", ".tasksViewBoardRowContainer .tasksViewHeader .uiIconSocSimplePlus", "//*[contains(@class, 'noTasksProject')]//*[contains(@class, 'btn btn-primary')][1]").map(this::findByXPathOrCSS).filter(ElementFacade::isCurrentlyVisible).findFirst().orElseThrow());
    }

    private ElementFacade arrowBackButtonElement() {
        return this.findByXPathOrCSS("//*[@class='uiIcon uiBackIcon']");
    }

    private ElementFacade assigneeRadioButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-label theme--light'and text()='Assignee']");
    }

    private ElementFacade backButtonProjectElement() {
        return this.findByXPathOrCSS("//*[@class='uiIcon uiBackIcon']");
    }

    private ElementFacade backDrawerElement() {
        return this.findByXPathOrCSS("//*[@class='uiIcon uiArrowBAckIcon']");
    }

    private ElementFacade cancelFilterButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterSortTasksDrawer')]//following::*[contains(text(),'Cancel')][1]");
    }

    private ElementFacade changeLocationLinkElement() {
        return this.findByXPathOrCSS("//a[@title='Change location']");
    }

    private ElementFacade checkChangesDrawerElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerTitle')]//*[contains(text(), 'Changes')]");
    }

    private ElementFacade ckEditorFrameDescriptionElement() {
        return this.findByXPathOrCSS("//*[@class='cke_wysiwyg_frame cke_reset']");
    }

    private ElementFacade ckEditorFrameTaskElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private ElementFacade ckEditorFrameTaskMentioningUserElement() {
        return this.findByXPathOrCSS("//*[@id = 'taskCommentDrawer']//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private TextBoxElementFacade clearButtonInFilterByProjectElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='ProjectListToolbar']//button[contains(@class,' mdi-close theme')]");
    }

    private TextBoxElementFacade clearButtonInFilterByTaskElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='TasksListToolbar']//button[contains(@class,' mdi-close theme')]");
    }

    private ElementFacade cloneoptionElement() {
        return this.findByXPathOrCSS("//*[contains (@class, 'uiIconCloneNode')]");
    }

    private ElementFacade cloneProjectButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconCloneNode ')]");
    }

    private ElementFacade colorPaletteElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'projectColorPicker')]");
    }

    private ElementFacade commentsDrawerSectionElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-list-item__content drawerTitle')]//span[contains(text(),'Comments')]");
    }

    private ElementFacade commentTaskButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'newCommentEditor')]//button[contains(@class , 'commentBtn')]");
    }

    private TextBoxElementFacade commentTaskMaxCharsMsgElement() {
        return this.findTextBoxByXPathOrCSS(")]");
    }

    private ElementFacade primaryButtonDrawerElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerFooter')]//*[contains(@class, 'btn-primary')]");
    }

    private ElementFacade deleteButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__actions']//button[contains(@class,'btn btn-primary')]");
    }

    private ElementFacade deleteProjectButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconTrash ')]");
    }

    private ElementFacade deleteStatusIconElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconDelete')]");
    }

    private ElementFacade deleteTaskOptionElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconTrash ')]");
    }

    private ElementFacade documentButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class ,'flex document-timeline-header ')]//button[contains(@class,'v-btn v-btn--flat')]");
    }

    private ElementFacade editProjectButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'menuable__content__active ')]//*[contains(@class,'uiIconEdit ')]");
    }

    private ElementFacade editTaskDrawerSectionElement() {
        return this.findByXPathOrCSS("//*[@class='drawerTitleAndProject d-flex']//span[contains(text(),'Edit task')]");
    }

    private ElementFacade fifthColumnThreeDotsIconElement() {
        return this.findByXPathOrCSS("(//*[@class='d-flex tasksViewHeaderLeft']/following::*[contains(@class,'uiIconVerticalDots')][1])[5]");
    }

    private ElementFacade filterButtonElement() {
        return this.findByXPathOrCSS("//button[contains(@class,'filterTasksSetting v-btn')]");
    }

    private TextBoxElementFacade filterByProjectElement() {
        return this.findTextBoxByXPathOrCSS("//input[@placeholder='Filter by project']");
    }

    private TextBoxElementFacade filterByTaskElement() {
        return this.findTextBoxByXPathOrCSS("//input[@placeholder='Filter by task']");
    }

    private ElementFacade filterDrawerButtonElement() {
        return this.findByXPathOrCSS("//button[contains(@class,'filterTasksSetting')]//span[contains(@class,'d-sm-inline')]");
    }

    private ElementFacade filterTabElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterTasksDrawer ')]//*[contains(@class,'v-tab') and contains(text(),'Filter')]");
    }

    private ElementFacade firstStatusColumnElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'task-board')]//*[contains(@class,'statusName')])[1]");
    }

    private ElementFacade getAddLabelToTask(String label) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-list')]//*[contains(text(), '%s')]//ancestor::*[contains(@class,'v-chip')]", label));
    }

    private ElementFacade getAttachmentName(String attachmentName) {
        return this.findByXPathOrCSS(String.format("(//div[@class='v-list-item__content']//div[@title='%s'])[2]", attachmentName));
    }

    private ElementFacade getCompletedTask(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[@class='nameGroup' and text()='Completed']//following::*[@class='taskCardViewTitle text-color strikethrough']//span[@class='taskTitleEllipsis' and contains(text(),'%s')]", taskName));
    }

    private ElementFacade getDescriptionForTask(String description) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'taskDescription')]//*[contains(text(), '%s')]", description));
    }

    private ElementFacade getDisplayedLabel(String label, String times) {
        return this.findByXPathOrCSS(String.format("//*[@class='nameGroup' and contains(text(),'%s')]//following::*[@class='amount-item' and contains(text(),'%s')][1]", label, times));
    }

    private ElementFacade getFilterOption(String option) {
        return this.findByXPathOrCSS(String.format("//*[@class='v-label theme--light' and text()='%s']", option));
    }

    private ElementFacade getLabelInEditProjectDrawer(String label) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'projectLabelsName')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-chip')]", label));
    }

    private ElementFacade getLabelInEditTaskDrawer(String label) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-chip')]", label));
    }

    private ElementFacade getProjectCard(String projectName) {
        return this.findByXPathOrCSS(String.format("//span[contains(@class,'projectCardTitle') and contains(text(),'%s')]", projectName));
    }

    private ElementFacade getProjectCardDescription(String description) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'taskItemDescription')]//*[contains(text(),'%s')]", description));
    }

    private ElementFacade getProjectCardUserAvatar(String userName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@id,'userAvatar') and contains(@aria-label,'%s')]", userName));
    }

    private int countProjectCardUserAvatars() {
        return this.findAll("//*[contains(@class,'managerAvatarsList')]//button[contains(@id,'userAvatar')]", new Object[0]).size();
    }

    private ElementFacade getRemoveLabelButton(String label) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'projectLabelsName')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-chip')]//button[contains(text(), 'close')]", label));
    }

    private ElementFacade getRemoveLabelTaskButton(String label) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'v-chip')]//button", label));
    }

    private ElementFacade getStatusColumn(String statusColumn) {
        return this.findByXPathOrCSS(String.format("(//*[@class='d-flex tasksViewHeaderLeft']//*[contains(text(),'%s')][1])[1]", statusColumn));
    }

    private ElementFacade getTaskCommentReplyBtn(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'taskCommentDrawer')]//*[@class='taskContentComment']/p[contains(text(),'%s')]/following::button[@id='reply_btn'][1]", comment));
    }

    private ElementFacade getTaskCommentWithUser(String user, String comment) {
        return this.findByXPathOrCSS(String.format("//*[@class='TaskCommentContent']//*[contains(text(),'%s')]/following::*[@class='taskContentComment']//p[contains(text(),'%s')]", user, comment));
    }

    private ElementFacade getTaskName(String taskName) {
        ElementFacade taskInListView = this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-window-item--active')]//*[contains(@class, 'taskListItemView ')]/*[contains(@class, 'taskTitle ')]//*[contains(text(), '%s')]", taskName));
        if (taskInListView.isCurrentlyVisible()) {
            return taskInListView;
        }
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'v-window-item--active')]//*[contains(@class, 'taskViewCard ')]//*[contains(text(), '%s')]", taskName));
    }

    private ElementFacade getTaskNamePlanView(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[@class='bar-group']//*[contains(text(),'%s')]", taskName));
    }

    private ElementFacade getTaskOrder(String number) {
        return this.findByXPathOrCSS(String.format("(//*[@id='projectListApplication']//*[contains(@id,'taskView')]//*[contains(@class,'taskTitle')]//a)[%s]", number));
    }

    private ElementFacade getTaskPriority(String taskPriority) {
        return this.findByXPathOrCSS(String.format("//*[@class='taskPriority']//*[@class='v-select__selections']/div[contains(text(),'%s')]", taskPriority));
    }

    private ElementFacade getTasksNumberToDo(String tasksNumber) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'taskStatusName')]//*[@title='To Do']/following ::*[@class='uiTaskNumber' and text()='%s']", tasksNumber));
    }

    private ElementFacade getTaskStatus(String taskStatus) {
        return this.findByXPathOrCSS(String.format("//*[@class='taskStatus']//*[contains(@class,'v-select__selection--comma') and contains(text(),'%s')]", taskStatus));
    }

    private ElementFacade getTaskStatusColumn(String status) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'taskStatusName')]//*[@title='%s']/following::*[@class='taskTitleEllipsis'])[1]", status));
    }

    private ElementFacade getTaskTitle(String taskName) {
        return this.findByXPathOrCSS(String.format("//span[contains(@class,'taskTitleEllipsis') and contains(text(),'%s')]", taskName));
    }

    private ElementFacade getTaskTitleInTasksTab(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-application tasksList')]//*[contains(@class,'taskTitle pe-14')]/a[contains(text(),'%s')]", taskName));
    }

    private ElementFacade getTaskToMarkAsCompleted(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'taskCard')]//*[contains(@class, 'uiIconCircle')]", taskName));
    }

    private ElementFacade getUncompletedTask(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[@class='nameGroup' and text()='Uncompleted']//following::*[@class='taskCardViewTitle text-color']//span[@class='taskTitleEllipsis' and contains(text(),'%s')]", taskName));
    }

    private ElementFacade goBackIconElement() {
        return this.findByXPathOrCSS("//div[@class='drawerTitle']/button[@type='button']");
    }

    private void goToTab(int tabIndex) {
        ElementFacade tabLink = this.findByXPathOrCSS(String.format("//*[contains(@class, 'tasksMenuParent')]//*[@role='tab'][%s]", tabIndex));
        this.clickOnElement(tabLink);
        Utils.waitForLoading();
        this.waitFor(300).milliseconds();
    }

    private ElementFacade groupAndSortTabElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterTasksDrawer ')]//*[contains(@class,'v-tab') and contains(text(),'Group and Sort')]");
    }

    private ElementFacade informationIconElement() {
        return this.findByXPathOrCSS("//*[@class='uiIconMessageLength']");
    }

    private TextBoxElementFacade inviteProjectManagerInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='editManager']//input[@content-class='identitySuggesterContent']");
    }

    private TextBoxElementFacade inviteProjectParticipantInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='editParticipant']//input[@content-class='identitySuggesterContent']");
    }

    private ElementFacade labelsTabElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterTasksDrawer ')]//*[contains(@class,'v-tab') and contains(text(),'Labels')]");
    }

    private TextBoxElementFacade labelTaskElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='labelInput']");
    }

    private ElementFacade lastColumnThreeDotsIconElement() {
        return this.findByXPathOrCSS("(//*[@class='d-flex tasksViewHeaderLeft']/following::*[contains(@class,'uiIconVerticalDots')][1])[4]");
    }

    private ElementFacade lastStatusColumnElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'task-board')]//*[contains(@class,'statusName')])[4]");
    }

    private ElementFacade markTaskCompletedElement() {
        return this.findByXPathOrCSS("//*[@class='tasksListItem']//*[@class='taskCheckBox']");
    }

    private ElementFacade markTaskCompletedInDrawerElement() {
        return this.findByXPathOrCSS("//button[@id='check_btn']");
    }

    private ElementFacade markTaskCompletedOnTaskCardElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'taskViewCard')]//*[@class='taskCheckBox']");
    }

    private ElementFacade maxCharsCountInfoElement() {
        return this.findByXPathOrCSS("//*[@class='activityCharsCount' and contains(text(),'0 / 1250')]");
    }

    private ElementFacade more1250CharsCountInfoElement() {
        return this.findByXPathOrCSS("//*[@class='activityCharsCount tooManyChars']");
    }

    private ElementFacade moveStatusAfterIconElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconArrowRight ')]");
    }

    private ElementFacade moveStatusBeforeIconElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconArrowLeft ')]");
    }

    private ElementFacade openTask(String projectName) {
        return this.findByXPathOrCSS(String.format("//span[contains(@class,'taskTitleEllipsis') and contains(text(),'%s')]", projectName));
    }

    private ElementFacade planViewElement() {
        return this.findByXPathOrCSS("//a[@class='taskTabGantt v-tab']");
    }

    private ElementFacade plusButtonToAddTaskElement() {
        return this.findByXPathOrCSS("(//*[@title='Add Task'])[1]");
    }

    private ElementFacade plusButtonToAddTaskOfTheSixthStatusColumnElement() {
        return this.findByXPathOrCSS("(//*[@title='Add Task'])[6]");
    }

    private ElementFacade plusIconElement() {
        return this.findByXPathOrCSS("(//div[@class='pe-0 v-list-item theme--light']//button[@type='button'])[7]");
    }

    private ElementFacade plusIconProjectElement() {
        return this.findByXPathOrCSS("(//div[contains(@class,'v-list-item__action drawerIcons')]//button)[7]");
    }

    private ElementFacade projectActiveBoardViewElement() {
        return this.findByXPathOrCSS("//*[@class='taskTabBoard v-tab v-tab--active']");
    }

    private ElementFacade projectCardUserFullNameElement() {
        return this.findByXPathOrCSS("(//*[contains(@class,'profile-popover')]//a[contains(@id,'userAvatar')]/following::div[contains(@class,'ms-2')])[2]");
    }

    private ElementFacade projectCardUserPopover() {
        return this.findByXPathOrCSS("//*[contains(@class, 'spaceAdminContainer')]//*[contains(@class, 'profile-popover')]");
    }

    private TextBoxElementFacade projectDescriptionFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private ElementFacade projectDetailsListButtonElement() {
        return this.findByXPathOrCSS("//*[@class='uiIcon uiIconList']");
    }

    private ElementFacade projectNameInProjectDetails(String projectName) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor-or-self::*[contains(@class, 'projectTasksDashboard')]", projectName));
    }

    private ElementFacade projectThreeDotsButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'uiIconVerticalDots')]");
    }

    private TextBoxElementFacade projectTitleElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'projectInputTitle')]");
    }

    private TextBoxElementFacade projectTitleInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'addProjectTitle ')]//input");
    }

    private ElementFacade quickAddTaskInProjectButtonElement() {
        return this.findByXPathOrCSS("//button[contains(@class, 'quickAddNewTaskButton')]");
    }

    private ElementFacade replyTaskCommentButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'editorContent commentEditorContainer')]//button");
    }

    private ElementFacade resetFilterButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'filterSortTasksDrawer')]//following::*[contains(text(),'Reset')]");
    }

    private ElementFacade saveButtonTaskElement() {
        return this.findByXPathOrCSS("(//*[@class='d-flex']//button[2])[2]");
    }

    private ElementFacade getApplyTaskDescriptionBtn() {
        return this.findByXPathOrCSS("//*[contains(@class, 'taskDescription')]//*[@id = 'saveDescriptionButton']");
    }

    private ElementFacade getTaskDrawerProject() {
        return this.findByXPathOrCSS("//*[@id = 'task-Drawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerTitleAndProject')]//span");
    }

    private ElementFacade getTaskDescriptionSecondeAttachImage() {
        return this.findByXPathOrCSS("//*[@id = 'task-Drawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'attachments-image-item')][2]");
    }

    private ElementFacade getTaskDescriptionAttachedImage() {
        return this.findByXPathOrCSS("//*[(@id = 'taskDescriptionId')]//*[contains(@class, 'carousel-top-parent')]//*[contains(@class, 'attachments-image-item')][1]");
    }

    private ElementFacade getTaskCommentAttachedImage() {
        return this.findByXPathOrCSS("//*[@id = 'task-Drawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'commentItem')]//*[contains(@class, 'carousel-top-parent')]//*[contains(@class, 'attachments-image-item')][1]");
    }

    private ElementFacade saveButtonTaskSpaceProjectElement() {
        return this.findByXPathOrCSS("(//*[@class='d-flex']//button[2])");
    }

    private TextBoxElementFacade searchProjectInputElement() {
        return this.findTextBoxByXPathOrCSS("//div[@id='projectBoardToolbar']//input");
    }

    private ElementFacade searchTaskNameElement() {
        return this.findByXPathOrCSS("//*[@id='TasksListToolbar']//*[@class='v-text-field__slot']//input");
    }

    private ElementFacade secondStatusColumnElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'task-board')]//*[contains(@class,'statusName')])[2]");
    }

    private ElementFacade selectStatusSelectorElement() {
        return this.findByXPathOrCSS("//*[@role='button']//*[@class='v-input__icon v-input__icon--append']");
    }

    private ElementFacade selectTaskPriority(String taskPriority) {
        return this.findByXPathOrCSS(String.format("//*[@class='body-2' and contains(text(),'%s')]", taskPriority));
    }

    private ElementFacade selectTaskStatus(String taskStatus) {
        return this.findByXPathOrCSS(String.format("//*[@role='listbox']//*[@class='v-list-item__title' and contains(text(),'%s')]", taskStatus));
    }

    private TextBoxElementFacade settaskDescriptionElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'cke_editable cke_editabl')]");
    }

    private TextBoxElementFacade spaceNameTitleElement() {
        return this.findTextBoxByXPathOrCSS("//*[@name='name']");
    }

    private ElementFacade statusFieldElement() {
        return this.findByXPathOrCSS("//*[@placeholder='Enter a name for this status']");
    }

    private ElementFacade switchToFrameTaskElement() {
        return this.findByXPathOrCSS("(//iframe[contains(@class,'cke_wysiwyg_frame')])[2]");
    }

    private ElementFacade switchToFrameTaskUserElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')])");
    }

    private ElementFacade taskAssignLinkElement() {
        return this.findByXPathOrCSS("(//*[@class='taskAssignBtn mt-n1'])");
    }

    private ElementFacade taskAssignMeElement() {
        return this.findByXPathOrCSS("(//*[@class='ms-4'])[1]");
    }

    private TextBoxElementFacade taskAssignUserInputElement() {
        return this.findTextBoxByXPathOrCSS("(//div[@name='taskAssignee']//input)[1]");
    }

    private TextBoxElementFacade taskCommentContentTextBoxElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private TextBoxElementFacade taskDescriptionBodyFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private TextBoxElementFacade taskDescriptionFieldElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='taskDescriptionId']");
    }

    private TextBoxElementFacade taskDescriptionTextFieldElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='taskDescriptionId']//*[@contenteditable = 'true']");
    }

    private TextBoxElementFacade taskCommentDrawerCloseBtn() {
        return this.findTextBoxByXPathOrCSS("//*[@id = 'taskCommentDrawer' and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class , 'drawerHeader')]//button[contains(@class, 'mdi-close')]");
    }

    private TextBoxElementFacade taskDueDateElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@id,'DatePicker')])[2]//input");
    }

    private TextBoxElementFacade taskDueDateNextWeekElement() {
        return this.findTextBoxByXPathOrCSS("((//div[@class='v-picker__actions v-card__actions']//div[contains(@class,'d-flex flex-wrap')])[02]//button)[03]");
    }

    private TextBoxElementFacade taskDueDateTodayElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class,'v-date-picker-table__current')])[2]");
    }

    private TextBoxElementFacade taskDueDateTomorrowElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class,'v-date-picker-table__current')])[2]/following::td[1]");
    }

    private TextBoxElementFacade taskMarkedAsCompletedInDrawerElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class,'taskCompleted')]//textarea");
    }

    private ElementFacade taskNameAndLabelAndNumberInProjectDetails(String taskName) {
        return this.findByXPathOrCSS(String.format("(//*[contains(@class,'taskStatusName')]//*[@title='To Do']/following::*[@class='taskTitleEllipsis' and contains(text(),'%s')]/following::*[contains(@class,'taskLabels')]//span[@class='text-truncate'])[1]", taskName));
    }

    private ElementFacade taskNameElement() {
        return this.findByXPathOrCSS("//*[@id='task-Drawer']//*[@id='task-name']");
    }

    private TextBoxElementFacade taskNameFieldElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'taskTitleAndMark')]//textarea");
    }

    private ElementFacade taskNameInProjectDetails(String taskName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'taskTitle')]//*[@title = '%s']", taskName));
    }

    private ElementFacade taskPrioritySelectorElement() {
        return this.findByXPathOrCSS("//*[@class='v-input__control']//i[@class='v-icon notranslate mdi mdi-flag-variant theme--light nonePriorityColor']");
    }

    private TextBoxElementFacade taskQuickNameFieldElement() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'task-name')]//input");
    }

    private TextBoxElementFacade taskStartDateElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@id,'DatePicker')])[1]//input");
    }

    private TextBoxElementFacade taskStartDateTodayElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class,'v-date-picker-table__current')])[1]");
    }

    private TextBoxElementFacade taskStartDateTomorrowElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class,'v-date-picker-table__current')])[1]/following::td[1]");
    }

    private ElementFacade taskThreeDotsOptionElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class,'drawerHeader')]//*[contains(@class,'fa-ellipsis-v')]");
    }

    private ElementFacade taskTooltipElement() {
        return this.findByXPathOrCSS("#TasksManagementPortlet .taskCard .taskTitleId .taskTitle");
    }

    private ElementFacade textAssigneeElement() {
        return this.findByXPathOrCSS("//*[@class='nameGroup' and contains (text(), 'Unassigned')]");
    }

    private ElementFacade thirdStatusColumnElement() {
        return this.findByXPathOrCSS("(//*[contains(@id,'task-board')]//*[contains(@class,'statusName')])[3]");
    }

    private ElementFacade threeDotsIconElement() {
        return this.findByXPathOrCSS("(//*[@class='d-flex tasksViewHeaderLeft']/following::*[contains(@class,'uiIconVerticalDots')][1])[1]");
    }

    private ElementFacade timesTampElement() {
        return this.findByXPathOrCSS("//*[@class='pe-2' and contains(text(),'Last Update')]");
    }

    private ElementFacade titleForTaskFieldElement() {
        return this.findByXPathOrCSS("//*[@placeholder='Enter a title for this task']");
    }

    private ElementFacade toolTipElement() {
        return this.findByXPathOrCSS("//*[@class='lastUpdatedTask pb-3']");
    }

    private ElementFacade updateButtonDescriptionElement() {
        return this.findByXPathOrCSS("//*[@id='saveDescriptionButton']");
    }

    private ElementFacade updateNameSpaceButtonElement() {
        return this.findByXPathOrCSS("button#updateSpaceButton");
    }

    private ElementFacade validateStatusNameElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'taskStatusNameEdit')]//*[contains(@class,'Tick')]");
    }

    private ElementFacade viewAllCommentsTaskButtonElement() {
        return this.findByXPathOrCSS("//*[@class='ViewAllCommentLabel']");
    }

    private ElementFacade viewAttachmentsLinkElement() {
        return this.findByXPathOrCSS("//div[@class='attachmentsList']//a[@class='viewAllAttachments primary--text font-weight-bold text-decoration-underline']");
    }
}

