/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.metadata;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataInitPlugin;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;

public interface MetadataService {
    public Metadata createMetadata(Metadata var1, long var2);

    public Metadata updateMetadata(Metadata var1, long var2);

    public Metadata deleteMetadataById(long var1);

    public int deleteMetadataBySpaceId(long var1);

    public int deleteMetadataBySpaceIdAndAudienceId(long var1, long var3);

    public Metadata getMetadataByKey(MetadataKey var1);

    public Metadata getMetadataById(long var1);

    public MetadataItem createMetadataItem(MetadataObject var1, MetadataKey var2, long var3) throws ObjectAlreadyExistsException;

    public MetadataItem createMetadataItem(MetadataObject var1, MetadataKey var2, Map<String, String> var3, long var4, boolean var6) throws ObjectAlreadyExistsException;

    public MetadataItem createMetadataItem(MetadataObject var1, MetadataKey var2, Map<String, String> var3, long var4) throws ObjectAlreadyExistsException;

    public MetadataItem createMetadataItem(MetadataObject var1, MetadataKey var2, Map<String, String> var3, boolean var4) throws ObjectAlreadyExistsException;

    public MetadataItem createMetadataItem(MetadataObject var1, MetadataKey var2, Map<String, String> var3) throws ObjectAlreadyExistsException;

    public MetadataItem updateMetadataItem(MetadataItem var1, long var2, boolean var4);

    public MetadataItem updateMetadataItem(MetadataItem var1, long var2);

    public MetadataItem deleteMetadataItem(long var1, long var3) throws ObjectNotFoundException;

    public MetadataItem deleteMetadataItem(long var1, boolean var3) throws ObjectNotFoundException;

    public void deleteMetadataItemsByObject(MetadataObject var1);

    public void deleteByMetadataTypeAndSpaceIdAndCreatorId(String var1, long var2, long var4);

    public void deleteByMetadataTypeAndCreatorId(String var1, long var2);

    public void deleteMetadataItemsByMetadataTypeAndObject(String var1, MetadataObject var2);

    public List<MetadataItem> shareMetadataItemsByObject(MetadataObject var1, String var2, long var3, long var5);

    public Set<String> getMetadataNamesByObject(MetadataObject var1);

    public List<String> getMetadataNamesByMetadataTypeAndObject(String var1, String var2, String var3);

    public List<String> getMetadataNamesByMetadataTypeAndObject(String var1, String var2, String var3, int var4, int var5);

    public List<MetadataItem> getMetadataItemsByObject(MetadataObject var1);

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndObject(String var1, MetadataObject var2);

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObject(String var1, String var2, String var3, long var4, long var6);

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObject(String var1, String var2, String var3, String var4, long var5, long var7);

    default public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceId(String metadataName, String metadataTypeName, String objectType, long spaceId, long offset, long limit) {
        throw new UnsupportedOperationException();
    }

    default public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndSpaceIds(String metadataName, String metadataTypeName, List<Long> spaceIds, long offset, long limit) {
        throw new UnsupportedOperationException();
    }

    default public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(String metadataName, String metadataTypeName, String objectType, List<Long> spaceIds, long offset, long limit) {
        throw new UnsupportedOperationException();
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(String var1, String var2, String var3, String var4, String var5, long var6, long var8);

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndCreator(String var1, long var2, long var4, long var6);

    public int countMetadataItemsByMetadataTypeAndCreator(String var1, long var2);

    public Map<String, Long> countMetadataItemsByMetadataTypeAndAudienceId(String var1, long var2, long var4);

    public Map<Long, Long> countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(String var1, long var2, List<Long> var4);

    public List<MetadataItem> getMetadataItemsByMetadataAndObject(MetadataKey var1, MetadataObject var2);

    public List<String> getMetadataObjectIds(String var1, String var2, String var3, long var4, long var6);

    public void addMetadataTypePlugin(MetadataTypePlugin var1);

    public void addMetadataPlugin(MetadataInitPlugin var1);

    public MetadataTypePlugin getMetadataTypePluginByName(String var1);

    public MetadataType getMetadataTypeByName(String var1);

    public List<MetadataType> getMetadataTypes();

    public List<Metadata> getMetadatasByProperty(String var1, String var2, long var3);

    public long countMetadataIdsByProperty(String var1, String var2);

    public List<Long> getMetadataIdsByProperty(String var1, String var2, long var3, long var5);

    public List<Metadata> getMetadatas(String var1, long var2);

    public void deleteMetadataItemsByParentObject(MetadataObject var1);

    public int deleteByMetadataItemsTypeAndUntilCreationDate(String var1, long var2);

    public List<String> findMetadataNamesByAudiences(String var1, String var2, Set<Long> var3, long var4);

    public List<String> findMetadataNamesByCreator(String var1, String var2, long var3, long var5);

    public List<String> findMetadataNamesByUserAndQuery(String var1, String var2, Set<Long> var3, long var4, long var6);

    default public List<MetadataItem> getMetadataItemsByFilter(MetadataFilter filter, long offset, long limit) {
        throw new UnsupportedOperationException();
    }
}

