/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;

public class SpaceFilter
implements Cloneable {
    private String spaceNameSearchCondition;
    private List<Space> includeSpaces;
    private List<Space> exclusions;
    private String remoteId;
    private long identityId;
    private String template;
    private SpaceMembershipStatus status;
    private SpaceMembershipStatus extraStatus;
    private Sorting sorting;
    private boolean favorite;
    private List<String> tagNames;

    public SpaceFilter() {
        this.spaceNameSearchCondition = null;
    }

    public SpaceFilter(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public void setSpaceNameSearchCondition(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public List<SpaceMembershipStatus> getStatusList() {
        return Stream.of(this.status, this.extraStatus).filter(Objects::nonNull).toList();
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            this.sorting = new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC);
        }
        return this.sorting;
    }

    public boolean isUnifiedSearch() {
        return this.favorite && this.identityId > 0L || StringUtils.isNotBlank((CharSequence)this.spaceNameSearchCondition) || CollectionUtils.isNotEmpty(this.tagNames);
    }

    public SpaceFilter clone() {
        return new SpaceFilter(this.spaceNameSearchCondition, this.includeSpaces, this.exclusions, this.remoteId, this.identityId, this.template, this.status, this.extraStatus, this.sorting, this.favorite, (List<String>)(this.tagNames == null ? null : new ArrayList<String>(this.tagNames)));
    }

    @Generated
    public SpaceFilter(String spaceNameSearchCondition, List<Space> includeSpaces, List<Space> exclusions, String remoteId, long identityId, String template, SpaceMembershipStatus status, SpaceMembershipStatus extraStatus, Sorting sorting, boolean favorite, List<String> tagNames) {
        this.spaceNameSearchCondition = spaceNameSearchCondition;
        this.includeSpaces = includeSpaces;
        this.exclusions = exclusions;
        this.remoteId = remoteId;
        this.identityId = identityId;
        this.template = template;
        this.status = status;
        this.extraStatus = extraStatus;
        this.sorting = sorting;
        this.favorite = favorite;
        this.tagNames = tagNames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceFilter)) {
            return false;
        }
        SpaceFilter other = (SpaceFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIdentityId() != other.getIdentityId()) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        String this$spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        String other$spaceNameSearchCondition = other.getSpaceNameSearchCondition();
        if (this$spaceNameSearchCondition == null ? other$spaceNameSearchCondition != null : !this$spaceNameSearchCondition.equals(other$spaceNameSearchCondition)) {
            return false;
        }
        List<Space> this$includeSpaces = this.getIncludeSpaces();
        List<Space> other$includeSpaces = other.getIncludeSpaces();
        if (this$includeSpaces == null ? other$includeSpaces != null : !((Object)this$includeSpaces).equals(other$includeSpaces)) {
            return false;
        }
        List<Space> this$exclusions = this.getExclusions();
        List<Space> other$exclusions = other.getExclusions();
        if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
            return false;
        }
        String this$remoteId = this.getRemoteId();
        String other$remoteId = other.getRemoteId();
        if (this$remoteId == null ? other$remoteId != null : !this$remoteId.equals(other$remoteId)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        SpaceMembershipStatus this$status = this.getStatus();
        SpaceMembershipStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        SpaceMembershipStatus this$extraStatus = this.getExtraStatus();
        SpaceMembershipStatus other$extraStatus = other.getExtraStatus();
        if (this$extraStatus == null ? other$extraStatus != null : !((Object)((Object)this$extraStatus)).equals((Object)other$extraStatus)) {
            return false;
        }
        Sorting this$sorting = this.getSorting();
        Sorting other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)this$sorting).equals(other$sorting)) {
            return false;
        }
        List<String> this$tagNames = this.getTagNames();
        List<String> other$tagNames = other.getTagNames();
        return !(this$tagNames == null ? other$tagNames != null : !((Object)this$tagNames).equals(other$tagNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpaceFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $identityId = this.getIdentityId();
        result = result * 59 + (int)($identityId >>> 32 ^ $identityId);
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        String $spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        result = result * 59 + ($spaceNameSearchCondition == null ? 43 : $spaceNameSearchCondition.hashCode());
        List<Space> $includeSpaces = this.getIncludeSpaces();
        result = result * 59 + ($includeSpaces == null ? 43 : ((Object)$includeSpaces).hashCode());
        List<Space> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        String $remoteId = this.getRemoteId();
        result = result * 59 + ($remoteId == null ? 43 : $remoteId.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        SpaceMembershipStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        SpaceMembershipStatus $extraStatus = this.getExtraStatus();
        result = result * 59 + ($extraStatus == null ? 43 : ((Object)((Object)$extraStatus)).hashCode());
        Sorting $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)$sorting).hashCode());
        List<String> $tagNames = this.getTagNames();
        result = result * 59 + ($tagNames == null ? 43 : ((Object)$tagNames).hashCode());
        return result;
    }

    @Generated
    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    @Generated
    public List<Space> getIncludeSpaces() {
        return this.includeSpaces;
    }

    @Generated
    public List<Space> getExclusions() {
        return this.exclusions;
    }

    @Generated
    public String getRemoteId() {
        return this.remoteId;
    }

    @Generated
    public long getIdentityId() {
        return this.identityId;
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public SpaceMembershipStatus getStatus() {
        return this.status;
    }

    @Generated
    public SpaceMembershipStatus getExtraStatus() {
        return this.extraStatus;
    }

    @Generated
    public boolean isFavorite() {
        return this.favorite;
    }

    @Generated
    public void setIncludeSpaces(List<Space> includeSpaces) {
        this.includeSpaces = includeSpaces;
    }

    @Generated
    public void setExclusions(List<Space> exclusions) {
        this.exclusions = exclusions;
    }

    @Generated
    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    @Generated
    public void setIdentityId(long identityId) {
        this.identityId = identityId;
    }

    @Generated
    public void setTemplate(String template) {
        this.template = template;
    }

    @Generated
    public void setStatus(SpaceMembershipStatus status) {
        this.status = status;
    }

    @Generated
    public void setExtraStatus(SpaceMembershipStatus extraStatus) {
        this.extraStatus = extraStatus;
    }

    @Generated
    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    @Generated
    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    @Generated
    public List<String> getTagNames() {
        return this.tagNames;
    }

    @Generated
    public void setTagNames(List<String> tagNames) {
        this.tagNames = tagNames;
    }
}

