/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.CacheEntry;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLoader;

public class Identity
implements CacheEntry,
Cloneable {
    String id;
    String remoteId;
    String providerId;
    boolean isDeleted;
    private boolean isEnable;
    volatile Profile profile;
    private volatile ProfileLoader profileLoader;
    private long cacheTime;
    GlobalId globalId;

    public Identity() {
    }

    public Identity(String id) {
        this.id = id;
        this.isEnable = true;
    }

    public Identity(String providerId, String remoteId) {
        this.remoteId = remoteId;
        this.providerId = providerId;
        this.isEnable = true;
    }

    public Identity(String id, String remoteId, String providerId, boolean isDeleted, boolean isEnable, Profile profile, ProfileLoader profileLoader, GlobalId globalId) {
        this.id = id;
        this.remoteId = remoteId;
        this.providerId = providerId;
        this.isDeleted = isDeleted;
        this.isEnable = isEnable;
        this.profile = profile;
        this.profileLoader = profileLoader;
        this.globalId = globalId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getProfile() {
        if (this.profile == null) {
            if (this.profileLoader == null) {
                this.profile = new Profile(this);
            } else {
                Identity identity = this;
                synchronized (identity) {
                    if (this.profile == null) {
                        this.profile = this.profileLoader.load();
                        this.profileLoader = null;
                    }
                }
            }
        }
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public void setProfileLoader(ProfileLoader profileLoader) {
        this.profileLoader = profileLoader;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean isSpace() {
        return StringUtils.equals((CharSequence)this.providerId, (CharSequence)"space");
    }

    public boolean isUser() {
        return StringUtils.equals((CharSequence)this.providerId, (CharSequence)"organization");
    }

    public boolean isExternal() {
        Profile identityProfile = this.getProfile();
        return identityProfile != null && Objects.equals("true", identityProfile.getProperty("external"));
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String toString() {
        return this.getGlobalId().toString();
    }

    public GlobalId getGlobalId() {
        if (this.globalId == null) {
            this.globalId = GlobalId.create(this.providerId, this.remoteId);
        }
        return this.globalId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Identity clone() {
        return new Identity(this.id, this.remoteId, this.providerId, this.isDeleted, this.isEnable, this.profile, this.profileLoader, this.globalId);
    }

    @Override
    @Generated
    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    @Generated
    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }
}

