/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.social.databind.plugin;

import io.meeds.social.databind.model.DatabindReport;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;

import java.io.File;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipOutputStream;

public interface DatabindPlugin {

  String getObjectType();

  boolean canHandleDatabind(String objectType, String objectId);

  void serialize(String objectId, ZipOutputStream zipOutputStream, String username) throws ObjectNotFoundException,
                                                                                    IllegalAccessException;

  CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username);
}
