/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.text.Normalizer;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final String SIZE_SPLIT_CHAR = "x";

    private Utils() {
    }

    public static String processUnifiedSearchCondition(String input) {
        String[] tab;
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        if (input.indexOf("~") < 0 || input.indexOf("\\~") > 0) {
            return input.trim();
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(" ")) {
            if (s.isEmpty()) continue;
            if (s.indexOf("~") > -1) {
                String searchTerm = s.substring(0, s.lastIndexOf("~"));
                builder.append(searchTerm).append(" ");
                continue;
            }
            builder.append(s).append(" ");
        }
        return builder.toString().trim();
    }

    public static String removeSpecialCharacterInSpaceFilter(String input) {
        String result = input.replaceAll("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\?\\*%0-9\\']", " ");
        result = result.replaceAll("\\s+", " ");
        return result.trim();
    }

    public static String cleanString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKD);
        StringBuilder cleanedStr = new StringBuilder(str.toLowerCase().trim());
        int lastChar = 95;
        for (int i = cleanedStr.length() - 1; i >= 0; --i) {
            char c = cleanedStr.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                if (lastChar == 95) {
                    cleanedStr.setCharAt(i, String.valueOf(c % 10).charAt(0));
                    continue;
                }
                lastChar = 95;
                cleanedStr.setCharAt(i, '_');
                continue;
            }
            lastChar = c;
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static int[] parseDimension(String size) {
        int[] dimension = new int[2];
        if (size.contains(SIZE_SPLIT_CHAR) && !size.startsWith(SIZE_SPLIT_CHAR)) {
            dimension[0] = Integer.parseInt(size.split(SIZE_SPLIT_CHAR)[0]);
        }
        if (size.contains(SIZE_SPLIT_CHAR) && !size.endsWith(SIZE_SPLIT_CHAR)) {
            dimension[1] = Integer.parseInt(size.split(SIZE_SPLIT_CHAR)[1]);
        }
        return dimension;
    }
}

