/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.social.html.service;

import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.plugin.HtmlProcessorPlugin;

/**
 * A service used to transform a HTML content for display
 */
public interface HtmlProcessorService {

  /**
   * Process the HTML input into content before storing in database
   * 
   * @param html HTML input
   * @param context HTML processor context of type {@link HtmlProcessorContext}
   * @return processed HTML output
   */
  String process(String html, HtmlProcessorContext context);

  /**
   * Add new Processor Plugin to consider while processing the html to write on
   * database
   * 
   * @param processorPlugin {@link HtmlProcessorPlugin}
   */
  void addPlugin(HtmlProcessorPlugin processorPlugin);

  /**
   * Removes a plugin that was previously added
   * 
   * @param processorPlugin {@link HtmlProcessorPlugin}
   */
  void removePlugin(HtmlProcessorPlugin processorPlugin);

}
