/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.space.plugin.SpaceCategoryLifeCycleEvent;
import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;

public class SpaceLifecycle
extends AbstractLifeCycle<SpaceLifeCycleListener, SpaceLifeCycleEvent> {
    private ThreadLocal<SpaceLifeCycleEvent.Type> currentEventThreadLocal = new ThreadLocal();

    public void setCurrentEvent(SpaceLifeCycleEvent.Type type) {
        if (this.currentEventThreadLocal.get() == null) {
            this.currentEventThreadLocal.set(type);
        }
    }

    public SpaceLifeCycleEvent.Type getCurrentEvent() {
        return this.currentEventThreadLocal.get();
    }

    public void resetCurrentEvent(SpaceLifeCycleEvent.Type type) {
        if (this.currentEventThreadLocal.get() == type) {
            this.currentEventThreadLocal.remove();
        }
    }

    @Override
    protected void dispatchEvent(SpaceLifeCycleListener listener, SpaceLifeCycleEvent event) {
        switch (event.getType()) {
            case SPACE_CREATED: {
                listener.spaceCreated(event);
                break;
            }
            case SPACE_REMOVED: {
                listener.spaceRemoved(event);
                break;
            }
            case CATEGORY_ADDED: {
                listener.categoryAdded((SpaceCategoryLifeCycleEvent)event);
                break;
            }
            case CATEGORY_REMOVED: {
                listener.categoryRemoved((SpaceCategoryLifeCycleEvent)event);
                break;
            }
            case JOINED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.joined(event);
                break;
            }
            case LEFT: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.left(event);
                break;
            }
            case GRANTED_LEAD: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.grantedLead(event);
                break;
            }
            case REVOKED_LEAD: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.revokedLead(event);
                break;
            }
            case SPACE_RENAMED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceRenamed(event);
                break;
            }
            case SPACE_DESCRIPTION_EDITED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceDescriptionEdited(event);
                break;
            }
            case SPACE_AVATAR_EDITED: {
                listener.spaceAvatarEdited(event);
                break;
            }
            case SPACE_BANNER_EDITED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceBannerEdited(event);
                break;
            }
            case SPACE_HIDDEN: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceAccessEdited(event);
                break;
            }
            case SPACE_REGISTRATION: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceRegistrationEdited(event);
                break;
            }
            case ADD_INVITED_USER: {
                listener.addInvitedUser(event);
                break;
            }
            case DENY_INVITED_USER: {
                listener.removeInvitedUser(event);
                break;
            }
            case ADD_PENDING_USER: {
                listener.addPendingUser(event);
                break;
            }
            case REMOVE_PENDING_USER: {
                listener.removePendingUser(event);
                break;
            }
            case ADD_REDACTOR_USER: {
                listener.addRedactorUser(event);
                break;
            }
            case REMOVE_REDACTOR_USER: {
                listener.removeRedactorUser(event);
                break;
            }
            case ADD_PUBLISHER_USER: {
                listener.addPublisherUser(event);
                break;
            }
            case REMOVE_PUBLISHER_USER: {
                listener.removePublisherUser(event);
                break;
            }
        }
    }

    public void spaceCreated(Space space, String creator) {
        this.broadcast(new SpaceLifeCycleEvent(space, creator, SpaceLifeCycleEvent.Type.SPACE_CREATED));
    }

    public void spaceRemoved(Space space, String remover) {
        this.broadcast(new SpaceLifeCycleEvent(space, remover, SpaceLifeCycleEvent.Type.SPACE_REMOVED));
    }

    public void memberJoined(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.JOINED));
    }

    public void memberLeft(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.LEFT));
    }

    public void grantedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.GRANTED_LEAD));
    }

    public void revokedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REVOKED_LEAD));
    }

    public void spaceRenamed(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_RENAMED));
    }

    public void spaceDescriptionEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_DESCRIPTION_EDITED));
    }

    public void spaceAvatarEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_AVATAR_EDITED));
    }

    public void spaceBannerEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_BANNER_EDITED));
    }

    public void spaceAccessEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_HIDDEN));
    }

    public void spaceCategoryAdded(Space space, String userId, long categoryId) {
        this.broadcast(new SpaceCategoryLifeCycleEvent(space, userId, categoryId, SpaceLifeCycleEvent.Type.CATEGORY_ADDED));
    }

    public void spaceCategoryRemoved(Space space, String userId, long categoryId) {
        this.broadcast(new SpaceCategoryLifeCycleEvent(space, userId, categoryId, SpaceLifeCycleEvent.Type.CATEGORY_REMOVED));
    }

    public void spaceRegistrationEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_REGISTRATION));
    }

    public void spacePublicSiteCreated(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_PUBLIC_SITE_CREATED));
    }

    public void spacePublicSiteUpdated(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_PUBLIC_SITE_UPDATED));
    }

    public void addInvitedUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_INVITED_USER));
    }

    public void removeInvitedUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.DENY_INVITED_USER));
    }

    public void addPendingUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_PENDING_USER));
    }

    public void removePendingUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REMOVE_PENDING_USER));
    }

    public void addRedactorUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_REDACTOR_USER));
    }

    public void removeRedactorUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REMOVE_REDACTOR_USER));
    }

    public void addPublisherUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_PUBLISHER_USER));
    }

    public void removePublisherUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REMOVE_PUBLISHER_USER));
    }

    private boolean isSpaceProperEvent(SpaceLifeCycleEvent event) {
        SpaceLifeCycleEvent.Type currentEvent = this.getCurrentEvent();
        return currentEvent == null || currentEvent == event.getType();
    }
}

