/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.social.cms.model;

import java.util.Locale;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

@NoArgsConstructor
@AllArgsConstructor
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ContentLink extends ContentLinkIdentifier {

  private String  title;

  private String  uri;

  private String  icon;

  private boolean drawer;

  public ContentLink(ContentLinkIdentifier link) {
    super(link.getObjectType(), link.getObjectId(), link.getFieldName(), link.getLocale());
  }

  public ContentLink(String objectType, String objectId, String fieldName, Locale locale, String title, String uri) {
    super(objectType, objectId, fieldName, locale);
    this.title = title;
    this.uri = uri;
  }

  public ContentLink(String objectType, String objectId, Locale locale, String title, String uri) {
    super(objectType, objectId, locale);
    this.title = title;
    this.uri = uri;
  }

}
