/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;

public class SpaceFilter
implements Cloneable {
    private String spaceNameSearchCondition;
    private List<Space> includeSpaces;
    private List<Long> excludedIds;
    private String remoteId;
    private long identityId;
    private List<Long> templateIds;
    private List<Long> categoryIds;
    private List<Long> excludedCategoryIds;
    private List<Long> managingTemplateIds;
    private SpaceMembershipStatus status;
    private SpaceMembershipStatus extraStatus;
    private SpaceRegistration registration;
    private SpaceVisibility visibility;
    private Sorting sorting;
    private boolean favorite;
    private List<String> tagNames;
    private long parentSpaceId;

    public SpaceFilter(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public void setSpaceNameSearchCondition(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public List<SpaceMembershipStatus> getStatusList() {
        return Stream.of(this.status, this.extraStatus).filter(Objects::nonNull).toList();
    }

    public boolean isSortingEmpty() {
        return this.sorting == null;
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            return new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC);
        }
        return this.sorting;
    }

    public boolean isUnifiedSearch() {
        return this.favorite && this.identityId > 0L || StringUtils.isNotBlank((CharSequence)this.spaceNameSearchCondition) || CollectionUtils.isNotEmpty(this.tagNames);
    }

    public SpaceFilter clone() {
        return new SpaceFilter(this.spaceNameSearchCondition, this.includeSpaces, this.excludedIds, this.remoteId, this.identityId, this.templateIds, this.categoryIds, this.excludedCategoryIds, this.managingTemplateIds, this.status, this.extraStatus, this.registration, this.visibility, this.sorting, this.favorite, (List<String>)(this.tagNames == null ? null : new ArrayList<String>(this.tagNames)), this.parentSpaceId);
    }

    @Generated
    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    @Generated
    public List<Space> getIncludeSpaces() {
        return this.includeSpaces;
    }

    @Generated
    public List<Long> getExcludedIds() {
        return this.excludedIds;
    }

    @Generated
    public String getRemoteId() {
        return this.remoteId;
    }

    @Generated
    public long getIdentityId() {
        return this.identityId;
    }

    @Generated
    public List<Long> getTemplateIds() {
        return this.templateIds;
    }

    @Generated
    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    @Generated
    public List<Long> getExcludedCategoryIds() {
        return this.excludedCategoryIds;
    }

    @Generated
    public List<Long> getManagingTemplateIds() {
        return this.managingTemplateIds;
    }

    @Generated
    public SpaceMembershipStatus getStatus() {
        return this.status;
    }

    @Generated
    public SpaceMembershipStatus getExtraStatus() {
        return this.extraStatus;
    }

    @Generated
    public SpaceRegistration getRegistration() {
        return this.registration;
    }

    @Generated
    public SpaceVisibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public boolean isFavorite() {
        return this.favorite;
    }

    @Generated
    public List<String> getTagNames() {
        return this.tagNames;
    }

    @Generated
    public long getParentSpaceId() {
        return this.parentSpaceId;
    }

    @Generated
    public void setIncludeSpaces(List<Space> includeSpaces) {
        this.includeSpaces = includeSpaces;
    }

    @Generated
    public void setExcludedIds(List<Long> excludedIds) {
        this.excludedIds = excludedIds;
    }

    @Generated
    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    @Generated
    public void setIdentityId(long identityId) {
        this.identityId = identityId;
    }

    @Generated
    public void setTemplateIds(List<Long> templateIds) {
        this.templateIds = templateIds;
    }

    @Generated
    public void setCategoryIds(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    @Generated
    public void setExcludedCategoryIds(List<Long> excludedCategoryIds) {
        this.excludedCategoryIds = excludedCategoryIds;
    }

    @Generated
    public void setManagingTemplateIds(List<Long> managingTemplateIds) {
        this.managingTemplateIds = managingTemplateIds;
    }

    @Generated
    public void setStatus(SpaceMembershipStatus status) {
        this.status = status;
    }

    @Generated
    public void setExtraStatus(SpaceMembershipStatus extraStatus) {
        this.extraStatus = extraStatus;
    }

    @Generated
    public void setRegistration(SpaceRegistration registration) {
        this.registration = registration;
    }

    @Generated
    public void setVisibility(SpaceVisibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    @Generated
    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    @Generated
    public void setTagNames(List<String> tagNames) {
        this.tagNames = tagNames;
    }

    @Generated
    public void setParentSpaceId(long parentSpaceId) {
        this.parentSpaceId = parentSpaceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceFilter)) {
            return false;
        }
        SpaceFilter other = (SpaceFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIdentityId() != other.getIdentityId()) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        if (this.getParentSpaceId() != other.getParentSpaceId()) {
            return false;
        }
        String this$spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        String other$spaceNameSearchCondition = other.getSpaceNameSearchCondition();
        if (this$spaceNameSearchCondition == null ? other$spaceNameSearchCondition != null : !this$spaceNameSearchCondition.equals(other$spaceNameSearchCondition)) {
            return false;
        }
        List<Space> this$includeSpaces = this.getIncludeSpaces();
        List<Space> other$includeSpaces = other.getIncludeSpaces();
        if (this$includeSpaces == null ? other$includeSpaces != null : !((Object)this$includeSpaces).equals(other$includeSpaces)) {
            return false;
        }
        List<Long> this$excludedIds = this.getExcludedIds();
        List<Long> other$excludedIds = other.getExcludedIds();
        if (this$excludedIds == null ? other$excludedIds != null : !((Object)this$excludedIds).equals(other$excludedIds)) {
            return false;
        }
        String this$remoteId = this.getRemoteId();
        String other$remoteId = other.getRemoteId();
        if (this$remoteId == null ? other$remoteId != null : !this$remoteId.equals(other$remoteId)) {
            return false;
        }
        List<Long> this$templateIds = this.getTemplateIds();
        List<Long> other$templateIds = other.getTemplateIds();
        if (this$templateIds == null ? other$templateIds != null : !((Object)this$templateIds).equals(other$templateIds)) {
            return false;
        }
        List<Long> this$categoryIds = this.getCategoryIds();
        List<Long> other$categoryIds = other.getCategoryIds();
        if (this$categoryIds == null ? other$categoryIds != null : !((Object)this$categoryIds).equals(other$categoryIds)) {
            return false;
        }
        List<Long> this$excludedCategoryIds = this.getExcludedCategoryIds();
        List<Long> other$excludedCategoryIds = other.getExcludedCategoryIds();
        if (this$excludedCategoryIds == null ? other$excludedCategoryIds != null : !((Object)this$excludedCategoryIds).equals(other$excludedCategoryIds)) {
            return false;
        }
        List<Long> this$managingTemplateIds = this.getManagingTemplateIds();
        List<Long> other$managingTemplateIds = other.getManagingTemplateIds();
        if (this$managingTemplateIds == null ? other$managingTemplateIds != null : !((Object)this$managingTemplateIds).equals(other$managingTemplateIds)) {
            return false;
        }
        SpaceMembershipStatus this$status = this.getStatus();
        SpaceMembershipStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        SpaceMembershipStatus this$extraStatus = this.getExtraStatus();
        SpaceMembershipStatus other$extraStatus = other.getExtraStatus();
        if (this$extraStatus == null ? other$extraStatus != null : !((Object)((Object)this$extraStatus)).equals((Object)other$extraStatus)) {
            return false;
        }
        SpaceRegistration this$registration = this.getRegistration();
        SpaceRegistration other$registration = other.getRegistration();
        if (this$registration == null ? other$registration != null : !((Object)((Object)this$registration)).equals((Object)other$registration)) {
            return false;
        }
        SpaceVisibility this$visibility = this.getVisibility();
        SpaceVisibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        Sorting this$sorting = this.getSorting();
        Sorting other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)this$sorting).equals(other$sorting)) {
            return false;
        }
        List<String> this$tagNames = this.getTagNames();
        List<String> other$tagNames = other.getTagNames();
        return !(this$tagNames == null ? other$tagNames != null : !((Object)this$tagNames).equals(other$tagNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpaceFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $identityId = this.getIdentityId();
        result = result * 59 + (int)($identityId >>> 32 ^ $identityId);
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        long $parentSpaceId = this.getParentSpaceId();
        result = result * 59 + (int)($parentSpaceId >>> 32 ^ $parentSpaceId);
        String $spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        result = result * 59 + ($spaceNameSearchCondition == null ? 43 : $spaceNameSearchCondition.hashCode());
        List<Space> $includeSpaces = this.getIncludeSpaces();
        result = result * 59 + ($includeSpaces == null ? 43 : ((Object)$includeSpaces).hashCode());
        List<Long> $excludedIds = this.getExcludedIds();
        result = result * 59 + ($excludedIds == null ? 43 : ((Object)$excludedIds).hashCode());
        String $remoteId = this.getRemoteId();
        result = result * 59 + ($remoteId == null ? 43 : $remoteId.hashCode());
        List<Long> $templateIds = this.getTemplateIds();
        result = result * 59 + ($templateIds == null ? 43 : ((Object)$templateIds).hashCode());
        List<Long> $categoryIds = this.getCategoryIds();
        result = result * 59 + ($categoryIds == null ? 43 : ((Object)$categoryIds).hashCode());
        List<Long> $excludedCategoryIds = this.getExcludedCategoryIds();
        result = result * 59 + ($excludedCategoryIds == null ? 43 : ((Object)$excludedCategoryIds).hashCode());
        List<Long> $managingTemplateIds = this.getManagingTemplateIds();
        result = result * 59 + ($managingTemplateIds == null ? 43 : ((Object)$managingTemplateIds).hashCode());
        SpaceMembershipStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        SpaceMembershipStatus $extraStatus = this.getExtraStatus();
        result = result * 59 + ($extraStatus == null ? 43 : ((Object)((Object)$extraStatus)).hashCode());
        SpaceRegistration $registration = this.getRegistration();
        result = result * 59 + ($registration == null ? 43 : ((Object)((Object)$registration)).hashCode());
        SpaceVisibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        Sorting $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)$sorting).hashCode());
        List<String> $tagNames = this.getTagNames();
        result = result * 59 + ($tagNames == null ? 43 : ((Object)$tagNames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpaceFilter(spaceNameSearchCondition=" + this.getSpaceNameSearchCondition() + ", includeSpaces=" + String.valueOf(this.getIncludeSpaces()) + ", excludedIds=" + String.valueOf(this.getExcludedIds()) + ", remoteId=" + this.getRemoteId() + ", identityId=" + this.getIdentityId() + ", templateIds=" + String.valueOf(this.getTemplateIds()) + ", categoryIds=" + String.valueOf(this.getCategoryIds()) + ", excludedCategoryIds=" + String.valueOf(this.getExcludedCategoryIds()) + ", managingTemplateIds=" + String.valueOf(this.getManagingTemplateIds()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", extraStatus=" + String.valueOf((Object)this.getExtraStatus()) + ", registration=" + String.valueOf((Object)this.getRegistration()) + ", visibility=" + String.valueOf((Object)this.getVisibility()) + ", sorting=" + String.valueOf(this.getSorting()) + ", favorite=" + this.isFavorite() + ", tagNames=" + String.valueOf(this.getTagNames()) + ", parentSpaceId=" + this.getParentSpaceId() + ")";
    }

    @Generated
    public SpaceFilter() {
    }

    @Generated
    public SpaceFilter(String spaceNameSearchCondition, List<Space> includeSpaces, List<Long> excludedIds, String remoteId, long identityId, List<Long> templateIds, List<Long> categoryIds, List<Long> excludedCategoryIds, List<Long> managingTemplateIds, SpaceMembershipStatus status, SpaceMembershipStatus extraStatus, SpaceRegistration registration, SpaceVisibility visibility, Sorting sorting, boolean favorite, List<String> tagNames, long parentSpaceId) {
        this.spaceNameSearchCondition = spaceNameSearchCondition;
        this.includeSpaces = includeSpaces;
        this.excludedIds = excludedIds;
        this.remoteId = remoteId;
        this.identityId = identityId;
        this.templateIds = templateIds;
        this.categoryIds = categoryIds;
        this.excludedCategoryIds = excludedCategoryIds;
        this.managingTemplateIds = managingTemplateIds;
        this.status = status;
        this.extraStatus = extraStatus;
        this.registration = registration;
        this.visibility = visibility;
        this.sorting = sorting;
        this.favorite = favorite;
        this.tagNames = tagNames;
        this.parentSpaceId = parentSpaceId;
    }
}

