/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ObjectHelper {
    private static final List<?> PRIMITIVE_ARRAY_TYPES = Arrays.asList(byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, char[].class, boolean[].class);

    public static <T> T getException(Class<T> type, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Iterator<Throwable> it = ObjectHelper.createExceptionIterator(exception);
        while (it.hasNext()) {
            Throwable e = it.next();
            if (!type.isInstance(e)) continue;
            return type.cast(e);
        }
        return null;
    }

    public static Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return new ExceptionIterator(exception);
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class<?> newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectHelper.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && !toType.equals(newType = ObjectHelper.convertPrimitiveTypeToWrapperType(toType))) {
            return (T)ObjectHelper.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + String.valueOf(value) + " to type: " + toType.getName() + " due to: " + String.valueOf(e), e);
        }
    }

    public static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            }
        }
        return rc;
    }

    private static final class ExceptionIterator
    implements Iterator<Throwable> {
        private List<Throwable> tree = new ArrayList<Throwable>();
        private Iterator<Throwable> it;

        public ExceptionIterator(Throwable exception) {
            for (Throwable current = exception; current != null; current = current.getCause()) {
                this.tree.add(current);
            }
            Collections.reverse(this.tree);
            this.it = this.tree.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Throwable next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

