/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.upgrade;

import io.meeds.social.core.upgrade.SpaceNavigationIconUpgradePlugin;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceNavigationIconUpgradePluginTest {
    private SpaceNavigationIconUpgradePlugin spaceNavigationIconUpgradePlugin;
    @Mock
    private EntityManagerService entityManagerService;
    InitParams initParams = new InitParams();

    @Before
    public void setUp() {
        ValueParam productGroupIdValueParam = new ValueParam();
        productGroupIdValueParam.setName("product.group.id");
        productGroupIdValueParam.setValue("org.exoplatform.platform");
        ValueParam spaceNodeNamesValueParam = new ValueParam();
        spaceNodeNamesValueParam.setName("space.node.names");
        spaceNodeNamesValueParam.setValue("settings;members");
        ValueParam spaceNodeIconsValueParam = new ValueParam();
        spaceNodeIconsValueParam.setName("space.node.icons");
        spaceNodeIconsValueParam.setValue("fas fa-cog;fas fa-users");
        this.initParams.addParameter((Parameter)productGroupIdValueParam);
        this.initParams.addParameter((Parameter)spaceNodeNamesValueParam);
        this.initParams.addParameter((Parameter)spaceNodeIconsValueParam);
        this.spaceNavigationIconUpgradePlugin = new SpaceNavigationIconUpgradePlugin(this.entityManagerService, this.initParams);
    }

    @Test
    public void testProcessUpgrade() {
        EntityManager entityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)entityManager);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)entityManager.createNativeQuery(Mockito.anyString())).thenReturn((Object)query);
        Mockito.when((Object)query.executeUpdate()).thenReturn((Object)2);
        boolean proceedToUpgrade = this.spaceNavigationIconUpgradePlugin.shouldProceedToUpgrade(null, null);
        Assert.assertTrue((boolean)proceedToUpgrade);
        UpgradePluginExecutionContext upgradePluginExecutionContext = new UpgradePluginExecutionContext("6.4.0", 0);
        proceedToUpgrade = this.spaceNavigationIconUpgradePlugin.shouldProceedToUpgrade("6.5.0", "6.4.0", upgradePluginExecutionContext);
        Assert.assertTrue((boolean)proceedToUpgrade);
        this.spaceNavigationIconUpgradePlugin.processUpgrade("oldVersion", "newVersion");
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        ((EntityManager)Mockito.verify((Object)entityManager)).createNativeQuery((String)sqlStatementCaptor.capture());
        String actualSQLStatement = (String)sqlStatementCaptor.getValue();
        String expectedSql = "  UPDATE PORTAL_NAVIGATION_NODES\n  SET ICON =\n    CASE\n      WHEN PARENT_ID IN (SELECT NODE_ID FROM (SELECT * FROM PORTAL_NAVIGATION_NODES WHERE NAME LIKE 'default') AS PARENT_NAVIGATION) THEN TRIM('fas fa-stream')\n         WHEN NAME in ('settings') THEN TRIM('fas fa-cog')\n   WHEN NAME in ('members') THEN TRIM('fas fa-users')\n\n    END\n  WHERE ICON IS NULL\n  AND EXISTS (SELECT * FROM PORTAL_PAGES p INNER JOIN PORTAL_SITES s ON s.ID = p.SITE_ID WHERE PAGE_ID = p.ID AND s.TYPE = 1 AND s.NAME LIKE '/spaces/%')\n";
        Assert.assertEquals((Object)expectedSql.trim(), (Object)actualSQLStatement.trim());
        ((Query)Mockito.verify((Object)query)).executeUpdate();
        Assert.assertEquals((long)2L, (long)this.spaceNavigationIconUpgradePlugin.getMigratedSpaceNodeIcons());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{entityManager, query});
    }
}

