/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;

public class MetadataActivityProcessorTest
extends AbstractCoreTest {
    private static final Log LOG = ExoLogger.getLogger(MetadataActivityProcessorTest.class);
    private static final String METADATA_TYPE_NAME = "testMetadataActivityProcessor";
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private MetadataService metadataService;
    private MetadataDAO metadataDAO;
    private List<ExoSocialActivity> tearDownActivityList;

    @Override
    public void setUp() throws Exception {
        try {
            super.setUp();
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing parent Test class", (Throwable)e);
        }
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        if (this.metadataService.getMetadataTypeByName(METADATA_TYPE_NAME) == null) {
            MetadataTypePlugin userMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(58466L, METADATA_TYPE_NAME)){

                public boolean isAllowMultipleItemsPerObject() {
                    return true;
                }

                public boolean isShareable() {
                    return true;
                }
            };
            this.metadataService.addMetadataTypePlugin(userMetadataTypePlugin);
        }
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        super.tearDown();
    }

    public void testSaveActivity() throws Exception {
        long creatorId;
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String metadataName = "testMetadata2";
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, metadataName, audienceId);
        MetadataObject metadataObject = new MetadataObject("activity", activity.getId(), null);
        MetadataItem metadataItem = this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        MetadataActivityProcessorTest.assertNotNull((Object)metadataItem);
        MetadataActivityProcessorTest.assertTrue((metadataItem.getId() > 0L ? 1 : 0) != 0);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        MetadataActivityProcessorTest.assertNotNull((Object)metadataItem);
        MetadataActivityProcessorTest.assertEquals((int)1, (int)metadataItems.size());
        activity = this.activityManager.getActivity(activity.getId());
        MetadataActivityProcessorTest.assertNotNull((Object)activity.getMetadatas());
        MetadataActivityProcessorTest.assertEquals((int)1, (int)activity.getMetadatas().size());
        MetadataActivityProcessorTest.assertNotNull(activity.getMetadatas().get(METADATA_TYPE_NAME));
        MetadataActivityProcessorTest.assertEquals((Object)metadataItems, activity.getMetadatas().get(METADATA_TYPE_NAME));
    }

    public void testSaveActivityWithSpecificMetadataObject() throws Exception {
        long creatorId;
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String metadataName = "testMetadata2";
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, metadataName, audienceId);
        String specificMetadataObjectType = "CUSTOME_METADATA_OBJECT_TYPE";
        String specificMetadataObjectId = "CUSTOME_METADATA_OBJECT_ID";
        MetadataObject metadataObject = new MetadataObject(specificMetadataObjectType, specificMetadataObjectId, null);
        MetadataItem metadataItem = this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        MetadataActivityProcessorTest.assertNotNull((Object)metadataItem);
        MetadataActivityProcessorTest.assertTrue((metadataItem.getId() > 0L ? 1 : 0) != 0);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        MetadataActivityProcessorTest.assertNotNull((Object)metadataItem);
        MetadataActivityProcessorTest.assertEquals((int)1, (int)metadataItems.size());
        activity = this.activityManager.getActivity(activity.getId());
        MetadataActivityProcessorTest.assertTrue((boolean)MapUtils.isEmpty((Map)activity.getMetadatas()));
        activity.setMetadataObjectType(specificMetadataObjectType);
        activity.setMetadataObjectId(specificMetadataObjectId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        MetadataActivityProcessorTest.assertNotNull((Object)activity.getMetadatas());
        MetadataActivityProcessorTest.assertEquals((int)1, (int)activity.getMetadatas().size());
        MetadataActivityProcessorTest.assertNotNull(activity.getMetadatas().get(METADATA_TYPE_NAME));
        MetadataActivityProcessorTest.assertEquals((Object)metadataItems, activity.getMetadatas().get(METADATA_TYPE_NAME));
    }

    private InitParams newParam(long id, String name) {
        InitParams params = new InitParams();
        MetadataType metadataType = new MetadataType(id, name);
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadataType");
        parameter.setObject((Object)metadataType);
        params.addParameter((Parameter)parameter);
        return params;
    }
}

