/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ConnectionESListenerImpl
extends RelationshipListenerPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(ConnectionESListenerImpl.class);

    public void requested(RelationshipEvent event) {
        this.reindexRelationship((Relationship)event.getPayload(), "requested");
    }

    public void denied(RelationshipEvent event) {
        this.reindexRelationship((Relationship)event.getPayload(), "denied");
    }

    public void confirmed(RelationshipEvent event) {
        this.reindexRelationship((Relationship)event.getPayload(), "confirmed");
    }

    public void ignored(RelationshipEvent event) {
        this.reindexRelationship((Relationship)event.getPayload(), "ignored");
    }

    public void removed(RelationshipEvent event) {
        this.reindexRelationship((Relationship)event.getPayload(), "removed");
    }

    private void reindexRelationship(Relationship relationship, String cause) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String receiverId = relationship.getReceiver().getId();
        String senderId = relationship.getSender().getId();
        LOG.info("Notifying indexing service for connection {} sender_id={} receiver_id={}", new Object[]{cause, senderId, receiverId});
        indexingService.reindex("profile", receiverId);
        indexingService.reindex("profile", senderId);
    }
}

