/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.upgrade;

import io.meeds.social.upgrade.SpaceSettingPermissionUpgradePlugin;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.PageDAOImpl;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/social.component.core-local-portal-configuration.xml")})
public class SpaceSettingPermissionUpgradePluginTest
extends AbstractCoreTest {
    @Override
    protected void setUp() {
        this.begin();
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
    }

    @Test
    public void testProcessUpgrade() {
        SpaceSettingPermissionUpgradePluginTest.assertTrue((boolean)(this.getContainer().getComponentInstanceOfType(PageDAO.class) instanceof PageDAOImpl));
        Space space = this.createSpace("spaceWithSettings", "root");
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        Page page = layoutService.getPage("group::" + space.getGroupId() + "::SpaceSettingPortlet");
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page);
        page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)));
        ((CacheService)this.getContainer().getComponentInstanceOfType(CacheService.class)).getCacheInstance("portal.PageService").clearCache();
        this.restartTransaction();
        new SpaceSettingPermissionUpgradePlugin(this.getEntityManagerService(), this.getInitParams()).processUpgrade(null, null);
        page = layoutService.getPage("group::" + space.getGroupId() + "::SpaceSettingPortlet");
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page);
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page.getAccessPermissions());
        SpaceSettingPermissionUpgradePluginTest.assertEquals((int)1, (int)page.getAccessPermissions().length);
        SpaceSettingPermissionUpgradePluginTest.assertEquals((String)("manager:" + space.getGroupId()), (String)page.getAccessPermissions()[0]);
    }

    private EntityManagerService getEntityManagerService() {
        return (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
    }

    private InitParams getInitParams() {
        InitParams initParams = new InitParams();
        ValueParam productGroupIdValueParam = new ValueParam();
        productGroupIdValueParam.setName("product.group.id");
        productGroupIdValueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)productGroupIdValueParam);
        return initParams;
    }

    private Space createSpace(String spaceName, String creator) {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setTemplate("template");
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.createSpace(space, creator);
        return space;
    }
}

