/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.application.SpaceActivityPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceActivityPublisherTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(SpaceActivityPublisherTest.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private IdentityStorage identityStorage;
    private SpaceService spaceService;
    private SpaceStorage spaceStorage;
    private SpaceActivityPublisher spaceActivityPublisher;
    private List<ExoSocialActivity> tearDownActivityList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        SpaceActivityPublisherTest.assertNotNull((String)"activityManager must not be null", (Object)this.activityManager);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        SpaceActivityPublisherTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        SpaceActivityPublisherTest.assertNotNull((String)"spaceService must not be null", (Object)this.spaceService);
        this.spaceStorage = (SpaceStorage)this.getContainer().getComponentInstanceOfType(SpaceStorage.class);
        SpaceActivityPublisherTest.assertNotNull((Object)this.spaceStorage);
        this.spaceActivityPublisher = (SpaceActivityPublisher)this.getContainer().getComponentInstanceOfType(SpaceActivityPublisher.class);
        SpaceActivityPublisherTest.assertNotNull((String)"spaceActivityPublisher must not be null", (Object)this.spaceActivityPublisher);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        SpaceActivityPublisherTest.assertNotNull((String)"identityStorage must not be null", (Object)this.identityStorage);
    }

    @Override
    public void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                this.LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpaceCreation() throws Exception {
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Space space = new Space();
        space.setDisplayName("Toto 3");
        space.setPrettyName(space.getDisplayName());
        space.setGroupId("/platform/users");
        space.setVisibility("private");
        space.setRegistration("open");
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root"};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.saveSpace(space, true);
        try {
            SpaceActivityPublisherTest.assertNotNull((String)"space.getId() must not be null", (Object)space.getId());
            SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, rootIdentity.getRemoteId(), SpaceLifeCycleEvent.Type.SPACE_CREATED);
            this.spaceActivityPublisher.spaceCreated(event);
            Thread.sleep(3000L);
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            SpaceActivityPublisherTest.assertEquals((int)1, (int)this.activityManager.getActivitiesWithListAccess(identity).getSize());
            ExoSocialActivity activity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(identity).load(0, 1))[0];
            this.tearDownActivityList.add(activity);
            ActivityStream activityStream = activity.getActivityStream();
            SpaceActivityPublisherTest.assertNotNull((String)"activityStream.getId() must not be null", (Object)activityStream.getId());
            SpaceActivityPublisherTest.assertEquals((String)("activityStream.getPrettyId() must return: " + space.getPrettyName()), (String)space.getPrettyName(), (String)activityStream.getPrettyId());
            SpaceActivityPublisherTest.assertEquals((Object)ActivityStream.Type.SPACE, (Object)activityStream.getType());
            SpaceActivityPublisherTest.assertEquals((String)"space", (String)activityStream.getType().toString());
        }
        finally {
            this.spaceService.deleteSpace(space);
            this.identityManager.deleteIdentity(rootIdentity);
        }
    }
}

