/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.authorization;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpacesAdministrationService;

public class AuthorizationManager
extends UserACL {
    private static final String SPACES_GROUP_PREFIX = "/spaces/";
    private SpacesAdministrationService spacesAdministrationService;

    public AuthorizationManager(InitParams params) {
        super(params);
    }

    public boolean hasEditPermission(Identity identity, String ownerType, String ownerId, String expression) {
        return this.isAdministrator(identity, ownerType, ownerId) || super.hasEditPermission(identity, ownerType, ownerId, expression);
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, Stream<String> expressionsStream) {
        return this.isAdministrator(identity, ownerType, ownerId) || super.hasAccessPermission(identity, ownerType, ownerId, expressionsStream);
    }

    private boolean isAdministrator(Identity identity, String ownerType, String ownerId) {
        return PortalConfig.GROUP_TYPE.equalsIgnoreCase(ownerType) && StringUtils.startsWith((CharSequence)ownerId, (CharSequence)SPACES_GROUP_PREFIX) && this.isSpacesAdministrator(identity);
    }

    private boolean isSpacesAdministrator(Identity identity) {
        List spacesAdministrators = this.getSpacesAdministrationService().getSpacesAdministratorsMemberships();
        return CollectionUtils.isNotEmpty((Collection)spacesAdministrators) && spacesAdministrators.stream().anyMatch(permission -> this.isMemberOf(identity, permission.toString()));
    }

    public SpacesAdministrationService getSpacesAdministrationService() {
        if (this.spacesAdministrationService == null) {
            this.spacesAdministrationService = (SpacesAdministrationService)ExoContainerContext.getService(SpacesAdministrationService.class);
        }
        return this.spacesAdministrationService;
    }

    @Generated
    public void setSpacesAdministrationService(SpacesAdministrationService spacesAdministrationService) {
        this.spacesAdministrationService = spacesAdministrationService;
    }
}

