/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.RenderRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.Application;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.PortletInfo;

public class SpaceUtils {
    private static final Log LOG = ExoLogger.getLogger(SpaceUtils.class);
    public static final String SPACE_GROUP = "/spaces";
    public static final String PLATFORM_USERS_GROUP = "/platform/users";
    public static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";
    public static final String PLATFORM_PUBLISHER_GROUP = "/platform/web-contributors";
    public static final String MANAGER = "manager";
    public static final String MEMBER = "member";
    public static final String INTERNAL = "internal";
    public static final String AUTHENTICATED = "authenticated";
    public static final String EVERYONE = "everyone";
    public static final String REDACTOR = "redactor";
    public static final String PUBLISHER = "publisher";
    public static final String PENDING = "pending";
    public static final String INVITED = "invited";
    public static final String IGNORED = "ignored";
    public static final String MENU_CONTAINER = "Menu";
    public static final String APPLICATION_CONTAINER = "Application";
    public static final String SPACE_URL = "SPACE_URL";
    public static final String SPACE_SETTINGS_PAGE = "settings";
    public static final String PUBLIC_SITE_SPACE_ID = "SPACE_ID";
    public static final String IS_PUBLIC_SITE_SPACE = "IS_SPACE_PUBLIC_SITE";
    public static final String CURRENT_SPACE = "CurrentSpace";
    private static final String SPACE_APPLICATIONS = "SpaceApplications";
    private static final ConcurrentHashMap<String, Application> APP_LIST_CACHE = new ConcurrentHashMap();
    private static final String PORTAL_PAGE_TITLE = "portal:requestTitle";
    private static final String NUMBER_REG_PATTERN = "[0-9]";
    private static final String UNDER_SCORE_STR = "_";
    private static final String SPACE_STR = " ";
    private static Set<Portlet> portletsCache = null;

    public static Application getApplication(String appId) {
        return APP_LIST_CACHE.computeIfAbsent(appId, key -> {
            Portlet portlet = SpaceUtils.getPortlets().stream().filter(p -> appId.equals(p.getInfo().getName()) || appId.equals(p.getInfo().getApplicationName() + "/" + p.getInfo().getName())).findFirst().orElse(null);
            if (portlet == null) {
                return null;
            }
            PortletInfo info = portlet.getInfo();
            MetaInfo meta = info.getMeta();
            LocalizedString descriptionLS = meta.getMetaValue("description");
            LocalizedString displayNameLS = meta.getMetaValue("display-name");
            String portletName = info.getName();
            String archiveName = info.getApplicationName();
            Application app = new Application();
            app.setContentId(archiveName + "/" + portletName);
            app.setApplicationName(portletName);
            app.setDisplayName(SpaceUtils.getLocalizedStringValue(displayNameLS, portletName));
            app.setDescription(SpaceUtils.getLocalizedStringValue(descriptionLS, portletName));
            return app;
        });
    }

    public static String cleanString(String str) {
        return Utils.cleanString((String)str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameGroupLabel(Space space) {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            group.setLabel(space.getDisplayName());
            groupHandler.saveGroup(group, true);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public static void updateDefaultSpaceAvatar(Space space) {
        Identity spaceIdentity;
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        FileItem spaceAvatar = identityManager.getAvatarFile(spaceIdentity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        if (spaceAvatar != null && spaceAvatar.getFileInfo().getId() != null && "DEFAULT_AVATAR".equals(spaceAvatar.getFileInfo().getName())) {
            Profile profile = spaceIdentity.getProfile();
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
            profile.setProperty("fullName", (Object)space.getDisplayName());
            space.setAvatarAttachment(null);
            space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
            identityManager.updateProfile(profile);
            FileService fileService = (FileService)CommonsUtils.getService(FileService.class);
            fileService.deleteFile(spaceAvatar.getFileInfo().getId().longValue());
        }
    }

    public static UserNode renamePageNode(Space space) {
        try {
            LayoutService layoutService = (LayoutService)CommonsUtils.getService(LayoutService.class);
            UserNode renamedNode = SpaceUtils.getSpaceUserNode(space);
            UserNode parentNode = renamedNode.getParent();
            String newNodeLabel = space.getDisplayName();
            String newNodeName = Utils.cleanString((String)newNodeLabel);
            renamedNode.setName(newNodeName);
            Page page = layoutService.getPage(renamedNode.getPageRef().format());
            if (page != null) {
                page.setTitle(newNodeLabel);
                layoutService.save(page);
            }
            SpaceUtils.getUserPortal().saveNode(parentNode, null);
            space.setUrl(newNodeName);
            SpaceUtils.changeAppPageTitle(renamedNode, newNodeLabel);
            ArrayList userNodes = new ArrayList(renamedNode.getChildren());
            for (UserNode childNode : userNodes) {
                SpaceUtils.changeAppPageTitle(childNode, newNodeLabel);
            }
            return renamedNode;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getSpaceUrl() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        return space != null ? space.getUrl() : null;
    }

    public static boolean isSpaceContext() {
        return SpaceUtils.getSpaceByContext() != null;
    }

    public static String getSpaceUrlByContext() {
        Space space = SpaceUtils.getSpaceByContext();
        return space != null ? space.getUrl() : null;
    }

    public static Space getSpaceByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        Object currentSpaceObject = pcontext.getAttribute(CURRENT_SPACE);
        if (currentSpaceObject != null) {
            if (Objects.equals(currentSpaceObject, "")) {
                return null;
            }
            return (Space)currentSpaceObject;
        }
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith(SPACE_GROUP)) {
            SpaceUtils.setSpaceByContext(pcontext, "");
            return null;
        }
        SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        Space currentSpace = spaceService.getSpaceByGroupId(pcontext.getSiteName());
        SpaceUtils.setSpaceByContext(pcontext, currentSpace);
        return currentSpace;
    }

    public static void setSpaceByContext(PortalRequestContext context, Object space) {
        context.setAttribute(CURRENT_SPACE, space);
    }

    public static Identity getSpaceIdentityByContext() {
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
            return identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        }
        return null;
    }

    public static void removePagesAndGroupNavigation(Space space) throws Exception {
        LayoutService layoutService = SpaceUtils.getLayoutService();
        String groupId = space.getGroupId();
        NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(groupId);
        if (spaceNavCtx == null) {
            return;
        }
        NodeContext<NodeContext<?>> homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(spaceNavCtx, groupId);
        Iterator iterator = homeNodeCtx.getNodes().iterator();
        while (iterator.hasNext()) {
            NodeContext child;
            NodeContext childNode = child = (NodeContext)iterator.next();
            Page page = layoutService.getPage(childNode.getState().getPageRef().format());
            layoutService.remove(page);
        }
        SpaceUtils.removeGroupNavigation(groupId);
    }

    public static void changeAppPageTitle(UserNode spacePageNode, String newSpaceName) throws Exception {
        String dispalyname;
        if (spacePageNode == null || spacePageNode.getPageRef() == null) {
            return;
        }
        LayoutService layoutService = SpaceUtils.getLayoutService();
        Page page = layoutService.getPage(spacePageNode.getPageRef().format());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PageStorage pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        PageContext pageContext = pageStorage.loadPage(page.getPageKey());
        if (pageContext != null && pageContext.getState() != null && (dispalyname = pageContext.getState().getDisplayName()) != null && !dispalyname.isEmpty() && dispalyname.indexOf("-") != -1) {
            String newPageTitle = newSpaceName + " -" + dispalyname.split("-")[1];
            pageContext.setState(pageContext.getState().builder().displayName(newPageTitle).build());
            pageStorage.savePage(pageContext);
        }
    }

    public static void changeMenuPortletPreference(Container menuContainer, LayoutService layoutService, Space space) {
        org.exoplatform.portal.config.model.Application menuPortlet = (org.exoplatform.portal.config.model.Application)menuContainer.getChildren().get(0);
        ApplicationState menuState = menuPortlet.getState();
        try {
            org.exoplatform.portal.pom.spi.portlet.Portlet menuPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)layoutService.load(menuState, ApplicationType.PORTLET);
            menuPortletPreference.setValue(SPACE_URL, space.getUrl());
            layoutService.save(menuState, (Object)menuPortletPreference);
        }
        catch (Exception e) {
            LOG.warn((Object)"Can not save menu portlet preference!", (Throwable)e);
        }
    }

    public static void changeAppPortletPreference(Container applicationContainer, LayoutService layoutService, Space space) {
        try {
            org.exoplatform.portal.config.model.Application applicationPortlet = (org.exoplatform.portal.config.model.Application)applicationContainer.getChildren().get(0);
            ApplicationState appState = applicationPortlet.getState();
            try {
                org.exoplatform.portal.pom.spi.portlet.Portlet appPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)layoutService.load(appState, ApplicationType.PORTLET);
                if (appPortletPreference == null || appPortletPreference.getPreference(SPACE_URL) == null) {
                    return;
                }
                appPortletPreference.setValue(SPACE_URL, space.getUrl());
                layoutService.save(appState, (Object)appPortletPreference);
            }
            catch (Exception e) {
                LOG.warn((Object)"Can not save application portlet preference!", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when change application porltet preference!", (Throwable)e);
        }
    }

    public static void restartRequest() {
        RequestLifeCycle.end();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)container);
    }

    public static Container findContainerById(ArrayList<ModelObject> children, String id) {
        Container found = null;
        for (ModelObject obj : children) {
            if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
            Container child = (Container)obj;
            if (child.getId() == null) {
                found = SpaceUtils.findContainerById(child.getChildren(), id);
                if (found == null) continue;
                return found;
            }
            if (child.getId().equals(id)) {
                return child;
            }
            found = SpaceUtils.findContainerById(child.getChildren(), id);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    public static void setNavigation(UserNavigation nav) {
        if (nav == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        try {
            UserNode selectedNav = Util.getUIPortal().getSelectedUserNode();
            if (selectedNav.getId() == nav.getKey().getName()) {
                Util.getUIPortal().setNavPath(selectedNav);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void removeNavigation(UserNavigation nav) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        try {
            navService.destroyNavigation(new NavigationContext(nav.getKey(), new NavigationState(Integer.valueOf(1))));
        }
        catch (NavigationServiceException nex) {
            LOG.warn((Object)"Failed to remove navigations", (Throwable)nex);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove navigations", (Throwable)e);
        }
    }

    public static void updateWorkingWorkSpace() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApplication.getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static String createGroup(String spaceName, String creator) throws SpaceException {
        return SpaceUtils.createGroup(spaceName, spaceName, creator);
    }

    public static String createGroup(String groupLabel, String spaceName, String creator) throws SpaceException {
        String groupId;
        Group newGroup;
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = organizationService.getGroupHandler();
        try {
            Group parentGroup = groupHandler.findGroupById(SPACE_GROUP);
            newGroup = groupHandler.createGroupInstance();
            String shortName = Utils.cleanString((String)spaceName);
            groupId = parentGroup.getId() + "/" + shortName;
            SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
            if (spaceService.getSpaceByGroupId(groupId) != null) {
                shortName = SpaceUtils.buildGroupId(shortName, parentGroup.getId());
                groupId = parentGroup.getId() + "/" + shortName;
            }
            if (SpaceUtils.isSpaceNameExisted(spaceName)) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(shortName);
            newGroup.setLabel(groupLabel);
            newGroup.setDescription("the " + parentGroup.getId() + "/" + shortName + " group");
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                SpaceException spaceException = (SpaceException)((Object)e);
                throw spaceException;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            SpaceUtils.addCreatorToGroup(creator, groupId);
            return groupId;
        }
        catch (Exception e) {
            try {
                groupHandler.removeGroup(newGroup, true);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Unable to rollback group creation after a failure in space group creation. Throw original exception to stop space creation only.", (Throwable)ex);
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
    }

    public static void removeGroup(Space space) throws SpaceException {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_GROUP, (Throwable)e);
        }
    }

    public static void removeMembershipFromGroup(Space space) {
        if (space == null) {
            return;
        }
        if (space.getMembers() != null) {
            for (String userId : space.getMembers()) {
                SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            }
        }
        if (space.getManagers() != null) {
            for (String userId : space.getManagers()) {
                SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            }
        }
        if (space.getRedactors() != null) {
            for (String userId : space.getRedactors()) {
                SpaceUtils.removeUserFromGroupWithRedactorMembership(userId, space.getGroupId());
            }
        }
        if (space.getPublishers() != null) {
            for (String userId : space.getPublishers()) {
                SpaceUtils.removeUserFromGroupWithPublisherMembership(userId, space.getGroupId());
            }
        }
    }

    public static boolean isSpaceNameExisted(String spaceName) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        return spaceService.getSpaceByPrettyName(Utils.cleanString((String)spaceName)) != null;
    }

    public static void addCreatorToGroup(String creator, String groupId) {
        SpaceUtils.addUserToGroupWithMemberMembership(creator, groupId);
        SpaceUtils.addUserToGroupWithManagerMembership(creator, groupId);
    }

    private static void addUserToGroupWithMembership(String remoteId, String groupId, String membership) {
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        try {
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            Membership found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
            if (found == null && !"*".equalsIgnoreCase(membership)) {
                found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
            }
            if (found != null) {
                LOG.debug("user: {} was already added to group: {} with membership * or : {}", new Object[]{remoteId, groupId, membership});
                return;
            }
            User user = organizationService.getUserHandler().findUserByName(remoteId);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            membershipHandler.linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to add user: " + remoteId + " to group: " + groupId + " with membership: " + membership, e);
        }
        finally {
            Space space;
            SpaceUtils.clearIdentityCaching("organization", remoteId);
            if (groupId.startsWith(SPACE_GROUP) && (space = SpaceUtils.getSpaceService().getSpaceByGroupId(groupId)) != null) {
                SpaceUtils.clearIdentityCaching("space", space.getPrettyName());
                SpaceUtils.clearSpaceCache(space.getId());
            }
        }
    }

    public static void addUserToGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void addUserToGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void addUserToGroupWithPublisherMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, PUBLISHER);
    }

    public static void addUserToGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, SpaceUtils.getUserACL().getAdminMSType());
    }

    private static void removeUserFromGroupWithMembership(String remoteId, String groupId, String membership) {
        try {
            Space space;
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
            if (MEMBER.equals(membership)) {
                Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(remoteId, groupId);
                if (CollectionUtils.isEmpty((Collection)memberships)) {
                    LOG.debug((Object)("User: " + remoteId + " is not a member of group: " + groupId));
                    return;
                }
                for (Membership mbShip : memberships) {
                    memberShipHandler.removeMembership(mbShip.getId(), true);
                }
            } else {
                Membership memberShip = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
                Membership any = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
                if (any != null) {
                    memberShipHandler.removeMembership(any.getId(), true);
                }
                if (memberShip == null) {
                    LOG.debug((Object)("User: " + remoteId + " is not a " + membership + " of group: " + groupId));
                    return;
                }
                UserHandler userHandler = organizationService.getUserHandler();
                User user = userHandler.findUserByName(remoteId);
                memberShipHandler.removeMembership(memberShip.getId(), true);
                MembershipType mbShipTypeMember = organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
                GroupHandler groupHandler = organizationService.getGroupHandler();
                memberShipHandler.linkMembership(user, groupHandler.findGroupById(groupId), mbShipTypeMember, true);
            }
            SpaceUtils.clearIdentityCaching("organization", remoteId);
            if (groupId.startsWith(SPACE_GROUP) && (space = SpaceUtils.getSpaceService().getSpaceByGroupId(groupId)) != null) {
                SpaceUtils.clearIdentityCaching("space", space.getPrettyName());
                SpaceUtils.clearSpaceCache(space.getId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to remove user: " + remoteId + " to group: " + groupId + " with membership: " + membership), (Throwable)e);
        }
    }

    public static void removeUserFromGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void removeUserFromGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void removeUserFromGroupWithPublisherMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, PUBLISHER);
    }

    public static void removeUserFromGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, SpaceUtils.getUserACL().getAdminMSType());
    }

    public static void removeUserFromGroupWithAnyMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, "*");
    }

    public static NavigationContext createGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NavigationContext navContext = navService.loadNavigation(SiteKey.group((String)groupId));
        try {
            if (navContext == null) {
                navContext = new NavigationContext(SiteKey.group((String)groupId), new NavigationState(Integer.valueOf(1)));
                navService.saveNavigation(navContext);
            }
            return navContext;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    public static void refreshNavigation() {
        try {
            UserPortal userPortal = SpaceUtils.getUserPortal();
            if (userPortal != null) {
                userPortal.refresh();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"It seem that we don't have a WebUI context, ignoring.", (Throwable)e);
            }
            LOG.warn("It seem that we don't have a WebUI context, error message: {}. Ignoring.", new Object[]{e.getMessage()});
        }
    }

    public static UserPortal getUserPortal() {
        try {
            PortalRequestContext prc = Util.getPortalRequestContext();
            return prc.getUserPortalConfig().getUserPortal();
        }
        catch (Exception e) {
            try {
                return SpaceUtils.getUserPortalForRest();
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public static UserNode getParentNode() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserPortal userPortal = SpaceUtils.getUserPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        UserNode currParent = selectedNode.getParent();
        if (currParent != null) {
            try {
                userPortal.updateNode(currParent, Scope.CHILDREN, null);
            }
            catch (NavigationServiceException e) {
                currParent = null;
            }
        }
        return currParent;
    }

    public static UserPortal getUserPortalForRest() throws Exception {
        return SpaceUtils.getUserPortalConfig().getUserPortal();
    }

    public static UserPortalConfig getUserPortalConfig() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        ConversationState conversationState = ConversationState.getCurrent();
        String remoteId = conversationState == null ? null : conversationState.getIdentity().getUserId();
        return userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getMetaPortal(), remoteId);
    }

    public static void removeGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        try {
            NavigationContext nav = navService.loadNavigation(SiteKey.group((String)groupId));
            if (nav == null) {
                throw new Exception("spaceNav is null");
            }
            navService.destroyNavigation(nav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_NAV, (Throwable)e);
        }
    }

    public static NavigationContext getGroupNavigationContext(String groupId) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        return navService.loadNavigation(SiteKey.group((String)groupId));
    }

    public static UserNavigation getGroupNavigation(String groupId) throws Exception {
        UserPortal userPortal = SpaceUtils.getUserPortal();
        if (userPortal != null) {
            return SpaceUtils.getUserPortal().getNavigation(SiteKey.group((String)groupId));
        }
        return null;
    }

    public static UserNode getHomeNode(UserNavigation userNavigation, String spaceUrl) {
        return SpaceUtils.getUserPortal().resolvePath(userNavigation, null, spaceUrl);
    }

    public static UserNode getHomeNode(UserNavigation userNavigation) {
        return SpaceUtils.getUserPortal().getNode(userNavigation, Scope.SINGLE, null, null);
    }

    public static NodeContext<NodeContext<?>> getHomeNodeWithChildren(NavigationContext spaceNavCtx, String spaceUrl) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        return SpaceUtils.loadNode(navService, spaceNavCtx, spaceUrl);
    }

    public static UserNode getHomeNodeWithChildren(UserNavigation userNavigation, String spaceUrl) {
        UserNode homeNode = SpaceUtils.getUserPortal().resolvePath(userNavigation, null, spaceUrl);
        SpaceUtils.getUserPortal().updateNode(homeNode, Scope.CHILDREN, null);
        return homeNode;
    }

    public static UserNode getSpaceUserNode(Space space) throws Exception {
        return SpaceUtils.getSpaceUserNode(space, null);
    }

    public static UserNode getSpaceUserNode(Space space, UserNodeFilterConfig filter) throws Exception {
        NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(space.getGroupId());
        UserNode spaceUserNode = null;
        UserPortal userPortal = SpaceUtils.getUserPortal();
        if (userPortal != null) {
            UserNavigation userNavigation = userPortal.getNavigation(spaceNavCtx.getKey());
            UserNode parentUserNode = userPortal.getNode(userNavigation, Scope.CHILDREN, filter, null);
            UserNode userNode = spaceUserNode = parentUserNode.getChildrenSize() > 0 ? parentUserNode.getChild(0) : null;
        }
        if (spaceUserNode == null) {
            LOG.warn("Failed to get spaceUserNode of group {}", new Object[]{space.getGroupId()});
        } else {
            userPortal.updateNode(spaceUserNode, Scope.CHILDREN, null);
        }
        return spaceUserNode;
    }

    public static List<UserNode> getSpaceUserNodeChildren(Space space) throws Exception {
        return new ArrayList<UserNode>(SpaceUtils.getSpaceUserNode(space).getChildren());
    }

    public static List<Space> getOrderedSpaces(List<Space> spaces) {
        Iterator<Space> itr = spaces.iterator();
        ArrayList<Space> orderedSpaces = new ArrayList<Space>();
        ArrayList<Space> middleSpaces = new ArrayList<Space>();
        ArrayList<Space> lowSpaces = new ArrayList<Space>();
        Space space = null;
        while (itr.hasNext()) {
            space = itr.next();
            String priority = space.getPriority();
            if (priority.equals("1")) {
                orderedSpaces.add(space);
                continue;
            }
            if (priority.equals("2")) {
                middleSpaces.add(space);
                continue;
            }
            if (!priority.equals("3")) continue;
            lowSpaces.add(space);
        }
        for (Space sp : middleSpaces) {
            orderedSpaces.add(sp);
        }
        for (Space sp : lowSpaces) {
            orderedSpaces.add(sp);
        }
        return orderedSpaces;
    }

    public static int countMembers(Space space) throws SpaceException {
        if (space.getMembers() != null) {
            return space.getMembers().length;
        }
        return 0;
    }

    public static String getAppStatus(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPattern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPattern.split(":")[3];
        }
        return null;
    }

    public static String getAppNodeName(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPatern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPatern.split(":")[1];
        }
        return null;
    }

    public static boolean isRemovableApp(Space space, String appId) {
        String appStatus;
        String[] spliter;
        String installedApps = space.getApp();
        return !installedApps.contains(appId) || !(spliter = (appStatus = SpaceUtils.getAppStatusPattern(installedApps, appId)).split(":"))[2].equals("false");
    }

    public static List<String> getAppIdList(Space space) {
        ArrayList<String> appIdList = new ArrayList<String>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            if (installedApps.contains(",")) {
                String[] appStatuses;
                for (String appStatus : appStatuses = installedApps.split(",")) {
                    appIdList.add(appStatus.split(":")[0]);
                }
            } else {
                appIdList.add(installedApps.split(":")[0]);
            }
        }
        return appIdList;
    }

    public static String getAbsoluteUrl() throws SpaceException {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.substring(0, str.indexOf(portalRequestContext.getRequestContextPath()));
    }

    public static void checkUserExisting(String userName) throws SpaceException {
        OrganizationService orgService = SpaceUtils.getOrganizationService();
        User user = null;
        try {
            user = orgService.getUserHandler().findUserByName(userName);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (user == null) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER);
        }
    }

    public static boolean isInstalledApp(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return false;
        }
        String[] apps = installedApps.split(",");
        for (int idx = 0; idx < apps.length; ++idx) {
            String[] appPart = apps[idx].split(":");
            if (!appPart[0].equals(appId) && (appPart.length <= 1 || !appPart[1].equals(appId))) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayAppName(String appDisplayName) {
        int length = appDisplayName.length();
        if (appDisplayName.toLowerCase().endsWith("portlet")) {
            return appDisplayName.substring(0, length - 7).trim();
        }
        return appDisplayName;
    }

    private static String getAppStatusPattern(String installedApps, String appId) {
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String[] apps;
            for (String app : apps = installedApps.split(",")) {
                if (!app.contains(appId)) continue;
                String[] splited = app.split(":");
                if (splited.length != 4) {
                    LOG.warn((Object)("appStatus is not in correct form of [appId:appNodeName:isRemovableString:status] : " + app));
                    return null;
                }
                return app;
            }
        }
        return null;
    }

    public static OrganizationService getOrganizationService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
    }

    public static LayoutService getLayoutService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (LayoutService)portalContainer.getComponentInstanceOfType(LayoutService.class);
    }

    private static boolean hasViewPermission(String expPerm, String groupId) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String tempExp = temp[1].trim();
        return tempExp.equals(groupId) || tempExp.equals(PLATFORM_USERS_GROUP);
    }

    private static String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    public static String buildGroupId(String prettyName, String parentGroupId) {
        String checkedGroupId = prettyName;
        String mainPatternGroupId = null;
        String numberPattern = NUMBER_REG_PATTERN;
        mainPatternGroupId = checkedGroupId.substring(checkedGroupId.lastIndexOf(UNDER_SCORE_STR) + 1).matches(numberPattern) ? checkedGroupId.substring(0, checkedGroupId.lastIndexOf(UNDER_SCORE_STR)) : checkedGroupId;
        boolean hasNext = true;
        int extendPattern = 0;
        while (hasNext) {
            IdentityManager idm;
            Identity identity;
            checkedGroupId = Utils.cleanString((String)(mainPatternGroupId + SPACE_STR + ++extendPattern));
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            if (spaceService.getSpaceByGroupId(parentGroupId + "/" + checkedGroupId) != null || (identity = (idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class)).getOrCreateIdentity("space", checkedGroupId, true)) != null) continue;
            hasNext = false;
        }
        return checkedGroupId;
    }

    public static String buildPrettyName(Space space) {
        String checkedPrettyName = space.getPrettyName();
        String mainPatternPrettyName = null;
        String numberPattern = NUMBER_REG_PATTERN;
        mainPatternPrettyName = checkedPrettyName.substring(checkedPrettyName.lastIndexOf(UNDER_SCORE_STR) + 1).matches(numberPattern) ? checkedPrettyName.substring(0, checkedPrettyName.lastIndexOf(UNDER_SCORE_STR)) : checkedPrettyName;
        boolean hasNext = true;
        int extendPattern = 0;
        while (hasNext) {
            checkedPrettyName = Utils.cleanString((String)(mainPatternPrettyName + SPACE_STR + ++extendPattern));
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("space", checkedPrettyName, true);
            if (identity != null) continue;
            hasNext = false;
        }
        return checkedPrettyName;
    }

    public static UserACL getUserACL() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (UserACL)container.getComponentInstanceOfType(UserACL.class);
    }

    public static NodeContext<NodeContext<?>> loadNode(NavigationService navigationService, NavigationContext navigation, String navUri) {
        if (navigation == null) {
            return null;
        }
        if (navUri != null) {
            String name;
            String[] path = SpaceUtils.trim(navUri.split("/"));
            NodeContext node = navigationService.loadNode(NodeModel.SELF_MODEL, navigation, GenericScope.branchShape((String[])path, (Scope)Scope.ALL), null);
            String[] stringArray = path;
            int n = stringArray.length;
            for (int i = 0; i < n && (node = node.get(name = stringArray[i])) != null; ++i) {
            }
            return node;
        }
        return navigationService.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
    }

    public static List<UserNode> getSpaceNavigations(Space space, Locale locale, String currentuser) {
        ArrayList<UserNode> navigations = new ArrayList<UserNode>();
        try {
            UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
            filterConfigBuilder.withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
            filterConfigBuilder.withTemporalCheck();
            UserNodeFilterConfig filter = filterConfigBuilder.build();
            UserNode parentNavigation = SpaceUtils.getSpaceUserNode(space, filter);
            UserNode settingNavigation = parentNavigation.getChild(SPACE_SETTINGS_PAGE);
            if (!SpaceUtils.hasSettingPermission(space, currentuser) && settingNavigation != null) {
                parentNavigation.removeChild(settingNavigation.getName());
            }
            navigations.add(parentNavigation);
            navigations.addAll(parentNavigation.getChildren());
            SpaceUtils.filterUnreachablePages(navigations);
            SpaceUtils.computeNavigationLabels(navigations, locale);
        }
        catch (Exception e) {
            LOG.error((Object)"Get UserNode of Space failed.", (Throwable)e);
        }
        return navigations;
    }

    public static String getUri(UserNode userNode) {
        String uri = userNode.getURI();
        if (!uri.startsWith("/" + PortalContainer.getCurrentPortalContainerName())) {
            uri = NavigationURLUtils.getURL((UserNode)userNode);
        }
        return uri;
    }

    public static void computeNavigationLabels(List<UserNode> navigations, Locale locale) {
        ResourceBundle resourceBundle = SpaceUtils.getSharedResourceBundle(locale);
        for (UserNode node : navigations) {
            if (node == null) continue;
            String nodeTitle = SpaceUtils.getResolvedAppLabel(node, resourceBundle, locale);
            node.setLabel(null);
            node.setResolvedLabel(nodeTitle);
        }
    }

    public static boolean hasSettingPermission(Space space, String username) {
        return SpaceUtils.getSpaceService().hasSettingPermission(space, username);
    }

    public static boolean isHomeNavigation(UserNode node) {
        return node.getParent() == null || StringUtils.equals((CharSequence)node.getParent().getName(), (CharSequence)"default") || node.getParent().getParent() == null;
    }

    public static String getResolvedAppLabel(UserNode userNode, ResourceBundle resourceBundle, Locale locale) {
        DescriptionStorage descriptionStorage;
        State description;
        if (userNode == null) {
            return null;
        }
        String id = userNode.getId();
        String nodeLabel = userNode.getLabel();
        if (nodeLabel != null) {
            return ExpressionUtil.getExpressionValue((ResourceBundle)resourceBundle, (String)nodeLabel);
        }
        if (id != null && (description = (descriptionStorage = SpaceUtils.getUserPortalConfigService().getDescriptionService()).resolveDescription(id, locale)) != null && !StringUtils.equals((CharSequence)description.getName(), (CharSequence)userNode.getName())) {
            return description.getName();
        }
        String labelKey = userNode.getPageRef().getName() + ".label.name";
        if (resourceBundle.containsKey(labelKey)) {
            return resourceBundle.getString(labelKey);
        }
        return userNode.getName();
    }

    public static void filterUnreachablePages(List<UserNode> nodes) {
        ArrayList<UserNode> nonePageNodes = new ArrayList<UserNode>();
        UserACL userACL = SpaceUtils.getUserACL();
        for (UserNode node : nodes) {
            PageKey currentPage = node.getPageRef();
            if (currentPage == null) {
                nonePageNodes.add(node);
                continue;
            }
            PageContext currentPageContext = SpaceUtils.getPageStorage().loadPage(currentPage);
            if (currentPageContext != null && userACL.hasAccessPermission(currentPageContext, ConversationState.getCurrent().getIdentity())) continue;
            nonePageNodes.add(node);
        }
        nodes.removeAll(nonePageNodes);
    }

    public static void setPageTitle(List<UserNode> navigations, RenderRequest request, Space space, Locale locale) throws Exception {
        UserNode selectedUserNode = Util.getUIPortal().getSelectedUserNode();
        String selectedUserNodeId = selectedUserNode.getId();
        String selectedUserNodeLabel = navigations.stream().filter(node -> StringUtils.equals((CharSequence)node.getId(), (CharSequence)selectedUserNodeId)).map(UserNode::getResolvedLabel).findFirst().orElse(null);
        if (selectedUserNodeLabel == null) {
            ResourceBundle resourceBundle = SpaceUtils.getSharedResourceBundle(locale);
            selectedUserNodeLabel = SpaceUtils.getResolvedAppLabel(selectedUserNode, resourceBundle, locale);
        }
        ((PortalRequestContext)RequestContext.getCurrentInstance()).getRequest().setAttribute(PORTAL_PAGE_TITLE, (Object)(space.getDisplayName() + " - " + selectedUserNodeLabel));
    }

    public static UserPortalConfigService getUserPortalConfigService() {
        return (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
    }

    public static PageStorage getPageStorage() {
        return (PageStorage)ExoContainerContext.getService(PageStorage.class);
    }

    public static SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getService(SpaceService.class);
    }

    public static ResourceBundle getSharedResourceBundle(Locale locale) {
        return SpaceUtils.getResourceBundleService().getResourceBundle(SpaceUtils.getSharedResources(), locale);
    }

    public static ResourceBundleService getResourceBundleService() {
        return (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
    }

    public static String[] getSharedResources() {
        return SpaceUtils.getResourceBundleService().getSharedResourceBundleNames();
    }

    private static String[] trim(String[] array) {
        ArrayList<String> trimmed = new ArrayList<String>(array.length);
        for (String s : array) {
            if (s == null || "".equals(s)) continue;
            trimmed.add(s);
        }
        return trimmed.toArray(new String[trimmed.size()]);
    }

    private static void clearIdentityCaching(String providerId, String remoteId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CachedIdentityStorage cachedIdentityStorage = (CachedIdentityStorage)container.getComponentInstanceOfType(CachedIdentityStorage.class);
        cachedIdentityStorage.clearIdentityCache(providerId, remoteId, false);
    }

    private static void clearSpaceCache(String spaceId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CachedSpaceStorage cachedSpaceStorage = (CachedSpaceStorage)container.getComponentInstanceOfType(CachedSpaceStorage.class);
        cachedSpaceStorage.clearSpaceCached(spaceId);
    }

    private static Set<Portlet> getPortlets() {
        if (portletsCache == null) {
            portletsCache = ((PortletInvoker)ExoContainerContext.getService(PortletInvoker.class)).getPortlets();
        }
        return portletsCache;
    }

    static class PortletComparator
    implements Comparator<Application> {
        PortletComparator() {
        }

        @Override
        public int compare(Application p1, Application p2) {
            return p1.getDisplayName().compareTo(p2.getDisplayName());
        }
    }
}

