/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceExternalInvitationDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListSpacesData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceSimpleData;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpacesKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceRefKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.LastAccessedSpacesCacheSelector;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class CachedSpaceStorage
extends RDBMSSpaceStorageImpl {
    private static final Log LOG = ExoLogger.getLogger(CachedSpaceStorage.class);
    private final ExoCache<SpaceKey, SpaceData> exoSpaceCache;
    private final ExoCache<SpaceKey, SpaceSimpleData> exoSpaceSimpleCache;
    private final ExoCache<SpaceRefKey, SpaceKey> exoRefSpaceCache;
    private final ExoCache<SpaceFilterKey, IntegerData> exoSpacesCountCache;
    private final ExoCache<ListSpacesKey, ListSpacesData> exoSpacesCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> exoIdentitiesCache;
    private final FutureExoCache<SpaceKey, SpaceData, ServiceContext<SpaceData>> spaceCache;
    private final FutureExoCache<SpaceKey, SpaceSimpleData, ServiceContext<SpaceSimpleData>> spaceSimpleCache;
    private final FutureExoCache<SpaceRefKey, SpaceKey, ServiceContext<SpaceKey>> spaceRefCache;
    private final FutureExoCache<SpaceFilterKey, IntegerData, ServiceContext<IntegerData>> spacesCountCache;
    private final FutureExoCache<ListSpacesKey, ListSpacesData, ServiceContext<ListSpacesData>> spacesCache;
    private SocialStorageCacheService cacheService;
    private CachedActivityStorage cachedActivityStorage;
    private CachedIdentityStorage cachedIdentityStorage;

    private List<Space> buildSpaces(ListSpacesData data) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (SpaceKey k : data.getIds()) {
            Space s = this.getSpaceById(k.getId());
            spaces.add(s);
        }
        return spaces;
    }

    private List<String> buildIds(ListSpacesData data) {
        if (data == null || data.getIds() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> identityIds = new ArrayList<String>();
        for (SpaceKey k : data.getIds()) {
            identityIds.add(k.getId());
        }
        return identityIds;
    }

    private List<Space> buildSimpleSpaces(ListSpacesData data) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (SpaceKey k : data.getIds()) {
            Space s = this.getSpaceSimpleById(k.getId());
            spaces.add(s);
        }
        return spaces;
    }

    public CachedActivityStorage getCachedActivityStorage() {
        if (this.cachedActivityStorage == null) {
            this.cachedActivityStorage = (CachedActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedActivityStorage.class);
        }
        return this.cachedActivityStorage;
    }

    public CachedIdentityStorage getCachedIdentityStorage() {
        if (this.cachedIdentityStorage == null) {
            this.cachedIdentityStorage = (CachedIdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedIdentityStorage.class);
        }
        return this.cachedIdentityStorage;
    }

    private ListSpacesData buildIds(List<Space> spaces) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (Space s : spaces) {
            SpaceKey k = this.putSpaceInCacheIfNotExists(s);
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    private ListSpacesData buildListIdentityIds(List<String> identities) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (String identityId : identities) {
            SpaceKey k = new SpaceKey(identityId);
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    private ListSpacesData buildSimpleIds(List<Space> spaces) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (Space s : spaces) {
            SpaceKey k = this.putSpaceInCacheIfNotExists(s);
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    public CachedSpaceStorage(SpaceDAO spaceDAO, SpaceMemberDAO spaceMemberDAO, IdentityStorage identityStorage, IdentityDAO identityDAO, ActivityDAO activityDAO, SpaceExternalInvitationDAO spaceExternalInvitationDAO, SocialStorageCacheService cacheService, FavoriteService favoriteService, RemindPasswordTokenService remindPasswordTokenService) {
        super(spaceDAO, spaceMemberDAO, identityStorage, identityDAO, activityDAO, spaceExternalInvitationDAO, favoriteService, remindPasswordTokenService);
        this.cacheService = cacheService;
        this.exoSpaceCache = cacheService.getSpaceCache();
        this.exoSpaceSimpleCache = cacheService.getSpaceSimpleCache();
        this.exoRefSpaceCache = cacheService.getSpaceRefCache();
        this.exoSpacesCountCache = cacheService.getSpacesCountCache();
        this.exoSpacesCache = cacheService.getSpacesCache();
        this.exoIdentitiesCache = cacheService.getIdentitiesCache();
        this.spaceCache = CacheType.SPACE.createFutureCache(this.exoSpaceCache);
        this.spaceSimpleCache = CacheType.SPACE_SIMPLE.createFutureCache(this.exoSpaceSimpleCache);
        this.spaceRefCache = CacheType.SPACE_REF.createFutureCache(this.exoRefSpaceCache);
        this.spacesCountCache = CacheType.SPACES_COUNT.createFutureCache(this.exoSpacesCountCache);
        this.spacesCache = CacheType.SPACES.createFutureCache(this.exoSpacesCache);
    }

    private void cleanRef(Space removed) {
        if (removed == null) {
            return;
        }
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(removed.getDisplayName()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, removed.getPrettyName()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, removed.getGroupId()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, null, removed.getUrl()));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(removed.getDisplayName()));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(null, removed.getPrettyName()));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(null, null, removed.getGroupId()));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(null, null, null, removed.getUrl()));
    }

    void clearIdentityCache() {
        try {
            this.exoIdentitiesCache.select((CachedObjectSelector)new IdentityCacheSelector("space"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error deleting cache entries of provider type 'Space Identities'", (Throwable)e);
        }
    }

    void clearSpaceCache() {
        try {
            this.exoSpacesCache.clearCache();
            this.exoSpacesCountCache.clearCache();
        }
        catch (Exception e) {
            LOG.error((Object)"Error deleting space caches", (Throwable)e);
        }
    }

    @Override
    public Space getSpaceByDisplayName(final String spaceDisplayName) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(spaceDisplayName);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get((Object)new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.super.getSpaceByDisplayName(spaceDisplayName);
                if (space != null) {
                    return CachedSpaceStorage.this.putSpaceInCacheIfNotExists(space);
                }
                return SpaceKey.NULL_OBJECT;
            }
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        super.saveSpace(space, isNew);
        this.exoSpaceSimpleCache.remove((Serializable)new SpaceKey(space.getId()));
        this.exoSpaceCache.remove((Serializable)new SpaceKey(space.getId()));
        this.clearSpaceCache();
        this.clearIdentityCache();
        this.cleanRef(space);
    }

    @Override
    public void renameSpace(Space space, String newDisplayName) throws SpaceStorageException {
        String oldDisplayName = space.getDisplayName();
        String oldUrl = Utils.cleanString((String)oldDisplayName);
        String oldPrettyName = space.getPrettyName();
        super.renameSpace(space, newDisplayName);
        this.cachedIdentityStorage = this.getCachedIdentityStorage();
        Identity identitySpace = this.cachedIdentityStorage.findIdentity("space", space.getPrettyName());
        if (identitySpace == null) {
            identitySpace = this.cachedIdentityStorage.findIdentity("space", oldPrettyName);
        }
        if (identitySpace != null) {
            this.cachedIdentityStorage.clearIdentityCached(identitySpace, oldPrettyName);
        }
        this.cachedActivityStorage = this.getCachedActivityStorage();
        this.cachedActivityStorage.clearOwnerStreamCache(oldPrettyName);
        this.exoSpaceCache.remove((Serializable)new SpaceKey(space.getId()));
        this.clearSpaceCache();
        this.clearIdentityCache();
        this.cleanRef(space);
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(oldDisplayName));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, oldPrettyName));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, space.getGroupId()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, null, oldUrl));
    }

    @Override
    public void deleteSpace(String id) throws SpaceStorageException {
        Space space = this.getSpaceById(id);
        super.deleteSpace(id);
        this.exoSpaceCache.remove((Serializable)new SpaceKey(id));
        this.clearSpaceCache();
        this.cleanRef(space);
        this.getCachedActivityStorage().clearCache();
    }

    @Override
    public void ignoreSpace(String spaceId, String userId) {
        super.ignoreSpace(spaceId, userId);
        this.exoSpaceSimpleCache.remove((Serializable)new SpaceKey(spaceId));
        SpaceData spaceData = (SpaceData)this.exoSpaceCache.remove((Serializable)new SpaceKey(spaceId));
        if (spaceData != null) {
            Space space = spaceData.build();
            this.clearSpaceCache();
            this.clearIdentityCache();
            if (space != null) {
                this.cleanRef(space);
            }
        }
    }

    @Override
    public boolean isSpaceIgnored(String spaceId, String userId) {
        return super.isSpaceIgnored(spaceId, userId);
    }

    @Override
    public List<Space> getManagerSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MANAGER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getManagerSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getManagerSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MANAGER);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getManagerSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public int getMemberSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getMemberSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getMemberSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getMemberSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getPendingSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getPendingSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getPendingSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getPendingSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getInvitedSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getInvitedSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getInvitedSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getInvitedSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getPublicSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PUBLIC);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getPublicSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public int getAccessibleSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getAccessibleSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public int getVisibleSpacesCount(final String userId, final SpaceFilter spaceFilter) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.VISIBLE);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getVisibleSpacesCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public int getUnifiedSearchSpacesCount(final String userId, final SpaceFilter spaceFilter) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.UNIFIED_SEARCH);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getUnifiedSearchSpacesCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getAccessibleSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getAccessibleSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getEditableSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.EDITABLE);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getEditableSpacesByFilterCount(userId, spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getEditableSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.EDITABLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getEditableSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getAllSpacesByFilterCount(final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(null, spaceFilter, null);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getAllSpacesByFilterCount(spaceFilter));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getSpacesByFilter(final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(spaceFilter == null ? null : spaceFilter.getRemoteId(), spaceFilter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0L) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getSpacesByFilter(spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public Space getSpaceById(final String id) throws SpaceStorageException {
        SpaceKey key = new SpaceKey(id);
        SpaceData data = (SpaceData)this.spaceCache.get((Object)new ServiceContext<SpaceData>(){

            @Override
            public SpaceData execute() {
                Space space = CachedSpaceStorage.super.getSpaceById(id);
                if (space != null) {
                    CachedSpaceStorage.this.putSpaceInCacheIfNotExists(space);
                    return new SpaceData(space);
                }
                return null;
            }
        }, (Object)key);
        if (data != null) {
            return data.build();
        }
        return null;
    }

    @Override
    public Space getSpaceSimpleById(final String id) throws SpaceStorageException {
        SpaceKey key = new SpaceKey(id);
        SpaceData data = (SpaceData)this.exoSpaceCache.get((Serializable)key);
        if (data != null) {
            Space s = data.build();
            if (this.exoSpaceSimpleCache.get((Serializable)key) == null) {
                this.putSpaceInCacheIfNotExists(s);
            }
            return s;
        }
        SpaceSimpleData simpleData = (SpaceSimpleData)this.spaceSimpleCache.get((Object)new ServiceContext<SpaceSimpleData>(){

            @Override
            public SpaceSimpleData execute() {
                Space space = CachedSpaceStorage.super.getSpaceSimpleById(id);
                if (space != null) {
                    return new SpaceSimpleData(space);
                }
                return null;
            }
        }, (Object)key);
        if (simpleData != null) {
            return simpleData.build();
        }
        return null;
    }

    @Override
    public Space getSpaceByPrettyName(final String spacePrettyName) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, spacePrettyName);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get((Object)new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.super.getSpaceByPrettyName(spacePrettyName);
                if (space != null) {
                    return CachedSpaceStorage.this.putSpaceInCacheIfNotExists(space);
                }
                return SpaceKey.NULL_OBJECT;
            }
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public Space getSpaceByGroupId(final String groupId) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, null, groupId);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get((Object)new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.super.getSpaceByGroupId(groupId);
                if (space != null) {
                    return CachedSpaceStorage.this.putSpaceInCacheIfNotExists(space);
                }
                return SpaceKey.NULL_OBJECT;
            }
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public Space getSpaceByUrl(final String url) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, null, null, url);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get((Object)new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.super.getSpaceByUrl(url);
                if (space != null) {
                    return CachedSpaceStorage.this.putSpaceInCacheIfNotExists(space);
                }
                return SpaceKey.NULL_OBJECT;
            }
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceStorageException {
        LastAccessedSpacesCacheSelector selector = new LastAccessedSpacesCacheSelector(remoteId, space, this.cacheService);
        try {
            if (selector.isUpdateStore()) {
                super.updateSpaceAccessed(remoteId, space);
            }
            this.exoSpacesCache.select((CachedObjectSelector)selector);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while removing cache entries for remoteId=" + remoteId + ", space=" + space.getDisplayName() + " and type=" + SpaceType.LATEST_ACCESSED.name() + " or type=" + String.valueOf((Object)SpaceType.VISITED)), (Throwable)e);
        }
    }

    @Override
    public List<Space> getLastAccessedSpace(final SpaceFilter filter, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(filter.getRemoteId(), filter, SpaceType.LATEST_ACCESSED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getLastAccessedSpace(filter, offset, limit);
                return CachedSpaceStorage.this.buildSimpleIds(got);
            }
        }, (Object)listKey);
        return this.buildSimpleSpaces(keys);
    }

    @Override
    public List<Space> getLastSpaces(final int limit) {
        SpaceFilter filter = new SpaceFilter(null, null);
        filter.setSorting(new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC));
        SpaceFilterKey key = new SpaceFilterKey(null, filter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, 0L, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getLastSpaces(limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSimpleSpaces(keys);
    }

    @Override
    public int getNumberOfMemberPublicSpaces(final String userId) {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PUBLIC);
        return (Integer)((IntegerData)this.spacesCountCache.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.super.getNumberOfMemberPublicSpaces(userId));
            }
        }, (Object)key)).build();
    }

    @Override
    public List<Space> getVisitedSpaces(final SpaceFilter filter, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(filter.getRemoteId(), filter, SpaceType.VISITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getVisitedSpaces(filter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<String> getMemberRoleSpaceIdentityIds(final String identityId, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(identityId, null, SpaceType.MEMBER_IDENTITY_IDS);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getMemberRoleSpaceIdentityIds(identityId, offset, limit);
                return CachedSpaceStorage.this.buildListIdentityIds(got);
            }
        }, (Object)listKey);
        return this.buildIds(keys);
    }

    @Override
    public List<String> getMemberRoleSpaceIds(final String identityId, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(identityId, null, SpaceType.MEMBER_IDS);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get((Object)new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                if (limit == 0) {
                    return CachedSpaceStorage.this.buildIds(Collections.emptyList());
                }
                List got = CachedSpaceStorage.super.getMemberRoleSpaceIds(identityId, offset, limit);
                return CachedSpaceStorage.this.buildListIdentityIds(got);
            }
        }, (Object)listKey);
        return this.buildIds(keys);
    }

    private SpaceKey putSpaceInCacheIfNotExists(Space space) {
        SpaceRefKey refKey;
        SpaceKey key = new SpaceKey(space.getId());
        if (this.exoSpaceCache.get((Serializable)key) == null) {
            this.exoSpaceCache.putLocal((Serializable)key, (Object)new SpaceData(space));
            this.exoSpaceSimpleCache.putLocal((Serializable)key, (Object)new SpaceSimpleData(space));
        }
        if (this.exoRefSpaceCache.get((Serializable)(refKey = new SpaceRefKey(space.getDisplayName(), null, null, null))) == null) {
            this.exoRefSpaceCache.putLocal((Serializable)refKey, (Object)key);
        }
        if (this.exoRefSpaceCache.get((Serializable)(refKey = new SpaceRefKey(null, null, space.getGroupId(), null))) == null) {
            this.exoRefSpaceCache.putLocal((Serializable)refKey, (Object)key);
        }
        if (this.exoRefSpaceCache.get((Serializable)(refKey = new SpaceRefKey(null, space.getPrettyName(), null, null))) == null) {
            this.exoRefSpaceCache.putLocal((Serializable)refKey, (Object)key);
        }
        if (this.exoRefSpaceCache.get((Serializable)(refKey = new SpaceRefKey(null, null, null, space.getUrl()))) == null) {
            this.exoRefSpaceCache.putLocal((Serializable)refKey, (Object)key);
        }
        return key;
    }

    public void clearSpaceCached(String spaceId) {
        SpaceKey cacheKey = new SpaceKey(spaceId);
        SpaceData cachedSpace = (SpaceData)this.exoSpaceCache.get((Serializable)cacheKey);
        if (cachedSpace != null) {
            Space space = cachedSpace.build();
            this.exoSpaceSimpleCache.remove((Serializable)cacheKey);
            this.exoSpaceCache.remove((Serializable)cacheKey);
            this.cleanRef(space);
        }
        this.clearSpaceCache();
        this.clearIdentityCache();
    }

    public void clearCaches() {
        this.exoSpaceCache.clearCache();
        this.exoSpaceSimpleCache.clearCache();
        this.exoSpacesCountCache.clearCache();
        this.exoSpacesCache.clearCache();
        this.exoRefSpaceCache.clearCache();
        this.exoIdentitiesCache.clearCache();
    }
}

