/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public abstract class BaseCoreTest
extends BaseExoTestCase {
    private final Log LOG = ExoLogger.getLogger(BaseCoreTest.class);
    protected SpaceService spaceService;
    protected IdentityManager identityManager;
    protected RelationshipManager relationshipManager;
    protected ActivityManager activityManager;
    protected ActivityStorage activityStorage;
    protected EntityManagerService entityManagerService;
    protected Identity rootIdentity;
    protected Identity johnIdentity;
    protected Identity maryIdentity;
    protected Identity demoIdentity;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    protected void setUp() throws Exception {
        this.begin();
        this.identityManager = this.getService(IdentityManager.class);
        this.activityManager = this.getService(ActivityManager.class);
        this.activityStorage = this.getService(ActivityStorage.class);
        this.relationshipManager = this.getService(RelationshipManager.class);
        this.spaceService = this.getService(SpaceService.class);
        this.entityManagerService = this.getService(EntityManagerService.class);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", false);
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john", false);
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary", false);
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", false);
    }

    protected void tearDown() throws Exception {
        try {
            ConnectionDAO reDao = this.getService(ConnectionDAO.class);
            List reItems = reDao.findAll();
            for (ConnectionEntity item : reItems) {
                reDao.delete((Object)item);
            }
            if (this.rootIdentity != null) {
                this.identityManager.deleteIdentity(this.rootIdentity);
                this.identityManager.deleteIdentity(this.johnIdentity);
                this.identityManager.deleteIdentity(this.maryIdentity);
                this.identityManager.deleteIdentity(this.demoIdentity);
            }
        }
        catch (Throwable e) {
            this.LOG.error("Error while tearing down: {}", new Object[]{e.getMessage()});
        }
        this.end();
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    protected void runTest() throws Throwable {
        String fName = this.getName();
        BaseCoreTest.assertNotNull((String)"TestCase.fName cannot be null", (Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, null);
        }
        catch (NoSuchMethodException e) {
            BaseCoreTest.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            BaseCoreTest.fail((String)("Method \"" + fName + "\" should be public"));
        }
    }

    protected <T> T doInTransaction(TransactionCallable<T> callable) {
        T result = null;
        try {
            callable.beforeTransactionCompletion();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            try {
                result = callable.execute();
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            callable.afterTransactionCompletion();
        }
        return result;
    }

    protected void doInTransaction(TransactionVoidCallable callable) {
        try {
            callable.beforeTransactionCompletion();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            callable.execute();
            RequestLifeCycle.end();
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            callable.afterTransactionCompletion();
        }
    }

    protected void executeSync(VoidCallable callable) {
        this.executeSync(Collections.singleton(callable));
    }

    protected void executeSync(Collection<VoidCallable> callables) {
        try {
            List futures = this.executorService.invokeAll(callables);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            System.out.println(e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException iex) {
            System.out.println(iex);
            throw new RuntimeException(iex);
        }
    }

    protected <T> void executeAsync(Runnable callable, final Runnable completionCallback) {
        final Future<?> future = this.executorService.submit(callable);
        new Thread(this){

            @Override
            public void run() {
                while (!future.isDone()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    completionCallback.run();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }.start();
    }

    protected Future<?> executeAsync(Runnable callable) {
        return this.executorService.submit(callable);
    }

    protected void awaitOnLatch(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void sleep(int millis) {
        this.sleep(millis, null);
    }

    protected <V> V sleep(int millis, Callable<V> callable) {
        V result = null;
        try {
            this.LOG.info("Wait {} ms!", new Object[]{millis});
            if (callable != null) {
                result = callable.call();
            }
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    protected List<ExoSocialActivity> listOf(int n, Identity poster, boolean isComment, boolean isSave) {
        LinkedList<ExoSocialActivity> list = new LinkedList<ExoSocialActivity>();
        ExoSocialActivity a = null;
        for (int i = 0; i < n; ++i) {
            a = ActivityBuilder.getInstance().posterId(poster.getId()).title("title " + i).body("body " + i).titleId("titleId " + i).isComment(isComment).take();
            if (isSave) {
                this.activityStorage.saveActivity(poster, a);
            }
            list.add(a);
        }
        return list;
    }

    protected ExoSocialActivity oneOfActivity(String title, final Identity poster, boolean isComment, boolean isSave) {
        final ExoSocialActivity a = ActivityBuilder.getInstance().posterId(poster.getId()).title(title).body("body ").titleId("titleId ").isComment(isComment).take();
        if (isSave) {
            this.doInTransaction(new TransactionCallable<ExoSocialActivity>(){

                @Override
                public ExoSocialActivity execute() {
                    return BaseCoreTest.this.activityStorage.saveActivity(poster, a);
                }
            });
        }
        return a;
    }

    protected ExoSocialActivity oneOfComment(String title, Identity commenter) {
        return ActivityBuilder.getInstance().posterId(commenter.getId()).title(title).body("body ").titleId("titleId ").isComment(true).take();
    }

    protected List<ExoSocialActivity> listOf(int n, Identity streamOwner, Identity poster, boolean isComment, boolean isSave) {
        LinkedList<ExoSocialActivity> list = new LinkedList<ExoSocialActivity>();
        ExoSocialActivity a = null;
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        for (int i = 0; i < n; ++i) {
            a = ActivityBuilder.getInstance().posterId(poster.getId()).title("title" + i).body("body" + i).titleId("titleId" + i).params(templateParams).isComment(isComment).take();
            if (isSave) {
                this.activityStorage.saveActivity(streamOwner, a);
            } else {
                this.restartTransaction();
            }
            list.add(a);
        }
        return list;
    }

    protected static abstract class TransactionCallable<T>
    implements SessionCallable<T> {
        protected TransactionCallable() {
        }

        void beforeTransactionCompletion() {
        }

        void afterTransactionCompletion() {
        }
    }

    protected static abstract class TransactionVoidCallable
    implements SessionVoidCallable {
        protected TransactionVoidCallable() {
        }

        protected void beforeTransactionCompletion() {
        }

        protected void afterTransactionCompletion() {
        }
    }

    public static class ActivityBuilder {
        final ExoSocialActivity activity;

        public ActivityBuilder(ExoSocialActivity activity) {
            this.activity = activity;
        }

        public static ActivityBuilder getInstance() {
            return new ActivityBuilder((ExoSocialActivity)new ExoSocialActivityImpl());
        }

        public static ActivityBuilder getInstance(ExoSocialActivity activity) {
            return new ActivityBuilder(activity);
        }

        public ActivityBuilder body(String body) {
            this.activity.setBody(body);
            return this;
        }

        public ActivityBuilder title(String title) {
            this.activity.setTitle(title);
            return this;
        }

        public ActivityBuilder titleId(String titleId) {
            this.activity.setTitleId(titleId);
            return this;
        }

        public ActivityBuilder posterId(String posterId) {
            this.activity.setPosterId(posterId);
            this.activity.setUserId(posterId);
            return this;
        }

        public ActivityBuilder isComment(boolean isComment) {
            this.activity.isComment(isComment);
            return this;
        }

        public ActivityBuilder params(Map<String, String> params) {
            this.activity.setTemplateParams(params);
            return this;
        }

        public ActivityBuilder commenters(String ... commenters) {
            this.activity.setCommentedIds(commenters);
            return this;
        }

        public ActivityBuilder likers(String ... likers) {
            this.activity.setLikeIdentityIds(likers);
            return this;
        }

        public ActivityBuilder mentioners(String ... mentioners) {
            this.activity.setMentionedIds(mentioners);
            return this;
        }

        public ExoSocialActivity take() {
            return this.activity;
        }
    }

    protected static interface SessionVoidCallable {
        public void execute();
    }

    protected static interface SessionCallable<T> {
        public T execute();
    }

    protected static abstract class VoidCallable
    implements Callable<Void> {
        protected VoidCallable() {
        }

        public abstract void execute();

        @Override
        public Void call() throws Exception {
            this.execute();
            return null;
        }
    }
}

