/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import java.util.Objects;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;

public class SpaceFilterKey
implements CacheKey {
    private static final long serialVersionUID = 2363449672896832814L;
    private String userId;
    private String spaceNameSearchCondition;
    private boolean favorite;
    private SpaceType type;
    private Sorting sorting;
    private final int hash;

    public SpaceFilterKey(String userId, SpaceFilter filter, SpaceType type) {
        this.userId = userId;
        if (filter != null) {
            this.spaceNameSearchCondition = filter.getSpaceNameSearchCondition();
            this.sorting = filter.getSorting();
            this.favorite = filter.isFavorite();
            if (userId == null) {
                this.userId = filter.getRemoteId();
            }
        }
        this.type = type;
        this.hash = Objects.hash(new Object[]{this.userId, filter, this.type, this.favorite});
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    public SpaceType getType() {
        return this.type;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpaceFilterKey)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }
}

