/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public abstract class AbstractCoreTest
extends BaseExoTestCase {
    protected final Log LOG = ExoLogger.getLogger(AbstractCoreTest.class);
    protected SpaceService spaceService;
    protected IdentityManager identityManager;
    protected RelationshipManager relationshipManager;
    protected ActivityManager activityManager;
    protected ActivityStorage activityStorage;
    protected ProfileSearchConnector mockProfileSearch = (ProfileSearchConnector)Mockito.mock(ProfileSearchConnector.class);

    protected void setUp() throws Exception {
        this.begin();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.identityManager = this.getService(IdentityManager.class);
        this.activityManager = this.getService(ActivityManager.class);
        this.activityStorage = this.getService(ActivityStorage.class);
        this.relationshipManager = this.getService(RelationshipManager.class);
        this.spaceService = this.getService(SpaceService.class);
        this.deleteAllRelationships();
        this.deleteAllSpaces();
        this.deleteAllIdentitiesWithActivities();
        this.deleteAllActivities();
    }

    protected void tearDown() throws Exception {
        this.restartTransaction();
        this.deleteAllRelationships();
        this.deleteAllSpaces();
        this.deleteAllIdentitiesWithActivities();
        this.deleteAllActivities();
        this.end();
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    protected void runTest() throws Throwable {
        String fName = this.getName();
        AbstractCoreTest.assertNotNull((String)"TestCase.fName cannot be null", (Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, null);
        }
        catch (NoSuchMethodException e) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" should be public"));
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    protected Space createSpaceNonInitApps(Space space, String creator, String invitedGroupId) {
        String groupId = null;
        try {
            groupId = SpaceUtils.createGroup((String)space.getDisplayName(), (String)creator);
        }
        catch (SpaceException e) {
            this.LOG.error((Object)"Error while creating group", (Throwable)e);
        }
        if (invitedGroupId != null) {
            OrganizationService org = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            try {
                ListAccess groupMembersAccess = org.getUserHandler().findUsersByGroupId(invitedGroupId);
                List<User> users = Arrays.asList((User[])groupMembersAccess.load(0, groupMembersAccess.getSize()));
                for (User user : users) {
                    Object[] invitedUsers;
                    String userId = user.getUserName();
                    if (userId.equals(creator) || ArrayUtils.contains((Object[])(invitedUsers = space.getInvitedUsers()), (Object)userId)) continue;
                    invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
                    space.setInvitedUsers((String[])invitedUsers);
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to invite users from group " + invitedGroupId), (Throwable)e);
            }
        }
        String[] managers = new String[]{creator};
        space.setManagers(managers);
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        try {
            this.spaceService.createSpace(space, creator);
        }
        catch (Exception e) {
            this.LOG.warn((Object)"Error while saving space", (Throwable)e);
        }
        return space;
    }

    protected void loginUser(String userId) {
        MembershipEntry membershipEntry = new MembershipEntry("/platform/user", "*");
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        membershipEntries.add(membershipEntry);
        Identity identity = new Identity(userId, membershipEntries);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    protected org.exoplatform.social.core.identity.model.Identity createUserAndIdentity(String username) throws Exception {
        OrganizationService organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        User user = userHandler.findUserByName(username);
        if (user == null) {
            user = userHandler.createUserInstance(username);
            user.setFirstName(username);
            user.setLastName(username);
            user.setEmail(username + "@test.com");
            userHandler.createUser(user, true);
        }
        return this.createIdentity(username);
    }

    protected org.exoplatform.social.core.identity.model.Identity createIdentity(String username) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)username);
        profile.setProperty("lastName", (Object)username);
        identity.setProfile(profile);
        this.identityManager.updateProfile(profile);
        if (identity.isDeleted() || !identity.isEnable()) {
            identity.setDeleted(false);
            identity.setEnable(true);
            this.identityManager.updateIdentity(identity);
        }
        return this.identityManager.getOrCreateUserIdentity(username);
    }

    protected org.exoplatform.social.core.identity.model.Identity createIdentity(String username, String email) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", username, true);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)username);
        profile.setProperty("lastName", (Object)username);
        identity.setProfile(profile);
        if (identity.isDeleted() || !identity.isEnable()) {
            identity.setDeleted(false);
            identity.setEnable(true);
            identity.getProfile().setProperty("email", (Object)email);
            identity = this.identityManager.updateIdentity(identity);
            this.identityManager.updateProfile(profile);
            identity.setProfile(profile);
        }
        return identity;
    }

    protected void deleteAllIdentitiesWithActivities() throws Exception {
        ListAccess organizationIdentities = this.identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
        Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])organizationIdentities.load(0, organizationIdentities.getSize())).forEach(identity -> {
            RealtimeListAccess identityActivities = this.activityManager.getActivitiesWithListAccess(identity);
            Arrays.stream((ExoSocialActivity[])identityActivities.load(0, identityActivities.getSize())).forEach(activity -> {
                this.begin();
                this.activityManager.deleteActivity(activity);
                this.end();
            });
            this.begin();
            this.identityManager.deleteIdentity(identity);
            this.end();
        });
        this.begin();
        ListAccess spaceIdentities = this.identityManager.getIdentitiesByProfileFilter("space", new ProfileFilter(), false);
        Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])spaceIdentities.load(0, spaceIdentities.getSize())).forEach(identity -> {
            this.begin();
            RealtimeListAccess identityActivities = this.activityManager.getActivitiesOfSpaceWithListAccess(identity);
            Arrays.stream((ExoSocialActivity[])identityActivities.load(0, identityActivities.getSize())).forEach(activity -> {
                this.begin();
                this.activityManager.deleteActivity(activity);
                this.end();
            });
            this.identityManager.deleteIdentity(identity);
            this.end();
        });
        this.end();
    }

    protected void deleteAllSpaces() throws Exception {
        ListAccess spaces = this.spaceService.getAllSpacesWithListAccess();
        Arrays.stream((Space[])spaces.load(0, spaces.getSize())).forEach(this::deleteSpace);
    }

    protected void deleteSpace(Space space) {
        this.spaceService.deleteSpace(space);
    }

    protected void deleteAllRelationships() throws Exception {
        RelationshipManager relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ListAccess identities = identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), true);
        for (org.exoplatform.social.core.identity.model.Identity identity : (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize())) {
            ListAccess relationships = relationshipManager.getAllWithListAccess(identity);
            Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])relationships.load(0, relationships.getSize())).forEach(relationship -> relationshipManager.deny(identity, relationship));
        }
    }

    protected void deleteAllActivities() throws Exception {
        ActivityDAO activityDAO = this.getService(ActivityDAO.class);
        activityDAO.deleteAll();
    }

    public void persist() {
        this.restartTransaction();
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

