/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class RelationshipStorageTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(RelationshipStorageTest.class);
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager;
    private RelationshipStorage relationshipStorage;
    private IdentityStorage identityStorage;
    private List<Identity> tearDownIdentityList;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private Identity ghostIdentity;
    private Identity paulIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.relationshipManager = this.getService(RelationshipManager.class);
        this.identityManager = this.getService(IdentityManager.class);
        this.relationshipStorage = (RelationshipStorage)this.getContainer().getComponentInstanceOfType(RelationshipStorage.class);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
        this.ghostIdentity = this.createIdentity("ghost");
        this.paulIdentity = this.createIdentity("paul");
        this.tearDownIdentityList = new ArrayList<Identity>();
    }

    public void testSaveRelationship() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
    }

    public void testRemoveRelationship() {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        try {
            this.relationshipStorage.saveRelationship(rootToJohnRelationship);
            RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
            this.relationshipStorage.removeRelationship(rootToJohnRelationship);
            RelationshipStorageTest.assertNull((String)"relationshipStorage.getRelationship(rootToJohnRelationship.getId() must be null", (Object)this.relationshipStorage.getRelationship(rootToJohnRelationship.getId()));
        }
        catch (RelationshipStorageException e) {
            this.LOG.error((Object)e);
        }
    }

    public void testGetRelationship() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipStorage.getRelationship(rootToJohnRelationship.getId());
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getRemoteId(), (String)rootToJohnRelationship.getSender().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getProviderId(), (String)rootToJohnRelationship.getSender().getProviderId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)rootToJohnRelationship.getReceiver().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getProviderId(), (String)rootToJohnRelationship.getReceiver().getProviderId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        rootToJohnRelationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipStorage.getRelationship(rootToJohnRelationship.getId());
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getRemoteId(), (String)rootToJohnRelationship.getSender().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getProviderId(), (String)rootToJohnRelationship.getSender().getProviderId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)rootToJohnRelationship.getReceiver().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getProviderId(), (String)rootToJohnRelationship.getReceiver().getProviderId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testGetUsersConnections() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.CONFIRMED);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.johnIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getConnections(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetConnectionsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.CONFIRMED);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getConnections(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getConnectionsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetRelationshipsWithListCheck() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.PENDING);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        ArrayList<Identity> listCheckIdentity = new ArrayList<Identity>();
        listCheckIdentity.add(this.rootIdentity);
        listCheckIdentity.add(this.demoIdentity);
        listCheckIdentity.add(this.maryIdentity);
        listCheckIdentity.add(this.johnIdentity);
        List rootConfirmedRelationships = this.relationshipStorage.getRelationships(this.rootIdentity, Relationship.Type.CONFIRMED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootConfirmedRelationships must not be null", (Object)rootConfirmedRelationships);
        RelationshipStorageTest.assertEquals((String)"rootConfirmedRelationships.size() must return: 1", (int)1, (int)rootConfirmedRelationships.size());
        List johnConfirmedRelationships = this.relationshipStorage.getRelationships(this.johnIdentity, Relationship.Type.CONFIRMED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnConfirmedRelationships must not be null", (Object)johnConfirmedRelationships);
        RelationshipStorageTest.assertEquals((String)"johnConfirmedRelationships.size() must return: 1", (int)1, (int)johnConfirmedRelationships.size());
        List johnPendingRelationships = this.relationshipStorage.getRelationships(this.johnIdentity, Relationship.Type.PENDING, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() must return: 0", (int)0, (int)johnPendingRelationships.size());
        List maryPendingRelationships = this.relationshipStorage.getRelationships(this.maryIdentity, Relationship.Type.PENDING, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoIgnoredRelationships = this.relationshipStorage.getRelationships(this.demoIdentity, Relationship.Type.IGNORED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoIgnoredRelationships must not be null", (Object)demoIgnoredRelationships);
        RelationshipStorageTest.assertEquals((String)"demoIgnoredRelationships.size() must return: 1", (int)1, (int)demoIgnoredRelationships.size());
    }

    public void testGetSenderRelationshipsByIdentityAndType() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        List relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, Relationship.Type.PENDING, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)2, (int)relationships.size());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, Relationship.Type.CONFIRMED, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)1, (int)relationships.size());
        relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, null, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)3, (int)relationships.size());
    }

    public void testGetSenderRelationships() throws Exception {
        String rootId = this.rootIdentity.getId();
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        List relationships = this.relationshipStorage.getSenderRelationships(rootId, Relationship.Type.PENDING, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)2, (int)relationships.size());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        relationships = this.relationshipStorage.getSenderRelationships(rootId, Relationship.Type.CONFIRMED, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)1, (int)relationships.size());
        relationships = this.relationshipStorage.getSenderRelationships(rootId, null, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)3, (int)relationships.size());
    }

    public void testGetRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 3", (int)3, (int)listIdentities.size());
    }

    public void testGetRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        int count = this.relationshipStorage.getRelationshipsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 3", (int)3, (int)count);
    }

    public void testGetConnectionsByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetIncomingByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.johnIdentity, this.rootIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.demoIdentity, this.rootIdentity, Relationship.Type.PENDING));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetOutgoingByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetIncomingRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToJohnRelationship = new Relationship(this.maryIdentity, this.johnIdentity, Relationship.Type.PENDING);
        maryToJohnRelationship = this.relationshipStorage.saveRelationship(maryToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToJohnRelationship.getId());
        Relationship demoToJohnRelationship = new Relationship(this.demoIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        demoToJohnRelationship = this.relationshipStorage.saveRelationship(demoToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)demoToJohnRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.maryIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getIncomingRelationships(this.johnIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetIncomingRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToJohnRelationship = new Relationship(this.maryIdentity, this.johnIdentity, Relationship.Type.PENDING);
        maryToJohnRelationship = this.relationshipStorage.saveRelationship(maryToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToJohnRelationship.getId());
        Relationship demoToJohnRelationship = new Relationship(this.demoIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        demoToJohnRelationship = this.relationshipStorage.saveRelationship(demoToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)demoToJohnRelationship.getId());
        List listIdentities = this.relationshipStorage.getIncomingRelationships(this.johnIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getIncomingRelationshipsCount(this.johnIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetOutgoingRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.johnIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        this.demoIdentity = this.identityStorage.findIdentity("organization", this.demoIdentity.getRemoteId());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be nul", (Object)identity.getProfile());
            RelationshipStorageTest.assertNotNull((String)"temp must not be null", (Object)identityLoadProfile);
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetOutgoingRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getOutgoingRelationshipsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetConnectionsByFilterEmpty() throws Exception {
        this.populateData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)0, (int)identities.size());
    }

    public void testGetConnectionsByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        pf.setCompany("exo");
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 2", (int)2, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName9");
        pf.setCompany("");
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)identities.size());
    }

    public void testGetConnectionsWithDisabledUser() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        Identity id1 = (Identity)identities.get(2);
        Identity id2 = (Identity)identities.get(3);
        String disabledUserName = id1.getRemoteId();
        String deletedUserName = id2.getRemoteId();
        id1.setEnable(false);
        this.identityStorage.saveIdentity(id1);
        id2.setDeleted(true);
        this.identityStorage.saveIdentity(id2);
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 10L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 6", (int)6, (int)identities.size());
        RelationshipStorageTest.assertNull((String)("User " + disabledUserName + " must not be found in connections"), (Object)this.getInList(identities, disabledUserName));
        RelationshipStorageTest.assertNull((String)("User " + deletedUserName + " must not be found in connections"), (Object)this.getInList(identities, deletedUserName));
    }

    public void testGetIncomingByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipIncommingData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getIncomingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)8, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName6");
        identities = this.relationshipStorage.getIncomingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)1, (int)identities.size());
    }

    public void testGetOutgoingByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.PENDING);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getOutgoingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName8");
        identities = this.relationshipStorage.getOutgoingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)identities.size());
    }

    public void testGetIncomingCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipIncommingData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getIncomingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName6");
        countIdentities = this.relationshipStorage.getIncomingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    public void testGetConnectionsCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getConnectionsCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName6");
        countIdentities = this.relationshipStorage.getConnectionsCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    public void testGetOutgoingCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.PENDING);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getOutgoingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName8");
        countIdentities = this.relationshipStorage.getOutgoingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    public void testGetAll() throws Exception {
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RelationshipStorageTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipStorageTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void TestGetConnectionsByFilter() throws Exception {
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.maryIdentity);
        ProfileFilter filter = new ProfileFilter();
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(this.maryIdentity, filter);
        Identity[] identities = (Identity[])listAccess.load(0, 10);
        RelationshipStorageTest.assertEquals((int)2, (int)identities.length);
    }

    public void TestPerfomanceGetConnectionsByFilter() throws Exception {
        UserHandler handler = this.getService(OrganizationService.class).getUserHandler();
        String key = "abc_test";
        for (int i = 0; i < 100; ++i) {
            User user = handler.createUserInstance(key + i);
            user.setPassword("gtn");
            user.setEmail(key + i + "@mail.com");
            user.setFirstName("abc " + i);
            user.setLastName("gtn");
            if (i % 5 == 0) {
                user.setLastName("foo");
            }
            handler.createUser(user, true);
        }
        for (int i = 0; i < 100; ++i) {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", key + i, true);
            this.relationshipManager.inviteToConnect(this.demoIdentity, identity);
            this.relationshipManager.confirm(identity, this.demoIdentity);
        }
        ProfileFilter filter = new ProfileFilter();
        filter.setName("abc");
        long t = System.currentTimeMillis();
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(this.demoIdentity, filter);
        Identity[] identities = (Identity[])listAccess.load(0, 110);
        this.LOG.info((Object)("Time to load " + identities.length + " identities: " + (System.currentTimeMillis() - t) + "ms"));
        RelationshipStorageTest.assertEquals((int)100, (int)identities.length);
        t = System.currentTimeMillis();
        filter.setName("foo");
        listAccess = this.relationshipManager.getConnectionsByFilter(this.demoIdentity, filter);
        identities = (Identity[])listAccess.load(0, 110);
        this.LOG.info((Object)("Time to load " + identities.length + " identities: " + (System.currentTimeMillis() - t) + "ms"));
        RelationshipStorageTest.assertEquals((int)20, (int)identities.length);
    }

    public void testGetAllWithListIdentities() throws Exception {
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAll(this.rootIdentity, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAll(this.maryIdentity, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RelationshipStorageTest.assertEquals((String)"maryRelationships.size() mut return: 1", (int)1, (int)maryRelationships.size());
        List johnRelationships = this.relationshipManager.getAll(this.johnIdentity, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipStorageTest.assertEquals((String)"johnRelationships.size() mut return: 1", (int)1, (int)johnRelationships.size());
    }

    public void testGetAllWithTypeAndListIdentities() throws Exception {
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() mut return: 1", (int)1, (int)maryPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() mut return: 1", (int)1, (int)johnPendingRelationships.size());
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        List rootConfirmedRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.CONFIRMED, listIdentities);
        RelationshipStorageTest.assertNotNull((String)"rootConfirmedRelationships must not be null", (Object)rootConfirmedRelationships);
        RelationshipStorageTest.assertEquals((String)"rootConfirmedRelationships.size() must return: 1", (int)1, (int)rootConfirmedRelationships.size());
    }

    public void testGet() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"rootToJohnRelationship.getStatus() must return: ", (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testGetWithRelationshipId() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        String relationshipId = relationship.getId();
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        relationship = this.relationshipManager.get(relationship.getId());
        RelationshipStorageTest.assertNotNull((String)"relationship must not be null", (Object)relationship);
        RelationshipStorageTest.assertEquals((String)("relationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"relationship must be null", (Object)relationship);
        relationship = this.relationshipManager.get(relationshipId);
        RelationshipStorageTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testInviteToConnect() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipStorageTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
    }

    public void testDupdicateInviteToConnect() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
    }

    public void testDupdicateInviteToConnectWithConfirmedRelationShip() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)"RelationShip status must be PENDING", (Object)Relationship.Type.PENDING, (Object)relationship1.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        relationship1 = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship1.getStatus());
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship2.getStatus());
        RelationshipStorageTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
    }

    public void testConfirmWithIdentity() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(rootToJohnRelationship.getId());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipStorageTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)maryToRootRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testDeny() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.deny(this.johnIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((Object)this.relationshipManager.get(rootToJohnRelationship.getId()));
        this.relationshipManager.deny(this.demoIdentity, this.rootIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testIgnore() throws Exception {
        Relationship relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((Object)relationship);
        this.relationshipManager.ignore(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship);
        RelationshipStorageTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RelationshipStorageTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        relationship = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship);
        RelationshipStorageTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RelationshipStorageTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        this.relationshipManager.ignore(this.demoIdentity, this.rootIdentity);
        relationship = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship);
        RelationshipStorageTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RelationshipStorageTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship);
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        this.relationshipManager.deny(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((Object)relationship);
        this.relationshipManager.ignore(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship);
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
    }

    public void testGetIncomingWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship johnToDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        ListAccess demoIncoming = this.relationshipManager.getIncomingWithListAccess(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoIncoming must not be null", (Object)demoIncoming);
        RelationshipStorageTest.assertEquals((String)"demoIncoming.getSize() must return: 3", (int)3, (int)demoIncoming.getSize());
        for (Identity identity : (Identity[])demoIncoming.load(0, 10)) {
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            Identity identityLoadProfile = this.identityManager.getOrCreateIdentity("organization", identity.getRemoteId(), true);
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
        ListAccess rootIncoming = this.relationshipManager.getIncomingWithListAccess(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootIncoming must not be null", (Object)rootIncoming);
        RelationshipStorageTest.assertEquals((String)"rootIncoming.getSize() must return: 0", (int)0, (int)rootIncoming.getSize());
        ListAccess maryIncoming = this.relationshipManager.getIncomingWithListAccess(this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryIncoming must not be null", (Object)maryIncoming);
        RelationshipStorageTest.assertEquals((String)"maryIncoming.getSize() must return: 0", (int)0, (int)maryIncoming.getSize());
    }

    public void testGetOutgoing() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship demoToJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        ListAccess rootOutgoing = this.relationshipManager.getOutgoing(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootOutgoing must not be null", (Object)rootOutgoing);
        RelationshipStorageTest.assertEquals((String)"rootOutgoing.getSize() must return: 2", (int)2, (int)rootOutgoing.getSize());
        for (Identity identity : (Identity[])rootOutgoing.load(0, 10)) {
            Identity identityLoadProfile = this.identityManager.getOrCreateIdentity("organization", identity.getRemoteId(), true);
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be nul", (Object)identity.getProfile());
            RelationshipStorageTest.assertNotNull((String)"temp must not be null", (Object)identityLoadProfile);
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
        ListAccess maryOutgoing = this.relationshipManager.getOutgoing(this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryOutgoing must not be null", (Object)maryOutgoing);
        RelationshipStorageTest.assertEquals((String)"maryOutgoing.getSize() must return: 1", (int)1, (int)maryOutgoing.getSize());
        ListAccess demoOutgoing = this.relationshipManager.getOutgoing(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoOutgoing must not be null", (Object)demoOutgoing);
        RelationshipStorageTest.assertEquals((String)"demoOutgoing.getSize() must return: 1", (int)1, (int)demoOutgoing.getSize());
    }

    public void testGetStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.demoIdentity));
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipStorageTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getStatus(maryIdentity, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity));
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, johnIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.johnIdentity));
    }

    public void testGetAllWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        ListAccess rootRelationships = this.relationshipManager.getAllWithListAccess(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.getSize() must return: 3", (int)3, (int)rootRelationships.getSize());
        ListAccess demoRelationships = this.relationshipManager.getAllWithListAccess(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RelationshipStorageTest.assertEquals((String)"demoRelationships.getSize() must return: 1", (int)1, (int)demoRelationships.getSize());
        ListAccess johnRelationships = this.relationshipManager.getAllWithListAccess(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipStorageTest.assertEquals((String)"johnRelationships.getSize() must return: 1", (int)1, (int)johnRelationships.getSize());
    }

    public void testGetRelationshipById() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(rootToDemoRelationship.getId());
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
    }

    public void testDenyWithRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.deny(rootToDemoRelationship);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(maryToRootRelationship);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testGetPendingRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"rootPendingRelationships.size() must return: 2", (int)2, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"demoPendingRelationships.size() must return: 0", (int)0, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() must return: 0", (int)0, (int)johnPendingRelationships.size());
    }

    public void testGetPendingRelationshipWithSentOrReceived() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, true);
        RelationshipStorageTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, true);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, true);
        RelationshipStorageTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, true);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
    }

    public void testGetPendingRealtionshipWithListIdentities() throws Exception {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, identities, true);
        RelationshipStorageTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, identities, true);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, identities, true);
        RelationshipStorageTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, identities, true);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
    }

    public void testGetContactsWithListIdentities() throws Exception {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity, identities);
        RelationshipStorageTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RelationshipStorageTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity, identities);
        RelationshipStorageTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RelationshipStorageTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity, identities);
        RelationshipStorageTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RelationshipStorageTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity, identities);
        RelationshipStorageTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipStorageTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
    }

    public void testGetContacts() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RelationshipStorageTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RelationshipStorageTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RelationshipStorageTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipStorageTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
    }

    public void testGetAllRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAllRelationships(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAllRelationships(this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RelationshipStorageTest.assertEquals((String)"maryRelationships.size() must return: 1", (int)1, (int)maryRelationships.size());
        List demoRelationships = this.relationshipManager.getAllRelationships(this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RelationshipStorageTest.assertEquals((String)"demoRelationships.size() must return: 1", (int)1, (int)demoRelationships.size());
        List johnRelationships = this.relationshipManager.getAllRelationships(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipStorageTest.assertEquals((String)"johnRelationships.size() must return: 1", (int)1, (int)johnRelationships.size());
    }

    public void testGetRelationshipsByIdentityId() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getRelationshipsByIdentityId(this.rootIdentity.getId());
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
    }

    public void testGetIdentities() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootConnections = this.relationshipManager.getIdentities(this.rootIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootConnections must not be null", (Object)rootConnections);
        RelationshipStorageTest.assertEquals((String)"rootConnections.size() must return: 3", (int)3, (int)rootConnections.size());
    }

    public void testGetUsersRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipStorageTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
    }

    public void testFindRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.PENDING);
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.CONFIRMED);
        RelationshipStorageTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipStorageTest.assertEquals((String)"rootRelationships.size() must return: 1", (int)1, (int)rootRelationships.size());
    }

    public void testGetIncomingRelationshipsSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getIncomingByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetConfirmedRelationshipsSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.confirm(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.confirm(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.confirm(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        this.relationshipManager.confirm(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getConnectionsByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetOutgoingRelationshipsSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser1, testuser5);
        this.relationshipManager.inviteToConnect(testuser1, testuser2);
        this.relationshipManager.inviteToConnect(testuser1, testuser4);
        this.relationshipManager.inviteToConnect(testuser1, testuser3);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getOutgoingByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetIncomingRelationshipsByFirstLetterSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getIncomingByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetConfirmedRelationshipsByFirstLetterSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.confirm(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.confirm(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.confirm(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        this.relationshipManager.confirm(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getConnectionsByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetOutgoingRelationshipsByFirstLetterSorted() throws Exception {
        Identity testuser5 = this.createUserAndIdentity("testuser5");
        Identity testuser3 = this.createUserAndIdentity("testuser3");
        Identity testuser1 = this.createUserAndIdentity("testuser1");
        Identity testuser4 = this.createUserAndIdentity("testuser4");
        Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser1, testuser5);
        this.relationshipManager.inviteToConnect(testuser1, testuser2);
        this.relationshipManager.inviteToConnect(testuser1, testuser4);
        this.relationshipManager.inviteToConnect(testuser1, testuser3);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getOutgoingByFilter(testuser1, profileFilter);
        RelationshipStorageTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RelationshipStorageTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        Identity[] loadedIdentities = (Identity[])identities.load(0, identities.getSize());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RelationshipStorageTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetRelationshipStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
    }

    public void testGetConnectionStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
    }

    public void testIntiveAndGetByRelationshipId() throws Exception {
        Relationship invitedRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship foundRelationship = this.relationshipManager.get(invitedRelationship.getId());
        RelationshipStorageTest.assertNotNull((String)"foundRelationship must not be null", (Object)foundRelationship);
        RelationshipStorageTest.assertNotNull((String)"foundRelationship.getId() must not be null", (Object)foundRelationship.getId());
        RelationshipStorageTest.assertEquals((String)foundRelationship.getId(), (String)invitedRelationship.getId());
    }

    public void testGetPendingWithIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        List foundListRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"foundListRelationships must not be null", (Object)foundListRelationships);
        RelationshipStorageTest.assertEquals((int)3, (int)foundListRelationships.size());
    }

    public void testGetPendingAndIncoming() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        List listPendingRelationship = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"listRelationshipConfirm must not be null", (Object)listPendingRelationship);
        RelationshipStorageTest.assertEquals((int)3, (int)listPendingRelationship.size());
        List listMaryRequireValidationRelationship = this.relationshipManager.getIncoming(this.maryIdentity);
        RelationshipStorageTest.assertEquals((int)1, (int)listMaryRequireValidationRelationship.size());
    }

    public void testGetPendingAndIncomingWithListIdentities() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        Relationship maryDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List listRelationshipConfirm = this.relationshipManager.getPending(this.johnIdentity, listIdentities);
        RelationshipStorageTest.assertEquals((int)3, (int)listRelationshipConfirm.size());
        List listRelationshipNotConfirm = this.relationshipManager.getIncoming(this.demoIdentity, listIdentities);
        RelationshipStorageTest.assertEquals((int)2, (int)listRelationshipNotConfirm.size());
    }

    public void testGetConfirmedWithIdentity() throws Exception {
        List johnContacts = this.relationshipManager.getConfirmed(this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipStorageTest.assertEquals((String)"johnContacts.size() must be 0", (int)0, (int)johnContacts.size());
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity);
        RelationshipStorageTest.assertEquals((int)3, (int)contactsList.size());
    }

    public void testGetConfirmedWithIdentityAndListIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity, listIdentities);
        RelationshipStorageTest.assertEquals((int)3, (int)contactsList.size());
    }

    public void testInviteRelationship() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship.getId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.maryIdentity);
        RelationshipStorageTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipStorageTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void testConfirm() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(relationship);
        relationship = this.relationshipManager.get(this.johnIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((Object)relationship.getId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RelationshipStorageTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipStorageTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void testDelete() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testRemove() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testGetPending() throws Exception {
        Relationship rootDemo = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        Relationship rootJohn = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        Relationship rootMary = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        Relationship demoMary = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        Relationship demoJohn = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoJohn.getId() must not be null", (Object)demoJohn.getId());
        List rootRelationships = this.relationshipManager.getPending(this.rootIdentity);
        List demoRelationships = this.relationshipManager.getPending(this.demoIdentity);
        List johnRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipStorageTest.assertEquals((int)3, (int)rootRelationships.size());
        RelationshipStorageTest.assertEquals((int)2, (int)demoRelationships.size());
        RelationshipStorageTest.assertEquals((int)0, (int)johnRelationships.size());
    }

    public void testSavedCached() throws Exception {
        Relationship rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((String)"rootDemo must be null", (Object)rootDemo);
        Relationship rootDemo2 = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((String)"rootDemo must be null", (Object)rootDemo2);
        Relationship.Type rootDemoStatus = this.relationshipManager.getStatus(this.demoIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((String)"rootDemoStatus must be null", (Object)rootDemoStatus);
        rootDemo = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        RelationshipStorageTest.assertEquals((Object)rootDemo.getStatus(), (Object)Relationship.Type.PENDING);
        Relationship rootMary = this.relationshipManager.get(this.rootIdentity, this.maryIdentity);
        Relationship.Type rootMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity);
        RelationshipStorageTest.assertNull((String)"rootMary must be null", (Object)rootMary);
        RelationshipStorageTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootMary = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootMary.getStatus());
        Relationship rootJohn = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNull((String)"rootJohn must be null", (Object)rootJohn);
        RelationshipStorageTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootJohn = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootJohn.getStatus());
        Relationship demoMary = this.relationshipManager.get(this.demoIdentity, this.maryIdentity);
        Relationship.Type demoMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.demoIdentity);
        RelationshipStorageTest.assertNull((String)"demoMary must be null", (Object)demoMary);
        RelationshipStorageTest.assertNull((String)"demoMaryStatus must be null", (Object)demoMaryStatus);
        demoMary = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)demoMary.getStatus());
    }

    public void testGetConnections() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        ListAccess contactsList = this.relationshipManager.getConnections(this.johnIdentity);
        RelationshipStorageTest.assertEquals((int)3, (int)contactsList.getSize());
    }

    public void testGetSuggestions() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        Relationship ghostToJohnRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.johnIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        Map suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertTrue((boolean)suggestions.isEmpty());
        this.relationshipManager.confirm(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.ghostIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertEquals((int)1, (int)suggestions.size());
        Object[] objs = suggestions.entrySet().toArray();
        Map.Entry first = (Map.Entry)objs[0];
        RelationshipStorageTest.assertEquals((int)1, (int)((Integer)first.getValue()));
        RelationshipStorageTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)first.getKey()).getRemoteId());
        Relationship johnToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        Relationship paulToDemoRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertEquals((int)1, (int)suggestions.size());
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertEquals((int)2, (int)suggestions.size());
        objs = suggestions.entrySet().toArray();
        first = (Map.Entry)objs[0];
        Map.Entry second = (Map.Entry)objs[1];
        RelationshipStorageTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)first.getKey()).getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((Identity)second.getKey()).getRemoteId());
        RelationshipStorageTest.assertEquals((int)2, (int)((Integer)first.getValue()));
        RelationshipStorageTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)first.getKey()).getRemoteId());
        RelationshipStorageTest.assertEquals((int)1, (int)((Integer)second.getValue()));
        RelationshipStorageTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((Identity)second.getKey()).getRemoteId());
        this.relationshipManager.delete(paulToDemoRelationship);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertEquals((int)1, (int)suggestions.size());
        this.paulIdentity.setEnable(false);
        this.identityManager.updateIdentity(this.paulIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertEquals((int)1, (int)suggestions.size());
        objs = suggestions.entrySet().toArray();
        first = (Map.Entry)objs[0];
        RelationshipStorageTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)first.getKey()).getRemoteId());
    }

    public void testGetSuggestionsWithParams() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        Relationship paulToMaryRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        Relationship johnToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Map suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertTrue((boolean)suggestions.isEmpty());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 10);
        RelationshipStorageTest.assertTrue((boolean)suggestions.isEmpty());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 10);
        RelationshipStorageTest.assertTrue((boolean)suggestions.isEmpty());
        this.relationshipManager.confirm(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertEquals((int)4, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertEquals((int)4, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 2, 10);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 3, 10);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 3, 10);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 2);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertEquals((int)2, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 2, 2);
        RelationshipStorageTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RelationshipStorageTest.assertEquals((int)2, (int)suggestions.size());
    }

    public void testGetLastConnections() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.ghostIdentity);
        this.restartTransaction();
        this.sleep(1);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.restartTransaction();
        this.sleep(1);
        Relationship paulToMaryRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.paulIdentity);
        this.sleep(1);
        List identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RelationshipStorageTest.assertEquals((int)3, (int)identities.size());
        RelationshipStorageTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((Identity)identities.get(0)).getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)identities.get(1)).getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.ghostIdentity.getRemoteId(), (String)((Identity)identities.get(2)).getRemoteId());
        this.restartTransaction();
        Relationship johnToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RelationshipStorageTest.assertEquals((int)4, (int)identities.size());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)((Identity)identities.get(0)).getRemoteId());
    }

    public void testGetConnectionsInCommonCount() throws Exception {
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.ghostIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.ghostIdentity);
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.paulIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.ghostIdentity);
        RelationshipStorageTest.assertEquals((int)1, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.ghostIdentity));
        RelationshipStorageTest.assertEquals((int)1, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.paulIdentity));
        RelationshipStorageTest.assertEquals((int)0, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.rootIdentity));
    }

    private Profile initProfile(String userName, String firstName, String lastName, String fullName, String position, String gender, String company) throws Exception {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userName, true);
        Profile profile = identity.getProfile();
        profile.setProperty("firstName", (Object)firstName);
        profile.setProperty("lastName", (Object)lastName);
        profile.setProperty("fullName", (Object)fullName);
        profile.setProperty("position", (Object)position);
        profile.setProperty("gender", (Object)gender);
        HashMap<String, String> xp = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> xps = new ArrayList<HashMap<String, String>>();
        xp.put("company", company);
        xps.add(xp);
        profile.setProperty("experiences", xps);
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        identity.setProfile(profile);
        this.identityManager.updateIdentity(identity);
        return profile;
    }

    private ProfileFilter buildProfileFilterWithExcludeIdentities(ProfileFilter filter) {
        ProfileFilter result = filter;
        if (result == null) {
            result = new ProfileFilter();
        }
        ArrayList<Identity> excludeIdentities = new ArrayList<Identity>();
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            excludeIdentities.add(identity0);
            result.setExcludedIdentityList(excludeIdentities);
        }
        return result;
    }

    private void populateRelationshipData(Relationship.Type type) {
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            Relationship firstToSecondRelationship = null;
            for (int i = 2; i < this.tearDownIdentityList.size(); ++i) {
                firstToSecondRelationship = new Relationship(identity0, this.tearDownIdentityList.get(i), type);
                this.relationshipStorage.saveRelationship(firstToSecondRelationship);
            }
        }
    }

    private void populateRelationshipIncommingData() {
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            Relationship firstToSecondRelationship = null;
            for (int i = 2; i < this.tearDownIdentityList.size(); ++i) {
                firstToSecondRelationship = new Relationship(this.tearDownIdentityList.get(i), identity0, Relationship.Type.PENDING);
                this.relationshipStorage.saveRelationship(firstToSecondRelationship);
            }
        }
    }

    private void populateData() {
        String providerId = "organization";
        int total = 10;
        HashMap<String, String> xp = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> xps = new ArrayList<HashMap<String, String>>();
        xp.put("company", "exo");
        xps.add(xp);
        for (int i = 0; i < total; ++i) {
            String remoteId = "username" + i;
            Identity identity = new Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            if (i == 3 || i == 4) {
                profile.setProperty("experiences", xps);
            }
            identity.setProfile(profile);
            this.tearDownIdentityList.add(identity);
            this.identityStorage.saveProfile(profile);
        }
    }

    private Identity getInList(List<Identity> identities, String username) {
        if (identities != null) {
            for (Identity id : identities) {
                if (!id.getRemoteId().equals(username)) continue;
                return id;
            }
        }
        return null;
    }
}

