/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.AbstractCategoryConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.model.CategoryTree;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class CategoryLinkServiceTest
extends AbstractCategoryConfigurationTest {
    @Test
    public void testIsLinked() {
        CategoryLinkServiceTest.assertFalse((boolean)this.categoryLinkService.isLinked(12254689L, new CategoryObject("space", "5566", 0L)));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        this.categoryLinkService.link(rootCategory.getId(), object);
        CategoryLinkServiceTest.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
    }

    @Test
    public void testLink() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.categoryLinkService.link(12254689L, new CategoryObject("space", "5566", 0L), "root"));
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), new CategoryObject("space", "5566", 0L), "root"));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "mary"));
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "root"));
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(0L, 0L, 1L, 0L, 1L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        CategoryTree category = (CategoryTree)categoryTree.getCategories().get(0);
        category.setLinkPermissionIds(Collections.singletonList(this.getUsersGroupIdentityId()));
        this.categoryService.updateCategory((Category)category, "john");
        CategoryLinkServiceTest.assertFalse((boolean)this.categoryLinkService.isLinked(category.getId(), object));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "mary"));
        CategoryLinkServiceTest.assertFalse((boolean)this.categoryLinkService.isLinked(category.getId(), object));
        this.spaceService.addMember(space, "mary");
        this.spaceService.setManager(space, "mary", true);
        this.categoryLinkService.link(category.getId(), object, "mary");
        CategoryLinkServiceTest.assertTrue((boolean)this.categoryLinkService.isLinked(category.getId(), object));
    }

    @Test
    public void testUnLink() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.categoryLinkService.unlink(12254689L, new CategoryObject("space", "5566", 0L), "root"));
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), new CategoryObject("space", "5566", 0L), "root"));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), object, "mary"));
        CategoryLinkServiceTest.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.categoryLinkService.unlink(rootCategory.getId(), object, "root");
        CategoryLinkServiceTest.assertFalse((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        rootCategory.setLinkPermissionIds(Collections.singletonList(this.getUsersGroupIdentityId()));
        this.categoryService.updateCategory(rootCategory, "john");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), object, "mary"));
        CategoryLinkServiceTest.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.spaceService.addMember(space, "mary");
        this.spaceService.setManager(space, "mary", true);
        this.categoryLinkService.unlink(rootCategory.getId(), object, "mary");
        CategoryLinkServiceTest.assertFalse((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
    }
}

