/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.junit.Test;

public class PageSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testGetType() {
        PageSidebarPluginTest.assertEquals((Object)SidebarItemType.PAGE, (Object)this.pageSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.pageSidebarPlugin.getDefaultItems();
        PageSidebarPluginTest.assertNotNull((Object)defaultItems);
        PageSidebarPluginTest.assertTrue((boolean)defaultItems.isEmpty());
    }

    @Test
    public void testItemExists() {
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(null, null));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.PAGE);
        item.setProperties(Collections.singletonMap("navigationNodeId", "3555"));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        NodeContext node = this.navigationService.loadNode(SiteKey.portal((String)"contribute"));
        PageSidebarPluginTest.assertNotNull((Object)node);
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("a").getId()));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("b").getId()));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("c").getId()));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("d").getId()));
        PageSidebarPluginTest.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        PageSidebarPluginTest.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SiteKey siteKey = SiteKey.portal((String)"contribute");
        SidebarItem item = new SidebarItem(SidebarItemType.PAGE);
        NodeContext node = this.navigationService.loadNode(siteKey);
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("d").getId()));
        this.pageSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        PageSidebarPluginTest.assertEquals((String)"d", (String)item.getName());
        PageSidebarPluginTest.assertEquals((String)"/portal/contribute/d", (String)item.getUrl());
        PageSidebarPluginTest.assertNull((Object)item.getTarget());
        PageSidebarPluginTest.assertNull((Object)item.getAvatar());
        PageSidebarPluginTest.assertNull((Object)item.getItems());
        PageSidebarPluginTest.assertEquals((String)"d-icon", (String)item.getIcon());
        PortalConfig site = this.layoutService.getPortalConfig(siteKey);
        String siteId = site.getStorageId().split("_")[1];
        PageSidebarPluginTest.assertEquals((String)siteId, (String)((String)item.getProperties().get("siteId")));
        PageSidebarPluginTest.assertEquals((String)siteKey.getTypeName(), (String)((String)item.getProperties().get("siteType")));
        PageSidebarPluginTest.assertEquals((String)siteKey.getName(), (String)((String)item.getProperties().get("siteName")));
        PageSidebarPluginTest.assertEquals((String)"a-icon", (String)((String)item.getProperties().get("siteIcon")));
        PageSidebarPluginTest.assertEquals((String)"contribute", (String)((String)item.getProperties().get("siteDisplayName")));
    }
}

