/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Before;
import org.junit.Test;

public class SpaceListSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        for (int i = 0; i < 5; ++i) {
            Space space = new Space();
            space.setRegistration("open");
            space.setVisibility("public");
            this.spaceService.createSpace(space, this.userAcl.getSuperUser());
        }
    }

    @Test
    public void testGetType() {
        SpaceListSidebarPluginTest.assertEquals((Object)SidebarItemType.SPACES, (Object)this.spaceListSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceListSidebarPlugin.getDefaultItems();
        SpaceListSidebarPluginTest.assertNotNull((Object)defaultItems);
        SpaceListSidebarPluginTest.assertTrue((boolean)defaultItems.stream().anyMatch(item -> StringUtils.contains((CharSequence)((CharSequence)item.getProperties().get("names")), (CharSequence)"sidebar.viewAllSpaces")));
    }

    @Test
    public void testItemExists() {
        SpaceListSidebarPluginTest.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(null, null));
        SpaceListSidebarPluginTest.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACES);
        SpaceListSidebarPluginTest.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("names", "{}"));
        SpaceListSidebarPluginTest.assertTrue((boolean)this.spaceListSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        String enName = "Test EN";
        String frName = "Test FR";
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(Locale.ENGLISH.toLanguageTag(), enName);
        names.put(Locale.FRENCH.toLanguageTag(), frName);
        String namesJsonString = JsonUtils.toJsonString(names);
        SidebarItem item = new SidebarItem("fakeName", "url", "target", "avatar", "icon", SidebarItemType.SPACES, null, Collections.singletonMap("names", namesJsonString));
        SidebarItem result = this.spaceListSidebarPlugin.resolveProperties(item, null, Locale.ENGLISH);
        SpaceListSidebarPluginTest.assertNotNull((Object)result);
        SpaceListSidebarPluginTest.assertEquals((String)enName, (String)result.getName());
        result = this.spaceListSidebarPlugin.resolveProperties(item, null, Locale.FRENCH);
        SpaceListSidebarPluginTest.assertNotNull((Object)result);
        SpaceListSidebarPluginTest.assertEquals((String)frName, (String)result.getName());
        SpaceListSidebarPluginTest.assertNotNull((Object)result.getItems());
        SpaceListSidebarPluginTest.assertTrue((boolean)result.getItems().isEmpty());
        result = this.spaceListSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.FRENCH);
        SpaceListSidebarPluginTest.assertNotNull((Object)result.getItems());
        SpaceListSidebarPluginTest.assertEquals((int)4, (int)item.getItems().size());
    }
}

