/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.social.space.service.SpaceLayoutService;
import java.util.Arrays;
import java.util.HashSet;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/social.component.core-local-portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml")})
public class SpaceLayoutServiceTest
extends AbstractCoreTest {
    private SpaceLayoutService spaceLayoutService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.spaceLayoutService = this.getService(SpaceLayoutService.class);
    }

    public void testSaveSpacePublicSite() {
        Space space = this.getSpaceInstance(18);
        String spaceId = space.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceLayoutService.saveSpacePublicSite("15587688", "authenticated", "demo"));
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", "raul"));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", "demo");
        space = this.spaceService.getSpaceById(space.getId());
        SpaceLayoutServiceTest.assertEquals((String)"authenticated", (String)space.getPublicSiteVisibility());
        long publicSiteId = space.getPublicSiteId();
        SpaceLayoutServiceTest.assertTrue((publicSiteId > 0L ? 1 : 0) != 0);
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        PortalConfig publicSitePortalConfig = layoutService.getPortalConfig(publicSiteId);
        SpaceLayoutServiceTest.assertNotNull((Object)publicSitePortalConfig);
        SpaceLayoutServiceTest.assertEquals((String)space.getPrettyName(), (String)publicSitePortalConfig.getName());
        SpaceLayoutServiceTest.assertEquals((String)space.getDisplayName(), (String)publicSitePortalConfig.getLabel());
        SpaceLayoutServiceTest.assertEquals((int)2, (int)publicSitePortalConfig.getAccessPermissions().length);
        SpaceLayoutServiceTest.assertEquals(new HashSet<String>(Arrays.asList("member:/platform/externals", "member:/platform/users")), new HashSet<String>(Arrays.asList(publicSitePortalConfig.getAccessPermissions())));
        SpaceLayoutServiceTest.assertEquals((String)("manager:" + space.getGroupId()), (String)publicSitePortalConfig.getEditPermission());
        SpaceLayoutServiceTest.assertEquals((String)spaceId, (String)publicSitePortalConfig.getProperty("SPACE_ID"));
        SpaceLayoutServiceTest.assertEquals((String)"true", (String)publicSitePortalConfig.getProperty("IS_SPACE_PUBLIC_SITE"));
    }

    public void testChangeSpacePublicSiteVisibility() {
        Space space = this.getSpaceInstance(18);
        String spaceId = space.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceLayoutService.saveSpacePublicSite("15587688", "authenticated", "demo"));
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", "raul"));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", "demo");
        space = this.spaceService.getSpaceById(space.getId());
        SpaceLayoutServiceTest.assertEquals((String)"authenticated", (String)space.getPublicSiteVisibility());
        long publicSiteId = space.getPublicSiteId();
        SpaceLayoutServiceTest.assertTrue((publicSiteId > 0L ? 1 : 0) != 0);
        space.setVisibility("hidden");
        this.spaceService.updateSpace(space);
        space = this.spaceService.getSpaceById(space.getId());
        SpaceLayoutServiceTest.assertEquals((String)"member", (String)space.getPublicSiteVisibility());
        SpaceLayoutServiceTest.assertEquals((String)space.getPrettyName(), (String)this.spaceLayoutService.getSpacePublicSiteName(space));
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        PortalConfig publicSitePortalConfig = layoutService.getPortalConfig(publicSiteId);
        SpaceLayoutServiceTest.assertNotNull((Object)publicSitePortalConfig);
        SpaceLayoutServiceTest.assertEquals((String)space.getPrettyName(), (String)publicSitePortalConfig.getName());
        SpaceLayoutServiceTest.assertEquals((String)space.getDisplayName(), (String)publicSitePortalConfig.getLabel());
        SpaceLayoutServiceTest.assertFalse((boolean)publicSitePortalConfig.isDefaultSite());
        SpaceLayoutServiceTest.assertEquals((int)1, (int)publicSitePortalConfig.getAccessPermissions().length);
        SpaceLayoutServiceTest.assertEquals(new HashSet<String>(Arrays.asList("member:" + space.getGroupId())), new HashSet<String>(Arrays.asList(publicSitePortalConfig.getAccessPermissions())));
        SpaceLayoutServiceTest.assertEquals((String)("manager:" + space.getGroupId()), (String)publicSitePortalConfig.getEditPermission());
    }

    public void testSpaceWithPublicSiteRemoved() {
        Space space = this.getSpaceInstance(19);
        String spaceId = space.getId();
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", "demo");
        space = this.spaceService.getSpaceById(space.getId());
        long publicSiteId = space.getPublicSiteId();
        SpaceLayoutServiceTest.assertTrue((publicSiteId > 0L ? 1 : 0) != 0);
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        PortalConfig publicSitePortalConfig = layoutService.getPortalConfig(publicSiteId);
        SpaceLayoutServiceTest.assertNotNull((Object)publicSitePortalConfig);
        this.spaceService.deleteSpace(space);
        SpaceLayoutServiceTest.assertNull((Object)layoutService.getPortalConfig(publicSiteId));
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        Space createdSpace = this.spaceService.createSpace(space, "root");
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        return createdSpace;
    }
}

