/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.service;

import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.model.SpaceTemplateFilter;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.data.domain.Pageable;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceTemplateServiceTest {
    private static final String SPACE_FIELDS = "spaceFields";
    private static final String SPACE_DELETE_PERMISSIONS = "spaceDeletePermissions";
    private static final String SPACE_LAYOUT_PERMISSIONS = "spaceLayoutPermissions";
    private static final String SPACE_PUBLIC_SITE_PERMISSIONS = "spacePublicSitePermissions";
    private static final String CREATE_AND_ACCESS_PERMISSIONS = "permissions";
    private static final String ADMIN_PERMISSIONS = "adminPermissions";
    private static final String TEST_USER = "testuser";
    private static final long SPACE_CATEGORY_ID = 2L;
    @Mock
    protected TranslationService translationService;
    @Mock
    protected AttachmentService attachmentService;
    @Mock
    protected UserPortalConfigService userPortalConfigService;
    @Mock
    protected LayoutService layoutService;
    @Mock
    protected NavigationService navigationService;
    @Mock
    protected ListenerService listenerService;
    @Mock
    protected UserACL userAcl;
    @Mock
    private SpaceTemplateStorage spaceTemplateStorage;
    @Mock
    private Identity userIdentity;
    @Mock
    private PortalConfig portalConfig;
    private SpaceTemplateService spaceTemplateService;

    @Before
    public void init() {
        this.spaceTemplateService = new SpaceTemplateService(this.translationService, this.attachmentService, this.userPortalConfigService, this.layoutService, this.navigationService, this.listenerService, this.userAcl, this.spaceTemplateStorage);
    }

    @Test
    public void testGetSpaceTemplates() {
        Pageable pageable = Pageable.unpaged();
        List spaceTemplates = this.spaceTemplateService.getSpaceTemplates(new SpaceTemplateFilter(), pageable, true);
        Assert.assertNotNull((Object)spaceTemplates);
        Assertions.assertEquals((int)0, (int)spaceTemplates.size());
        SpaceTemplate spaceTemplate = this.newSpaceTemplate(2L);
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplates(pageable)).then(invocation -> List.of(spaceTemplate));
        spaceTemplates = this.spaceTemplateService.getSpaceTemplates(null, pageable, true);
        Assert.assertNotNull((Object)spaceTemplates);
        Assertions.assertEquals((int)1, (int)spaceTemplates.size());
        Assertions.assertEquals((Object)spaceTemplate, spaceTemplates.get(0));
        SpaceTemplateFilter spaceTemplateFilter = new SpaceTemplateFilter();
        spaceTemplateFilter.setUsername(TEST_USER);
        spaceTemplateFilter.setIncludeDisabled(true);
        spaceTemplates = this.spaceTemplateService.getSpaceTemplates(spaceTemplateFilter, pageable, true);
        Assert.assertNotNull((Object)spaceTemplates);
        Assertions.assertEquals((int)0, (int)spaceTemplates.size());
        this.setCanViewTemplate(true);
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)spaceTemplate);
        spaceTemplates = this.spaceTemplateService.getSpaceTemplates(spaceTemplateFilter, pageable, false);
        Assert.assertNotNull((Object)spaceTemplates);
        Assertions.assertEquals((int)1, (int)spaceTemplates.size());
        Assertions.assertEquals((Object)spaceTemplate, spaceTemplates.get(0));
    }

    @Test
    public void testGetSpaceTemplate() throws IllegalAccessException {
        Assert.assertNull((Object)this.spaceTemplateService.getSpaceTemplate(2L));
        Assert.assertNull((Object)this.spaceTemplateService.getSpaceTemplate(2L, TEST_USER, Locale.ENGLISH, false));
        SpaceTemplate spaceTemplate = this.newSpaceTemplate(2L);
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)spaceTemplate);
        Assertions.assertEquals((Object)spaceTemplate, (Object)this.spaceTemplateService.getSpaceTemplate(2L));
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceTemplateService.getSpaceTemplate(2L, TEST_USER, Locale.ENGLISH, false));
        this.setCanViewTemplate(true);
        Assertions.assertEquals((Object)spaceTemplate, (Object)this.spaceTemplateService.getSpaceTemplate(2L, TEST_USER, Locale.ENGLISH, false));
    }

    @Test
    public void testCanManageTemplates() {
        Assert.assertFalse((boolean)this.spaceTemplateService.canManageTemplates(TEST_USER));
        this.setCanManageTemplate(true);
        Assert.assertTrue((boolean)this.spaceTemplateService.canManageTemplates(TEST_USER));
    }

    @Test
    public void testCanViewTemplateWhenManager() {
        Assert.assertFalse((boolean)this.spaceTemplateService.canViewTemplate(2L, null));
        Assert.assertFalse((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
        this.setCanManageTemplate(true);
        Assert.assertFalse((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)this.newSpaceTemplate(2L));
        Assert.assertTrue((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
    }

    @Test
    public void testCanViewTemplateWhenMemberOfPermissions() {
        Assert.assertFalse((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
        this.setCanViewTemplate(true);
        Assert.assertFalse((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)this.newSpaceTemplate(2L));
        Assert.assertTrue((boolean)this.spaceTemplateService.canViewTemplate(2L, TEST_USER));
    }

    @Test
    public void testCreateSpaceTemplate() throws IllegalAccessException, ObjectNotFoundException {
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceTemplateService.createSpaceTemplate(this.newSpaceTemplate(0L), TEST_USER));
        this.setCanManageTemplate(true);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.spaceTemplateService.createSpaceTemplate(this.newSpaceTemplate(2L), TEST_USER));
        SpaceTemplate spaceTemplate = this.newSpaceTemplate(0L);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceTemplateService.createSpaceTemplate(spaceTemplate, TEST_USER));
        ((SpaceTemplateStorage)Mockito.doAnswer(invocation -> {
            SpaceTemplate spaceTemplateClone = spaceTemplate.clone();
            spaceTemplateClone.setId(2L);
            return spaceTemplateClone;
        }).when((Object)this.spaceTemplateStorage)).createSpaceTemplate((SpaceTemplate)ArgumentMatchers.any());
        Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.groupTemplate((String)spaceTemplate.getLayout()))).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.groupTemplate((String)"2"))).thenReturn((Object)this.portalConfig);
        this.spaceTemplateService.createSpaceTemplate(spaceTemplate, TEST_USER);
        SpaceTemplate spaceTemplateClone = spaceTemplate.clone();
        spaceTemplateClone.setLayout(null);
        spaceTemplateClone.setSystem(false);
        spaceTemplateClone.setDeleted(false);
        ((SpaceTemplateStorage)Mockito.verify((Object)this.spaceTemplateStorage)).createSpaceTemplate(spaceTemplateClone);
        ((SpaceTemplateStorage)Mockito.verify((Object)this.spaceTemplateStorage)).updateSpaceTemplate((SpaceTemplate)ArgumentMatchers.argThat(template -> StringUtils.equals((CharSequence)template.getLayout(), (CharSequence)"2")));
        ((UserPortalConfigService)Mockito.verify((Object)this.userPortalConfigService)).createSiteFromTemplate(SiteKey.groupTemplate((String)spaceTemplate.getLayout()), SiteKey.groupTemplate((String)"2"));
    }

    @Test
    public void testUpdateSpaceTemplate() throws ObjectNotFoundException, IllegalAccessException {
        SpaceTemplate spaceTemplate = this.newSpaceTemplate(2L);
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceTemplateService.updateSpaceTemplate(spaceTemplate, TEST_USER));
        this.setCanManageTemplate(true);
        spaceTemplate.setDeleted(true);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.spaceTemplateService.updateSpaceTemplate(spaceTemplate, TEST_USER));
        SpaceTemplate savedSpaceTemplate = this.newSpaceTemplate(2L);
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)savedSpaceTemplate);
        savedSpaceTemplate.setDeleted(true);
        spaceTemplate.setDeleted(false);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceTemplateService.updateSpaceTemplate(spaceTemplate, TEST_USER));
        savedSpaceTemplate.setDeleted(false);
        this.spaceTemplateService.updateSpaceTemplate(spaceTemplate, TEST_USER);
        ((SpaceTemplateStorage)Mockito.verify((Object)this.spaceTemplateStorage)).updateSpaceTemplate(spaceTemplate);
    }

    @Test
    public void testDeleteSpaceTemplate() throws IllegalAccessException, ObjectNotFoundException {
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceTemplateService.deleteSpaceTemplate(2L, TEST_USER));
        this.setCanManageTemplate(true);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceTemplateService.deleteSpaceTemplate(2L, TEST_USER));
        SpaceTemplate savedSpaceTemplate = this.newSpaceTemplate(2L);
        Mockito.when((Object)this.spaceTemplateStorage.getSpaceTemplate(2L)).thenReturn((Object)savedSpaceTemplate);
        savedSpaceTemplate.setSystem(false);
        savedSpaceTemplate.setDeleted(true);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceTemplateService.deleteSpaceTemplate(2L, TEST_USER));
        savedSpaceTemplate.setDeleted(false);
        savedSpaceTemplate.setSystem(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceTemplateService.deleteSpaceTemplate(2L, TEST_USER));
        savedSpaceTemplate.setSystem(false);
        this.spaceTemplateService.deleteSpaceTemplate(2L, TEST_USER);
        ((SpaceTemplateStorage)Mockito.verify((Object)this.spaceTemplateStorage)).updateSpaceTemplate(savedSpaceTemplate);
        Assert.assertTrue((boolean)savedSpaceTemplate.isDeleted());
    }

    private void setCanViewTemplate(boolean hasAccess) {
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.userIdentity.isMemberOf(new MembershipEntry(CREATE_AND_ACCESS_PERMISSIONS))).thenReturn((Object)hasAccess);
    }

    private void setCanManageTemplate(boolean hasAccess) {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)identity);
        Mockito.when((Object)this.userAcl.isAdministrator(identity)).thenReturn((Object)hasAccess);
    }

    private SpaceTemplate newSpaceTemplate(long id) {
        return new SpaceTemplate(id, "name", "description", 6L, "icon", true, false, true, "layout", Arrays.asList(CREATE_AND_ACCESS_PERMISSIONS), Arrays.asList(ADMIN_PERMISSIONS), Arrays.asList(SPACE_LAYOUT_PERMISSIONS), Arrays.asList(SPACE_DELETE_PERMISSIONS), Arrays.asList(SPACE_PUBLIC_SITE_PERMISSIONS), Arrays.asList(SPACE_FIELDS), Arrays.asList(2L), SpaceVisibility.PRIVATE, SpaceRegistration.VALIDATION, true);
    }
}

