/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.metadata.favorite;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;

public class FavoriteServiceTest
extends AbstractCoreTest {
    private Identity johnIdentity;
    private FavoriteService favoriteService;
    private MetadataService metadataService;
    private MetadataType favoriteMetadataType;
    private MetadataType userMetadataType;
    private MetadataDAO metadataDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.favoriteService = (FavoriteService)this.getContainer().getComponentInstanceOfType(FavoriteService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        ((MetadataStorage)this.getContainer().getComponentInstanceOfType(MetadataStorage.class)).clearCaches();
        this.favoriteMetadataType = new MetadataType(1L, "favorites");
        this.userMetadataType = new MetadataType(2L, "user");
        if (this.metadataService.getMetadataTypeByName(this.userMetadataType.getName()) == null) {
            MetadataTypePlugin userMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(1000L, "user")){

                public boolean isAllowMultipleItemsPerObject() {
                    return false;
                }

                public boolean isShareable() {
                    return true;
                }
            };
            this.metadataService.addMetadataTypePlugin(userMetadataTypePlugin);
        }
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.metadataDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateFavorite() throws Exception {
        String objectType = "type";
        String objectId = "1";
        String parentObjectId = "2";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 500L;
        Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)metadataItemsByObject));
        this.favoriteService.createFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        MetadataItem metadataItem = (MetadataItem)metadataItemsByObject.get(0);
        FavoriteServiceTest.assertEquals((long)userIdentityId, (long)metadataItem.getCreatorId());
        FavoriteServiceTest.assertEquals((String)objectId, (String)metadataItem.getObjectId());
        FavoriteServiceTest.assertEquals((String)objectType, (String)metadataItem.getObjectType());
        FavoriteServiceTest.assertEquals((String)parentObjectId, (String)metadataItem.getParentObjectId());
        try {
            this.favoriteService.createFavorite(favorite);
            FavoriteServiceTest.fail();
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
    }

    public void testGetFavoriteItemsByCreator() throws Exception {
        long userIdentityId;
        long audienceId = userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String favoriteType = this.favoriteMetadataType.getName();
        String otherType = this.userMetadataType.getName();
        this.createNewMetadataItem(favoriteType, "testMetadata1", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata2", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata3", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata4", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata5", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata6", "objectType1", "objectId1", "parentObjectId1", userIdentityId, audienceId);
        List favoritesList = this.metadataService.getMetadataItemsByMetadataTypeAndCreator("favorites", userIdentityId, 3L, 0L);
        favoritesList = this.metadataService.getMetadataItemsByMetadataTypeAndCreator("favorites", userIdentityId, 0L, 5L);
        FavoriteServiceTest.assertEquals((int)3, (int)favoritesList.size());
        favoritesList = this.metadataService.getMetadataItemsByMetadataTypeAndCreator("favorites", 100L, 0L, 5L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoritesList.size());
    }

    public void testGetFavoriteItemsByCreatorAndType() throws Exception {
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String objectType = "space";
        String otherObjectType = "activite";
        this.favoriteService.createFavorite(new Favorite(objectType, "objectId1", null, userIdentityId));
        this.favoriteService.createFavorite(new Favorite(objectType, "objectId2", null, userIdentityId));
        this.favoriteService.createFavorite(new Favorite(otherObjectType, "objectId3", null, userIdentityId));
        this.favoriteService.createFavorite(new Favorite(otherObjectType, "objectId4", null, userIdentityId + 1L));
        List favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 2L, 2L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoritesList.size());
        favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 0L, 2L);
        FavoriteServiceTest.assertEquals((int)2, (int)favoritesList.size());
        favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType("test", userIdentityId, 0L, 3L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoritesList.size());
    }

    public void testDeleteFavorite() throws Exception {
        String objectType = "type";
        String objectId = "1";
        String parentObjectId = "2";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 500L;
        Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)metadataItemsByObject));
        this.favoriteService.createFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        this.favoriteService.deleteFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)0, (int)metadataItemsByObject.size());
        try {
            this.favoriteService.deleteFavorite(favorite);
            FavoriteServiceTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    private MetadataItem createNewMetadataItem(String type, String name, String objectType, String objectId, String parentObjectId, long creatorId, long audienceId) throws Exception {
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setObjectId(objectId);
        metadataItem.setObjectType(objectType);
        metadataItem.setParentObjectId(parentObjectId);
        return this.metadataService.createMetadataItem(metadataItem.getObject(), new MetadataKey(type, name, audienceId), creatorId);
    }

    private InitParams newParam(long id, String name) {
        InitParams params = new InitParams();
        MetadataType metadataType = new MetadataType(id, name);
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadataType");
        parameter.setObject((Object)metadataType);
        params.addParameter((Parameter)parameter);
        return params;
    }
}

