/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.listener;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.junit.Test;

public class NavigationConfigurationSiteDisplayListenerTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testUpdateSiteDisplayedStatusByConfiguration() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration();
        NavigationConfigurationSiteDisplayListenerTest.assertNotNull((Object)configuration);
        NavigationConfigurationSiteDisplayListenerTest.assertNotNull((Object)configuration.getTopbar());
        NavigationConfigurationSiteDisplayListenerTest.assertNotNull((Object)configuration.getSidebar());
        SiteFilter siteFilter = new SiteFilter();
        siteFilter.setSiteType(SiteType.PORTAL);
        List sites = this.layoutService.getSites(siteFilter);
        NavigationConfigurationSiteDisplayListenerTest.assertNotNull((Object)sites);
        List<String> siteNames = this.getSiteNames(configuration);
        String siteName = siteNames.get(0);
        List originalSidebarItems = configuration.getSidebar().getItems();
        ArrayList<SidebarItem> sidebarItems = new ArrayList<SidebarItem>(originalSidebarItems);
        sidebarItems.removeIf(item -> item.getType() == SidebarItemType.SITE && siteName.equals(item.getProperties().get("siteName")));
        configuration.getSidebar().setItems(sidebarItems);
        this.navigationConfigurationService.updateConfiguration(configuration);
        SiteKey standaloneSiteKey = SiteKey.portal((String)siteName);
        PortalConfig updatedSite = this.layoutService.getPortalConfig(standaloneSiteKey);
        NavigationConfigurationSiteDisplayListenerTest.assertFalse((boolean)updatedSite.isDisplayed());
        configuration.getSidebar().setItems(originalSidebarItems);
        this.navigationConfigurationService.updateConfiguration(configuration);
        updatedSite = this.layoutService.getPortalConfig(standaloneSiteKey);
        NavigationConfigurationSiteDisplayListenerTest.assertTrue((boolean)updatedSite.isDisplayed());
    }

    private List<String> getSiteNames(NavigationConfiguration configuration) {
        return configuration.getSidebar().getItems().stream().filter(item -> item.getType() == SidebarItemType.SITE).map(item -> (String)item.getProperties().get("siteName")).toList();
    }
}

