/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.upgrade;

import io.meeds.social.upgrade.LayoutUpgradePlugin;
import io.meeds.social.upgrade.model.LayoutUpgrade;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/social.component.core-local-portal-configuration.xml")})
public class LayoutUpgradePluginTest
extends AbstractCoreTest {
    private static final String UPGRADE_LOCATION_PATH = "classpath:/portal/config/upgrade";
    private static final String PORTAL_TYPE = "portal";
    private static final String PORTAL_NAME = "meeds";
    private static final String PAGE_KEY_UPGRADE = "portal::meeds::test55";
    private static final String PAGE_KEY = "portal::meeds::test1";
    private static final String PROP_KEY = "prop_key";
    private static final String PROP_VALUE = "test_prop_value";
    private static final String PROP_VALUE_MODIFIED = "test_prop_value_2";
    private static final String NAV_NODE_NAME = "node_name";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getService(UserPortalConfigService.class).start();
    }

    public void testUpgradePortalConfig() {
        InitParams initParams = new InitParams();
        LayoutUpgrade layoutUpgrade = new LayoutUpgrade();
        layoutUpgrade.setConfigPath(UPGRADE_LOCATION_PATH);
        layoutUpgrade.setPortalType(PORTAL_TYPE);
        layoutUpgrade.setPortalName(PORTAL_NAME);
        layoutUpgrade.setUpdatePortalConfig(true);
        ObjectParameter objectParam = new ObjectParameter();
        objectParam.setObject((Object)layoutUpgrade);
        initParams.addParameter((Parameter)objectParam);
        LayoutService layoutService = this.getService(LayoutService.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        Container portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        LayoutUpgradePlugin layoutUpgradePlugin = new LayoutUpgradePlugin(layoutService, this.getService(SettingService.class), this.getService(UserPortalConfigService.class), this.getService(NavigationService.class), this.getService(DescriptionStorage.class), initParams);
        layoutUpgradePlugin.processUpgrade(null, null);
        portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE_MODIFIED, (String)portalConfig.getProperty(PROP_KEY));
        portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)5, (int)portalLayout.getChildren().size());
        LayoutUpgradePluginTest.assertNull((Object)layoutService.getPage(PageKey.parse((String)PAGE_KEY_UPGRADE)));
    }

    public void testUpgradePageLayout() {
        InitParams initParams = new InitParams();
        LayoutUpgrade layoutUpgrade = new LayoutUpgrade();
        layoutUpgrade.setConfigPath(UPGRADE_LOCATION_PATH);
        layoutUpgrade.setPortalType(PORTAL_TYPE);
        layoutUpgrade.setPortalName(PORTAL_NAME);
        layoutUpgrade.setUpdatePageLayout(true);
        ObjectParameter objectParam = new ObjectParameter();
        objectParam.setObject((Object)layoutUpgrade);
        initParams.addParameter((Parameter)objectParam);
        LayoutService layoutService = this.getService(LayoutService.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        Container portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        Page page = layoutService.getPage(PageKey.parse((String)PAGE_KEY));
        LayoutUpgradePluginTest.assertNotNull((Object)page);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)page.getChildren().size());
        LayoutUpgradePlugin layoutUpgradePlugin = new LayoutUpgradePlugin(layoutService, this.getService(SettingService.class), this.getService(UserPortalConfigService.class), this.getService(NavigationService.class), this.getService(DescriptionStorage.class), initParams);
        layoutUpgradePlugin.processUpgrade(null, null);
        portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        LayoutUpgradePluginTest.assertNull((Object)layoutService.getPage(PageKey.parse((String)PAGE_KEY_UPGRADE)));
        page = layoutService.getPage(PageKey.parse((String)PAGE_KEY));
        LayoutUpgradePluginTest.assertNotNull((Object)page);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)page.getChildren().size());
        layoutUpgrade.setPageNames(Collections.singletonList("test1"));
        layoutUpgradePlugin.processUpgrade(null, null);
        portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        LayoutUpgradePluginTest.assertNull((Object)layoutService.getPage(PageKey.parse((String)PAGE_KEY_UPGRADE)));
        page = layoutService.getPage(PageKey.parse((String)PAGE_KEY));
        LayoutUpgradePluginTest.assertNotNull((Object)page);
        LayoutUpgradePluginTest.assertEquals((int)2, (int)page.getChildren().size());
    }

    public void testUpgradeNavigation() {
        InitParams initParams = new InitParams();
        LayoutUpgrade layoutUpgrade = new LayoutUpgrade();
        layoutUpgrade.setConfigPath(UPGRADE_LOCATION_PATH);
        layoutUpgrade.setPortalType(PORTAL_TYPE);
        layoutUpgrade.setPortalName(PORTAL_NAME);
        layoutUpgrade.setUpdateNavigation(true);
        ObjectParameter objectParam = new ObjectParameter();
        objectParam.setObject((Object)layoutUpgrade);
        initParams.addParameter((Parameter)objectParam);
        LayoutService layoutService = this.getService(LayoutService.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        Container portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        Page page = layoutService.getPage(PageKey.parse((String)PAGE_KEY));
        LayoutUpgradePluginTest.assertNotNull((Object)page);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)page.getChildren().size());
        NavigationService navigationService = this.getService(NavigationService.class);
        NodeContext navNode = navigationService.loadNode(new SiteKey(PORTAL_TYPE, PORTAL_NAME), NAV_NODE_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)navNode);
        LayoutUpgradePluginTest.assertNotNull((Object)navNode.getState());
        LayoutUpgradePluginTest.assertNotNull((Object)navNode.getState().getPageRef());
        LayoutUpgradePluginTest.assertEquals((String)"test1", (String)navNode.getState().getPageRef().getName());
        LayoutUpgradePlugin layoutUpgradePlugin = new LayoutUpgradePlugin(layoutService, this.getService(SettingService.class), this.getService(UserPortalConfigService.class), navigationService, this.getService(DescriptionStorage.class), initParams);
        layoutUpgradePlugin.processUpgrade(null, null);
        portalConfig = layoutService.getPortalConfig(PORTAL_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)portalConfig);
        LayoutUpgradePluginTest.assertEquals((String)PROP_VALUE, (String)portalConfig.getProperty(PROP_KEY));
        portalLayout = portalConfig.getPortalLayout();
        LayoutUpgradePluginTest.assertNotNull((Object)portalLayout);
        LayoutUpgradePluginTest.assertEquals((int)1, (int)portalLayout.getChildren().size());
        LayoutUpgradePluginTest.assertNull((Object)layoutService.getPage(PageKey.parse((String)PAGE_KEY_UPGRADE)));
        navNode = navigationService.loadNode(new SiteKey(PORTAL_TYPE, PORTAL_NAME), NAV_NODE_NAME);
        LayoutUpgradePluginTest.assertNotNull((Object)navNode);
        LayoutUpgradePluginTest.assertEquals((String)"test2", (String)navNode.getState().getPageRef().getName());
    }
}

