/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.impl.StorageUtils;

public class StorageUtilsTest
extends TestCase {
    public void testProcessUnifiedSearchCondition() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.add("first");
        result.add("*two");
        result.add("three%");
        result.add("%four*");
        result.add("*five*");
        StorageUtilsTest.assertEquals(result, (Object)StorageUtils.processUnifiedSearchCondition((String)"first *two three% %four* *five*"));
    }

    public void testSortMapByValue() throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("value1", 1);
        map.put("value12", 12);
        map.put("value10", 10);
        map.put("value9", 9);
        map.put("value3", 3);
        map.put("value5", 0);
        LinkedHashMap<String, Integer> ascMap = new LinkedHashMap<String, Integer>();
        ascMap.put("value5", 0);
        ascMap.put("value1", 1);
        ascMap.put("value3", 3);
        ascMap.put("value9", 9);
        ascMap.put("value10", 10);
        ascMap.put("value12", 12);
        LinkedHashMap<String, Integer> descMap = new LinkedHashMap<String, Integer>();
        descMap.put("value12", 12);
        descMap.put("value10", 10);
        descMap.put("value9", 9);
        descMap.put("value3", 3);
        descMap.put("value1", 1);
        descMap.put("value5", 0);
        StorageUtilsTest.assertEquals(ascMap, (Object)StorageUtils.sortMapByValue(map, (boolean)true));
        StorageUtilsTest.assertEquals(descMap, (Object)StorageUtils.sortMapByValue(map, (boolean)false));
    }

    public void testGetCommonItemNumber() throws Exception {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        list1.add("d");
        list1.add("e");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("b");
        list2.add("d");
        list2.add("x");
        list2.add("y");
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("m");
        list3.add("e");
        list3.add("p");
        StorageUtilsTest.assertEquals((int)2, (int)StorageUtils.getCommonItemNumber(list1, list2));
        StorageUtilsTest.assertEquals((int)2, (int)StorageUtils.getCommonItemNumber(list2, list1));
        StorageUtilsTest.assertEquals((int)1, (int)StorageUtils.getCommonItemNumber(list1, list3));
        StorageUtilsTest.assertEquals((int)1, (int)StorageUtils.getCommonItemNumber(list3, list1));
        StorageUtilsTest.assertEquals((int)0, (int)StorageUtils.getCommonItemNumber(list2, list3));
        StorageUtilsTest.assertEquals((int)0, (int)StorageUtils.getCommonItemNumber(list3, list2));
    }

    public void testSubList() throws Exception {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i = 0; i < 20; ++i) {
            list.add((CallSite)((Object)("" + i)));
        }
        List loaded = StorageUtils.subList(list, (int)0, (int)10);
        StorageUtilsTest.assertEquals((int)10, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)0, (int)25);
        StorageUtilsTest.assertEquals((int)20, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)19, (int)25);
        StorageUtilsTest.assertEquals((int)1, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)10, (int)25);
        StorageUtilsTest.assertEquals((int)10, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)15, (int)15);
        StorageUtilsTest.assertEquals((int)0, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)20, (int)25);
        StorageUtilsTest.assertEquals((int)0, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)25, (int)10);
        StorageUtilsTest.assertEquals((int)0, (int)loaded.size());
        loaded = StorageUtils.subList(list, (int)25, (int)30);
        StorageUtilsTest.assertEquals((int)0, (int)loaded.size());
    }

    public void testSortSpaceByName() {
        Space space1 = new Space();
        space1.setDisplayName("XYZ");
        Space space2 = new Space();
        space2.setDisplayName("ABC");
        Space space3 = new Space();
        space3.setDisplayName("GHE");
        LinkedList<Space> list = new LinkedList<Space>();
        list.add(space1);
        list.add(space2);
        list.add(space3);
        StorageUtilsTest.assertEquals((String)"XYZ", (String)((Space)list.get(0)).getDisplayName());
        StorageUtilsTest.assertEquals((String)"ABC", (String)((Space)list.get(1)).getDisplayName());
        StorageUtilsTest.assertEquals((String)"GHE", (String)((Space)list.get(2)).getDisplayName());
        StorageUtils.sortSpaceByName(list, (boolean)true);
        StorageUtilsTest.assertEquals((String)"ABC", (String)((Space)list.get(0)).getDisplayName());
        StorageUtilsTest.assertEquals((String)"GHE", (String)((Space)list.get(1)).getDisplayName());
        StorageUtilsTest.assertEquals((String)"XYZ", (String)((Space)list.get(2)).getDisplayName());
    }

    public void testSortIdentitiesByFullName() {
        Identity id1 = new Identity("id1");
        Profile profile = id1.getProfile();
        profile.setProperty("fullName", (Object)"Xyz");
        Identity id2 = new Identity("id2");
        profile = id2.getProfile();
        profile.setProperty("fullName", (Object)"BCD");
        Identity id3 = new Identity("id3");
        profile = id3.getProfile();
        profile.setProperty("fullName", (Object)"Abc");
        LinkedList<Identity> list = new LinkedList<Identity>();
        list.add(id1);
        list.add(id2);
        list.add(id3);
        StorageUtilsTest.assertEquals((String)"Xyz", (String)((Identity)list.get(0)).getProfile().getFullName());
        StorageUtilsTest.assertEquals((String)"Abc", (String)((Identity)list.get(2)).getProfile().getFullName());
        StorageUtils.sortIdentitiesByFullName(list, (boolean)true);
        StorageUtilsTest.assertEquals((String)"Abc", (String)((Identity)list.get(0)).getProfile().getFullName());
        StorageUtilsTest.assertEquals((String)"Xyz", (String)((Identity)list.get(2)).getProfile().getFullName());
    }
}

