/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceTemplateConfigPlugin;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.impl.SpaceTemplateServiceImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceTemplateServiceTest
extends AbstractCoreTest {
    private SpaceTemplateService spaceTemplateService;
    private IdentityStorage identityStorage;
    private List<Space> tearDownSpaceList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceTemplateService = (SpaceTemplateService)CommonsUtils.getService(SpaceTemplateService.class);
        this.identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        this.tearDownSpaceList = new ArrayList<Space>();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                try {
                    this.identityStorage.deleteIdentity(spaceIdentity);
                }
                catch (IdentityStorageException identityStorageException) {
                    // empty catch block
                }
            }
            try {
                this.spaceService.deleteSpace(space);
            }
            catch (Exception exception) {}
        }
        super.tearDown();
    }

    public void testGetSpaceTemplates() {
        List templates = this.spaceTemplateService.getSpaceTemplates();
        SpaceTemplateServiceTest.assertTrue((boolean)Collections.unmodifiableList(Collections.EMPTY_LIST).getClass().isInstance(templates));
    }

    public void testGetAllSpaceTemplatesWithNoPermissions() throws Exception {
        List templates = this.spaceTemplateService.getSpaceTemplates("toto");
        SpaceTemplateServiceTest.assertEquals((int)0, (int)templates.size());
    }

    public void testGetSpaceTemplateByName() {
        SpaceTemplate template = this.spaceTemplateService.getSpaceTemplateByName("classic");
        SpaceTemplate templateFake = this.spaceTemplateService.getSpaceTemplateByName("fake");
        SpaceTemplateServiceTest.assertEquals((String)template.getName(), (String)"classic");
        SpaceTemplateServiceTest.assertNotNull((Object)templateFake);
        SpaceTemplateServiceTest.assertEquals((String)templateFake.getName(), (String)"classic");
    }

    public void testRegisterSpaceTemplatePlugin() {
        SpaceApplication homeApplication = new SpaceApplication();
        homeApplication.setAppTitle("fakeHome");
        homeApplication.setPortletApp("fakeHomeApp");
        homeApplication.setPortletName("fakeHomeName");
        ArrayList<SpaceApplication> applicationList = new ArrayList<SpaceApplication>();
        for (int i = 0; i < 3; ++i) {
            SpaceApplication app = new SpaceApplication();
            app.setAppTitle("fakeTitle" + i);
            app.setPortletApp("fakeApp" + i);
            app.setPortletName("fakeName" + i);
            applicationList.add(app);
        }
        SpaceTemplate spaceTemplate = new SpaceTemplate();
        spaceTemplate.setName("custom");
        spaceTemplate.setVisibility("private");
        spaceTemplate.setRegistration("open");
        spaceTemplate.setHomeApplication(homeApplication);
        spaceTemplate.setSpaceApplicationList(applicationList);
        InitParams params = new InitParams();
        ObjectParameter objParam = new ObjectParameter();
        objParam.setName("template");
        objParam.setObject((Object)spaceTemplate);
        params.addParameter((Parameter)objParam);
        int initialSize = this.spaceTemplateService.getSpaceTemplates().size();
        this.spaceTemplateService.registerSpaceTemplatePlugin(new SpaceTemplateConfigPlugin(params));
        SpaceTemplateServiceTest.assertEquals((int)(initialSize + 1), (int)this.spaceTemplateService.getSpaceTemplates().size());
    }

    public void testExtendSpaceTemplatePlugin() {
        ArrayList<SpaceApplication> applicationList = new ArrayList<SpaceApplication>();
        SpaceTemplateConfigPlugin spaceTemplateConfigPlugin = this.getSpaceTemplateList(applicationList, 3, 6);
        SpaceTemplate template = this.spaceTemplateService.getSpaceTemplateByName("classic");
        SpaceTemplateServiceTest.assertEquals((int)3, (int)template.getSpaceApplicationList().size());
        this.spaceTemplateService.extendSpaceTemplatePlugin(spaceTemplateConfigPlugin);
        ((SpaceTemplateServiceImpl)this.spaceTemplateService).start();
        template = this.spaceTemplateService.getSpaceTemplateByName("classic");
        SpaceTemplateServiceTest.assertEquals((int)6, (int)template.getSpaceApplicationList().size());
        spaceTemplateConfigPlugin = this.getSpaceTemplateList(applicationList, 0, 3);
        this.spaceTemplateService.extendSpaceTemplatePlugin(spaceTemplateConfigPlugin);
        ((SpaceTemplateServiceImpl)this.spaceTemplateService).start();
        template = this.spaceTemplateService.getSpaceTemplateByName("classic");
        SpaceTemplateServiceTest.assertEquals((int)9, (int)template.getSpaceApplicationList().size());
    }

    private SpaceTemplateConfigPlugin getSpaceTemplateList(List<SpaceApplication> applicationList, int from, int to) {
        for (int i = from; i < to; ++i) {
            SpaceApplication app = new SpaceApplication();
            app.setAppTitle("fakeTitle" + i);
            app.setPortletApp("fakeApp" + i);
            app.setPortletName("fakeName" + i);
            app.setOrder(4 + i);
            applicationList.add(app);
        }
        SpaceTemplate spaceTemplate = new SpaceTemplate();
        spaceTemplate.setName("classic");
        spaceTemplate.setSpaceApplicationList(applicationList);
        InitParams params = new InitParams();
        ObjectParameter objParam = new ObjectParameter();
        objParam.setName("template");
        objParam.setObject((Object)spaceTemplate);
        params.addParameter((Parameter)objParam);
        SpaceTemplateConfigPlugin spaceTemplateConfigPlugin = new SpaceTemplateConfigPlugin(params);
        return spaceTemplateConfigPlugin;
    }

    public void testRegisterSpaceApplicationHandler() {
        Map handlerMap = this.spaceTemplateService.getSpaceApplicationHandlers();
        int initialSize = handlerMap.size();
        InitParams params = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("templateName");
        valueParam.setValue("custom");
        params.addParameter((Parameter)valueParam);
        DefaultSpaceApplicationHandler applicationHandler = new DefaultSpaceApplicationHandler(params, null, null, null, null);
        this.spaceTemplateService.registerSpaceApplicationHandler((SpaceApplicationHandler)applicationHandler);
        handlerMap = this.spaceTemplateService.getSpaceApplicationHandlers();
        SpaceTemplateServiceTest.assertEquals((int)(initialSize + 1), (int)handlerMap.size());
    }

    public void testGetSpaceApplicationHandlers() {
        Map handlers = this.spaceTemplateService.getSpaceApplicationHandlers();
        SpaceTemplateServiceTest.assertTrue((boolean)Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass().isInstance(handlers));
    }

    public void testGetDefaultSpaceTemplate() {
        SpaceTemplateServiceTest.assertEquals((String)"classic", (String)this.spaceTemplateService.getDefaultSpaceTemplate());
    }

    public void testInitSpaceApplications() throws Exception {
    }

    private Space createSpace(String spaceName, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setTemplate("classic");
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.createSpace(space, creator);
        this.tearDownSpaceList.add(space);
        return space;
    }
}

