/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.social.core.space.impl.DynamicSpacePortalLayoutMatcher;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DynamicSpacePortalLayoutMatcherTest {
    @Test
    public void testMatchSpaceLayout() {
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        String spacePrefix = "testMatchSpaceLayout";
        String templateName = spacePrefix + " Template";
        String groupId = "/spaces/" + spacePrefix;
        this.mockSpaceService(spaceService, spacePrefix, groupId, templateName);
        DynamicSpacePortalLayoutMatcher dynamicSpacePortalLayoutMatcher = new DynamicSpacePortalLayoutMatcher();
        dynamicSpacePortalLayoutMatcher.setSpaceService(spaceService);
        dynamicSpacePortalLayoutMatcher.setSpaceTemplateRegex(".+Template.*");
        Assert.assertFalse((String)"Portal site shouldn't match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.portal((String)spacePrefix), "currentSite"));
        Assert.assertTrue((String)"Group site with temmplate name matching should match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)groupId), "currentSite"));
        Assert.assertFalse((String)"Super Dynamic layout Matcher class should fail when no current site name", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)groupId), null));
        Assert.assertFalse((String)"Non existing space shouldn't match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)(groupId + "1")), "currentSite"));
    }

    @Test
    public void testEmptySpaceLayoutMatcher() {
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        String spacePrefix = "testMatchSpaceLayout";
        String templateName = spacePrefix + " Template";
        String groupId = "/spaces/" + spacePrefix;
        this.mockSpaceService(spaceService, spacePrefix, groupId, templateName);
        DynamicSpacePortalLayoutMatcher dynamicSpacePortalLayoutMatcher = new DynamicSpacePortalLayoutMatcher();
        dynamicSpacePortalLayoutMatcher.setSpaceService(spaceService);
        Assert.assertFalse((String)"Portal site shouldn't match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.portal((String)spacePrefix), "currentSite"));
        Assert.assertTrue((String)"Group site with any temmplate name matching should match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)groupId), "currentSite"));
        Assert.assertFalse((String)"Super Dynamic layout Matcher class should fail when no current site name", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)groupId), null));
        Assert.assertFalse((String)"Non existing space shouldn't match", (boolean)dynamicSpacePortalLayoutMatcher.matches(SiteKey.group((String)(groupId + "1")), "currentSite"));
    }

    private void mockSpaceService(SpaceService spaceService, String spacePrefix, String groupId, String templateName) {
        Space space = new Space();
        space.setDisplayName(spacePrefix + " Display Name");
        space.setPrettyName(spacePrefix + " Pretty Name");
        space.setGroupId(groupId);
        space.setTemplate(templateName);
        Mockito.reset((Object[])new SpaceService[]{spaceService});
        Mockito.when((Object)spaceService.getSpaceByGroupId((String)Matchers.eq((Object)groupId))).thenReturn((Object)space);
    }
}

