/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.StreamItemDAO;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class StreamItemDAOTest
extends BaseCoreTest {
    private List<ExoSocialActivity> tearDownActivityList;
    private Identity ghostIdentity;
    private Identity raulIdentity;
    private Identity jameIdentity;
    private Identity paulIdentity;
    private IdentityStorage identityStorage;
    private StreamItemDAO streamItemDAO;
    private SpaceService spaceService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = this.getService(IdentityStorage.class);
        this.streamItemDAO = this.getService(StreamItemDAO.class);
        this.spaceService = this.getService(SpaceService.class);
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.ghostIdentity = this.identityManager.getOrCreateIdentity("organization", "ghost", true);
        this.raulIdentity = this.identityManager.getOrCreateIdentity("organization", "raul", true);
        this.jameIdentity = this.identityManager.getOrCreateIdentity("organization", "jame", true);
        this.paulIdentity = this.identityManager.getOrCreateIdentity("organization", "paul", true);
        this.getService(ActivityDAO.class).deleteAll();
    }

    @Override
    public void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityStorage.deleteActivity(activity.getId());
        }
        for (Space space : this.spaceService.getAllSpaces()) {
            Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityStorage.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        this.identityManager.deleteIdentity(this.ghostIdentity);
        this.identityManager.deleteIdentity(this.jameIdentity);
        this.identityManager.deleteIdentity(this.raulIdentity);
        this.identityManager.deleteIdentity(this.paulIdentity);
        ConversationState.setCurrent(null);
        super.tearDown();
    }

    public void testPostActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)1, (int)items.size());
    }

    public void testGetFeedWithPostActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        List ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
    }

    public void testCommentOnHisActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivity comment = this.createActivity("comment on his activity", this.demoIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testCommentOnOtherActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testGetFeedWithCommentOnOtherActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testDoubleCommentOnOtherActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity 1", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        comment = this.createActivity("comment on demo's activity 2", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testGetFeedWithDoubleCommentOnOtherActivity() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity 1", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        comment = this.createActivity("comment on demo's activity 2", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testGetFeedWithConnections() throws Exception {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testStreamsWithConnectionsAndMention() throws Exception {
        ExoSocialActivity activity = this.createActivity("post on my stream @mary", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        ids = this.activityStorage.getActivityIdsOfConnections(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testCommentOnOtherActivityAndMention() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity @demo", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)3, (int)items.size());
    }

    public void testCommentOnOtherActivityAndOtherMention() {
        ExoSocialActivity activity = this.createActivity("post on my stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity @root", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)3, (int)items.size());
    }

    public void testStreamsWithCommentOnOtherActivityAndOtherMention() {
        ExoSocialActivity activity = this.createActivity("post on my stream @mary", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        ExoSocialActivity comment = this.createActivity("comment on demo's activity", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testPostActivityAndMention() {
        ExoSocialActivity activity = this.createActivity("post activity and mention @mary", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testLikerActivity() {
        ExoSocialActivity activity = this.createActivity("post on stream and mary liker", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        this.activityManager.saveLike(activity, this.maryIdentity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testDislikeActivity() {
        ExoSocialActivity activity = this.createActivity("post on stream and mary liker", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.tearDownActivityList.add(activity);
        this.activityManager.saveLike(activity, this.maryIdentity);
        this.activityManager.deleteLike(activity, this.maryIdentity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)1, (int)items.size());
    }

    public void testPostOnViewerStream() {
        ExoSocialActivity activity = this.createActivity("demo post on mary's stream", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activity);
        this.tearDownActivityList.add(activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
    }

    public void testPostOnSpace() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivity activity = this.createActivity("demo post on the space 1", this.demoIdentity.getId());
        this.activityStorage.saveActivity(spaceIdentity, activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)2, (int)items.size());
        this.tearDownActivityList.add(activity);
    }

    public void testPostOnSpaceAndMention() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivity activity = this.createActivity("demo post on the space 1 and mention @mary", this.demoIdentity.getId());
        this.activityStorage.saveActivity(spaceIdentity, activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)3, (int)items.size());
        this.tearDownActivityList.add(activity);
    }

    public void testDeleteActivity() {
        ExoSocialActivity activity = this.createActivity("post on stream and mary liker", this.demoIdentity.getId());
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        this.activityManager.saveLike(activity, this.maryIdentity);
        this.activityManager.deleteActivity(activity);
        List items = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(activity.getId()));
        StreamItemDAOTest.assertEquals((int)0, (int)items.size());
    }

    public void testAddPlusTenActivitiesWithComment() {
        ExoSocialActivity activity = this.createActivity("Post on my stream", this.maryIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activity);
        this.tearDownActivityList.add(activity);
        for (int i = 1; i <= 11; ++i) {
            ExoSocialActivity socialActivity = this.createActivity("Post on my stream " + i, this.maryIdentity.getId());
            this.activityStorage.saveActivity(this.maryIdentity, socialActivity);
            this.tearDownActivityList.add(socialActivity);
        }
        ExoSocialActivity comment = this.createActivity("Comment on first activity", this.maryIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"First activity should be at first position", (String)activity.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.maryIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.maryIdentity, 10L, 10L);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
    }

    public void testWithRelationAddPlusTenActivitiesWithComment() {
        ExoSocialActivity activity = this.createActivity("Post on my stream", this.maryIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        for (int i = 1; i <= 11; ++i) {
            ExoSocialActivity socialActivity = this.createActivity("Post on my stream " + i, this.demoIdentity.getId());
            this.activityStorage.saveActivity(this.demoIdentity, socialActivity);
            this.tearDownActivityList.add(socialActivity);
        }
        ExoSocialActivity comment = this.createActivity("Comment on first activity", this.demoIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"First activity should be at first position", (String)activity.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 20);
        StreamItemDAOTest.assertEquals((int)12, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 10L, 10L);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    public void testPostPlusTenActivitiesOnSpaceWithComment() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        space.setMembers(new String[]{this.maryIdentity.getRemoteId(), this.demoIdentity.getRemoteId()});
        ExoSocialActivity activity = this.createActivity("Post on the space", this.maryIdentity.getId());
        this.activityStorage.saveActivity(spaceIdentity, activity);
        this.tearDownActivityList.add(activity);
        for (int i = 1; i <= 11; ++i) {
            ExoSocialActivity socialActivity = this.createActivity("Post on the space " + i, this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity, socialActivity);
            this.tearDownActivityList.add(socialActivity);
        }
        ExoSocialActivity comment = this.createActivity("Comment on first activity", this.demoIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"First activity should be at first position since it is commented", (String)activity.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.maryIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        ids = this.activityStorage.getSpaceActivityIds(spaceIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getSpaceActivityIds(spaceIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getUserSpacesActivityIds(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getUserSpacesActivityIds(this.demoIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        space.setMembers(new String[]{this.demoIdentity.getRemoteId()});
    }

    public void testWithRelationPostPlusTenActivitiesOnSpaceWithComment() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        space.setMembers(new String[]{this.maryIdentity.getRemoteId(), this.demoIdentity.getRemoteId()});
        ExoSocialActivity activity = this.createActivity("Post on the space", this.maryIdentity.getId());
        this.activityStorage.saveActivity(spaceIdentity, activity);
        this.tearDownActivityList.add(activity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        for (int i = 1; i <= 11; ++i) {
            ExoSocialActivity socialActivity = this.createActivity("Post on the space " + i, this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity, socialActivity);
            this.tearDownActivityList.add(socialActivity);
        }
        ExoSocialActivity comment = this.createActivity("Comment on first activity", this.demoIdentity.getId());
        this.activityStorage.saveComment(activity, comment);
        List ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"First activity should be at first position since it is commented", (String)activity.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 20);
        StreamItemDAOTest.assertEquals((int)12, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 10L, 10L);
        StreamItemDAOTest.assertEquals((int)1, (int)ids.size());
        ids = this.activityStorage.getSpaceActivityIds(spaceIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getSpaceActivityIds(spaceIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        ids = this.activityStorage.getUserSpacesActivityIds(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)10, (int)ids.size());
        ids = this.activityStorage.getUserSpacesActivityIds(this.demoIdentity, 10, 10);
        StreamItemDAOTest.assertEquals((int)2, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
        space.setMembers(new String[]{this.demoIdentity.getRemoteId()});
    }

    public void testWithRelationInteractOnActivities() {
        ExoSocialActivity activityToComment = this.createActivity("Post on my stream", this.maryIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activityToComment);
        this.tearDownActivityList.add(activityToComment);
        ExoSocialActivity activityToLike = this.createActivity("Post on my stream", this.maryIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activityToLike);
        this.tearDownActivityList.add(activityToLike);
        ExoSocialActivity activityToMentionIn = this.createActivity("Post on my stream", this.maryIdentity.getId());
        this.activityStorage.saveActivity(this.maryIdentity, activityToMentionIn);
        this.tearDownActivityList.add(activityToMentionIn);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        ExoSocialActivity comment = this.createActivity("Comment on first activity", this.demoIdentity.getId());
        this.activityStorage.saveComment(activityToComment, comment);
        this.activityManager.saveLike(activityToLike, this.demoIdentity);
        ExoSocialActivity MentionComment = this.createActivity("comment on demo's activity @mary", this.demoIdentity.getId());
        this.activityStorage.saveComment(activityToMentionIn, MentionComment);
        List ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)3, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"Last activity commented should be at first position", (String)activityToMentionIn.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.maryIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)3, (int)ids.size());
        StreamItemDAOTest.assertEquals((String)"Last activity commented should be at first position", (String)activityToMentionIn.getId(), (String)((String)ids.get(0)));
        ids = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        StreamItemDAOTest.assertEquals((int)3, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.demoIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)3, (int)ids.size());
        ids = this.activityStorage.getUserIdsActivities(this.maryIdentity, 0L, 10L);
        StreamItemDAOTest.assertEquals((int)3, (int)ids.size());
        this.relationshipManager.delete(demoMaryConnection);
    }

    private Space getSpaceInstance(SpaceService spaceService, int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"demo"};
        String[] members = new String[]{"demo"};
        space.setManagers(managers);
        space.setMembers(members);
        spaceService.saveSpace(space, true);
        return space;
    }

    private ExoSocialActivity createActivity(String title, String posterId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(title);
        activity.setTitleId("TitleID");
        activity.setType("UserActivity");
        activity.setBody("Body of " + activity.getTitle());
        activity.setBodyId("BodyId of " + activity.getTitle());
        activity.setLikeIdentityIds(new String[]{"demo", "mary"});
        activity.setMentionedIds(new String[]{"demo", "john"});
        activity.setCommentedIds(new String[0]);
        activity.setReplyToId(new String[0]);
        activity.setAppId("AppID");
        activity.setExternalId("External ID");
        activity.setUserId(posterId);
        return activity;
    }
}

