/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.service;

import io.meeds.social.link.constant.LinkDisplayType;
import io.meeds.social.link.dao.LinkDAO;
import io.meeds.social.link.dao.LinkSettingDAO;
import io.meeds.social.link.model.Link;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.model.LinkWithIconAttachment;
import io.meeds.social.link.service.LinkService;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.mock.MockUploadService;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public class LinkServiceTest
extends AbstractKernelTest {
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testuser";
    private static final String LINK_SETTING_NAME = "linkSettingName";
    private static final String MIME_TYPE = "image/png";
    private static final String FILE_NAME = "cover.png";
    private static final String UPLOAD_ID = "1234";
    private static final long SPACE_ID = 3L;
    private LayoutService layoutService;
    private LinkService linkService;
    private IdentityRegistry identityRegistry;
    private MockUploadService uploadService;
    private FileService fileService;
    private LocaleConfigService localeConfigService;

    protected void setUp() throws Exception {
        super.setUp();
        this.linkService = (LinkService)this.getContainer().getComponentInstanceOfType(LinkService.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        this.localeConfigService = (LocaleConfigService)this.getContainer().getComponentInstanceOfType(LocaleConfigService.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.restartTransaction();
        ((LinkDAO)this.getContainer().getComponentInstanceOfType(LinkDAO.class)).deleteAll();
        this.restartTransaction();
        ((LinkSettingDAO)this.getContainer().getComponentInstanceOfType(LinkSettingDAO.class)).deleteAll();
        ((CacheService)this.getContainer().getComponentInstanceOfType(CacheService.class)).getCacheInstance("social.linkSettings").clearCache();
        this.end();
        super.tearDown();
    }

    public void testInitLinkSetting() {
        String pageReference = this.createPage("testInitLinkSetting", "Everyone", ADMINISTRATORS_GROUP);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.linkService.initLinkSetting(null, pageReference, 0L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.linkService.initLinkSetting(LINK_SETTING_NAME, null, 0L));
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkSetting linkSetting = this.linkService.getLinkSetting(LINK_SETTING_NAME);
        LinkServiceTest.assertNotNull((Object)linkSetting);
        LinkServiceTest.assertEquals((String)LINK_SETTING_NAME, (String)linkSetting.getName());
        LinkServiceTest.assertEquals((String)pageReference, (String)linkSetting.getPageReference());
        LinkServiceTest.assertEquals((long)3L, (long)linkSetting.getSpaceId());
    }

    public void testSaveLinkSettingPermissions() throws IllegalAccessException, InterruptedException, ObjectNotFoundException {
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, "testSaveLinkSettingPermissions1");
        LinkServiceTest.assertNotNull((Object)linkSetting);
        linkSetting.setLargeIcon(true);
        linkSetting.setShowName(true);
        linkSetting.setSeeMore("SeeMore1");
        linkSetting.setType(LinkDisplayType.COLUMN);
        Assert.assertThrows(IllegalAccessException.class, () -> this.linkService.saveLinkSetting(linkSetting, null, null));
        Assert.assertThrows(IllegalAccessException.class, () -> this.linkService.saveLinkSetting(linkSetting, null, this.registerInternalUser(USERNAME)));
        LinkSetting nameNotFoundLinkSetting = linkSetting.clone();
        nameNotFoundLinkSetting.setName("NotFound");
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.linkService.saveLinkSetting(nameNotFoundLinkSetting, null, this.registerAdministratorUser(USERNAME)));
        Thread.sleep(2L);
        LinkSetting updatedLinkSetting = this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        LinkServiceTest.assertNotNull((Object)updatedLinkSetting);
        Assert.assertNotEquals((long)linkSetting.getLastModified(), (long)updatedLinkSetting.getLastModified());
        linkSetting.setLastModified(updatedLinkSetting.getLastModified());
        LinkServiceTest.assertEquals((Object)linkSetting, (Object)updatedLinkSetting);
        linkSetting.setHeader(Collections.singletonMap("en", "header2"));
        linkSetting.setLargeIcon(false);
        linkSetting.setShowName(true);
        linkSetting.setSeeMore("SeeMore2");
        linkSetting.setType(LinkDisplayType.CARD);
        Thread.sleep(2L);
        updatedLinkSetting = this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        LinkServiceTest.assertNotNull((Object)updatedLinkSetting);
        updatedLinkSetting = this.linkService.getLinkSetting(updatedLinkSetting.getName(), "en", true);
        Assert.assertNotEquals((long)linkSetting.getLastModified(), (long)updatedLinkSetting.getLastModified());
        linkSetting.setLastModified(updatedLinkSetting.getLastModified());
        LinkServiceTest.assertEquals((Object)linkSetting, (Object)updatedLinkSetting);
        linkSetting.setShowName(false);
        Thread.sleep(2L);
        updatedLinkSetting = this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        LinkServiceTest.assertNotNull((Object)updatedLinkSetting);
        updatedLinkSetting = this.linkService.getLinkSetting(updatedLinkSetting.getName(), "en", true);
        Assert.assertNotEquals((long)linkSetting.getLastModified(), (long)updatedLinkSetting.getLastModified());
        linkSetting.setLastModified(updatedLinkSetting.getLastModified());
        LinkServiceTest.assertEquals((Object)linkSetting, (Object)updatedLinkSetting);
    }

    public void testSaveLinks() throws Exception {
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, "testSaveLinkSettingPermissions");
        LinkServiceTest.assertNotNull((Object)linkSetting);
        linkSetting.setHeader(Collections.singletonMap("en", "header"));
        linkSetting.setLargeIcon(true);
        linkSetting.setShowName(true);
        linkSetting.setSeeMore("SeeMore");
        linkSetting.setType(LinkDisplayType.COLUMN);
        this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        List links = this.linkService.getLinks(LINK_SETTING_NAME, null, true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((long)0L, (long)links.size());
        Link linkToSave1 = new Link(0L, Collections.singletonMap("en", "Website"), Collections.singletonMap("en", "Website description"), "https://localhost/", true, 5, 0L);
        List<Link> linksToSave = Collections.singletonList(linkToSave1.clone());
        this.linkService.saveLinkSetting(linkSetting, linksToSave, this.registerAdministratorUser(USERNAME));
        links = this.linkService.getLinks(LINK_SETTING_NAME, null, true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        Link savedLink1 = (Link)links.get(0);
        LinkServiceTest.assertTrue((savedLink1.getId() > 0L ? 1 : 0) != 0);
        linksToSave = Collections.singletonList(linkToSave1.clone());
        linksToSave.get(0).setId(savedLink1.getId());
        LinkServiceTest.assertEquals(linksToSave, (Object)links);
        LinkWithIconAttachment linkToSave2 = new LinkWithIconAttachment(0L, Collections.singletonMap("en", "Website2"), Collections.singletonMap("en", "Website2 description"), "https://localhost2/", true, 4, 54444L, UPLOAD_ID);
        savedLink1.setName(Collections.singletonMap("en", "name1"));
        savedLink1.setDescription(Collections.singletonMap("en", "description1"));
        savedLink1.setUrl("url1");
        savedLink1.setOrder(6);
        savedLink1.setSameTab(!savedLink1.isSameTab());
        linksToSave = Arrays.asList(savedLink1.clone(), linkToSave2.clone());
        this.uploadResource();
        this.linkService.saveLinkSetting(linkSetting, linksToSave, this.registerAdministratorUser(USERNAME));
        links = this.linkService.getLinks(LINK_SETTING_NAME, null, true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)2, (int)links.size());
        LinkServiceTest.assertEquals(links.get(1), (Object)savedLink1);
        Link savedLink2 = (Link)links.get(0);
        LinkServiceTest.assertTrue((savedLink2.getId() > 0L ? 1 : 0) != 0);
        LinkServiceTest.assertTrue((savedLink2.getIconFileId() > 0L ? 1 : 0) != 0);
        linksToSave = Arrays.asList(savedLink1.clone(), linkToSave2.toLink());
        Assert.assertNotEquals((long)linksToSave.get(1).getIconFileId(), (long)savedLink2.getIconFileId());
        linksToSave.get(1).setId(savedLink2.getId());
        linksToSave.get(1).setIconFileId(savedLink2.getIconFileId());
        LinkServiceTest.assertEquals((Object)linksToSave.get(1), (Object)savedLink2);
        linkToSave2 = linkToSave2.clone();
        linkToSave2.setId(savedLink2.getId());
        linksToSave = Arrays.asList(linkToSave2.clone());
        this.uploadResource();
        this.linkService.saveLinkSetting(linkSetting, linksToSave, this.registerAdministratorUser(USERNAME));
        links = this.linkService.getLinks(LINK_SETTING_NAME, null, true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        LinkServiceTest.assertEquals((long)savedLink2.getId(), (long)((Link)links.get(0)).getId());
        Assert.assertNotEquals((long)savedLink2.getIconFileId(), (long)((Link)links.get(0)).getIconFileId());
        FileItem file = this.fileService.getFile(savedLink2.getIconFileId());
        LinkServiceTest.assertTrue((file == null || file.getFileInfo().isDeleted() ? 1 : 0) != 0);
        file = this.fileService.getFile(((Link)links.get(0)).getIconFileId());
        LinkServiceTest.assertTrue((file != null && !file.getFileInfo().isDeleted() ? 1 : 0) != 0);
        ((Link)links.get(0)).setIconFileId(savedLink2.getIconFileId());
        LinkServiceTest.assertEquals((Object)savedLink2, links.get(0));
        savedLink2 = (Link)links.get(0);
        this.linkService.saveLinkSetting(linkSetting, Collections.singletonList(linkToSave1), this.registerAdministratorUser(USERNAME));
        links = this.linkService.getLinks(LINK_SETTING_NAME);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        file = this.fileService.getFile(savedLink2.getIconFileId());
        LinkServiceTest.assertTrue((file == null || file.getFileInfo().isDeleted() ? 1 : 0) != 0);
    }

    public void testGetLinkIconStream() throws Exception {
        LinkServiceTest.assertNull((Object)this.linkService.getLinkIconStream(LINK_SETTING_NAME, 2325L));
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, "testGetLinkIconStream1");
        LinkServiceTest.assertNotNull((Object)linkSetting);
        linkSetting.setHeader(Collections.singletonMap("en", "header"));
        linkSetting.setLargeIcon(true);
        linkSetting.setShowName(true);
        linkSetting.setSeeMore("SeeMore");
        linkSetting.setType(LinkDisplayType.COLUMN);
        this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        LinkWithIconAttachment linkToSave = new LinkWithIconAttachment(0L, Collections.singletonMap("en", "Website2"), Collections.singletonMap("en", "Website description2"), "https://localhost2/", true, 4, 54444L, UPLOAD_ID);
        List<Link> linksToSave = Arrays.asList(linkToSave.clone());
        this.uploadResource();
        this.linkService.saveLinkSetting(linkSetting, linksToSave, this.registerAdministratorUser(USERNAME));
        List links = this.linkService.getLinks(LINK_SETTING_NAME);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        Link savedLink = (Link)links.get(0);
        LinkServiceTest.assertTrue((savedLink.getId() > 0L ? 1 : 0) != 0);
        LinkServiceTest.assertTrue((savedLink.getIconFileId() > 0L ? 1 : 0) != 0);
        FileItem file = this.fileService.getFile(savedLink.getIconFileId());
        LinkServiceTest.assertTrue((file != null && file.getFileInfo() != null && !file.getFileInfo().isDeleted() ? 1 : 0) != 0);
        InputStream inputStream = this.linkService.getLinkIconStream(LINK_SETTING_NAME, savedLink.getId());
        LinkServiceTest.assertNotNull((Object)inputStream);
        FileInfo fileInfo = file.getFileInfo();
        LinkServiceTest.assertEquals((long)fileInfo.getSize(), (long)inputStream.available());
    }

    public void testGetLinkSettingPermissions() throws IllegalAccessException {
        LinkServiceTest.assertNull((Object)this.linkService.getLinkSetting(LINK_SETTING_NAME, null, null));
        String pageReference = this.createPage("testGetLinkSettingPermissions1", "Everyone", ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertNotNull((Object)this.linkService.getLinkSetting(LINK_SETTING_NAME, null, null));
        LinkServiceTest.assertNotNull((Object)this.linkService.getLinkSetting(LINK_SETTING_NAME, null, this.registerInternalUser(USERNAME)));
        pageReference = this.createPage("testGetLinkSettingPermissions1", USERS_GROUP, ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        Assert.assertThrows(IllegalAccessException.class, () -> this.linkService.getLinkSetting(LINK_SETTING_NAME, null, null));
        LinkServiceTest.assertNotNull((Object)this.linkService.getLinkSetting(LINK_SETTING_NAME, null, this.registerInternalUser(USERNAME)));
    }

    public void testHasAccessPermission() {
        LinkServiceTest.assertFalse((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, null));
        String pageReference = this.createPage("testHasAccessPermission1", "Everyone", ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertTrue((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, null));
        LinkServiceTest.assertTrue((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, this.registerInternalUser(USERNAME)));
        pageReference = this.createPage("testHasAccessPermission2", USERS_GROUP, ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertFalse((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, null));
        LinkServiceTest.assertTrue((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, this.registerInternalUser(USERNAME)));
        pageReference = this.createPage("testHasAccessPermission3", ADMINISTRATORS_GROUP, ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertFalse((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, null));
        LinkServiceTest.assertFalse((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, this.registerInternalUser(USERNAME)));
        LinkServiceTest.assertTrue((boolean)this.linkService.hasAccessPermission(LINK_SETTING_NAME, this.registerAdministratorUser(USERNAME)));
    }

    public void testHasEditPermission() {
        LinkServiceTest.assertFalse((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, null));
        String pageReference = this.createPage("testHasEditPermission1", "Everyone", ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertFalse((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, null));
        LinkServiceTest.assertFalse((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, this.registerInternalUser(USERNAME)));
        LinkServiceTest.assertTrue((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, this.registerAdministratorUser(USERNAME)));
    }

    public void testLinkHasEditPermission() {
        List links = this.linkService.getLinks(LINK_SETTING_NAME);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertTrue((boolean)links.isEmpty());
        String pageReference = this.createPage("testLinkHasEditPermission1", "Everyone", ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageReference, 3L);
        LinkServiceTest.assertFalse((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, null));
        LinkServiceTest.assertFalse((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, this.registerInternalUser(USERNAME)));
        LinkServiceTest.assertTrue((boolean)this.linkService.hasEditPermission(LINK_SETTING_NAME, this.registerAdministratorUser(USERNAME)));
    }

    public void testGetLinkTranslations() throws ObjectNotFoundException, IllegalAccessException {
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, "testSaveLinkSettingPermissions");
        LinkServiceTest.assertNotNull((Object)linkSetting);
        linkSetting.setHeader(Collections.singletonMap("en", "header"));
        linkSetting.setLargeIcon(true);
        linkSetting.setShowName(true);
        linkSetting.setSeeMore("SeeMore");
        linkSetting.setType(LinkDisplayType.COLUMN);
        this.linkService.saveLinkSetting(linkSetting, null, this.registerAdministratorUser(USERNAME));
        List links = this.linkService.getLinks(LINK_SETTING_NAME, null, true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((long)0L, (long)links.size());
        Link linkToSave1 = new Link(0L, Collections.singletonMap("en", "Website"), Collections.singletonMap("en", "Website description"), "https://localhost/", true, 5, 0L);
        List<Link> linksToSave = Collections.singletonList(linkToSave1.clone());
        this.linkService.saveLinkSetting(linkSetting, linksToSave, this.registerAdministratorUser(USERNAME));
        links = this.linkService.getLinks(LINK_SETTING_NAME, "en", true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        Map name = ((Link)links.get(0)).getName();
        LinkServiceTest.assertNotNull(name.get("en"));
        LinkServiceTest.assertNull(name.get("fr"));
        this.localeConfigService.saveDefaultLocaleConfig("fr");
        links = this.linkService.getLinks(LINK_SETTING_NAME, "fr", true);
        LinkServiceTest.assertNotNull((Object)links);
        LinkServiceTest.assertEquals((int)1, (int)links.size());
        name = ((Link)links.get(0)).getName();
        LinkServiceTest.assertNotNull(name.get("en"));
        LinkServiceTest.assertNull(name.get("fr"));
    }

    private LinkSetting initLinkSetting(String linkSettingName, String pageName) {
        String pageReference = this.createPage(pageName, "Everyone", ADMINISTRATORS_GROUP);
        return this.linkService.initLinkSetting(linkSettingName, pageReference, 3L);
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "test";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, null, Collections.singletonList(accessPermission), editPermission);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private void uploadResource() throws Exception {
        File tempFile = File.createTempFile("image", "temp");
        this.uploadService.createUploadResource(UPLOAD_ID, tempFile.getPath(), FILE_NAME, MIME_TYPE);
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(new MembershipEntry("/platform/administrators")));
        this.identityRegistry.register(identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

