/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;

public class RDBMSRelationshipManagerTest
extends AbstractCoreTest {
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager;
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private org.exoplatform.social.core.identity.model.Identity johnIdentity;
    private org.exoplatform.social.core.identity.model.Identity maryIdentity;
    private org.exoplatform.social.core.identity.model.Identity demoIdentity;
    private org.exoplatform.social.core.identity.model.Identity ghostIdentity;
    private org.exoplatform.social.core.identity.model.Identity paulIdentity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.relationshipManager = this.getService(RelationshipManager.class);
        this.identityManager = this.getService(IdentityManager.class);
        RDBMSRelationshipManagerTest.assertNotNull((String)"relationshipManager must not be null", (Object)this.relationshipManager);
        RDBMSRelationshipManagerTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
        this.ghostIdentity = this.createIdentity("ghost");
        this.paulIdentity = this.createIdentity("paul");
        Identity identity = this.getService(IdentityRegistry.class).getIdentity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
    }

    @Override
    protected void tearDown() throws Exception {
        ConversationState.setCurrent(null);
        super.tearDown();
    }

    public void testGetAll() throws Exception {
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void TestGetConnectionsByFilter() throws Exception {
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.maryIdentity);
        ProfileFilter filter = new ProfileFilter();
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(this.maryIdentity, filter);
        org.exoplatform.social.core.identity.model.Identity[] identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(0, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)identities.length);
    }

    public void TestPerfomanceGetConnectionsByFilter() throws Exception {
        UserHandler handler = this.getService(OrganizationService.class).getUserHandler();
        String key = "abc_test";
        for (int i = 0; i < 100; ++i) {
            User user = handler.createUserInstance(key + i);
            user.setPassword("gtn");
            user.setEmail(key + i + "@mail.com");
            user.setFirstName("abc " + i);
            user.setLastName("gtn");
            if (i % 5 == 0) {
                user.setLastName("foo");
            }
            handler.createUser(user, true);
        }
        for (int i = 0; i < 100; ++i) {
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", key + i, true);
            this.relationshipManager.inviteToConnect(this.demoIdentity, identity);
            this.relationshipManager.confirm(identity, this.demoIdentity);
        }
        ProfileFilter filter = new ProfileFilter();
        filter.setName("abc");
        long t = System.currentTimeMillis();
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(this.demoIdentity, filter);
        org.exoplatform.social.core.identity.model.Identity[] identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(0, 110);
        this.LOG.info((Object)("Time to load " + identities.length + " identities: " + (System.currentTimeMillis() - t) + "ms"));
        RDBMSRelationshipManagerTest.assertEquals((int)100, (int)identities.length);
        t = System.currentTimeMillis();
        filter.setName("foo");
        listAccess = this.relationshipManager.getConnectionsByFilter(this.demoIdentity, filter);
        identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(0, 110);
        this.LOG.info((Object)("Time to load " + identities.length + " identities: " + (System.currentTimeMillis() - t) + "ms"));
        RDBMSRelationshipManagerTest.assertEquals((int)20, (int)identities.length);
    }

    public void testGetAllWithListIdentities() throws Exception {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> listIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAll(this.rootIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAll(this.maryIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryRelationships.size() mut return: 1", (int)1, (int)maryRelationships.size());
        List johnRelationships = this.relationshipManager.getAll(this.johnIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnRelationships.size() mut return: 1", (int)1, (int)johnRelationships.size());
    }

    public void testGetAllWithTypeAndListIdentities() throws Exception {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> listIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.PENDING, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() mut return: 1", (int)1, (int)maryPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() mut return: 1", (int)1, (int)johnPendingRelationships.size());
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        List rootConfirmedRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.CONFIRMED, listIdentities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootConfirmedRelationships must not be null", (Object)rootConfirmedRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootConfirmedRelationships.size() must return: 1", (int)1, (int)rootConfirmedRelationships.size());
    }

    public void testGet() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootToJohnRelationship.getStatus() must return: ", (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testGetWithRelationshipId() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        String relationshipId = relationship.getId();
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        relationship = this.relationshipManager.get(relationship.getId());
        RDBMSRelationshipManagerTest.assertNotNull((String)"relationship must not be null", (Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("relationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
        relationship = this.relationshipManager.get(relationshipId);
        RDBMSRelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testInviteToConnect() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
    }

    public void testDupdicateInviteToConnect() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
    }

    public void testDupdicateInviteToConnectWithConfirmedRelationShip() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)"RelationShip status must be PENDING", (Object)Relationship.Type.PENDING, (Object)relationship1.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        relationship1 = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship1.getStatus());
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship2.getStatus());
        RDBMSRelationshipManagerTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
    }

    public void testConfirmWithIdentity() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(rootToJohnRelationship.getId());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)maryToRootRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testDeny() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.deny(this.johnIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((Object)this.relationshipManager.get(rootToJohnRelationship.getId()));
        this.relationshipManager.deny(this.demoIdentity, this.rootIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testIgnore() throws Exception {
        Relationship relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((Object)relationship);
        this.relationshipManager.ignore(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RDBMSRelationshipManagerTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        relationship = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RDBMSRelationshipManagerTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        this.relationshipManager.ignore(this.demoIdentity, this.rootIdentity);
        relationship = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((Object)this.rootIdentity, (Object)relationship.getSender());
        RDBMSRelationshipManagerTest.assertEquals((Object)this.demoIdentity, (Object)relationship.getReceiver());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        this.relationshipManager.deny(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((Object)relationship);
        this.relationshipManager.ignore(this.rootIdentity, this.demoIdentity);
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship);
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
    }

    public void testGetIncomingWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship johnToDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        ListAccess demoIncoming = this.relationshipManager.getIncomingWithListAccess(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoIncoming must not be null", (Object)demoIncoming);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoIncoming.getSize() must return: 3", (int)3, (int)demoIncoming.getSize());
        for (org.exoplatform.social.core.identity.model.Identity identity : (org.exoplatform.social.core.identity.model.Identity[])demoIncoming.load(0, 10)) {
            RDBMSRelationshipManagerTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            org.exoplatform.social.core.identity.model.Identity identityLoadProfile = this.identityManager.getOrCreateIdentity("organization", identity.getRemoteId(), true);
            RDBMSRelationshipManagerTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
        ListAccess rootIncoming = this.relationshipManager.getIncomingWithListAccess(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootIncoming must not be null", (Object)rootIncoming);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootIncoming.getSize() must return: 0", (int)0, (int)rootIncoming.getSize());
        ListAccess maryIncoming = this.relationshipManager.getIncomingWithListAccess(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryIncoming must not be null", (Object)maryIncoming);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryIncoming.getSize() must return: 0", (int)0, (int)maryIncoming.getSize());
    }

    public void testGetOutgoing() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship demoToJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        ListAccess rootOutgoing = this.relationshipManager.getOutgoing(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootOutgoing must not be null", (Object)rootOutgoing);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootOutgoing.getSize() must return: 2", (int)2, (int)rootOutgoing.getSize());
        for (org.exoplatform.social.core.identity.model.Identity identity : (org.exoplatform.social.core.identity.model.Identity[])rootOutgoing.load(0, 10)) {
            org.exoplatform.social.core.identity.model.Identity identityLoadProfile = this.identityManager.getOrCreateIdentity("organization", identity.getRemoteId(), true);
            RDBMSRelationshipManagerTest.assertNotNull((String)"identity.getProfile() must not be nul", (Object)identity.getProfile());
            RDBMSRelationshipManagerTest.assertNotNull((String)"temp must not be null", (Object)identityLoadProfile);
            RDBMSRelationshipManagerTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
        ListAccess maryOutgoing = this.relationshipManager.getOutgoing(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryOutgoing must not be null", (Object)maryOutgoing);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryOutgoing.getSize() must return: 1", (int)1, (int)maryOutgoing.getSize());
        ListAccess demoOutgoing = this.relationshipManager.getOutgoing(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoOutgoing must not be null", (Object)demoOutgoing);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoOutgoing.getSize() must return: 1", (int)1, (int)demoOutgoing.getSize());
    }

    public void testGetStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.demoIdentity));
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(maryIdentity, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity));
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, johnIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.johnIdentity));
    }

    public void testGetAllWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        ListAccess rootRelationships = this.relationshipManager.getAllWithListAccess(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.getSize() must return: 3", (int)3, (int)rootRelationships.getSize());
        ListAccess demoRelationships = this.relationshipManager.getAllWithListAccess(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoRelationships.getSize() must return: 1", (int)1, (int)demoRelationships.getSize());
        ListAccess johnRelationships = this.relationshipManager.getAllWithListAccess(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnRelationships.getSize() must return: 1", (int)1, (int)johnRelationships.getSize());
    }

    public void testGetRelationshipById() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(rootToDemoRelationship.getId());
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
    }

    public void testDenyWithRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.deny(rootToDemoRelationship);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(maryToRootRelationship);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testGetPendingRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 2", (int)2, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 0", (int)0, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 0", (int)0, (int)johnPendingRelationships.size());
    }

    public void testGetPendingRelationshipWithSentOrReceived() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
    }

    public void testGetPendingRealtionshipWithListIdentities() throws Exception {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> identities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, identities, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, identities, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, identities, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, identities, true);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
    }

    public void testGetContactsWithListIdentities() throws Exception {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> identities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity, identities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity, identities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity, identities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity, identities);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
    }

    public void testGetContacts() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
    }

    public void testGetAllRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAllRelationships(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAllRelationships(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"maryRelationships.size() must return: 1", (int)1, (int)maryRelationships.size());
        List demoRelationships = this.relationshipManager.getAllRelationships(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"demoRelationships.size() must return: 1", (int)1, (int)demoRelationships.size());
        List johnRelationships = this.relationshipManager.getAllRelationships(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnRelationships.size() must return: 1", (int)1, (int)johnRelationships.size());
    }

    public void testGetRelationshipsByIdentityId() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getRelationshipsByIdentityId(this.rootIdentity.getId());
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
    }

    public void testGetIdentities() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootConnections = this.relationshipManager.getIdentities(this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootConnections must not be null", (Object)rootConnections);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootConnections.size() must return: 3", (int)3, (int)rootConnections.size());
    }

    public void testGetRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RDBMSRelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
    }

    public void testFindRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.PENDING);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.CONFIRMED);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RDBMSRelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 1", (int)1, (int)rootRelationships.size());
    }

    public void testGetIncomingRelationshipsSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getIncomingByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetConfirmedRelationshipsSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.confirm(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.confirm(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.confirm(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        this.relationshipManager.confirm(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getConnectionsByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetOutgoingRelationshipsSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser1, testuser5);
        this.relationshipManager.inviteToConnect(testuser1, testuser2);
        this.relationshipManager.inviteToConnect(testuser1, testuser4);
        this.relationshipManager.inviteToConnect(testuser1, testuser3);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getOutgoingByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetIncomingRelationshipsByFirstLetterSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getIncomingByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetConfirmedRelationshipsByFirstLetterSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser5, testuser1);
        this.relationshipManager.confirm(testuser5, testuser1);
        this.relationshipManager.inviteToConnect(testuser2, testuser1);
        this.relationshipManager.confirm(testuser2, testuser1);
        this.relationshipManager.inviteToConnect(testuser4, testuser1);
        this.relationshipManager.confirm(testuser4, testuser1);
        this.relationshipManager.inviteToConnect(testuser3, testuser1);
        this.relationshipManager.confirm(testuser3, testuser1);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getConnectionsByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetOutgoingRelationshipsByFirstLetterSorted() throws Exception {
        org.exoplatform.social.core.identity.model.Identity testuser5 = this.createUserAndIdentity("testuser5");
        org.exoplatform.social.core.identity.model.Identity testuser3 = this.createUserAndIdentity("testuser3");
        org.exoplatform.social.core.identity.model.Identity testuser1 = this.createUserAndIdentity("testuser1");
        org.exoplatform.social.core.identity.model.Identity testuser4 = this.createUserAndIdentity("testuser4");
        org.exoplatform.social.core.identity.model.Identity testuser2 = this.createUserAndIdentity("testuser2");
        this.relationshipManager.inviteToConnect(testuser1, testuser5);
        this.relationshipManager.inviteToConnect(testuser1, testuser2);
        this.relationshipManager.inviteToConnect(testuser1, testuser4);
        this.relationshipManager.inviteToConnect(testuser1, testuser3);
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess identities = this.relationshipManager.getOutgoingByFilter(testuser1, profileFilter);
        RDBMSRelationshipManagerTest.assertNotNull((String)"Relationships must not be null", (Object)identities);
        RDBMSRelationshipManagerTest.assertEquals((String)"Wrong size of returned relationships", (int)4, (int)identities.getSize());
        org.exoplatform.social.core.identity.model.Identity[] loadedIdentities = (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser2", (String)loadedIdentities[0].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser3", (String)loadedIdentities[1].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser4", (String)loadedIdentities[2].getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)"Returned identities list semms not sorted", (String)"testuser5", (String)loadedIdentities[3].getRemoteId());
    }

    public void testGetRelationshipStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
    }

    public void testGetConnectionStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
    }

    public void testIntiveAndGetByRelationshipId() throws Exception {
        Relationship invitedRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship foundRelationship = this.relationshipManager.get(invitedRelationship.getId());
        RDBMSRelationshipManagerTest.assertNotNull((String)"foundRelationship must not be null", (Object)foundRelationship);
        RDBMSRelationshipManagerTest.assertNotNull((String)"foundRelationship.getId() must not be null", (Object)foundRelationship.getId());
        RDBMSRelationshipManagerTest.assertEquals((String)foundRelationship.getId(), (String)invitedRelationship.getId());
    }

    public void testGetPendingWithIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        List foundListRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"foundListRelationships must not be null", (Object)foundListRelationships);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)foundListRelationships.size());
    }

    public void testGetPendingAndIncoming() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        List listPendingRelationship = this.relationshipManager.getPending(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"listRelationshipConfirm must not be null", (Object)listPendingRelationship);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)listPendingRelationship.size());
        List listMaryRequireValidationRelationship = this.relationshipManager.getIncoming(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)listMaryRequireValidationRelationship.size());
    }

    public void testGetPendingAndIncomingWithListIdentities() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        Relationship maryDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        ArrayList<org.exoplatform.social.core.identity.model.Identity> listIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List listRelationshipConfirm = this.relationshipManager.getPending(this.johnIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)listRelationshipConfirm.size());
        List listRelationshipNotConfirm = this.relationshipManager.getIncoming(this.demoIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)listRelationshipNotConfirm.size());
    }

    public void testGetConfirmedWithIdentity() throws Exception {
        List johnContacts = this.relationshipManager.getConfirmed(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RDBMSRelationshipManagerTest.assertEquals((String)"johnContacts.size() must be 0", (int)0, (int)johnContacts.size());
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)contactsList.size());
    }

    public void testGetConfirmedWithIdentityAndListIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        ArrayList<org.exoplatform.social.core.identity.model.Identity> listIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity, listIdentities);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)contactsList.size());
    }

    public void testInviteRelationship() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.maryIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void testConfirm() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(relationship);
        relationship = this.relationshipManager.get(this.johnIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((Object)relationship.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
    }

    public void testDelete() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testRemove() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testGetPending() throws Exception {
        Relationship rootDemo = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        Relationship rootJohn = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        Relationship rootMary = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        Relationship demoMary = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        Relationship demoJohn = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoJohn.getId() must not be null", (Object)demoJohn.getId());
        List rootRelationships = this.relationshipManager.getPending(this.rootIdentity);
        List demoRelationships = this.relationshipManager.getPending(this.demoIdentity);
        List johnRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)rootRelationships.size());
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)demoRelationships.size());
        RDBMSRelationshipManagerTest.assertEquals((int)0, (int)johnRelationships.size());
    }

    public void testSavedCached() throws Exception {
        Relationship rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootDemo must be null", (Object)rootDemo);
        Relationship rootDemo2 = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootDemo must be null", (Object)rootDemo2);
        Relationship.Type rootDemoStatus = this.relationshipManager.getStatus(this.demoIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootDemoStatus must be null", (Object)rootDemoStatus);
        rootDemo = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)rootDemo.getStatus(), (Object)Relationship.Type.PENDING);
        Relationship rootMary = this.relationshipManager.get(this.rootIdentity, this.maryIdentity);
        Relationship.Type rootMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootMary must be null", (Object)rootMary);
        RDBMSRelationshipManagerTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootMary = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootMary.getStatus());
        Relationship rootJohn = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"rootJohn must be null", (Object)rootJohn);
        RDBMSRelationshipManagerTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootJohn = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootJohn.getStatus());
        Relationship demoMary = this.relationshipManager.get(this.demoIdentity, this.maryIdentity);
        Relationship.Type demoMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.demoIdentity);
        RDBMSRelationshipManagerTest.assertNull((String)"demoMary must be null", (Object)demoMary);
        RDBMSRelationshipManagerTest.assertNull((String)"demoMaryStatus must be null", (Object)demoMaryStatus);
        demoMary = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        RDBMSRelationshipManagerTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        RDBMSRelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)demoMary.getStatus());
    }

    public void testGetConnections() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        ListAccess contactsList = this.relationshipManager.getConnections(this.johnIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)contactsList.getSize());
    }

    public void testGetSuggestions() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        Relationship ghostToJohnRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.johnIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        Map suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertTrue((boolean)suggestions.isEmpty());
        this.relationshipManager.confirm(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.ghostIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)suggestions.size());
        Object[] objs = suggestions.entrySet().toArray();
        Map.Entry first = (Map.Entry)objs[0];
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)((Integer)first.getValue()));
        RDBMSRelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)first.getKey()).getRemoteId());
        Relationship johnToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        Relationship paulToDemoRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)suggestions.size());
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.maryIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)suggestions.size());
        objs = suggestions.entrySet().toArray();
        first = (Map.Entry)objs[0];
        Map.Entry second = (Map.Entry)objs[1];
        RDBMSRelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)first.getKey()).getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)second.getKey()).getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)((Integer)first.getValue()));
        RDBMSRelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)first.getKey()).getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)((Integer)second.getValue()));
        RDBMSRelationshipManagerTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)second.getKey()).getRemoteId());
        this.relationshipManager.delete(paulToDemoRelationship);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)suggestions.size());
        this.paulIdentity.setEnable(false);
        this.identityManager.updateIdentity(this.paulIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)suggestions.size());
        objs = suggestions.entrySet().toArray();
        first = (Map.Entry)objs[0];
        RDBMSRelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)first.getKey()).getRemoteId());
    }

    public void testGetSuggestionsWithParams() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        Relationship paulToMaryRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        Relationship johnToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Map suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertTrue((boolean)suggestions.isEmpty());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 10);
        RDBMSRelationshipManagerTest.assertTrue((boolean)suggestions.isEmpty());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 10);
        RDBMSRelationshipManagerTest.assertTrue((boolean)suggestions.isEmpty());
        this.relationshipManager.confirm(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)4, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, -1, -1, 10);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)4, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 2, 10);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 3, 10);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 2, 3, 10);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertTrue((suggestions.size() > 0 && suggestions.size() <= 2 ? 1 : 0) != 0);
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 10, 2);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)suggestions.size());
        suggestions = this.relationshipManager.getSuggestions(this.ghostIdentity, 10, 2, 2);
        RDBMSRelationshipManagerTest.assertFalse((boolean)suggestions.containsKey(this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)2, (int)suggestions.size());
    }

    public void testGetLastConnections() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.ghostIdentity);
        this.restartTransaction();
        this.sleep(1);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.restartTransaction();
        this.sleep(1);
        Relationship paulToMaryRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.paulIdentity);
        this.sleep(1);
        List identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)3, (int)identities.size());
        RDBMSRelationshipManagerTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)identities.get(0)).getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)identities.get(1)).getRemoteId());
        RDBMSRelationshipManagerTest.assertEquals((String)this.ghostIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)identities.get(2)).getRemoteId());
        this.restartTransaction();
        Relationship johnToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RDBMSRelationshipManagerTest.assertEquals((int)4, (int)identities.size());
        RDBMSRelationshipManagerTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)((org.exoplatform.social.core.identity.model.Identity)identities.get(0)).getRemoteId());
    }

    public void testGetConnectionsInCommonCount() throws Exception {
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.ghostIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.ghostIdentity);
        this.relationshipManager.inviteToConnect(this.ghostIdentity, this.paulIdentity);
        this.relationshipManager.confirm(this.paulIdentity, this.ghostIdentity);
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.ghostIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)1, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.paulIdentity));
        RDBMSRelationshipManagerTest.assertEquals((int)0, (int)this.relationshipManager.getConnectionsInCommonCount(this.maryIdentity, this.rootIdentity));
    }

    private Profile initProfile(String userName, String firstName, String lastName, String fullName, String position, String gender, String company) throws Exception {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", userName, true);
        Profile profile = identity.getProfile();
        profile.setProperty("firstName", (Object)firstName);
        profile.setProperty("lastName", (Object)lastName);
        profile.setProperty("fullName", (Object)fullName);
        profile.setProperty("position", (Object)position);
        profile.setProperty("gender", (Object)gender);
        HashMap<String, String> xp = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> xps = new ArrayList<HashMap<String, String>>();
        xp.put("company", company);
        xps.add(xp);
        profile.setProperty("experiences", xps);
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        identity.setProfile(profile);
        this.identityManager.updateIdentity(identity);
        return profile;
    }
}

